//----------------------------------------------------------------------------
//  EDGE DJGPP Video Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#include "..\i_defs.h"
#include "i_sysinc.h"

#include "..\m_argv.h"   // These should not be here!!!
#include "..\st_stuff.h" // These should not be here!!!
#include "..\v_colour.h" // These should not be here!!!
#include "..\v_res.h"    // These should not be here!!!

static BITMAP *doom_s;
static int bitspp = 8;
static screen_t dummy_screen;
static boolean_t started = false;
static boolean_t nogfxmode;
static void (*FlipScreens)(void);

typedef struct
{
  char *name;
  void (*func) ();
  boolean_t flags;
  char *desc;
}
blitfunc_t;

// Blitting prototypes...
static void Blit_LBL(void);
static void Blit_Banked(void);
static void Blit_Alleg(void);
static void Blit_None(void);

static blitfunc_t blitfuncs[] =
{
  { "Allegro", Blit_Alleg,  0, "Allegro"              },
  { "Lbl",     Blit_LBL,    0, "Line-by-line Blitter" },
  { "banked",  Blit_Banked, 0, "Vesa1 Banked Blit"    },
  { "none",    Blit_None,   0, "None"                 },
  {  NULL,     NULL,        0, NULL                   }
};

static screenmode_t possresmode[] =
{
  // fullscreen modes
  { 320, 200,  8, false},
  { 320, 240,  8, false},
  { 640, 400,  8, false},
  { 640, 480,  8, false},
  { 800, 600,  8, false},
  { 1024, 768, 8, false},

  { 320, 200,  16, false},
  { 320, 240,  16, false},
  { 640, 400,  16, false},
  { 640, 480,  16, false},
  { 800, 600,  16, false},
  { 1024, 768, 16, false},

  { -1, -1, -1, false }
};

//
// Blit_LBL
//
static void Blit_LBL(void)
{
  int i;
  unsigned int temppointer;

  temppointer = (unsigned int)main_scr->data;
  // -ACB- 1998/06/18 used SCREENPITCH to replace j (SCREENWIDTH*BPP)
  for (i = 0; i < SCREENHEIGHT; i++, temppointer += SCREENPITCH)
  {
    movedata(_my_ds(), temppointer, screen->seg, (unsigned int)screen->line[i], SCREENWIDTH * BPP);
  }
}

//
// Blit_Banked
//
static void Blit_Banked(void)
{
  int i;
  unsigned long temppointer, destpointer;

  temppointer = (unsigned long)main_scr->data;
  for (i = 0; i < SCREENHEIGHT; i++)
  {
    destpointer = bmp_write_line(screen, i);
    // -ACB- 1998/06/18 used SCREENPITCH to replace j (SCREENWIDTH*BPP)
    movedata(_my_ds(), temppointer, screen->seg, destpointer, SCREENWIDTH * BPP);
    temppointer += SCREENPITCH;
  }
}

//
// Blit_Alleg
//
// 23-6-98 KM Fixed this.
//
static void Blit_Alleg(void)
{
  blit(doom_s, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

//
// Blit_None
//
// Used for "-nogfxmode". Debugging tool.
//
static void Blit_None(void)
{
}

//
// SelectBlitFunction8
//
// -ES- 1999/06/14 Splitted up into smaller functions
//
static boolean_t SelectBlitFunction8(void)
{
  int i;

  set_color_depth(8);
  if (!M_CheckParm("-forcevga"))
  {
    i = set_gfx_mode(GFX_AUTODETECT, SCREENWIDTH, SCREENHEIGHT, 0, 0);
    if (i == 0)
    {
      FlipScreens = Blit_Alleg;
      return false;
    }
  }

  if ((SCREENWIDTH == 320) && (SCREENHEIGHT <= 200))
  {
    i = set_gfx_mode(GFX_VGA, SCREENWIDTH, SCREENHEIGHT, 0, 0);
    FlipScreens = Blit_Alleg;
    return false;
  }

  // Failed.
  return true;
}

//
// SelectBlitFunctionHicolour
//
static boolean_t SelectBlitFunctionHicolour(int depth)
{
  int i;

  set_color_depth(depth);
  i = set_gfx_mode(GFX_AUTODETECT, SCREENWIDTH, SCREENHEIGHT, 0, 0);
  if (i == 0)
  {
    FlipScreens = Blit_Alleg;
    return false;
  }
  return true;
}

//
// SelectBlitFunction
//
// -ES- 1998/08/20 Changed exit() and return to return -1 and return 0.
//                 Also re-indented the code.
//
static boolean_t SelectBlitFunction(void)
{
  const char *p;

  if (nogfxmode)
  {
    FlipScreens = Blit_None;
    set_color_depth(BPP==1 ? 8 : 16);
    return false;
  }

  if (BPP == 1)
  {
    return SelectBlitFunction8();
  }
  else
  {
    // bitspp forces either 16- or 15-bit colour in hicolour mode
    p = M_GetParm("-bitspp");
    if (p)
    {
      return SelectBlitFunctionHicolour(atoi(p));
    }
    if (SelectBlitFunctionHicolour(16) == false)
      return false;
    if (SelectBlitFunctionHicolour(15) == false)
      return false;
  }

  return true;
}

//
// I_StartupGraphics
//
// Nothing major for DJGPP/Allegro to do here apart from set the resolution table
//
void I_StartupGraphics(void)
{
  int i;
  
  started = true;

  for (i=0; possresmode[i].width != -1; i++)
  {
    V_AddAvailableResolution(possresmode + i);
  }

  nogfxmode = M_CheckParm("-nogfxmode");
}

//
// I_SetScreenSize
//
// -ACB- 1999/09/19 Moved from I_Allegv.C
//                  Removed DEBUG info.
//                  Removed blit selector.
//                  New parameters.
//
boolean_t I_SetScreenSize(screenmode_t *mode)
{
  int setdepth;
  int actdepth;
  const char *p;

  setdepth = mode->depth;

  // -ES- 1998/08/20 Changed select_blit_function() error handling
  if (SelectBlitFunction())
    return false;

  p = M_GetParm("-blitfunc");
  if (p)
  {
    blitfunc_t *f;

    // -ES- 1999/07/18 Use default routine if invalid blitter name is passed
    for (f = blitfuncs; f; f++)
      if (!stricmp(p, f->name))
      {
        FlipScreens = f->func;
        break;
      }
  }

  bitspp = _color_depth;
                              
  actdepth = V_GetPitch(mode->width, mode->depth / 8);

  // -ES- 1998/08/20 Destroy bitmap
  if (doom_s)
  {
    destroy_bitmap(doom_s);
    doom_s = NULL;
  }

  doom_s = create_bitmap(actdepth/(mode->depth/8), mode->height);

  if (doom_s == NULL)
    return false;  // failed

  // -ES- 1998/11/07 Remove garbage
  clear_to_color(doom_s, 0);

  dummy_screen.width = mode->width;
  dummy_screen.height = mode->height;
  dummy_screen.pitch = actdepth;
  dummy_screen.bytepp = mode->depth / 8;
  dummy_screen.parent = NULL;
  dummy_screen.data = doom_s->dat;

  main_scr = V_CreateSubScreen(&dummy_screen, 0, 0, 
      dummy_screen.width, dummy_screen.height);

  doom_s->vtable->mask_color = 247;

  SCREENPITCH = actdepth;

  return true;
}

//
// I_StartFrame
//
void I_StartFrame(void)
{
}

//
// I_FinishFrame
//
// -ACB- 1999/09/19 Simplified to the blitting function only.
//
void I_FinishFrame(void)
{
  FlipScreens(); // Blast it to the screen
}

//
// I_SetPalette
//
// -AJA- 1999/07/03: removed `redness' parameter, and moved the 16-bit
//                   handling to I_MakeColourmapRange.
//
void I_SetPalette(byte palette[256][3])
{
  int i;
  const byte *gtable = gammatable[usegamma];
  PALETTE pal;

  if (nogfxmode)
    return;

  for (i = 0; i < 256; i++)
  {
    pal[i].r = gtable[palette[i][0]] >> 2;
    pal[i].g = gtable[palette[i][1]] >> 2;
    pal[i].b = gtable[palette[i][2]] >> 2;
  }

  set_palette(pal);
}

//
// I_Colour2Pixel
//
// -AJA- 1999/07/05: added this.
//
long I_Colour2Pixel(byte palette[256][3], int col)
{
  if (BPP == 2)
  {
    return makecol(palette[col][0], palette[col][1], palette[col][2]);
  }

  return col;
}

//
// I_GetTruecolInfo
//
// -AJA- 1999/07/04: added this.
// -ACB- 1999/09/19: Moved from I_ALLEGV.C
//
void I_GetTruecolInfo(truecol_info_t *info)
{
  if (bitspp == 16)
  {
    info->red_bits = 5;
    info->red_shift = 11;
    info->red_mask = 0xF800;

    info->green_bits = 6;
    info->green_shift = 5;
    info->green_mask = 0x07E0;

    info->blue_bits = 5;
    info->blue_shift = 0;
    info->blue_mask = 0x001F;

    info->grey_mask = 0xFFDF;
    return;
  }

  if (bitspp == 15)
  {
    info->red_bits = 5;
    info->red_shift = 10;
    info->red_mask = 0xEC00;

    info->green_bits = 5;
    info->green_shift = 5;
    info->green_mask = 0x03E0;

    info->blue_bits = 5;
    info->blue_shift = 0;
    info->blue_mask = 0x001F;

    info->grey_mask = 0xFFFF;
    return;
  }
}

//
// I_ShutdownGraphics
//
// Shutdown Graphics Mode
//
void I_ShutdownGraphics(void)
{
  if (started)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    system("cls");  // -ES- 2000/03/23 Workaround for Allegro bug
  }

  started = false;
  graphicsmode = false;
}

