;
;       i386 CPU detection routines, by Phil Frisbie.
;
;       Theuzifan improved the support for Cyrix chips.
;
;       Calin Andrian added 3DNow! detection code.
;
;       See readme.txt for copyright information.


extern _asmarg1
extern _asmarg2
extern _asmret

%ifndef CODE_SECTION
%define CODE_SECTION .text
%endif
SECTION CODE_SECTION

; int _i_is_486()
;  Returns TRUE for 486+, and FALSE for 386.

GLOBAL _I_386Is486
_I_386Is486:
   push  ebp
   mov  ebp,esp

   pushf                         ; save EFLAGS
   pop  eax                      ; get EFLAGS
   mov  edx,eax                  ; temp storage EFLAGS
   xor  eax,40000h               ; change AC bit in EFLAGS
   push  eax                     ; put new EFLAGS value on stack
   popf                          ; replace current EFLAGS value
   pushf                         ; get EFLAGS
   pop  eax                      ; save new EFLAGS in EAX
   cmp  eax,edx                  ; compare temp and new EFLAGS
   jz is486_not_found

   mov long [_asmret], 1
   jmp is486_done

is486_not_found:
   mov long [_asmret], 0

is486_done: 
   push  edx                     ; get original EFLAGS
   popf                          ; restore EFLAGS

   pop  ebp
   ret



;
; int I_386IsFPU()
;
; Returns TRUE is the CPU has floating point hardware.

GLOBAL _I_386IsFPU
_I_386IsFPU:
   push  ebp
   mov  ebp,esp

   fninit
   mov  eax,5A5Ah
   fnstsw ax
   cmp  eax, 0
   jne is_fpu_not_found

   mov long [_asmret], 1
   jmp is_fpu_done

is_fpu_not_found: 
   mov long [_asmret], 0

is_fpu_done: 
   pop  ebp
   ret




; int I_386IsCyrix()
;  Returns TRUE if this is a Cyrix processor.

GLOBAL _I_386IsCyrix
_I_386IsCyrix:
   push  ebp
   mov  ebp,esp

   xor  ax,ax                    ; clear eax
   sahf                          ; bit 1 is always 1 in flags
   mov  ax,5
   mov  dx,2
   div dl
   lahf                          ; get flags
   cmp  ah,2                     ; check for change in flags
   jne is_cyrix_not_found

   mov long [_asmret], 1
   jmp is_cyrix_done

is_cyrix_not_found: 
   mov long [_asmret], 0

is_cyrix_done: 
   pop  ebp
   ret




; void _i_cx_w(int index, int value)
;  Writes to a Cyrix register.

GLOBAL _i_cx_w
_i_cx_w: 
   push  ebp
   mov  ebp,esp
   cli

   mov  al, [_asmarg1]
   out  22h,al

   mov  al, [_asmarg2]
   out  23h,al

   sti
   pop  ebp
   ret




; char _i_cx_r(int index)
;  Reads from a Cyrix register.

GLOBAL _i_cx_r
_i_cx_r: 
   push  ebp
   mov  ebp,esp
   cli

   mov  al,[_asmarg1]
   out  22h,al

   xor  eax,eax
   in  al,23h

   mov [_asmret], eax

   sti
   pop  ebp
   ret



;
; int I_386IsCpuidSupported()
;
;  Checks whether the cpuid instruction is available.

GLOBAL _I_386IsCpuidSupported
_I_386IsCpuidSupported: 
   push  ebp
   mov  ebp,esp

   pushfd                        ; get extended flags
   pop  eax
   mov  edx,eax                  ; save current flags
   xor  eax,200000h              ; toggle bit 21
   push  eax                     ; put new flags on stack
   popfd                         ; flags updated now in flags
   pushfd                        ; get extended flags
   pop  eax
   xor  eax,edx                  ; if bit 21 r/w then supports cpuid
   jz cpuid_not_found

   mov long [_asmret],1
   jmp cpuid_done

cpuid_not_found: 
   mov long [_asmret], 0

cpuid_done: 
   pop  ebp
   ret




; void I_386GetCpuidInfo(long cpuid_levels, long *reg)
;  This is so easy!

GLOBAL _I_386GetCpuidInfo
_I_386GetCpuidInfo: 
   push  ebp
   mov  ebp,esp
   push  ebx
   push  ecx
   push  edi

   mov  eax,[_asmarg1]                 ; eax = cpuid_levels

   cpuid

   mov  edi,[_asmarg2]                 ; edi = reg

   mov  [edi],eax                ; store results
   mov  [edi+4],ebx
   mov  [edi+8],ecx
   mov  [edi+12],edx

   pop  edi
   pop  ecx
   pop  ebx
   pop  ebp
   ret

