//----------------------------------------------------------------------------
//  EDGE MP3 Interface
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------

#ifndef __L_MP3__
#define __L_MP3__

// NOTE: this interface to be used by platform code only.
// (It will one day be a part of the "common lib").

void L_MP3Init(int sample_rate, int sample_bits, int channels);
void L_MP3Shutdown(void);

boolean_t L_MP3SetMusicFile(const char *filename, int *sample_rate);
boolean_t L_MP3SetMusicLump(int handle, int position, int size, 
    int *sample_rate);
void L_MP3ClearMusicFile(void);

boolean_t L_MP3FillBuffer(void);
void L_MP3RestartMusicFile(void);

byte *L_MP3ReadBuffer(int samples);
void L_MP3ReadAdvance(int samples);

#endif  // __L_MP3__
