//----------------------------------------------------------------------------
//  EDGE Linux OpenGL Prototype
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2000  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#include "i_defs.h"
#include "./i_trans.h"

#include "m_argv.h"

#include "dm_state.h"
#include "dm_defs.h"
#include "dm_type.h"
#include "st_stuff.h"
#include "v_video1.h"
#include "v_video2.h"
#include "v_res.h"
#include "v_colour.h"
#include "v_screen.h"

#include "e_main.h"
#include "e_event.h"
#include "w_wad.h"
#include "z_zone.h"

#include "s_sound.h"


#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <signal.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>


short hicolortransmask1, hicolortransmask2;

// Dummy screen... 
// mainscreen is a full-size subscreen of this one.
static screen_t dummy_screen;


unsigned char *thepalette;

static int graphics_shutdown = 0;


// Common const strings
static const char lcase_lxdoom[] =
{"lxedge"};
static const char ucase_lxdoom[] =
{"LXEDGE"};


//// ====================== FROM: l_trans.c =================

static colourshift_t redshift, greenshift, blueshift;

static inline unsigned long MakeCol(long r, long g, long b)
{
  r = (r >> (8 - redshift.bits))   << redshift.shift;
  g = (g >> (8 - greenshift.bits)) << greenshift.shift;
  b = (b >> (8 - blueshift.bits))  << blueshift.shift;

  return r | g | b;
}

static const inline unsigned long 
count_leading_zeros (unsigned long x)
{
  unsigned long r = 0;

  if (x == 0)
    return 0;

  while (!(x & 1))
    {
      x >>= 1;
      r++;
    }
  return r;
}

static const inline unsigned long 
count_bits_in_mask (unsigned long x)
{
  unsigned long r = 0;

  while (!(x & 1))
    x >>= 1;

  while (x & 1)
    {
      x >>= 1;
      r++;
    }

  if (x)
    I_Error ("X Version: Mask is not contiguous.\n");

  return r;
}

void I_StartupGraphics(void)
{
  // check for command-line options
  // (none ATM)
}

void I_ShutdownGraphics (void)
{
  if (graphics_shutdown)
    return;

  graphics_shutdown = 1;

  fprintf(stderr, "Shutting down graphics...\n");
}


void I_GetTruecolInfo (truecol_info_t * info)
{
  info->red_bits = redshift.bits;
  info->red_shift = redshift.shift;
  info->red_mask = redshift.mask;

  info->green_bits = greenshift.bits;
  info->green_shift = greenshift.shift;
  info->green_mask = greenshift.mask;

  info->blue_bits = blueshift.bits;
  info->blue_shift = blueshift.shift;
  info->blue_mask = blueshift.mask;

  info->grey_mask = 0x7FFFFFFF;

  // check for RGB 5:6:5 mode (should be more general !)
  if (info->red_bits == 5 && info->green_bits == 6 &&
      info->blue_bits == 5)
  {
    info->grey_mask = 0xFFDF;
  }
}


//
// SetColourShift
//
// Constructs the shifts necessary to set one element of an RGB colour value

void SetColourShift(unsigned long mask, colourshift_t * ps)
{
  ps->mask  = mask;
  ps->shift = count_leading_zeros(mask);
  ps->bits  = count_bits_in_mask(mask);
}

boolean_t I_SetScreenSize(int width, int height, int bpp)
{
  glutInitWindowSize(width, height);
  glutInitWindowPosition(0, 0);

  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);

  SCREENDEPTH = V_GetDepth(SCREENWIDTH, BPP);

  glutCreateWindow("glEDGE !");

  if (BPP != 1)
  {
//    SetColourShift(my_dbuf->buffer.plb.pixelformat->red_mask,   &redshift);
//    SetColourShift(my_dbuf->buffer.plb.pixelformat->green_mask, &greenshift);
//    SetColourShift(my_dbuf->buffer.plb.pixelformat->blue_mask,  &blueshift);
  }

  dummy_screen.width = SCREENWIDTH;
  dummy_screen.height = SCREENHEIGHT;
  dummy_screen.depth = SCREENDEPTH;
  dummy_screen.bpp = BPP;
  dummy_screen.parent = NULL;
  dummy_screen.data = malloc(SCREENDEPTH * SCREENHEIGHT); //!!!!

  main_scr = V_CreateSubScreen (&dummy_screen, 0, 0, SCREENWIDTH, SCREENHEIGHT);

  return true;
}


//
// I_StartFrame
//
void I_StartFrame (void)
{
  // nada
}

//
// I_FinishFrame
//
void I_FinishFrame (void)
{
  // this implies glFlush:
  glutSwapBuffers();
}

//
// I_SetPalette
//
void I_SetPalette (byte palette[256][3])
{
#if 0 // NYI
  int i;

  const byte *gtable = gammatable[usegamma];

  if (BPP != 1)
    return;

  for (i = 0; i < 256; i++)
  {
    int r = gtable[palette[i][0]];
    int g = gtable[palette[i][1]];
    int b = gtable[palette[i][2]];

    my_pal[i].r = (r << 8) + r;
    my_pal[i].g = (g << 8) + g;
    my_pal[i].b = (b << 8) + b;
  }

  ggiSetPalette(my_vis, 0, 256, my_pal);
#endif
}

long I_Colour2Pixel(byte palette[256][3], int col)
{
  if (BPP == 1)
    return col;

  return MakeCol(palette[col][0], palette[col][1], palette[col][2]);
}


//
//   INPUT CODE 
//


//
// I_ControlGetEvents
//
void I_ControlGetEvents (void)
{
  // All events sent elsewhere
}

static int GlutKeyToDoomKey(unsigned char c)
{
  switch (c)
  {
    case 0x1B: return KEYD_ESCAPE;
    case 0x08: return KEYD_BACKSPACE;
    case 0x7F: return KEYD_DELETE;
    
    default:
  }

  if (1 <= c && c <= 127)
    return (int) tolower(c);

  return -1;
}

static int GlutSpecialToDoomKey(int key)
{
  switch(key)
  {
    case GLUT_KEY_UP:    return KEYD_UPARROW;
    case GLUT_KEY_DOWN:  return KEYD_DOWNARROW;
    case GLUT_KEY_LEFT:  return KEYD_LEFTARROW;
    case GLUT_KEY_RIGHT: return KEYD_RIGHTARROW;

    case GLUT_KEY_PAGE_UP:   return KEYD_PGUP;
    case GLUT_KEY_PAGE_DOWN: return KEYD_PGDN;
    case GLUT_KEY_HOME:      return KEYD_HOME;
    case GLUT_KEY_END:       return KEYD_END;
    case GLUT_KEY_INSERT:    return KEYD_INSERT;

    case GLUT_KEY_F1:  return KEYD_F1;
    case GLUT_KEY_F2:  return KEYD_F2;
    case GLUT_KEY_F3:  return KEYD_F3;
    case GLUT_KEY_F4:  return KEYD_F4;
    case GLUT_KEY_F5:  return KEYD_F5;
    case GLUT_KEY_F6:  return KEYD_F6;
    case GLUT_KEY_F7:  return KEYD_F7;
    case GLUT_KEY_F8:  return KEYD_F8;
    case GLUT_KEY_F9:  return KEYD_F9;
    case GLUT_KEY_F10: return KEYD_F10;
    case GLUT_KEY_F11: return KEYD_F11;
    case GLUT_KEY_F12: return KEYD_F12;

    default:
  }
  
  return -1;
}



//
//   GLUT CALLBACKS
//


static void IdleHandler(void)
{
  E_EDGELoopRoutine();
}

static void DrawHandler(void)
{
  E_EDGELoopRoutine();
}

static void ReshapeHandler(int width, int height)
{
  // glViewport(0, 0, width, height);
}

static void KeyDownHandler(unsigned char key, int x, int y)
{
  event_t event;

  int dm_key = GlutKeyToDoomKey(key);

  if (dm_key >= 0)
  {
    event.type  = ev_keydown;
    event.value.key = dm_key;

    E_PostEvent(&event);
  }
}

static void KeyUpHandler(unsigned char key, int x, int y)
{
  event_t event;

  int dm_key = GlutKeyToDoomKey(key);

  if (dm_key >= 0)
  {
    event.type  = ev_keyup;
    event.value.key = dm_key;

    E_PostEvent(&event);
  }
}

static void SpecialDownHandler(int key, int x, int y)
{
  event_t event;

  int dm_key = GlutSpecialToDoomKey(key);

  if (dm_key >= 0)
  {
    event.type  = ev_keydown;
    event.value.key = dm_key;

    E_PostEvent(&event);
  }
}

static void SpecialUpHandler(int key, int x, int y)
{
  event_t event;

  int dm_key = GlutSpecialToDoomKey(key);

  if (dm_key >= 0)
  {
    event.type  = ev_keyup;
    event.value.key = dm_key;

    E_PostEvent(&event);
  }
}

//
// I_EDGELoop
//
void I_EDGELoop(void)
{
  glutKeyboardFunc(KeyDownHandler);
  glutKeyboardUpFunc(KeyUpHandler);
  glutSpecialFunc(SpecialDownHandler);
  glutSpecialUpFunc(SpecialUpHandler);

  glutIdleFunc(IdleHandler);
  glutDisplayFunc(DrawHandler);
  glutReshapeFunc(ReshapeHandler);

  glutMainLoop();
}
