//----------------------------------------------------------------------------
//  EDGE Null Input System
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2000  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#include "../i_defs.h"

#include "../con_main.h"
#include "../dm_state.h"
#include "../e_main.h"
#include "../m_argv.h"
#include "../m_menu.h"
#include "../z_zone.h"

#include "i_sysinc.h"

int usejoystick = 0;
int usemouse = 0;

static void I_StartupKeyboard(void)
{
}

static void I_ReadKeyboard(void)
{
// This function relies on the non-ansi kbhit(), so we give the option to
// comment it out. In that case, EDGE will have no inputs and you can
// only use it to play demos.
#ifndef NO_KEYBOARD
  // Keeps track of which keys that were pressed the last call. They are
  // marked with an 1.
  // If an element remains 1 after all kbhits are processed, this means that
  // it is no longer pressed, and a ev_keyup event is sent.
  static int pressed_keys[256];
  event_t event;
  unsigned char k;
  int code;
  int i;

  while (kbhit())
  {
    k = getch();
    switch (k)
    {
      // Hack: To make it as portable as possible, just treat
      // SHIFT+some keys as some required specials.
      case 'W' : code = KEYD_UPARROW; break;
      case 'S' : code = KEYD_DOWNARROW; break;
      case 'A' : code = KEYD_LEFTARROW; break;
      case 'D' : code = KEYD_RIGHTARROW; break;
      case 'Q' : code = KEYD_ESCAPE; break;
      case 'C' : code = KEYD_TILDE; break;
      case 'P' : code = KEYD_PAUSE; break;
      case 'T' : code = KEYD_TAB; break;

      default: code = k;
    }

    pressed_keys[code]++;

    event.type = ev_keydown;
    event.value.key = code;
    E_PostEvent(&event);
  }

  for (i = 0; i < 256; i++)
  {
    if (pressed_keys[i])
    {
      if (pressed_keys[i] == 1)
      {
        pressed_keys[i] = 0;
        event.type = ev_keyup;
        event.value.key = i;
        E_PostEvent(&event);
      }
      else
      {
        pressed_keys[i] = 1;
      }
    }
  }
#endif
}

void I_CalibrateJoystick(int ch)
{
}

//
// I_PureRandom
//
// Returns a fairly random value, used as seed for EDGE's internal random
// engine.
// If this function would return a constant value, everything would still work
// great, except that random events before the first tic of a level (like
// random RTS spawn) would be predictable.
long I_PureRandom(void)
{
  return time(NULL);
}

//
// I_StartupControl
//
void I_StartupControl(void)
{
  // Add the initialisation of other devices (mouse, joystick) here.
  I_Printf("I_StartupKeyboard\n");
  I_StartupKeyboard();

  return;
}

void I_ControlGetEvents(void)
{
  I_ReadKeyboard();
}

//
// I_ShutdownKeyboard
//
// Kills Keyboard
void I_ShutdownKeyboard(void)
{
}

//
// I_ShutdownControl
//
// Return input devices to system control
//
void I_ShutdownControl(void)
{
  I_ShutdownKeyboard();
}

