//----------------------------------------------------------------------------
//  EDGE Null Sound System
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2000  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#include "..\i_defs.h"
#include "..\z_zone.h"
#include "i_sysinc.h"

//
// I_StartupSound
//
// Exactly what it says on the label
boolean_t I_StartupSound(void *sysinfo)
{
  return false;
}

//
// I_LoadSfx
//
// Loads a sound effect from data.
boolean_t I_LoadSfx(const unsigned char *data, unsigned int length, unsigned int freq, unsigned int handle)
{
  return true;
}

//
// I_UnloadSfx
//
// Unloads a sound effect.
boolean_t I_UnloadSfx(unsigned int handle)
{
  return true;
}

//
// I_SoundPlayback
//
// Sets up a sound for playback.
// Returns the channel number, or -1 on failure
int I_SoundPlayback(unsigned int soundid, int pan, int vol, boolean_t looping)
{
  return -1;
}

//
// I_SoundKill
//
// Stops sound from playing any further.
boolean_t I_SoundKill(unsigned int chanid)
{
  return true;
}

//
// I_SoundCheck
//
// Checks to see if a channel is playing
boolean_t I_SoundCheck(unsigned int chanid)
{
  return false;
}

//
// I_PauseSound
//
void I_PauseSound(int channel)
{
}

//
// I_ResumeSound
//
void I_ResumeSound(int channel)
{
}

//
// I_UpdateSound
//
// Called once in a while to maintain the sound system.
void I_UpdateSound(void)
{
}

//
// I_SoundAlter
//
// Alters the parameters of a currently playing sound
boolean_t I_SoundAlter(unsigned int channel, int pan, int vol)
{
  return false;
}

//
// I_ShutdownSound
//
// Brings the sound system to a halt
void I_ShutdownSound(void)
{
}

boolean_t I_SoundPause(unsigned int chanid)
{
  return false;
}

boolean_t I_SoundResume(unsigned int chanid)
{
  return false;
}

boolean_t I_SoundStopLooping(unsigned int chanid)
{
  return false;
}

void I_SoundTicker(void)
{
}

const char *I_SoundReturnError(void)
{
  return "Sound not supported";
}
