//----------------------------------------------------------------------------
//  EDGE Null Video Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2000  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------

#include "../i_defs.h"

#include "../dm_defs.h"
#include "../dm_state.h"
#include "../i_system.h"
#include "../st_stuff.h"
#include "../m_argv.h"
#include "../v_res.h"
#include "../w_wad.h"
#include "../z_zone.h"
#include "../v_colour.h"

#include "i_sysinc.h"

static int bitspp = 8;

static screenmode_t possresmode[] =
{
  // windowed modes
  { 320, 200,  8, true},
  { 320, 240,  8, true},
  { 640, 400,  8, true},
  { 640, 480,  8, true},
  { 800, 600,  8, true},
  { 1024, 768, 8, true},

  { 320, 200,  16, true},
  { 320, 240,  16, true},
  { 640, 400,  16, true},
  { 640, 480,  16, true},
  { 800, 600,  16, true},
  { 1024, 768, 16, true},

  [ -1, -1, -1 }
};

// -AJA- 1999/07/04: added this.
// -ACB- 1999/09/19: Moved from I_ALLEGV.C
void I_GetTruecolInfo(truecol_info_t* info)
{
  if (bitspp == 16)
  {
    info->red_bits = 5;
    info->red_shift = 11;
    info->red_mask = 0xF800;

    info->green_bits = 6;
    info->green_shift = 5;
    info->green_mask = 0x07E0;

    info->blue_bits = 5;
    info->blue_shift = 0;
    info->blue_mask = 0x001F;

    info->grey_mask = 0xFFDF;
    return;
  }

  if (bitspp == 15)
  {
    info->red_bits = 5;
    info->red_shift = 10;
    info->red_mask = 0xEC00;

    info->green_bits = 5;
    info->green_shift = 5;
    info->green_mask = 0x03E0;

    info->blue_bits = 5;
    info->blue_shift = 0;
    info->blue_mask = 0x001F;

    info->grey_mask = 0xFFFF;
    return;
  }
}

//
// I_SetScreenSize
//
// Sets the screen size to the given parameters
//
boolean_t I_SetScreenSize(screenmode_t *mode)
{
  // this version just pretends that it sets the gfxmode, to make the
  // game work.
  int actdepth;
  const char *p;

  bitspp = mode->depth;

  actdepth = V_GetPitch(mode->width, mode->depth / 8);

  if (main_scr)
    V_DestroyScreen(main_scr);

  main_scr = V_CreateScreen(mode->width, mode->height, mode->depth / 8);

  SCREENPITCH = actdepth;

  return true;
}

void I_StartFrame(void)
{
}

//
// I_FinishFrame
//
// Copy the frame to the screen.
void I_FinishFrame(void)
{
}

//
// I_SetPalette
//
// Sets the palette.
// palette is 256 RGB triplets. Each R, G and B element ranges from 0 to 255.
void I_SetPalette(byte palette[256][3])
{
}

// -AJA- 1999/07/05: added this.
long I_Colour2Pixel(byte palette[256][3], int col)
{
  if (bitspp == 16)
  {
    return ((palette[col][0] >> 3) << 11) | ((palette[col][1] >> 2) << 5) |
      (palette[col][2] >> 3);
  }
  if (bitspp == 15)
  {
    return ((palette[col][0] >> 3) << 10) | ((palette[col][1] >> 3) << 5) |
      (palette[col][2] >> 3);
  }

  return col;
}

//
// I_StartupGraphics
//
// Inits some tables.
//
void I_StartupGraphics(void)
{
  int i;
  
  for (i=0; possresmode[i].width != -1; i++)
  {
    V_AddAvailableResolution(possresmode + i);
  }
}

void I_ShutdownGraphics(void)
{
}

