//----------------------------------------------------------------------------
//  EDGE Column/Span Drawing for 8-bit Colour Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------
//
// -ACB- 1998/09/10 Cleaned up.
//

#ifndef __R_DRAW1__
#define __R_DRAW1__

#include "con_cvar.h"

extern funclist_t drawcol8_funcs;
extern funclist_t drawspan8_funcs;

void resinit_r_draw_c8(void);

void R_DrawColumn8_CVersion(void);  // C Version
void R_DrawColumn8_MIP(void);  // Mipmap version
void R_DrawColumn8_vfi(void);  // David Finch's fast smooth version
void R_DrawColumn8_KM(void);  // Smooth version
void R_DrawColumn8_BLF(void);  // Smooth version
void R_DrawColumn8_id(void);  // id's original
void R_DrawColumn8_id_Erik(void);  // improved id's original
void R_DrawColumn8_Pentium(void);  // Optimised for Pentium
void R_DrawColumn8_Chi(void);  // DOSDoom original
void R_DrawColumn8_K6_MMX(void);  // MMX asm version, optimised for K6
void R_DrawColumn8_Rasem(void);  // Rasem's
void R_DrawColumn8_dontdraw(void);  // Returns without drawing anything

void R_DrawFuzzColumn8(void);

void R_DrawTranslucentColumn8(void);
void R_DrawTranslucentColumn8_MIP(void);
void R_DrawTranslucentSpan8(void);
void R_DrawTranslucentSpan8_MIP(void);
void R_DrawHoleySpan8_MIP(void);
void R_DrawHaloColumn8_MIP(void);

void R_DrawTranslatedColumn8(void);
void R_DrawTranslucentTranslatedColumn8(void);

void R_DrawSpan8_CVersion(void);  // C Version
void R_DrawSpan8_MIP(void);  // Mipmap version
void R_DrawSpan8_vfi(void);  // David Finch's fast smooth version
void R_DrawSpan8_KM(void);  // Interpolated
void R_DrawSpan8_BLF(void);  // Bilinear Filtering
void R_DrawSpan8_id(void);  // id's original
void R_DrawSpan8_id_Erik(void);  // improved id's original
void R_DrawSpan8_MMX(void);  // MMX asm version
void R_DrawSpan8_Rasem(void);  // Rasem's
void R_DrawSpan8_dontdraw(void);  // Returns without drawing anything

void R_InitFunctions_Draw1(void);

void R_VideoErase8(unsigned ofs, int count);
void R_FillBackScreen8(void);
void R_DrawViewBorder8(void);

#endif
