//----------------------------------------------------------------------------
//  EDGE Column/Span Drawing for 16-bit Colour Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------
//
// Note: The best place for optimisation!
//
// -ACB- 1998/09/10 Cleaned up.
//

#ifndef __R_DRAW2__
#define __R_DRAW2__
#ifndef NOHICOLOUR

#include "con_cvar.h"

extern funclist_t drawcol16_funcs;
extern funclist_t drawspan16_funcs;

void resinit_r_draw_c16(void);

void R_DrawColumn16_KM(void);  // Smooth version
void R_DrawColumn16_BLF(void);  // Smooth version
void R_DrawColumn16_CVersion(void);  // C Version
void R_DrawColumn16_MIP(void);  // Mipmap version
void R_DrawColumn16_Rasem(void);  // Rasem's
void R_DrawColumn16_Chi(void);  // Chi's Original
void R_DrawSpan16_BLF(void);  // Bilinear Filtering

void R_DrawFuzzColumn16(void);

void R_DrawTranslucentColumn16(void);
void R_DrawTranslucentColumn16_MIP(void);
void R_DrawTranslucentSpan16(void);
void R_DrawTranslucentSpan16_MIP(void);
void R_DrawHoleySpan16_MIP(void);
void R_DrawHaloColumn16_MIP(void);

void R_DrawTranslatedColumn16(void);
void R_DrawTranslucentTranslatedColumn16(void);

void R_DrawSpan16_KM(void);  // Smooth version
void R_DrawSpan16_CVersion(void);  // C Version
void R_DrawSpan16_MIP(void);  // Mipmap Version
void R_DrawSpan16_Rasem(void);  // Rasem's
void R_InitFunctions_Draw2(void);

void R_VideoErase16(unsigned ofs, int count);
void R_FillBackScreen16(void);
void R_DrawViewBorder16(void);

#endif // NOHICOLOUR
#endif // __R_DRAW2__
