//----------------------------------------------------------------------------
//  EDGE Floor and Ceiling Rendering Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------
//
// -ACB- 1998/07/13 - Changed RANGECHECK for DEVELOPERS
// -KM- 1998/09/27 Dynamic colourmaps.
// -AJA- 1999/07/12: Updated for colmap.ddf.
// -AJA- 1999/07/16: Added xoffset & yoffset (for scrolling flats).
// -AJA- 1999/08/16: Support for rendering extra floors.
//

#include "i_defs.h"
#include "r_plane.h"

#include "dm_defs.h"
#include "dm_state.h"
#include "m_inline.h"
#include "r_local.h"
#include "r_sky.h"
#include "r_state.h"
#include "v_colour.h"
#include "w_textur.h"
#include "w_wad.h"
#include "z_zone.h"

//
// spanstart holds the start of a plane span
// initialised to 0 at start
//
int *spanstart = NULL;

// 1999/03/20 Removed the origyslope hack
float_t *yslope = NULL;

float_t *distscale = NULL;
float_t basexscale;
float_t baseyscale;

// -ES- 1999/03/23 Changed to cache struct
typedef struct planecache_s
{
  float_t height;
  float_t distance;
  fixed_t xstep;
  fixed_t ystep;
} planecache_t;

planecache_t *planecache = NULL;

