//----------------------------------------------------------------------------
//  EDGE Segs Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------
//
// -KM- 1998/09/27 Dynamic colourmaps.
// -AJA- 1999/08/16: Support for rendering extra floors.
//

#include "i_defs.h"
#include "r_segs.h"

#include "dm_defs.h"
#include "dm_state.h"
#include "m_inline.h"
#include "r_local.h"
#include "r_sky.h"
#include "v_colour.h"
#include "w_textur.h"
#include "w_wad.h"
#include "z_zone.h"

// True if any of the segs textures might be visible.
boolean_t segtextured;

// False if the back side is the same plane.
boolean_t markfloor;
boolean_t markceiling;

angle_t rw_normalangle;

// angle to line origin
int rw_angle1;

boolean_t maskedtexture;

//
// regular wall
//
int rw_x;
int rw_stopx;
angle_t rw_centerangle;
fixed_t rw_offset;
float_t rw_distance;
float_t rw_scale;
float_t rw_scalestep;

fixed_t rw_midtexturemid;
fixed_t rw_toptexturemid;
fixed_t rw_bottomtexturemid;

// -ES- 1999/03/24 Added These. They show the light level.
float_t rw_light;
float_t rw_lightstep;

fixed_t topfrac;
fixed_t topstep;

fixed_t bottomfrac;
fixed_t bottomstep;

// -AJA- 1999/07/10: Updated for colmap.ddf.
const lighttable_t *walllights;
const colourmap_t *wallnominal;

const byte *dc_source2;
fixed_t dc_xfrac;

