//----------------------------------------------------------------------------
//  EDGE Video Virtual Functions Code
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------
//
// Original Author: Chi Hoang
//

//
// These are where the function pointers are actually delared (not extern)
// Two helper functions, that didn't belong anywhere else, are also here.
//

#include "i_defs.h"

#include "dm_type.h"
#include "dm_defs.h"
#include "r_data.h"
#include "r_main.h"
#include "v_ctx.h"
#include "v_res.h"
#include "v_screen.h"
#include "w_image.h"
#include "w_wad.h"

void (*V_CopyRect) (screen_t * dest, screen_t * src, int srcx, int srcy, int width, int height, int destx, int desty);

void (*V_CopyScreen) (screen_t * dest, screen_t * src);

// -AJA- 1999/07/04: added the following misc drawing functions:
void (*V_DrawPixel) (screen_t *scr, int x, int y, int c);
void (*V_DrawLine) (screen_t *scr, int x1, int y1, int x2, int y2, int c);
void (*V_DrawBox) (screen_t *scr, int x, int y, int w, int h, int c);
void (*V_DrawBoxAlpha) (screen_t *scr, int x, int y, int w, int h, int c, fixed_t alpha);

void (*resinit_r_draw_c) (void);

// The span blitting interface.
// Hook in assembler or system specific BLT here.
void (*R_DrawColumn) (void);
void (*R_DrawColumn_MIP) (void);

// The Spectre/Invisibility effect.
void (*R_DrawFuzzColumn) (void);

// -KM- 1998/11/25 All the 75%/50%/25% funcs have been removed.
void (*R_DrawTranslucentColumn) (void);
void (*R_DrawTranslucentColumn_MIP) (void);
void (*R_DrawTranslucentTranslatedColumn) (void);
void (*R_DrawTranslatedColumn) (void);

void (*R_VideoErase) (unsigned ofs, int count);

// Span blitting for rows, floor/ceiling.
// No Spectre effect needed.
void (*R_DrawSpan) (void);
void (*R_DrawSpan_MIP) (void);

// Translucent span blitting for floor/ceiling.
void (*R_DrawTranslucentSpan) (void);
void (*R_DrawTranslucentSpan_MIP) (void);
void (*R_DrawHoleySpan_MIP) (void);

// Initialise colour translation tables,
//  for player rendering etc.
void (*R_InitTranslationTables) (void);

void R_DrawViewBorder(void)
{
  //!!!
}

static const image_t *fill_image = NULL;
static char fill_name[10] = { 0, };

void R_FillBackScreen(void)
{
  int WW = SCREENWIDTH;
  int HH = (screenblocks == 11) ? SCREENHEIGHT :
      (SCREENHEIGHT - (32 * SCREENHEIGHT / 200));

  int left   = viewwindowx;
  int top    = viewwindowy;
  int right  = WW - viewwindowx - viewwindowwidth;
  int bottom = HH - viewwindowy - viewwindowheight;

  float_t t_r, t_b;

  DEV_ASSERT2(currentmap);

  if (!fill_image || strcmp(fill_name, currentmap->surround) != 0)
  {
    strcpy(fill_name, currentmap->surround);
    fill_image = W_ImageFromFlat(fill_name);
  }

  t_r = IM_RIGHT(fill_image)  * 5.0;
  t_b = IM_BOTTOM(fill_image) * 5.0;

  #define X_TO_TX(xx)  (t_r * (xx) / SCREENWIDTH)
  #define Y_TO_TY(yy)  (t_b * (yy) / SCREENHEIGHT)

  if (top > 0)
  {
    vctx.DrawImage(0, 0, WW, top, fill_image, X_TO_TX(0), Y_TO_TY(0), 
        X_TO_TX(WW), Y_TO_TY(top), NULL, 1.0);
  }
  if (left > 0)
  {
    vctx.DrawImage(0, top, left, viewwindowheight, fill_image,
        X_TO_TX(0), Y_TO_TY(top), X_TO_TX(left), 
        Y_TO_TY(top + viewwindowheight), NULL, 1.0);
  }
  if (right > 0)
  {
    vctx.DrawImage(WW - right, top, right, viewwindowheight, fill_image,
        X_TO_TX(WW - right), Y_TO_TY(top), X_TO_TX(WW),
        Y_TO_TY(top + viewwindowheight), NULL, 1.0);
  }
  if (bottom > 0)
  {
    vctx.DrawImage(0, HH - bottom, WW, bottom, fill_image,
        X_TO_TX(0), Y_TO_TY(HH - bottom), X_TO_TX(WW), Y_TO_TY(HH),
        NULL, 1.0);
  }

  #undef X_TO_TX
  #undef Y_TO_TY
}

