//----------------------------------------------------------------------------
//  EDGE Top-level Video System
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------

#ifndef __V_TOPLEV__
#define __V_TOPLEV__

#include "dm_type.h"
#include "w_image.h"
#include "v_ctx.h"

//
// These routines provide an interface to the video context (see
// v_ctx.h) to be used by Drawer() functions in the layer system.
// Most importantly, the drawing routines here (Drawimage and
// SolidBox) will clip to the dirty matrix and solid rectangles
// which the VCTX routines ignore.
//

void VTOP_NewScreenSize(int width, int height, int bpp);
void VTOP_RenderScene(int x1, int y1, int x2, int y2, vid_view_t *view);
byte *VTOP_ReadScreen(int x1, int y1, int x2, int y2);

void VTOP_BeginDraw(int x1, int y1, int x2, int y2, int solid_index);
void VTOP_EndDraw(void);

void VTOP_DrawImage(int x1, int y1, int x2, int y2,
    float_t tx1, float_t ty1, float_t tx2, float_t ty2,
    const image_t *image, const colourmap_t *colmap, 
    int alpha, boolean_t is_vol);
  
void VTOP_SolidBox(int x1, int y1, int x2, int y2,
    int colour, int alpha, boolean_t is_vol);
void VTOP_SolidLine(int x1, int y1, int x2, int y2,
    int colour, int alpha);

//
// Utility routines for analysing the dirty matrix and/or solid
// rectangles and returning rectangles to draw.
//

void VTOP_AnalyseBegin(int x1, int y1, int x2, int y2, int solid_index);
void VTOP_AnalyseEnd(void);
boolean_t VTOP_AnalyseNextRect(int *x1, int *y1, int *x2, int *y2);


#endif  // __V_TOPLEV__
