//----------------------------------------------------------------------------
//  EDGE Video Code for 8-Bit Colour. 
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------

#include "i_defs.h"
#include "v_video1.h"

#include "dm_data.h"
#include "dm_defs.h"
#include "dm_state.h"
#include "e_main.h"
#include "m_bbox.h"
#include "m_inline.h"
#include "m_misc.h"
#include "m_swap.h"
#include "r_local.h"
#include "v_colour.h"
#include "v_res.h"
#include "v_screen.h"
#include "w_wad.h"
#include "z_zone.h"

//
// V_CopyRect8
// 
void V_CopyRect8(screen_t * destscr, screen_t * srcscr, int srcx, int srcy,
    int width, int height, int destx, int desty)
{
  byte *src;
  byte *dest;

  src = srcscr->data + srcscr->pitch * srcy + srcx;
  dest = destscr->data + destscr->pitch * desty + destx;

#ifdef DEVELOPERS
  if (srcx + width > srcscr->width || srcy + height > srcscr->height ||
      destx + width > destscr->width || desty + height > destscr->height ||
      (srcx | srcy | destx | desty) < 0)
    I_Error("V_CopyRect8: Coordinates outside screen boundaries!\n%d,%d, %d,%d, %d,%d",
        srcx, srcy, width, height, destx, desty);
#endif

  while (height--)
  {
    Z_MoveData(dest, src, byte, width);
    src += srcscr->pitch;
    dest += destscr->pitch;
  }
}

//
// V_CopyScreen8
//
// Copies one screen to another. They must have equal size.
//
void V_CopyScreen8(screen_t * dest, screen_t * src)
{
  if (src->width != dest->width ||
      src->height != dest->height ||
      src->bytepp != dest->bytepp)
    I_Error("V_CopyScreen8:  Screens have different size!");

  V_CopyRect8(dest, src, 0, 0, src->width, src->height, 0, 0);
}

//
// Classic Bresenham w/ whatever optimizations needed for speed
//
// -AJA- 1999/07/04: Moved here from am_map.c.

void V_DrawLine8(screen_t * scr, int x1, int y1, int x2, int y2, int col)
{
  register int x;
  register int y;
  register int dx;
  register int dy;
  register int sx;
  register int sy;
  register int ax;
  register int ay;
  register int d;
  register byte *fb = scr->data;
  int pitch = scr->pitch;

  dx = x2 - x1;
  ax = 2 * (dx < 0 ? -dx : dx);
  sx = dx < 0 ? -1 : 1;

  dy = y2 - y1;
  ay = 2 * (dy < 0 ? -dy : dy);
  sy = dy < 0 ? -1 : 1;

  x = x1;
  y = y1;

  if (ax > ay)
  {
    d = ay - ax / 2;
    while (1)
    {
      fb[(y) * pitch + (x)] = (col);
      if (x == x2)
        return;
      if (d >= 0)
      {
        y += sy;
        d -= ax;
      }
      x += sx;
      d += ay;
    }
  }
  else
  {
    d = ax - ay / 2;
    while (1)
    {
      fb[(y) * pitch + (x)] = (col);
      if (y == y2)
        return;
      if (d >= 0)
      {
        x += sx;
        d -= ay;
      }
      y += sy;
      d += ax;
    }
  }
}

// -AJA- 1999/07/05: Added these two functions.

void V_DrawPixel8(screen_t * scr, int x, int y, int col)
{
  scr->data[y * scr->pitch + x] = col;
}

void V_DrawBox8(screen_t * scr, int x, int y, int w, int h, int col)
{
  byte *dest;

  dest = scr->data + y * scr->pitch + x;

  for (y = 0; y < h; y++)
  {
    memset(dest, col, w);
    dest += scr->pitch;
  }
}

void V_DrawBoxAlpha8(screen_t * scr, int x, int y, int w, int h, int col, fixed_t alpha)
{
  byte *dest;

  fixed_t fglevel, bglevel;
  unsigned long *fg2rgb, *bg2rgb;
  unsigned long fg;  // current colours

  fglevel = alpha & ~0x3ff;
  bglevel = FRACUNIT - fglevel;

  fg2rgb = col2rgb8[fglevel >> 10];
  bg2rgb = col2rgb8[bglevel >> 10];

  dest = scr->data + y * scr->pitch + x;

  for (y=0; y < h; y++, dest += scr->pitch)
  {
    for (x=0; x < w; x++)
    {
      fg = (fg2rgb[col] + bg2rgb[dest[x]]) | 0x07c1fc1f;

      dest[x] = rgb_32k[0][0][fg & (fg >> 17)];
    }
  }
}

