//----------------------------------------------------------------------------
//  EDGE Video Code for 16-Bit Colour. 
//----------------------------------------------------------------------------
// 
//  Copyright (c) 1999-2001  The EDGE Team.
// 
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//----------------------------------------------------------------------------
//
//  Based on the DOOM source code, released by Id Software under the
//  following copyright:
//
//    Copyright (C) 1993-1996 by id Software, Inc.
//
//----------------------------------------------------------------------------

#include "i_defs.h"

#ifndef NOHICOLOUR

#include "v_video2.h"

#include "dm_data.h"
#include "dm_defs.h"
#include "dm_state.h"
#include "e_main.h"
#include "r_local.h"
#include "m_bbox.h"
#include "m_inline.h"
#include "m_misc.h"
#include "m_swap.h"
#include "v_res.h"
#include "v_colour.h"
#include "w_image.h"
#include "w_wad.h"
#include "w_image.h"
#include "z_zone.h"

//
// V_CopyRect16
// 
void V_CopyRect16(screen_t * destscr, screen_t * srcscr, int srcx, int srcy,
    int width, int height, int destx, int desty)
{
  byte *src;
  byte *dest;

  src = srcscr->data + srcscr->pitch * srcy + srcx * 2;
  dest = destscr->data + destscr->pitch * desty + destx * 2;

#ifdef DEVELOPERS
  if (srcx + width > srcscr->width || srcy + height > srcscr->height ||
      destx + width > destscr->width || desty + height > destscr->height ||
      (srcx | srcy | destx | desty) < 0)
    I_Error("V_CopyRect8: Coordinates outside screen boundaries!\n%d,%d, %d,%d, %d,%d",
        srcx, srcy, width, height, destx, desty);
#endif

  while (height--)
  {
    Z_MoveData(dest, src, byte, width * sizeof(short));
    src += srcscr->pitch;
    dest += destscr->pitch;
  }
}

//
// V_CopyScreen16
//
// Copies one screen to another. They must have equal size.
//
void V_CopyScreen16(screen_t * dest, screen_t * src)
{
  if (src->width != dest->width ||
      src->height != dest->height ||
      src->bytepp != dest->bytepp)
    I_Error("V_CopyScreen16:  Screens have different size!");

  V_CopyRect16(dest, src, 0, 0, src->width, src->height, 0, 0);
}

//
// Classic Bresenham w/ whatever optimizations needed for speed
//
// -AJA- 1999/07/04: Moved here from am_map.c.
// -ES- Optimise: This algorithm is very very poor.
void V_DrawLine16(screen_t * scr, int x1, int y1, int x2, int y2, int col)
{
  register int x;
  register int y;
  register int dx;
  register int dy;
  register int sx;
  register int sy;
  register int ax;
  register int ay;
  register int d;
  register short *fb = (short *)scr->data;
  int pitch = scr->pitch;

  dx = x2 - x1;
  ax = 2 * (dx < 0 ? -dx : dx);
  sx = dx < 0 ? -1 : 1;

  dy = y2 - y1;
  ay = 2 * (dy < 0 ? -dy : dy);
  sy = dy < 0 ? -1 : 1;

  x = x1;
  y = y1;

  if (ax > ay)
  {
    d = ay - ax / 2;
    while (1)
    {
      fb[(y) * pitch / 2 + (x)] = (short)pixel_values[col];
      if (x == x2)
        return;
      if (d >= 0)
      {
        y += sy;
        d -= ax;
      }
      x += sx;
      d += ay;
    }
  }
  else
  {
    d = ax - ay / 2;
    while (1)
    {
      fb[(y) * pitch / 2 + (x)] = (short)pixel_values[col];
      if (y == y2)
        return;
      if (d >= 0)
      {
        x += sx;
        d -= ay;
      }
      y += sy;
      d += ax;
    }
  }
}

// -AJA- 1999/07/05: Added these two functions.

void V_DrawPixel16(screen_t * scr, int x, int y, int col)
{
  short *line = (short *)&scr->data[y * scr->pitch];

  line[x] = (short)pixel_values[col];
}

void V_DrawBox16(screen_t * scr, int x, int y, int w, int h, int col)
{
  short *dest;

  col = (short)pixel_values[col];
  dest = (short *)(scr->data + y * scr->pitch) + x;

  for (y=0; y < h; y++)
  {
    for (x=0; x < w; x++)
      dest[x] = col;

    dest += scr->pitch / 2;
  }
}

void V_DrawBoxAlpha16(screen_t * scr, int x, int y, int w, int h, int col, fixed_t alpha)
{
  short *dest;

  fixed_t fglevel, bglevel;
  unsigned long c;  // current colour
  
  fglevel = (alpha + 1023) / 1040;
  bglevel = 64 - fglevel;

  col = (short)pixel_values[col];
  dest = (short *)(scr->data + y * scr->pitch) + x;

  for (y=0; y < h; y++)
  {
    for (x=0; x < w; x++)
    {
      c = col2rgb16[fglevel][(byte)col][0] +
          col2rgb16[fglevel][(byte)(col >> 8)][1] +
          col2rgb16[bglevel][((byte *)dest)[2*x]][0] +
          col2rgb16[bglevel][((byte *)dest)[2*x+1]][1];

      c |= hicolourtransmask;

      dest[x] = (short)(c & (c >> 16));
    }
    
    dest += scr->pitch / 2;
  }
}

#endif // NOHICOLOUR
