/* Doom RGB palette, straight from doom.wad */

const unsigned char doom_rgb[3 * 256] = {
 '\x00', '\x00', '\x00', '\x1F', '\x17', '\x0B', '\x17', '\x0F', '\x07',
 '\x4B', '\x4B', '\x4B', '\xFF', '\xFF', '\xFF', '\x1B', '\x1B', '\x1B',
 '\x13', '\x13', '\x13', '\x0B', '\x0B', '\x0B', '\x07', '\x07', '\x07',
 '\x2F', '\x37', '\x1F', '\x23', '\x2B', '\x0F', '\x17', '\x1F', '\x07',
 '\x0F', '\x17', '\x00', '\x4F', '\x3B', '\x2B', '\x47', '\x33', '\x23',
 '\x3F', '\x2B', '\x1B', '\xFF', '\xB7', '\xB7', '\xF7', '\xAB', '\xAB',
 '\xF3', '\xA3', '\xA3', '\xEB', '\x97', '\x97', '\xE7', '\x8F', '\x8F',
 '\xDF', '\x87', '\x87', '\xDB', '\x7B', '\x7B', '\xD3', '\x73', '\x73',
 '\xCB', '\x6B', '\x6B', '\xC7', '\x63', '\x63', '\xBF', '\x5B', '\x5B',
 '\xBB', '\x57', '\x57', '\xB3', '\x4F', '\x4F', '\xAF', '\x47', '\x47',
 '\xA7', '\x3F', '\x3F', '\xA3', '\x3B', '\x3B', '\x9B', '\x33', '\x33',
 '\x97', '\x2F', '\x2F', '\x8F', '\x2B', '\x2B', '\x8B', '\x23', '\x23',
 '\x83', '\x1F', '\x1F', '\x7F', '\x1B', '\x1B', '\x77', '\x17', '\x17',
 '\x73', '\x13', '\x13', '\x6B', '\x0F', '\x0F', '\x67', '\x0B', '\x0B',
 '\x5F', '\x07', '\x07', '\x5B', '\x07', '\x07', '\x53', '\x07', '\x07',
 '\x4F', '\x00', '\x00', '\x47', '\x00', '\x00', '\x43', '\x00', '\x00',
 '\xFF', '\xEB', '\xDF', '\xFF', '\xE3', '\xD3', '\xFF', '\xDB', '\xC7',
 '\xFF', '\xD3', '\xBB', '\xFF', '\xCF', '\xB3', '\xFF', '\xC7', '\xA7',
 '\xFF', '\xBF', '\x9B', '\xFF', '\xBB', '\x93', '\xFF', '\xB3', '\x83',
 '\xF7', '\xAB', '\x7B', '\xEF', '\xA3', '\x73', '\xE7', '\x9B', '\x6B',
 '\xDF', '\x93', '\x63', '\xD7', '\x8B', '\x5B', '\xCF', '\x83', '\x53',
 '\xCB', '\x7F', '\x4F', '\xBF', '\x7B', '\x4B', '\xB3', '\x73', '\x47',
 '\xAB', '\x6F', '\x43', '\xA3', '\x6B', '\x3F', '\x9B', '\x63', '\x3B',
 '\x8F', '\x5F', '\x37', '\x87', '\x57', '\x33', '\x7F', '\x53', '\x2F',
 '\x77', '\x4F', '\x2B', '\x6B', '\x47', '\x27', '\x5F', '\x43', '\x23',
 '\x53', '\x3F', '\x1F', '\x4B', '\x37', '\x1B', '\x3F', '\x2F', '\x17',
 '\x33', '\x2B', '\x13', '\x2B', '\x23', '\x0F', '\xEF', '\xEF', '\xEF',
 '\xE7', '\xE7', '\xE7', '\xDF', '\xDF', '\xDF', '\xDB', '\xDB', '\xDB',
 '\xD3', '\xD3', '\xD3', '\xCB', '\xCB', '\xCB', '\xC7', '\xC7', '\xC7',
 '\xBF', '\xBF', '\xBF', '\xB7', '\xB7', '\xB7', '\xB3', '\xB3', '\xB3',
 '\xAB', '\xAB', '\xAB', '\xA7', '\xA7', '\xA7', '\x9F', '\x9F', '\x9F',
 '\x97', '\x97', '\x97', '\x93', '\x93', '\x93', '\x8B', '\x8B', '\x8B',
 '\x83', '\x83', '\x83', '\x7F', '\x7F', '\x7F', '\x77', '\x77', '\x77',
 '\x6F', '\x6F', '\x6F', '\x6B', '\x6B', '\x6B', '\x63', '\x63', '\x63',
 '\x5B', '\x5B', '\x5B', '\x57', '\x57', '\x57', '\x4F', '\x4F', '\x4F',
 '\x47', '\x47', '\x47', '\x43', '\x43', '\x43', '\x3B', '\x3B', '\x3B',
 '\x37', '\x37', '\x37', '\x2F', '\x2F', '\x2F', '\x27', '\x27', '\x27',
 '\x23', '\x23', '\x23', '\x77', '\xFF', '\x6F', '\x6F', '\xEF', '\x67',
 '\x67', '\xDF', '\x5F', '\x5F', '\xCF', '\x57', '\x5B', '\xBF', '\x4F',
 '\x53', '\xAF', '\x47', '\x4B', '\x9F', '\x3F', '\x43', '\x93', '\x37',
 '\x3F', '\x83', '\x2F', '\x37', '\x73', '\x2B', '\x2F', '\x63', '\x23',
 '\x27', '\x53', '\x1B', '\x1F', '\x43', '\x17', '\x17', '\x33', '\x0F',
 '\x13', '\x23', '\x0B', '\x0B', '\x17', '\x07', '\xBF', '\xA7', '\x8F',
 '\xB7', '\x9F', '\x87', '\xAF', '\x97', '\x7F', '\xA7', '\x8F', '\x77',
 '\x9F', '\x87', '\x6F', '\x9B', '\x7F', '\x6B', '\x93', '\x7B', '\x63',
 '\x8B', '\x73', '\x5B', '\x83', '\x6B', '\x57', '\x7B', '\x63', '\x4F',
 '\x77', '\x5F', '\x4B', '\x6F', '\x57', '\x43', '\x67', '\x53', '\x3F',
 '\x5F', '\x4B', '\x37', '\x57', '\x43', '\x33', '\x53', '\x3F', '\x2F',
 '\x9F', '\x83', '\x63', '\x8F', '\x77', '\x53', '\x83', '\x6B', '\x4B',
 '\x77', '\x5F', '\x3F', '\x67', '\x53', '\x33', '\x5B', '\x47', '\x2B',
 '\x4F', '\x3B', '\x23', '\x43', '\x33', '\x1B', '\x7B', '\x7F', '\x63',
 '\x6F', '\x73', '\x57', '\x67', '\x6B', '\x4F', '\x5B', '\x63', '\x47',
 '\x53', '\x57', '\x3B', '\x47', '\x4F', '\x33', '\x3F', '\x47', '\x2B',
 '\x37', '\x3F', '\x27', '\xFF', '\xFF', '\x73', '\xEB', '\xDB', '\x57',
 '\xD7', '\xBB', '\x43', '\xC3', '\x9B', '\x2F', '\xAF', '\x7B', '\x1F',
 '\x9B', '\x5B', '\x13', '\x87', '\x43', '\x07', '\x73', '\x2B', '\x00',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xDB', '\xDB', '\xFF', '\xBB', '\xBB',
 '\xFF', '\x9B', '\x9B', '\xFF', '\x7B', '\x7B', '\xFF', '\x5F', '\x5F',
 '\xFF', '\x3F', '\x3F', '\xFF', '\x1F', '\x1F', '\xFF', '\x00', '\x00',
 '\xEF', '\x00', '\x00', '\xE3', '\x00', '\x00', '\xD7', '\x00', '\x00',
 '\xCB', '\x00', '\x00', '\xBF', '\x00', '\x00', '\xB3', '\x00', '\x00',
 '\xA7', '\x00', '\x00', '\x9B', '\x00', '\x00', '\x8B', '\x00', '\x00',
 '\x7F', '\x00', '\x00', '\x73', '\x00', '\x00', '\x67', '\x00', '\x00',
 '\x5B', '\x00', '\x00', '\x4F', '\x00', '\x00', '\x43', '\x00', '\x00',
 '\xE7', '\xE7', '\xFF', '\xC7', '\xC7', '\xFF', '\xAB', '\xAB', '\xFF',
 '\x8F', '\x8F', '\xFF', '\x73', '\x73', '\xFF', '\x53', '\x53', '\xFF',
 '\x37', '\x37', '\xFF', '\x1B', '\x1B', '\xFF', '\x00', '\x00', '\xFF',
 '\x00', '\x00', '\xE3', '\x00', '\x00', '\xCB', '\x00', '\x00', '\xB3',
 '\x00', '\x00', '\x9B', '\x00', '\x00', '\x83', '\x00', '\x00', '\x6B',
 '\x00', '\x00', '\x53', '\xFF', '\xFF', '\xFF', '\xFF', '\xEB', '\xDB',
 '\xFF', '\xD7', '\xBB', '\xFF', '\xC7', '\x9B', '\xFF', '\xB3', '\x7B',
 '\xFF', '\xA3', '\x5B', '\xFF', '\x8F', '\x3B', '\xFF', '\x7F', '\x1B',
 '\xF3', '\x73', '\x17', '\xEB', '\x6F', '\x0F', '\xDF', '\x67', '\x0F',
 '\xD7', '\x5F', '\x0B', '\xCB', '\x57', '\x07', '\xC3', '\x4F', '\x00',
 '\xB7', '\x47', '\x00', '\xAF', '\x43', '\x00', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xD7', '\xFF', '\xFF', '\xB3', '\xFF', '\xFF', '\x8F',
 '\xFF', '\xFF', '\x6B', '\xFF', '\xFF', '\x47', '\xFF', '\xFF', '\x23',
 '\xFF', '\xFF', '\x00', '\xA7', '\x3F', '\x00', '\x9F', '\x37', '\x00',
 '\x93', '\x2F', '\x00', '\x87', '\x23', '\x00', '\x4F', '\x3B', '\x27',
 '\x43', '\x2F', '\x1B', '\x37', '\x23', '\x13', '\x2F', '\x1B', '\x0B',
 '\x00', '\x00', '\x53', '\x00', '\x00', '\x47', '\x00', '\x00', '\x3B',
 '\x00', '\x00', '\x2F', '\x00', '\x00', '\x23', '\x00', '\x00', '\x17',
 '\x00', '\x00', '\x0B', '\x00', '\x00', '\x00', '\xFF', '\x9F', '\x43',
 '\xFF', '\xE7', '\x4B', '\xFF', '\x7B', '\xFF', '\xFF', '\x00', '\xFF',
 '\xCF', '\x00', '\xCF', '\x9F', '\x00', '\x9B', '\x6F', '\x00', '\x6B',
 '\xA7', '\x6B', '\x6B' };

/* Doom alpha 0.4 RGB palette, straight from doom.wad */

const unsigned char doom04_rgb[3 * 256] = {
 '\x00', '\x00', '\x00', '\x1C', '\x14', '\x08', '\x14', '\x0C', '\x04',
 '\x48', '\x48', '\x48', '\xFC', '\xFC', '\xFC', '\x18', '\x18', '\x18',
 '\x10', '\x10', '\x10', '\x08', '\x08', '\x08', '\x04', '\x04', '\x04',
 '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC',
 '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC',
 '\xFC', '\xFC', '\xFC', '\xFC', '\xB4', '\xB4', '\xF4', '\xA8', '\xA8',
 '\xF0', '\xA0', '\xA0', '\xE8', '\x94', '\x94', '\xE4', '\x8C', '\x8C',
 '\xDC', '\x84', '\x84', '\xD8', '\x78', '\x78', '\xD0', '\x70', '\x70',
 '\xC8', '\x68', '\x68', '\xC4', '\x60', '\x60', '\xBC', '\x58', '\x58',
 '\xB8', '\x54', '\x54', '\xB0', '\x4C', '\x4C', '\xAC', '\x44', '\x44',
 '\xA4', '\x3C', '\x3C', '\xA0', '\x38', '\x38', '\x98', '\x30', '\x30',
 '\x94', '\x2C', '\x2C', '\x8C', '\x28', '\x28', '\x88', '\x20', '\x20',
 '\x80', '\x1C', '\x1C', '\x7C', '\x18', '\x18', '\x74', '\x14', '\x14',
 '\x70', '\x10', '\x10', '\x68', '\x0C', '\x0C', '\x64', '\x08', '\x08',
 '\x5C', '\x04', '\x04', '\x58', '\x04', '\x04', '\x50', '\x04', '\x04',
 '\x4C', '\x00', '\x00', '\x44', '\x00', '\x00', '\x40', '\x00', '\x00',
 '\xFC', '\xE8', '\xDC', '\xFC', '\xE0', '\xD0', '\xFC', '\xD8', '\xC4',
 '\xFC', '\xD0', '\xB8', '\xFC', '\xCC', '\xB0', '\xFC', '\xC4', '\xA4',
 '\xFC', '\xBC', '\x98', '\xFC', '\xB8', '\x90', '\xFC', '\xB0', '\x80',
 '\xF4', '\xA8', '\x78', '\xEC', '\xA0', '\x70', '\xE4', '\x98', '\x68',
 '\xDC', '\x90', '\x60', '\xD4', '\x88', '\x58', '\xCC', '\x80', '\x50',
 '\xC8', '\x7C', '\x4C', '\xBC', '\x78', '\x48', '\xB0', '\x70', '\x44',
 '\xA8', '\x6C', '\x40', '\xA0', '\x68', '\x3C', '\x98', '\x60', '\x38',
 '\x8C', '\x5C', '\x34', '\x84', '\x54', '\x30', '\x7C', '\x50', '\x2C',
 '\x74', '\x4C', '\x28', '\x68', '\x44', '\x24', '\x5C', '\x40', '\x20',
 '\x50', '\x3C', '\x1C', '\x48', '\x34', '\x18', '\x3C', '\x2C', '\x14',
 '\x30', '\x28', '\x10', '\x28', '\x20', '\x0C', '\xEC', '\xEC', '\xEC',
 '\xE4', '\xE4', '\xE4', '\xDC', '\xDC', '\xDC', '\xD8', '\xD8', '\xD8',
 '\xD0', '\xD0', '\xD0', '\xC8', '\xC8', '\xC8', '\xC4', '\xC4', '\xC4',
 '\xBC', '\xBC', '\xBC', '\xB4', '\xB4', '\xB4', '\xB0', '\xB0', '\xB0',
 '\xA8', '\xA8', '\xA8', '\xA4', '\xA4', '\xA4', '\x9C', '\x9C', '\x9C',
 '\x94', '\x94', '\x94', '\x90', '\x90', '\x90', '\x88', '\x88', '\x88',
 '\x80', '\x80', '\x80', '\x7C', '\x7C', '\x7C', '\x74', '\x74', '\x74',
 '\x6C', '\x6C', '\x6C', '\x68', '\x68', '\x68', '\x60', '\x60', '\x60',
 '\x58', '\x58', '\x58', '\x54', '\x54', '\x54', '\x4C', '\x4C', '\x4C',
 '\x44', '\x44', '\x44', '\x40', '\x40', '\x40', '\x38', '\x38', '\x38',
 '\x34', '\x34', '\x34', '\x2C', '\x2C', '\x2C', '\x24', '\x24', '\x24',
 '\x20', '\x20', '\x20', '\x74', '\xFC', '\x6C', '\x6C', '\xEC', '\x64',
 '\x64', '\xDC', '\x5C', '\x5C', '\xCC', '\x54', '\x58', '\xBC', '\x4C',
 '\x50', '\xAC', '\x44', '\x48', '\x9C', '\x3C', '\x40', '\x90', '\x34',
 '\x3C', '\x80', '\x2C', '\x34', '\x70', '\x28', '\x2C', '\x60', '\x20',
 '\x24', '\x50', '\x18', '\x1C', '\x40', '\x14', '\x14', '\x30', '\x0C',
 '\x10', '\x20', '\x08', '\x08', '\x14', '\x04', '\xBC', '\xA4', '\x8C',
 '\xB4', '\x9C', '\x84', '\xAC', '\x94', '\x7C', '\xA4', '\x8C', '\x74',
 '\x9C', '\x84', '\x6C', '\x98', '\x7C', '\x68', '\x90', '\x78', '\x60',
 '\x88', '\x70', '\x58', '\x80', '\x68', '\x54', '\x78', '\x60', '\x4C',
 '\x74', '\x5C', '\x48', '\x6C', '\x54', '\x40', '\x64', '\x50', '\x3C',
 '\x5C', '\x48', '\x34', '\x54', '\x40', '\x30', '\x50', '\x3C', '\x2C',
 '\x9C', '\x80', '\x60', '\x8C', '\x74', '\x50', '\x80', '\x68', '\x48',
 '\x74', '\x5C', '\x3C', '\x64', '\x50', '\x30', '\x58', '\x44', '\x28',
 '\x4C', '\x38', '\x20', '\x40', '\x30', '\x18', '\x78', '\x7C', '\x60',
 '\x6C', '\x70', '\x54', '\x64', '\x68', '\x4C', '\x58', '\x60', '\x44',
 '\x50', '\x54', '\x38', '\x44', '\x4C', '\x30', '\x3C', '\x44', '\x28',
 '\x34', '\x3C', '\x24', '\xFC', '\xFC', '\x70', '\xE8', '\xD8', '\x54',
 '\xD4', '\xB8', '\x40', '\xC0', '\x98', '\x2C', '\xAC', '\x78', '\x1C',
 '\x98', '\x58', '\x10', '\x84', '\x40', '\x04', '\x70', '\x28', '\x00',
 '\xFC', '\xFC', '\xFC', '\xFC', '\xD8', '\xD8', '\xFC', '\xB8', '\xB8',
 '\xFC', '\x98', '\x98', '\xFC', '\x78', '\x78', '\xFC', '\x5C', '\x5C',
 '\xFC', '\x3C', '\x3C', '\xFC', '\x1C', '\x1C', '\xFC', '\x00', '\x00',
 '\xEC', '\x00', '\x00', '\xE0', '\x00', '\x00', '\xD4', '\x00', '\x00',
 '\xC8', '\x00', '\x00', '\xBC', '\x00', '\x00', '\xB0', '\x00', '\x00',
 '\xA4', '\x00', '\x00', '\x98', '\x00', '\x00', '\x88', '\x00', '\x00',
 '\x7C', '\x00', '\x00', '\x70', '\x00', '\x00', '\x64', '\x00', '\x00',
 '\x58', '\x00', '\x00', '\x4C', '\x00', '\x00', '\x40', '\x00', '\x00',
 '\xE4', '\xE4', '\xFC', '\xC4', '\xC4', '\xFC', '\xA8', '\xA8', '\xFC',
 '\x8C', '\x8C', '\xFC', '\x70', '\x70', '\xFC', '\x50', '\x50', '\xFC',
 '\x34', '\x34', '\xFC', '\x18', '\x18', '\xFC', '\x00', '\x00', '\xFC',
 '\x00', '\x00', '\xE0', '\x00', '\x00', '\xC8', '\x00', '\x00', '\xB0',
 '\x00', '\x00', '\x98', '\x00', '\x00', '\x80', '\x00', '\x00', '\x68',
 '\x00', '\x00', '\x50', '\xFC', '\xFC', '\xFC', '\xFC', '\xE8', '\xD8',
 '\xFC', '\xD4', '\xB8', '\xFC', '\xC4', '\x98', '\xFC', '\xB0', '\x78',
 '\xFC', '\xA0', '\x58', '\xFC', '\x8C', '\x38', '\xFC', '\x7C', '\x18',
 '\xF0', '\x70', '\x14', '\xE8', '\x6C', '\x0C', '\xDC', '\x64', '\x0C',
 '\xD4', '\x5C', '\x08', '\xC8', '\x54', '\x04', '\xC0', '\x4C', '\x00',
 '\xB4', '\x44', '\x00', '\xAC', '\x40', '\x00', '\xFC', '\xFC', '\xFC',
 '\xFC', '\xFC', '\xD4', '\xFC', '\xFC', '\xB0', '\xFC', '\xFC', '\x8C',
 '\xFC', '\xFC', '\x68', '\xFC', '\xFC', '\x44', '\xFC', '\xFC', '\x20',
 '\xFC', '\xFC', '\x00', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC',
 '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC',
 '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC', '\xFC',
 '\x00', '\x00', '\x50', '\x00', '\x00', '\x44', '\x00', '\x00', '\x38',
 '\x00', '\x00', '\x2C', '\x00', '\x00', '\x20', '\x00', '\x00', '\x14',
 '\x00', '\x00', '\x08', '\x00', '\x00', '\x00', '\xFC', '\xFC', '\xFC',
 '\xFC', '\xFC', '\xFC', '\xFC', '\x78', '\xFC', '\xFC', '\x00', '\xFC',
 '\xCC', '\x00', '\xCC', '\x9C', '\x00', '\x98', '\x6C', '\x00', '\x68',
 '\xA4', '\x68', '\x68' };

/* Doom alpha 0.4 TITLEPIC RGB palette, straight from doom.wad/TITLEPAL */

const unsigned char doom04t_rgb[3 * 256] = {
 '\x00', '\x00', '\x00', '\x5F', '\x2B', '\x33', '\x7B', '\x9B', '\x43',
 '\x6B', '\x9F', '\xA3', '\x00', '\x00', '\x47', '\x6F', '\x00', '\x6B',
 '\x0F', '\x0F', '\x67', '\xA3', '\x33', '\x3F', '\x9F', '\x00', '\x9B',
 '\xFF', '\xFF', '\x00', '\x17', '\x17', '\x1B', '\x37', '\x53', '\x63',
 '\x33', '\x23', '\x2F', '\xEF', '\xE7', '\x3F', '\x9F', '\x57', '\x43',
 '\x63', '\x53', '\x37', '\xF7', '\xE7', '\xA3', '\xAF', '\x33', '\x5F',
 '\xD7', '\xA7', '\x43', '\xCF', '\x00', '\xCF', '\x37', '\x53', '\x9B',
 '\x27', '\x27', '\x2F', '\xDF', '\x9F', '\xA3', '\x67', '\x67', '\x63',
 '\x67', '\x53', '\x9B', '\xCF', '\x57', '\x43', '\x37', '\x37', '\x37',
 '\xFF', '\x00', '\x00', '\x00', '\x00', '\x83', '\x23', '\x23', '\x27',
 '\xA7', '\x5F', '\x5B', '\x77', '\x33', '\x00', '\x67', '\x6B', '\x3F',
 '\xD7', '\x5B', '\xA3', '\x37', '\x77', '\xA3', '\xC7', '\xAB', '\xAF',
 '\xDB', '\xD3', '\x3F', '\xB3', '\x9F', '\x43', '\x7B', '\x2F', '\x3F',
 '\xEB', '\xE7', '\x4F', '\x27', '\x23', '\x3F', '\x47', '\x27', '\x2F',
 '\x3F', '\x33', '\x7B', '\x2F', '\x1F', '\x27', '\x3B', '\x67', '\x6B',
 '\x3F', '\x4B', '\x37', '\xFF', '\x00', '\xFF', '\xCB', '\x33', '\x3F',
 '\xE7', '\xF3', '\xE7', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\x23',
 '\x9F', '\x77', '\x43', '\xCF', '\x77', '\x43', '\x37', '\x27', '\x43',
 '\x3B', '\x2F', '\x5F', '\x8B', '\xA3', '\x67', '\x83', '\x4B', '\x3F',
 '\x33', '\x3F', '\x7B', '\x77', '\x33', '\x37', '\xD3', '\x5F', '\x5F',
 '\x6B', '\x47', '\x5F', '\xF7', '\xFF', '\xF3', '\xEB', '\xE7', '\x9F',
 '\xCB', '\x2F', '\x3B', '\x8B', '\x6B', '\x3B', '\xD7', '\xA7', '\x53',
 '\xE7', '\xEB', '\x63', '\xBB', '\xA7', '\x53', '\x4F', '\x3B', '\x33',
 '\x37', '\x53', '\x83', '\xF3', '\xFB', '\xEF', '\xCB', '\x37', '\x5B',
 '\x67', '\x7B', '\x87', '\xDF', '\xD3', '\x4F', '\xBB', '\x2B', '\x3B',
 '\x2F', '\x37', '\x5F', '\x8B', '\x63', '\xA3', '\x33', '\x2F', '\x7B',
 '\x1B', '\x1B', '\x23', '\x23', '\x1B', '\x37', '\x37', '\x7F', '\xB7',
 '\x43', '\x1F', '\x2B', '\x5F', '\x3B', '\x33', '\x47', '\x2B', '\x3B',
 '\x9F', '\xAB', '\xA3', '\x3B', '\x6B', '\x87', '\x8B', '\x33', '\x3F',
 '\xCB', '\x2B', '\x3B', '\x3B', '\x5B', '\x4B', '\x3F', '\x3F', '\x8F',
 '\x8B', '\x7B', '\x47', '\xD3', '\x83', '\x5F', '\xEF', '\x9F', '\x3F',
 '\xE7', '\x7B', '\x3F', '\x8B', '\x47', '\x5B', '\x27', '\x23', '\x4F',
 '\x4B', '\x53', '\x9B', '\xD3', '\xDB', '\xD7', '\xBB', '\xB3', '\x43',
 '\xCF', '\x43', '\x47', '\x67', '\x2F', '\x5B', '\x3B', '\x3F', '\x67',
 '\x37', '\x3B', '\x4F', '\xCB', '\x3B', '\x6B', '\xAB', '\x33', '\x7F',
 '\xE3', '\xA7', '\x77', '\xBF', '\xC7', '\x57', '\xF3', '\xCB', '\x3F',
 '\x8B', '\x63', '\x67', '\x87', '\x2F', '\x5F', '\xFF', '\xF7', '\x3F',
 '\x67', '\x7F', '\x43', '\xB3', '\x57', '\x43', '\xDB', '\xCF', '\x5F',
 '\x9F', '\x47', '\x43', '\x2F', '\x2B', '\x5F', '\xF3', '\xF3', '\xE3',
 '\x4B', '\x7B', '\xB3', '\xDF', '\x57', '\x3F', '\xDF', '\xAB', '\xD3',
 '\x9F', '\x9B', '\x47', '\xB7', '\x7F', '\x3B', '\x7F', '\x73', '\x7F',
 '\x67', '\x2F', '\x3B', '\x37', '\x4B', '\x4F', '\xB7', '\x3F', '\x43',
 '\x67', '\x7F', '\xA7', '\xDF', '\xEB', '\xE3', '\x47', '\x77', '\x83',
 '\x4F', '\x8B', '\x9F', '\x5F', '\x3B', '\x43', '\xF3', '\xEF', '\x7F',
 '\x8B', '\x7F', '\xAF', '\xAB', '\x7B', '\x5F', '\x37', '\x2B', '\x53',
 '\x4F', '\x3B', '\x47', '\x73', '\x4B', '\x3F', '\x2B', '\x2B', '\x2F',
 '\x2B', '\x2F', '\x53', '\x47', '\x57', '\x67', '\x2B', '\x2B', '\x3F',
 '\x4B', '\x2B', '\x4B', '\x53', '\x2B', '\x33', '\x47', '\x7F', '\x6F',
 '\x27', '\x27', '\x2B', '\x2B', '\x27', '\x63', '\x4B', '\x2F', '\x67',
 '\x47', '\x57', '\x83', '\x33', '\x3F', '\x8B', '\x67', '\x43', '\x7F',
 '\x7F', '\xA7', '\x87', '\x53', '\x63', '\x37', '\xFF', '\xFB', '\x4F',
 '\xDF', '\xE7', '\xDF', '\x4B', '\x67', '\x97', '\x7B', '\x3F', '\x3F',
 '\xD7', '\xBB', '\x43', '\x37', '\x63', '\x9F', '\x00', '\x00', '\xAF',
 '\xA7', '\xB3', '\xBB', '\x8B', '\x47', '\x77', '\x47', '\x27', '\x2B',
 '\xBF', '\xCB', '\xC7', '\xDB', '\x8B', '\xBB', '\x1F', '\x1F', '\x27',
 '\x83', '\x83', '\x63', '\x3B', '\x27', '\x33', '\x8F', '\x4B', '\x43',
 '\x6F', '\x7F', '\x63', '\x3F', '\x3F', '\x7F', '\x77', '\xAB', '\xBF',
 '\x2F', '\x33', '\x6F', '\x8B', '\x3F', '\x43', '\xD3', '\x3F', '\x3B',
 '\xFB', '\xEB', '\x3F', '\x4F', '\x3F', '\x8F', '\xF3', '\xB3', '\x3F',
 '\xB7', '\xCB', '\x73', '\x4F', '\x8F', '\xBB', '\xD3', '\x87', '\x7B',
 '\x2F', '\x2B', '\x2B', '\xDF', '\xD7', '\xDB', '\x6B', '\x2B', '\x33',
 '\x87', '\x2F', '\x37', '\xA7', '\x77', '\x7B', '\x17', '\x17', '\x1F',
 '\x47', '\x77', '\x9F', '\xF3', '\xCF', '\x4B', '\x9F', '\x8B', '\x47',
 '\x33', '\x2B', '\x6B', '\x47', '\x3F', '\x6B', '\x9B', '\xB3', '\x87',
 '\xE3', '\x6B', '\x3F', '\xB3', '\x83', '\x47', '\x77', '\x6B', '\x43',
 '\xEB', '\x8B', '\x3F', '\x53', '\x4B', '\x37', '\x9F', '\xAF', '\x47',
 '\xDB', '\x47', '\x43', '\xCB', '\x3F', '\x83', '\x9F', '\x67', '\x43',
 '\x4B', '\x67', '\xAB', '\xE3', '\xE7', '\xD7', '\xFB', '\xEF', '\x4F',
 '\x7B', '\x87', '\x83', '\xFF', '\xFF', '\xF7', '\x63', '\x53', '\x47',
 '\xCF', '\x8B', '\x43', '\x63', '\x2F', '\x73', '\xBB', '\x2F', '\x47',
 '\xEF', '\xAB', '\x4F', '\xBF', '\xC7', '\x43', '\x3B', '\x2F', '\x6F',
 '\xEB', '\xF7', '\xEF', '\x4B', '\x67', '\x6F', '\x8B', '\x2F', '\x7B',
 '\xB3', '\x67', '\x43', '\x47', '\x4B', '\x4F', '\x47', '\x37', '\x2B',
 '\x73', '\x57', '\x3F', '\xF3', '\xDB', '\x3F', '\x93', '\xBB', '\x6F',
 '\xCB', '\x67', '\x43', '\x2B', '\x3F', '\x53', '\x6B', '\x3B', '\x37',
 '\xCB', '\x33', '\x4B', '\xB7', '\x4B', '\x9F', '\x67', '\x2B', '\x47',
 '\xFB', '\xF7', '\x63', '\x4B', '\x6B', '\x83', '\x53', '\x5F', '\x4F',
 '\xE7', '\xC7', '\xA3', '\x83', '\x5B', '\x43', '\xAF', '\x87', '\x9F',
 '\x33', '\x2F', '\x33', '\x53', '\x2B', '\x3B', '\xBB', '\xA7', '\x6B',
 '\x77', '\x7F', '\x3F', '\xD3', '\x5F', '\x73', '\x4B', '\x33', '\x7B',
 '\x6B', '\x3B', '\x43', '\x87', '\xAF', '\x9F', '\x33', '\x53', '\x6F',
 '\x8B', '\x8B', '\x43', '\x2B', '\x3B', '\x43', '\x4F', '\x3F', '\x7F',
 '\x8F', '\xA3', '\x43', '\xE7', '\xD3', '\x77', '\xC7', '\x9F', '\x3B',
 '\x4F', '\x8B', '\x87', '\x2F', '\x3F', '\x6F', '\x3F', '\x6B', '\x4F',
 '\x8F', '\x5B', '\x43', '\x8B', '\x6B', '\x4B', '\xA3', '\x5F', '\x6B',
 '\xA7', '\x6B', '\x6B' };

/* Doom alpha 0.5 RGB palette, straight from doom.wad */

const unsigned char doom05_rgb[3 * 256] = {
 '\x00', '\x00', '\x00', '\x1F', '\x17', '\x0B', '\x17', '\x0F', '\x07',
 '\x4B', '\x4B', '\x4B', '\xFF', '\xFF', '\xFF', '\x1B', '\x1B', '\x1B',
 '\x13', '\x13', '\x13', '\x0B', '\x0B', '\x0B', '\x07', '\x07', '\x07',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xB7', '\xB7', '\xF7', '\xAB', '\xAB',
 '\xF3', '\xA3', '\xA3', '\xEB', '\x97', '\x97', '\xE7', '\x8F', '\x8F',
 '\xDF', '\x87', '\x87', '\xDB', '\x7B', '\x7B', '\xD3', '\x73', '\x73',
 '\xCB', '\x6B', '\x6B', '\xC7', '\x63', '\x63', '\xBF', '\x5B', '\x5B',
 '\xBB', '\x57', '\x57', '\xB3', '\x4F', '\x4F', '\xAF', '\x47', '\x47',
 '\xA7', '\x3F', '\x3F', '\xA3', '\x3B', '\x3B', '\x9B', '\x33', '\x33',
 '\x97', '\x2F', '\x2F', '\x8F', '\x2B', '\x2B', '\x8B', '\x23', '\x23',
 '\x83', '\x1F', '\x1F', '\x7F', '\x1B', '\x1B', '\x77', '\x17', '\x17',
 '\x73', '\x13', '\x13', '\x6B', '\x0F', '\x0F', '\x67', '\x0B', '\x0B',
 '\x5F', '\x07', '\x07', '\x5B', '\x07', '\x07', '\x53', '\x07', '\x07',
 '\x4F', '\x00', '\x00', '\x47', '\x00', '\x00', '\x43', '\x00', '\x00',
 '\xFF', '\xEB', '\xDF', '\xFF', '\xE3', '\xD3', '\xFF', '\xDB', '\xC7',
 '\xFF', '\xD3', '\xBB', '\xFF', '\xCF', '\xB3', '\xFF', '\xC7', '\xA7',
 '\xFF', '\xBF', '\x9B', '\xFF', '\xBB', '\x93', '\xFF', '\xB3', '\x83',
 '\xF7', '\xAB', '\x7B', '\xEF', '\xA3', '\x73', '\xE7', '\x9B', '\x6B',
 '\xDF', '\x93', '\x63', '\xD7', '\x8B', '\x5B', '\xCF', '\x83', '\x53',
 '\xCB', '\x7F', '\x4F', '\xBF', '\x7B', '\x4B', '\xB3', '\x73', '\x47',
 '\xAB', '\x6F', '\x43', '\xA3', '\x6B', '\x3F', '\x9B', '\x63', '\x3B',
 '\x8F', '\x5F', '\x37', '\x87', '\x57', '\x33', '\x7F', '\x53', '\x2F',
 '\x77', '\x4F', '\x2B', '\x6B', '\x47', '\x27', '\x5F', '\x43', '\x23',
 '\x53', '\x3F', '\x1F', '\x4B', '\x37', '\x1B', '\x3F', '\x2F', '\x17',
 '\x33', '\x2B', '\x13', '\x2B', '\x23', '\x0F', '\xEF', '\xEF', '\xEF',
 '\xE7', '\xE7', '\xE7', '\xDF', '\xDF', '\xDF', '\xDB', '\xDB', '\xDB',
 '\xD3', '\xD3', '\xD3', '\xCB', '\xCB', '\xCB', '\xC7', '\xC7', '\xC7',
 '\xBF', '\xBF', '\xBF', '\xB7', '\xB7', '\xB7', '\xB3', '\xB3', '\xB3',
 '\xAB', '\xAB', '\xAB', '\xA7', '\xA7', '\xA7', '\x9F', '\x9F', '\x9F',
 '\x97', '\x97', '\x97', '\x93', '\x93', '\x93', '\x8B', '\x8B', '\x8B',
 '\x83', '\x83', '\x83', '\x7F', '\x7F', '\x7F', '\x77', '\x77', '\x77',
 '\x6F', '\x6F', '\x6F', '\x6B', '\x6B', '\x6B', '\x63', '\x63', '\x63',
 '\x5B', '\x5B', '\x5B', '\x57', '\x57', '\x57', '\x4F', '\x4F', '\x4F',
 '\x47', '\x47', '\x47', '\x43', '\x43', '\x43', '\x3B', '\x3B', '\x3B',
 '\x37', '\x37', '\x37', '\x2F', '\x2F', '\x2F', '\x27', '\x27', '\x27',
 '\x23', '\x23', '\x23', '\x77', '\xFF', '\x6F', '\x6F', '\xEF', '\x67',
 '\x67', '\xDF', '\x5F', '\x5F', '\xCF', '\x57', '\x5B', '\xBF', '\x4F',
 '\x53', '\xAF', '\x47', '\x4B', '\x9F', '\x3F', '\x43', '\x93', '\x37',
 '\x3F', '\x83', '\x2F', '\x37', '\x73', '\x2B', '\x2F', '\x63', '\x23',
 '\x27', '\x53', '\x1B', '\x1F', '\x43', '\x17', '\x17', '\x33', '\x0F',
 '\x13', '\x23', '\x0B', '\x0B', '\x17', '\x07', '\xBF', '\xA7', '\x8F',
 '\xB7', '\x9F', '\x87', '\xAF', '\x97', '\x7F', '\xA7', '\x8F', '\x77',
 '\x9F', '\x87', '\x6F', '\x9B', '\x7F', '\x6B', '\x93', '\x7B', '\x63',
 '\x8B', '\x73', '\x5B', '\x83', '\x6B', '\x57', '\x7B', '\x63', '\x4F',
 '\x77', '\x5F', '\x4B', '\x6F', '\x57', '\x43', '\x67', '\x53', '\x3F',
 '\x5F', '\x4B', '\x37', '\x57', '\x43', '\x33', '\x53', '\x3F', '\x2F',
 '\x9F', '\x83', '\x63', '\x8F', '\x77', '\x53', '\x83', '\x6B', '\x4B',
 '\x77', '\x5F', '\x3F', '\x67', '\x53', '\x33', '\x5B', '\x47', '\x2B',
 '\x4F', '\x3B', '\x23', '\x43', '\x33', '\x1B', '\x7B', '\x7F', '\x63',
 '\x6F', '\x73', '\x57', '\x67', '\x6B', '\x4F', '\x5B', '\x63', '\x47',
 '\x53', '\x57', '\x3B', '\x47', '\x4F', '\x33', '\x3F', '\x47', '\x2B',
 '\x37', '\x3F', '\x27', '\xFF', '\xFF', '\x73', '\xEB', '\xDB', '\x57',
 '\xD7', '\xBB', '\x43', '\xC3', '\x9B', '\x2F', '\xAF', '\x7B', '\x1F',
 '\x9B', '\x5B', '\x13', '\x87', '\x43', '\x07', '\x73', '\x2B', '\x00',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xDB', '\xDB', '\xFF', '\xBB', '\xBB',
 '\xFF', '\x9B', '\x9B', '\xFF', '\x7B', '\x7B', '\xFF', '\x5F', '\x5F',
 '\xFF', '\x3F', '\x3F', '\xFF', '\x1F', '\x1F', '\xFF', '\x00', '\x00',
 '\xEF', '\x00', '\x00', '\xE3', '\x00', '\x00', '\xD7', '\x00', '\x00',
 '\xCB', '\x00', '\x00', '\xBF', '\x00', '\x00', '\xB3', '\x00', '\x00',
 '\xA7', '\x00', '\x00', '\x9B', '\x00', '\x00', '\x8B', '\x00', '\x00',
 '\x7F', '\x00', '\x00', '\x73', '\x00', '\x00', '\x67', '\x00', '\x00',
 '\x5B', '\x00', '\x00', '\x4F', '\x00', '\x00', '\x43', '\x00', '\x00',
 '\xE7', '\xE7', '\xFF', '\xC7', '\xC7', '\xFF', '\xAB', '\xAB', '\xFF',
 '\x8F', '\x8F', '\xFF', '\x73', '\x73', '\xFF', '\x53', '\x53', '\xFF',
 '\x37', '\x37', '\xFF', '\x1B', '\x1B', '\xFF', '\x00', '\x00', '\xFF',
 '\x00', '\x00', '\xE3', '\x00', '\x00', '\xCB', '\x00', '\x00', '\xB3',
 '\x00', '\x00', '\x9B', '\x00', '\x00', '\x83', '\x00', '\x00', '\x6B',
 '\x00', '\x00', '\x53', '\xFF', '\xFF', '\xFF', '\xFF', '\xEB', '\xDB',
 '\xFF', '\xD7', '\xBB', '\xFF', '\xC7', '\x9B', '\xFF', '\xB3', '\x7B',
 '\xFF', '\xA3', '\x5B', '\xFF', '\x8F', '\x3B', '\xFF', '\x7F', '\x1B',
 '\xF3', '\x73', '\x17', '\xEB', '\x6F', '\x0F', '\xDF', '\x67', '\x0F',
 '\xD7', '\x5F', '\x0B', '\xCB', '\x57', '\x07', '\xC3', '\x4F', '\x00',
 '\xB7', '\x47', '\x00', '\xAF', '\x43', '\x00', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xD7', '\xFF', '\xFF', '\xB3', '\xFF', '\xFF', '\x8F',
 '\xFF', '\xFF', '\x6B', '\xFF', '\xFF', '\x47', '\xFF', '\xFF', '\x23',
 '\xFF', '\xFF', '\x00', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF', '\xFF',
 '\x00', '\x00', '\x53', '\x00', '\x00', '\x47', '\x00', '\x00', '\x3B',
 '\x00', '\x00', '\x2F', '\x00', '\x00', '\x23', '\x00', '\x00', '\x17',
 '\x00', '\x00', '\x0B', '\x00', '\x00', '\x00', '\xFF', '\xFF', '\xFF',
 '\xFF', '\xFF', '\xFF', '\xFF', '\x7B', '\xFF', '\xFF', '\x00', '\xFF',
 '\xCF', '\x00', '\xCF', '\x9F', '\x00', '\x9B', '\x6F', '\x00', '\x6B',
 '\xA7', '\x6B', '\x6B' };

/* Doom alpha 0.5 TITLEPIC RGB palette, straight from doom.wad/TITLEPAL */

const unsigned char *const doom05t_rgb = doom04t_rgb;

/* Heretic RGB palette, straight from heretic_share.wad */

const unsigned char heretic_rgb[3 * 256] = {
 '\x02', '\x02', '\x02', '\x02', '\x02', '\x02', '\x10', '\x10', '\x10',
 '\x18', '\x18', '\x18', '\x1F', '\x1F', '\x1F', '\x24', '\x24', '\x24',
 '\x2C', '\x2C', '\x2C', '\x30', '\x30', '\x30', '\x37', '\x37', '\x37',
 '\x3F', '\x3F', '\x3F', '\x46', '\x46', '\x46', '\x4E', '\x4E', '\x4E',
 '\x56', '\x56', '\x56', '\x5D', '\x5D', '\x5D', '\x65', '\x65', '\x65',
 '\x6C', '\x6C', '\x6C', '\x74', '\x74', '\x74', '\x7C', '\x7C', '\x7C',
 '\x83', '\x83', '\x83', '\x8B', '\x8B', '\x8B', '\x92', '\x92', '\x92',
 '\x9A', '\x9A', '\x9A', '\xA2', '\xA2', '\xA2', '\xA9', '\xA9', '\xA9',
 '\xB1', '\xB1', '\xB1', '\xB8', '\xB8', '\xB8', '\xC0', '\xC0', '\xC0',
 '\xC8', '\xC8', '\xC8', '\xCF', '\xCF', '\xCF', '\xD2', '\xD2', '\xD2',
 '\xD7', '\xD7', '\xD7', '\xDE', '\xDE', '\xDE', '\xE4', '\xE4', '\xE4',
 '\xEC', '\xEC', '\xEC', '\xF5', '\xF5', '\xF5', '\xFF', '\xFF', '\xFF',
 '\x32', '\x32', '\x32', '\x3B', '\x3C', '\x3B', '\x45', '\x48', '\x44',
 '\x4E', '\x50', '\x4D', '\x58', '\x5D', '\x56', '\x61', '\x64', '\x5F',
 '\x6D', '\x70', '\x68', '\x74', '\x7B', '\x70', '\x7D', '\x83', '\x79',
 '\x86', '\x8D', '\x82', '\x90', '\x97', '\x8B', '\x99', '\xA1', '\x94',
 '\xA3', '\xAB', '\x9D', '\xAC', '\xB5', '\xA6', '\xB5', '\xBD', '\xB0',
 '\xBD', '\xC4', '\xB9', '\x14', '\x10', '\x24', '\x18', '\x18', '\x2C',
 '\x24', '\x24', '\x3C', '\x34', '\x34', '\x50', '\x44', '\x44', '\x60',
 '\x58', '\x58', '\x74', '\x6C', '\x6C', '\x88', '\x7C', '\x7C', '\x98',
 '\x94', '\x94', '\xAC', '\xA4', '\xA4', '\xB8', '\xB4', '\xB8', '\xC8',
 '\xC0', '\xC4', '\xD0', '\xD0', '\xD0', '\xD8', '\xE0', '\xE0', '\xE0',
 '\x1B', '\x0F', '\x08', '\x26', '\x14', '\x0B', '\x31', '\x1B', '\x0E',
 '\x3D', '\x1F', '\x0E', '\x41', '\x23', '\x12', '\x4A', '\x25', '\x13',
 '\x53', '\x2B', '\x13', '\x57', '\x2F', '\x17', '\x5F', '\x33', '\x1B',
 '\x67', '\x3B', '\x1F', '\x73', '\x43', '\x23', '\x7B', '\x4B', '\x27',
 '\x83', '\x53', '\x2F', '\x8F', '\x5B', '\x33', '\x97', '\x63', '\x3B',
 '\xA0', '\x6C', '\x40', '\xAF', '\x74', '\x4A', '\xB4', '\x7E', '\x51',
 '\xC0', '\x87', '\x5B', '\xCC', '\x8F', '\x5D', '\xD5', '\x97', '\x67',
 '\xD8', '\x9F', '\x73', '\xDC', '\xA7', '\x7E', '\xDF', '\xAF', '\x8A',
 '\xE3', '\xB7', '\x95', '\xE6', '\xBE', '\xA1', '\xE9', '\xC6', '\xAC',
 '\xED', '\xCE', '\xB8', '\xF0', '\xD6', '\xC3', '\x3E', '\x28', '\x0B',
 '\x4B', '\x32', '\x10', '\x54', '\x3B', '\x17', '\x5F', '\x43', '\x1E',
 '\x67', '\x4B', '\x26', '\x6E', '\x53', '\x2F', '\x7B', '\x5F', '\x37',
 '\x89', '\x6B', '\x3E', '\x96', '\x76', '\x4B', '\xA3', '\x81', '\x54',
 '\xAB', '\x89', '\x5C', '\xB4', '\x92', '\x65', '\xBC', '\x9A', '\x6D',
 '\xC4', '\xA2', '\x75', '\xCC', '\xAA', '\x7D', '\xD0', '\xB0', '\x85',
 '\x25', '\x14', '\x04', '\x2F', '\x18', '\x04', '\x39', '\x1C', '\x06',
 '\x44', '\x21', '\x04', '\x4C', '\x24', '\x03', '\x54', '\x28', '\x00',
 '\x61', '\x2F', '\x02', '\x72', '\x36', '\x00', '\x7D', '\x3F', '\x06',
 '\x8D', '\x4B', '\x09', '\x9B', '\x53', '\x11', '\xA2', '\x5F', '\x15',
 '\xA9', '\x67', '\x1A', '\xB4', '\x71', '\x20', '\xBC', '\x7C', '\x14',
 '\xCC', '\x88', '\x18', '\xDC', '\x94', '\x1C', '\xEC', '\xA0', '\x17',
 '\xF4', '\xAC', '\x2F', '\xFC', '\xBB', '\x39', '\xFC', '\xC2', '\x46',
 '\xFB', '\xC9', '\x53', '\xFB', '\xD0', '\x61', '\xFB', '\xD6', '\x6E',
 '\xFB', '\xDD', '\x7B', '\xFA', '\xE4', '\x88', '\x9D', '\x33', '\x04',
 '\xAA', '\x41', '\x02', '\xB9', '\x56', '\x04', '\xD5', '\x76', '\x04',
 '\xEC', '\xA4', '\x03', '\xF8', '\xBE', '\x03', '\xFF', '\xD8', '\x2B',
 '\xFF', '\xFF', '\x00', '\x43', '\x00', '\x00', '\x4F', '\x00', '\x00',
 '\x5B', '\x00', '\x00', '\x67', '\x00', '\x00', '\x73', '\x00', '\x00',
 '\x7F', '\x00', '\x00', '\x8B', '\x00', '\x00', '\x9B', '\x00', '\x00',
 '\xA7', '\x00', '\x00', '\xB3', '\x00', '\x00', '\xBF', '\x00', '\x00',
 '\xCB', '\x00', '\x00', '\xD7', '\x00', '\x00', '\xE3', '\x00', '\x00',
 '\xEF', '\x00', '\x00', '\xFF', '\x00', '\x00', '\xFF', '\x34', '\x34',
 '\xFF', '\x4A', '\x4A', '\xFF', '\x5F', '\x5F', '\xFF', '\x7B', '\x7B',
 '\xFF', '\x9B', '\x9B', '\xFF', '\xB3', '\xB3', '\xFF', '\xC9', '\xC9',
 '\xFF', '\xD7', '\xD7', '\x3C', '\x0C', '\x58', '\x50', '\x08', '\x6C',
 '\x68', '\x08', '\x80', '\x80', '\x00', '\x90', '\x98', '\x00', '\xB0',
 '\xB8', '\x00', '\xE0', '\xD8', '\x2C', '\xFC', '\xE0', '\x78', '\xF0',
 '\x25', '\x06', '\x81', '\x3C', '\x21', '\x93', '\x52', '\x3D', '\xA5',
 '\x69', '\x58', '\xB7', '\x80', '\x74', '\xC9', '\x97', '\x8F', '\xDB',
 '\xAD', '\xAB', '\xED', '\xC4', '\xC6', '\xFF', '\x02', '\x04', '\x29',
 '\x02', '\x05', '\x31', '\x06', '\x08', '\x39', '\x02', '\x05', '\x41',
 '\x02', '\x05', '\x4F', '\x00', '\x04', '\x58', '\x00', '\x04', '\x60',
 '\x00', '\x04', '\x68', '\x02', '\x05', '\x79', '\x02', '\x05', '\x89',
 '\x06', '\x09', '\x9F', '\x0C', '\x10', '\xB8', '\x20', '\x28', '\xC8',
 '\x38', '\x3C', '\xDC', '\x50', '\x50', '\xFD', '\x50', '\x6C', '\xFC',
 '\x50', '\x88', '\xFC', '\x50', '\xA4', '\xFC', '\x50', '\xC4', '\xFC',
 '\x48', '\xDC', '\xFC', '\x50', '\xEC', '\xFC', '\x54', '\xFC', '\xFC',
 '\x98', '\xFC', '\xFC', '\xBC', '\xFC', '\xF4', '\x0B', '\x17', '\x07',
 '\x13', '\x23', '\x0B', '\x17', '\x33', '\x0F', '\x1F', '\x43', '\x17',
 '\x27', '\x53', '\x1B', '\x2F', '\x63', '\x23', '\x37', '\x73', '\x2B',
 '\x3F', '\x83', '\x2F', '\x43', '\x93', '\x37', '\x4B', '\x9F', '\x3F',
 '\x53', '\xAF', '\x47', '\x5B', '\xBF', '\x4F', '\x5F', '\xCF', '\x57',
 '\x67', '\xDF', '\x5F', '\x6F', '\xEF', '\x67', '\x77', '\xFF', '\x6F',
 '\x17', '\x1F', '\x17', '\x1B', '\x23', '\x1B', '\x1F', '\x2B', '\x1F',
 '\x23', '\x33', '\x23', '\x2B', '\x37', '\x2B', '\x2F', '\x3F', '\x2F',
 '\x33', '\x47', '\x33', '\x3B', '\x4B', '\x37', '\x3F', '\x53', '\x3B',
 '\x43', '\x5B', '\x43', '\x4B', '\x5F', '\x47', '\x4F', '\x67', '\x4B',
 '\x57', '\x6F', '\x4F', '\x5B', '\x73', '\x53', '\x5F', '\x7B', '\x57',
 '\x67', '\x83', '\x5F', '\xFF', '\xDF', '\x00', '\xFF', '\xBF', '\x00',
 '\xFF', '\x9F', '\x00', '\xFF', '\x7F', '\x00', '\xFF', '\x5F', '\x00',
 '\xFF', '\x3F', '\x00', '\xF4', '\x0E', '\x03', '\x37', '\x00', '\x00',
 '\x2F', '\x00', '\x00', '\x27', '\x00', '\x00', '\x17', '\x00', '\x00',
 '\x0F', '\x0F', '\x0F', '\x0B', '\x0B', '\x0B', '\x07', '\x07', '\x07',
 '\xFF', '\xFF', '\xFF' };

/* Hexen RGB palette, straight from hexen.wad */

const unsigned char hexen_rgb[3 * 256] = {
 '\x02', '\x02', '\x02', '\x04', '\x04', '\x04', '\x0F', '\x0F', '\x0F',
 '\x13', '\x13', '\x13', '\x1B', '\x1B', '\x1B', '\x1C', '\x1C', '\x1C',
 '\x21', '\x21', '\x21', '\x27', '\x27', '\x27', '\x2D', '\x2D', '\x2D',
 '\x33', '\x33', '\x33', '\x39', '\x39', '\x39', '\x3F', '\x3F', '\x3F',
 '\x45', '\x45', '\x45', '\x4B', '\x4B', '\x4B', '\x51', '\x51', '\x51',
 '\x56', '\x56', '\x56', '\x5C', '\x5C', '\x5C', '\x62', '\x62', '\x62',
 '\x68', '\x68', '\x68', '\x70', '\x70', '\x70', '\x79', '\x79', '\x79',
 '\x82', '\x82', '\x82', '\x8B', '\x8B', '\x8B', '\x93', '\x93', '\x93',
 '\x9D', '\x9D', '\x9D', '\xA6', '\xA6', '\xA6', '\xB0', '\xB0', '\xB0',
 '\xB9', '\xB9', '\xB9', '\xC2', '\xC2', '\xC2', '\xCB', '\xCB', '\xCB',
 '\xD4', '\xD4', '\xD4', '\xDD', '\xDD', '\xDD', '\xE6', '\xE6', '\xE6',
 '\x1D', '\x20', '\x1D', '\x26', '\x28', '\x25', '\x32', '\x32', '\x32',
 '\x3B', '\x3C', '\x3B', '\x45', '\x48', '\x44', '\x4E', '\x50', '\x4D',
 '\x58', '\x5D', '\x56', '\x61', '\x64', '\x5F', '\x6D', '\x70', '\x68',
 '\x74', '\x7B', '\x70', '\x7D', '\x83', '\x79', '\x86', '\x8D', '\x82',
 '\x90', '\x97', '\x8B', '\x99', '\xA1', '\x94', '\xA3', '\xAB', '\x9D',
 '\xAC', '\xB5', '\xA6', '\xB5', '\xBD', '\xB0', '\xBD', '\xC4', '\xB9',
 '\x16', '\x1D', '\x16', '\x1B', '\x24', '\x1B', '\x1F', '\x2B', '\x1F',
 '\x23', '\x33', '\x23', '\x2B', '\x37', '\x2B', '\x2F', '\x3F', '\x2F',
 '\x33', '\x47', '\x33', '\x3B', '\x4B', '\x37', '\x3F', '\x53', '\x3B',
 '\x43', '\x5B', '\x43', '\x4B', '\x5F', '\x47', '\x4F', '\x67', '\x4B',
 '\x57', '\x6F', '\x4F', '\x5B', '\x73', '\x53', '\x5F', '\x7B', '\x57',
 '\x67', '\x83', '\x5F', '\x14', '\x10', '\x24', '\x1E', '\x1A', '\x2E',
 '\x28', '\x24', '\x39', '\x32', '\x2E', '\x43', '\x3B', '\x39', '\x4E',
 '\x45', '\x43', '\x58', '\x4F', '\x4D', '\x63', '\x59', '\x57', '\x6D',
 '\x63', '\x61', '\x78', '\x6D', '\x6B', '\x82', '\x76', '\x76', '\x8D',
 '\x80', '\x80', '\x97', '\x8A', '\x8A', '\xA2', '\x94', '\x94', '\xAC',
 '\x3E', '\x28', '\x0B', '\x4B', '\x32', '\x10', '\x54', '\x3B', '\x17',
 '\x5F', '\x43', '\x1E', '\x67', '\x4B', '\x26', '\x6E', '\x53', '\x2F',
 '\x7B', '\x5F', '\x37', '\x89', '\x6B', '\x3E', '\x96', '\x76', '\x4B',
 '\xA3', '\x81', '\x54', '\xAB', '\x89', '\x5C', '\xB4', '\x92', '\x65',
 '\xBC', '\x9A', '\x6D', '\xC4', '\xA2', '\x75', '\xCC', '\xAA', '\x7D',
 '\xD0', '\xB0', '\x85', '\x1B', '\x0F', '\x08', '\x26', '\x14', '\x0B',
 '\x31', '\x1B', '\x0E', '\x3D', '\x1F', '\x0E', '\x41', '\x23', '\x12',
 '\x4A', '\x25', '\x13', '\x53', '\x2B', '\x13', '\x57', '\x2F', '\x17',
 '\x5F', '\x33', '\x1B', '\x67', '\x3B', '\x1F', '\x73', '\x43', '\x23',
 '\x7B', '\x4B', '\x27', '\x83', '\x53', '\x2F', '\x8F', '\x5B', '\x33',
 '\x97', '\x63', '\x3B', '\xA0', '\x6C', '\x40', '\xAF', '\x74', '\x4A',
 '\xB4', '\x7E', '\x51', '\xC0', '\x87', '\x5B', '\xCC', '\x8F', '\x5D',
 '\xD5', '\x97', '\x67', '\xD8', '\x9F', '\x73', '\xDC', '\xA7', '\x7E',
 '\xDF', '\xAF', '\x8A', '\xE3', '\xB7', '\x95', '\x25', '\x14', '\x04',
 '\x2F', '\x18', '\x04', '\x39', '\x1C', '\x06', '\x44', '\x21', '\x04',
 '\x4C', '\x24', '\x03', '\x54', '\x28', '\x00', '\x61', '\x2F', '\x02',
 '\x72', '\x36', '\x00', '\x7D', '\x3F', '\x06', '\x8D', '\x4B', '\x09',
 '\x9B', '\x53', '\x11', '\xA2', '\x5F', '\x15', '\xA9', '\x67', '\x1A',
 '\xB4', '\x71', '\x20', '\xBC', '\x7C', '\x14', '\xCC', '\x88', '\x18',
 '\xDC', '\x94', '\x1C', '\xEC', '\xA0', '\x17', '\xF4', '\xAC', '\x2F',
 '\xFC', '\xBB', '\x39', '\xFC', '\xC2', '\x46', '\xFB', '\xC9', '\x53',
 '\xFB', '\xD0', '\x61', '\xFB', '\xDD', '\x7B', '\x02', '\x04', '\x29',
 '\x02', '\x05', '\x31', '\x06', '\x08', '\x39', '\x02', '\x05', '\x41',
 '\x02', '\x05', '\x4F', '\x00', '\x04', '\x58', '\x00', '\x04', '\x60',
 '\x00', '\x04', '\x68', '\x04', '\x06', '\x79', '\x02', '\x05', '\x89',
 '\x14', '\x17', '\x98', '\x26', '\x29', '\xA7', '\x38', '\x3B', '\xB5',
 '\x4A', '\x4D', '\xC4', '\x5B', '\x5E', '\xD3', '\x6D', '\x70', '\xE2',
 '\x7F', '\x82', '\xF0', '\x91', '\x94', '\xFF', '\x1F', '\x04', '\x04',
 '\x27', '\x00', '\x00', '\x2F', '\x00', '\x00', '\x37', '\x00', '\x00',
 '\x43', '\x00', '\x00', '\x4F', '\x00', '\x00', '\x5B', '\x00', '\x00',
 '\x67', '\x00', '\x00', '\x73', '\x00', '\x00', '\x7F', '\x00', '\x00',
 '\x8B', '\x00', '\x00', '\x9B', '\x00', '\x00', '\xA7', '\x00', '\x00',
 '\xB9', '\x00', '\x00', '\xCA', '\x00', '\x00', '\xDC', '\x00', '\x00',
 '\xED', '\x00', '\x00', '\xFF', '\x00', '\x00', '\xFF', '\x2E', '\x2E',
 '\xFF', '\x5B', '\x5B', '\xFF', '\x89', '\x89', '\xFF', '\xAB', '\xAB',
 '\x14', '\x10', '\x04', '\x0D', '\x18', '\x09', '\x11', '\x21', '\x0C',
 '\x15', '\x29', '\x0E', '\x18', '\x32', '\x11', '\x1C', '\x39', '\x14',
 '\x20', '\x41', '\x18', '\x23', '\x49', '\x1C', '\x27', '\x50', '\x1F',
 '\x2C', '\x56', '\x25', '\x2E', '\x5F', '\x26', '\x33', '\x68', '\x2B',
 '\x3C', '\x7A', '\x33', '\x44', '\x8B', '\x3A', '\x4D', '\x9D', '\x42',
 '\x55', '\xAE', '\x49', '\x5E', '\xC0', '\x51', '\x9D', '\x33', '\x04',
 '\xAA', '\x41', '\x02', '\xB9', '\x56', '\x04', '\xD5', '\x77', '\x06',
 '\xEA', '\x93', '\x05', '\xFF', '\xB2', '\x06', '\xFF', '\xC3', '\x1A',
 '\xFF', '\xD8', '\x2D', '\x04', '\x85', '\x04', '\x08', '\xAF', '\x08',
 '\x02', '\xD7', '\x02', '\x03', '\xEA', '\x03', '\x2A', '\xFC', '\x2A',
 '\x79', '\xFF', '\x79', '\x03', '\x03', '\xB8', '\x0F', '\x29', '\xDC',
 '\x1C', '\x50', '\xE2', '\x29', '\x77', '\xE9', '\x36', '\x9E', '\xEF',
 '\x43', '\xC5', '\xF6', '\x50', '\xEC', '\xFC', '\xF4', '\x0E', '\x03',
 '\xFF', '\x3F', '\x00', '\xFF', '\x5F', '\x00', '\xFF', '\x7F', '\x00',
 '\xFF', '\x9F', '\x00', '\xFF', '\xC3', '\x1A', '\xFF', '\xDF', '\x00',
 '\x2B', '\x0D', '\x40', '\x3D', '\x0E', '\x59', '\x5A', '\x0F', '\x7A',
 '\x78', '\x10', '\x9C', '\x95', '\x10', '\xBD', '\xB2', '\x11', '\xDE',
 '\xC5', '\x4A', '\xE8', '\xD7', '\x81', '\xF3', '\xEA', '\xA9', '\xFD',
 '\x3D', '\x10', '\x10', '\x5A', '\x24', '\x21', '\x76', '\x38', '\x31',
 '\x93', '\x4D', '\x42', '\xB0', '\x61', '\x53', '\xCC', '\x75', '\x63',
 '\x47', '\x35', '\x02', '\x51', '\x3F', '\x06', '\x60', '\x48', '\x00',
 '\x6C', '\x50', '\x00', '\x78', '\x58', '\x00', '\x80', '\x60', '\x00',
 '\x95', '\x70', '\x01', '\xB5', '\x88', '\x03', '\xD4', '\xA0', '\x04',
 '\xFF', '\xFF', '\xFF' };

/* Strife RGB palette, straight from strife.wad */

const unsigned char strife_rgb[3 * 256] = {
  '\x00', '\x00', '\x00', '\xE7', '\xE3', '\xE3', '\xDF', '\xDB', '\xDB',
  '\xD7', '\xD3', '\xD3', '\xCF', '\xCB', '\xCB', '\xC7', '\xC3', '\xC3',
  '\xBF', '\xBF', '\xBF', '\xB7', '\xB7', '\xB7', '\xB3', '\xAF', '\xAF',
  '\xAB', '\xA7', '\xA7', '\xA3', '\x9F', '\x9F', '\x9B', '\x97', '\x97',
  '\x93', '\x93', '\x93', '\x8B', '\x8B', '\x8B', '\x83', '\x83', '\x83',
  '\x7B', '\x7B', '\x7B', '\x77', '\x73', '\x73', '\x6F', '\x6F', '\x6F',
  '\x67', '\x67', '\x67', '\x5F', '\x5F', '\x5F', '\x57', '\x57', '\x57',
  '\x4F', '\x4F', '\x4F', '\x47', '\x47', '\x47', '\x43', '\x3F', '\x3F',
  '\x3B', '\x3B', '\x3B', '\x33', '\x33', '\x33', '\x2B', '\x2B', '\x2B',
  '\x23', '\x23', '\x23', '\x1B', '\x1B', '\x1B', '\x13', '\x13', '\x13',
  '\x0B', '\x0B', '\x0B', '\x07', '\x07', '\x07', '\xBB', '\xBF', '\xB7',
  '\xB3', '\xB7', '\xAB', '\xA7', '\xB3', '\x9F', '\xA3', '\xAB', '\x93',
  '\x9B', '\xA7', '\x8B', '\x93', '\x9F', '\x7F', '\x8B', '\x9B', '\x77',
  '\x83', '\x93', '\x6B', '\x7F', '\x8F', '\x67', '\x77', '\x87', '\x5B',
  '\x73', '\x83', '\x53', '\x6B', '\x7B', '\x4B', '\x67', '\x77', '\x43',
  '\x63', '\x6F', '\x3F', '\x5B', '\x6B', '\x37', '\x57', '\x63', '\x2F',
  '\x53', '\x5F', '\x2B', '\x4B', '\x57', '\x23', '\x47', '\x53', '\x1F',
  '\x43', '\x4B', '\x1B', '\x3F', '\x47', '\x17', '\x3B', '\x3F', '\x13',
  '\x33', '\x3B', '\x0F', '\x2F', '\x33', '\x0B', '\x2B', '\x2F', '\x07',
  '\x27', '\x2B', '\x07', '\x1F', '\x23', '\x07', '\x1B', '\x1F', '\x00',
  '\x17', '\x17', '\x00', '\x0F', '\x13', '\x00', '\x0B', '\x0B', '\x00',
  '\x07', '\x07', '\x00', '\xDB', '\x2B', '\x2B', '\xCB', '\x23', '\x23',
  '\xBF', '\x1F', '\x1F', '\xAF', '\x1B', '\x1B', '\xA3', '\x17', '\x17',
  '\x93', '\x13', '\x13', '\x87', '\x0F', '\x0F', '\x77', '\x0B', '\x0B',
  '\x6B', '\x07', '\x07', '\x5B', '\x07', '\x07', '\x4F', '\x00', '\x00',
  '\x3F', '\x00', '\x00', '\x33', '\x00', '\x00', '\x27', '\x00', '\x00',
  '\x17', '\x00', '\x00', '\x0B', '\x00', '\x00', '\xEB', '\xE7', '\x00',
  '\xE7', '\xD3', '\x00', '\xD7', '\xB3', '\x00', '\xC7', '\x97', '\x00',
  '\xB7', '\x7F', '\x00', '\xA7', '\x67', '\x00', '\x97', '\x53', '\x00',
  '\x87', '\x3F', '\x00', '\x77', '\x2F', '\x00', '\x67', '\x23', '\x00',
  '\x57', '\x17', '\x00', '\x47', '\x0B', '\x00', '\x37', '\x07', '\x00',
  '\x27', '\x00', '\x00', '\x17', '\x00', '\x00', '\x0B', '\x00', '\x00',
  '\xB7', '\xE7', '\x7F', '\xA3', '\xD7', '\x6F', '\x8F', '\xC7', '\x5F',
  '\x7F', '\xB7', '\x4F', '\x6B', '\xAB', '\x43', '\x5B', '\x9B', '\x37',
  '\x4B', '\x8B', '\x2B', '\x3F', '\x7B', '\x23', '\x2F', '\x6F', '\x1B',
  '\x23', '\x5F', '\x13', '\x17', '\x4F', '\x0B', '\x0F', '\x43', '\x07',
  '\x07', '\x33', '\x07', '\x00', '\x23', '\x00', '\x00', '\x13', '\x00',
  '\x00', '\x07', '\x00', '\xC7', '\xCF', '\xFF', '\xB7', '\xBB', '\xEF',
  '\xA3', '\xAB', '\xDB', '\x97', '\x9B', '\xCB', '\x87', '\x8B', '\xBB',
  '\x7B', '\x7F', '\xAB', '\x6B', '\x6F', '\x9B', '\x5F', '\x63', '\x8B',
  '\x53', '\x53', '\x7B', '\x43', '\x47', '\x6B', '\x37', '\x3B', '\x5B',
  '\x2F', '\x2F', '\x4B', '\x23', '\x23', '\x3B', '\x17', '\x17', '\x2B',
  '\x0F', '\x0F', '\x1B', '\x00', '\x00', '\x0B', '\xC7', '\xBF', '\x93',
  '\xB3', '\xAB', '\x83', '\xA7', '\x9B', '\x77', '\x9B', '\x8B', '\x6F',
  '\x8F', '\x7F', '\x63', '\x83', '\x6F', '\x5B', '\x77', '\x63', '\x4F',
  '\x6B', '\x57', '\x47', '\x5B', '\x47', '\x3B', '\x4F', '\x3B', '\x33',
  '\x43', '\x2F', '\x2B', '\x37', '\x27', '\x23', '\x2B', '\x1B', '\x1B',
  '\x1F', '\x13', '\x13', '\x13', '\x0B', '\x0B', '\x07', '\x07', '\x00',
  '\x8F', '\xC3', '\xD3', '\x7B', '\xB3', '\xC3', '\x6B', '\xA7', '\xB7',
  '\x5B', '\x9B', '\xA7', '\x4B', '\x8B', '\x9B', '\x3B', '\x7F', '\x8B',
  '\x2F', '\x73', '\x7F', '\x23', '\x67', '\x73', '\x1B', '\x5B', '\x63',
  '\x13', '\x4F', '\x57', '\x0B', '\x43', '\x47', '\x07', '\x37', '\x3B',
  '\x00', '\x2B', '\x2B', '\x00', '\x1F', '\x1F', '\x00', '\x13', '\x13',
  '\x00', '\x07', '\x07', '\xD3', '\xBF', '\xAF', '\xCB', '\xB3', '\xA3',
  '\xC3', '\xAB', '\x97', '\xBF', '\x9F', '\x8F', '\xB7', '\x97', '\x83',
  '\xAF', '\x8F', '\x7B', '\xAB', '\x87', '\x73', '\xA3', '\x7B', '\x67',
  '\x9B', '\x73', '\x5F', '\x97', '\x6B', '\x57', '\x8F', '\x63', '\x4F',
  '\x8B', '\x5B', '\x47', '\x83', '\x53', '\x43', '\x7B', '\x4B', '\x3B',
  '\x77', '\x43', '\x33', '\x6F', '\x3B', '\x2F', '\x67', '\x37', '\x27',
  '\x63', '\x2F', '\x23', '\x5B', '\x2B', '\x1F', '\x53', '\x23', '\x1B',
  '\x4F', '\x1F', '\x17', '\x47', '\x1B', '\x13', '\x3F', '\x13', '\x0F',
  '\x3B', '\x0F', '\x0B', '\x33', '\x0B', '\x07', '\x2B', '\x07', '\x07',
  '\x27', '\x07', '\x00', '\x1F', '\x00', '\x00', '\x1B', '\x00', '\x00',
  '\x13', '\x00', '\x00', '\x0B', '\x00', '\x00', '\x07', '\x00', '\x00',
  '\xD3', '\xC7', '\xBB', '\xCB', '\xBF', '\xB3', '\xC3', '\xB7', '\xAB',
  '\xBF', '\xAF', '\xA3', '\xB7', '\xA7', '\x9B', '\xAF', '\x9F', '\x93',
  '\xAB', '\x97', '\x8B', '\xA3', '\x8F', '\x87', '\x9B', '\x8B', '\x7F',
  '\x97', '\x83', '\x77', '\x8F', '\x7B', '\x6F', '\x87', '\x73', '\x6B',
  '\x83', '\x6B', '\x63', '\x7B', '\x67', '\x5F', '\x73', '\x5F', '\x57',
  '\x6F', '\x57', '\x53', '\x67', '\x53', '\x4B', '\x5F', '\x4B', '\x47',
  '\x5B', '\x43', '\x3F', '\x53', '\x3F', '\x3B', '\x4F', '\x37', '\x33',
  '\x47', '\x33', '\x2F', '\x3F', '\x2B', '\x2B', '\x3B', '\x27', '\x27',
  '\x33', '\x23', '\x1F', '\x2B', '\x1B', '\x1B', '\x27', '\x17', '\x17',
  '\x1F', '\x13', '\x13', '\x17', '\x0F', '\x0F', '\x13', '\x0B', '\x0B',
  '\x0B', '\x07', '\x07', '\x07', '\x07', '\x00', '\xEF', '\xEF', '\x00',
  '\xE7', '\xD7', '\x00', '\xE3', '\xBF', '\x00', '\xDB', '\xAB', '\x00',
  '\xD7', '\x97', '\x00', '\xD3', '\x83', '\x00', '\xCB', '\x6F', '\x00',
  '\xC7', '\x5B', '\x00', '\xBF', '\x4B', '\x00', '\xBB', '\x3B', '\x00',
  '\xB7', '\x2B', '\x00', '\xFF', '\x00', '\x00', '\xDF', '\x00', '\x00',
  '\xBF', '\x00', '\x00', '\x9F', '\x00', '\x00', '\x7F', '\x00', '\x00',
  '\x00', '\x00', '\x00', '\x8B', '\xC7', '\x67', '\x6B', '\xAB', '\x4B',
  '\x4F', '\x8F', '\x37', '\x37', '\x73', '\x23', '\x23', '\x57', '\x13',
  '\x13', '\x3F', '\x0B', '\xD7', '\xDF', '\xFF', '\xBB', '\xCB', '\xF7',
  '\x8F', '\xA7', '\xDB', '\x63', '\x83', '\xC3', '\x3F', '\x5B', '\xA7',
  '\xCB', '\xCB', '\xCB', '\xD7', '\xD7', '\xD7', '\xDF', '\xDF', '\xDF',
  '\xEB', '\xEB', '\xEB' };
