#include <unistd.h>
#include <go32.h>
#include <dpmi.h>
#include <stdio.h>
#include <libc/file.h>
#include <stdlib.h>
#include <dos.h>
#include <sys/stat.h>
#include <dir.h>
#include <ctype.h>
#include <inlines/ctype.ha>
#include <stdarg.h>
#include <libc/unconst.h>
#include <string.h>
#include <stubinfo.h>
#include <libc/atexit.h>
#include <limits.h>

char _sctab[256] = {
0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

int nchars = 0;
int _instr(char *ptr,int type,int len,FILE *iop,int(*scan_getc)(FILE *),int(*scan_ungetc)(int,FILE *),int *eofptr)
{
  register int ch;
  register char *optr;
  int ignstp;
  *eofptr = 0; optr = ptr;
  if (type=='c' && len==30000) len = 1; ignstp = 0;
  if (type=='s') ignstp = 1;
  while ((nchars++, ch = scan_getc(iop)) != EOF && _sctab[ch] & ignstp);
  ignstp = 1;
  if (type=='c') ignstp = 0;
  else if (type=='[') ignstp = 2;
  while (ch!=EOF && (_sctab[ch]&ignstp)==0) { if (ptr) *ptr++ = ch;
    if (--len <= 0) break; ch = scan_getc(iop); nchars++; }
  if (ch != EOF) { if (len > 0) { scan_ungetc(ch, iop); nchars--; }
    *eofptr = 0; } else { nchars--; *eofptr = 1; }
  if (!ptr) return(1);
  if (ptr!=optr) { if (type!='c') *ptr++ = '\0'; return(1); }
  return(0);
}
int _innum(int **ptr,int type,int len,int size,FILE *iop,int(*scan_getc)(FILE *),int(*scan_ungetc)(int,FILE *),int *eofptr)
{
  register char *np;
  char numbuf[64];
  register int c, base;
  int expseen, scale, negflg, c1, ndigit, cpos;
  long lcval;
  if (type=='c' || type=='s' || type=='[')
    return(_instr(ptr? *(char **)ptr: (char *)NULL, type, len,iop, scan_getc, scan_ungetc, eofptr));
  lcval = 0; ndigit = 0; scale = 0;
  if (type=='e'||type=='f'||type=='g') scale = 1;
  base = 10;
  if (type=='o') base = 8;
  else if (type=='x') base = 16;
  np = numbuf; expseen = 0; negflg = 0;
  while (((nchars++, c = scan_getc(iop)) != EOF) && (_sctab[c] & 1));
  if (c == EOF) nchars--;
  if (c=='-') { negflg++; *np++ = c; c = scan_getc(iop); nchars++; len--;
  } else if (c=='+') { len--; c = scan_getc(iop); nchars++; }
  cpos = 0;
  for ( ; --len>=0; *np++ = c, c = scan_getc(iop), nchars++) {
    cpos++;
    if (c=='0'&&cpos==1&&type=='i') base=8;
    if ((c=='x'||c=='X')&&(type=='i'||type=='x')&&cpos==2&&lcval==0)
    { base = 16; continue; }
    if (isdigit(c)||(base==16&&(('a'<=c&&c<='f')||('A'<=c&&c<='F')))) { ndigit++;
      if (base==8)lcval <<=3; else if (base==10) lcval = ((lcval<<2) + lcval)<<1;
      else lcval <<= 4; c1 = c;
      if (isdigit(c)) c -= '0'; else if ('a'<=c && c<='f')
	c -= 'a'-10; else c -= 'A'-10;
      lcval += c; c = c1; continue;
    } else if (c=='.') { if (base!=10 || scale==0) break;
      ndigit++; continue;
    } else if ((c=='e'||c=='E') && expseen==0) {
      if (base!=10 || scale==0 || ndigit==0) break;
      expseen++; *np++ = c; c = scan_getc(iop); nchars++;
      if (c!='+'&&c!='-'&&('0'>c||c>'9')) break;
    } else break;
  }
  if (negflg) lcval = -lcval;
  if (c != EOF) { scan_ungetc(c, iop); *eofptr = 0; } else *eofptr = 1;
  nchars--;
  if (np==numbuf || (negflg && np==numbuf+1) ) return(0);
  if (ptr==NULL) return(1);
  *np++ = 0; **(long **)ptr = lcval;
  return(1);
}
int _doscan(FILE *iop, const char *fmt, void **argp)
{ return(_doscan_low(iop, fgetc, ungetc, fmt, argp)); }
int _doscan_low(FILE *iop, int (*scan_getc)(FILE *), int (*scan_ungetc)(int, FILE *),
const char *fmt, void **argp)
{
  register int ch;
  int nmatch=0, len, ch1, **ptr, fileended=0, size;
  nchars = 0;
  for (;;) switch (ch = *fmt++) {
  case '\0': return (nmatch);
  case '%': if ((ch = *fmt++) == '%') goto def;
    ptr = 0;
    if (ch != '*') ptr = (int **)argp++;
    else ch = *fmt++;
    len = 0;
    size = 1;
    while (isdigit(ch)) { len = len*10 + ch - '0'; ch = *fmt++; }
    if (len == 0) len = 30000;
    if (isupper(ch)) { ch += 'a' - 'A';
      if (size==2) size = 4;
      else if (size != 4) size = 2;
    }
    if (ch == '\0') return(-1);
    if (ch == 'n') { if (!ptr) break; **(long**)ptr = nchars;
      break;
    }
    if (_innum(ptr, ch, len, size, iop, scan_getc, scan_ungetc,&fileended))
    { if (ptr) nmatch++; } else
    { if (fileended && nmatch==0) return(-1); return(nmatch); }
    break;
  case ' ': case '\n': case '\t': case '\r': case '\f': case '\v':
    while (((nchars++, ch1 = scan_getc(iop))!=EOF) && (_sctab[ch1] & 1));
    if (ch1 != EOF) scan_ungetc(ch1, iop); nchars--; break;
  default: def:
    ch1 = scan_getc(iop);
    if (ch1 != EOF) nchars++;
    if (ch1 != ch) { if (ch1==EOF) return(nmatch? nmatch: -1);
    scan_ungetc(ch1, iop); nchars--;
    return(nmatch);
    }
  }
}
#define	MAXEXP		308
#define MAXEXPLD        4952
#define	MAXFRACT	39
#define	DEFPREC	6
#define	DEFLPREC	6
#define	BUF		(MAXEXPLD+MAXFRACT+1)
int putc(int c, FILE *fp) { return __putc(c, fp); }
#define	PUTC(ch)	(void) putc(ch, fp)

int todigit(char c) { if (c<='0') return 0; if (c>='9') return 9; return c-'0'; }
#define	ALT		0x08
#define	LADJUST		0x10
#define	ZEROPAD	0x20
#define	HEXPREFIX	0x40
char NULL_REP[] = "(null)";

int _doprnt(const char *fmt0, va_list argp, FILE *fp)
{
  const char *fmt, *digs;
  int ch, cnt, n, base, dprec, fieldsz, flags, fpprec, prec, realsz, size, width;
  char *t, sign, softsign, buf[BUF];
  unsigned long _ulong=0;

  if (fp->_flag & _IORW) { fp->_flag |= _IOWRT; fp->_flag &= ~(_IOEOF|_IOREAD); }
  if ((fp->_flag & _IOWRT) == 0) return (EOF);

  fmt = fmt0; digs = "0123456789abcdef";
  for (cnt = 0;; ++fmt)
  {
    while ((ch = *fmt) && ch != '%') { PUTC (ch); fmt++; cnt++; }
    if (!ch) return cnt;
    flags = 0; dprec = 0; fpprec = 0; width = 0;
    prec = -1; sign = '\0';
  rflag:
    switch (*++fmt)
    {
    case ' ': if (!sign) sign = ' '; goto rflag;
    case '#': flags |= ALT; goto rflag;
    case '*':
      if ((width = va_arg(argp, int)) >= 0) goto rflag;
      width = -width;
    case '-': flags |= LADJUST; goto rflag;
    case '+': sign = '+'; goto rflag;
    case '.':
      if (*++fmt == '*') n = va_arg(argp, int);
      else { n = 0; while (isascii(*fmt) && isdigit(*fmt))
	n = 10 * n + todigit(*fmt++); --fmt; }
      prec = n < 0 ? -1 : n;
      goto rflag;
    case '0':
      flags |= ZEROPAD;
      goto rflag;
    case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      n = 0;
      do { n = 10 * n + todigit(*fmt); } while (isascii(*++fmt) && isdigit(*fmt));
      width = n; --fmt;
    case 'L': case 'h': case 'l': goto rflag;
    case 'c': *(t = buf) = va_arg(argp, int);
      size = 1; sign = '\0'; goto pforw;
    case 'D': case 'd': case 'i':
      _ulong = va_arg(argp, int);
      if ((long)_ulong < 0) { _ulong = -_ulong; sign = '-'; }
      base = 10;
      goto number;
    case 'e': case 'E': case 'f': case 'g': case 'G':
      if (prec > MAXFRACT)
      {
	if (*fmt != 'g' && (*fmt != 'G' || (flags&ALT)))
	  fpprec = prec - MAXFRACT;
	prec = MAXFRACT;
      }
      else if (prec == -1) prec = DEFPREC;
	softsign = 0; *buf = NULL; size = 0;
      if (softsign) sign = '-'; t = *buf ? buf : buf + 1;
      goto pforw;
    case 'n': 
      *va_arg(argp, int *) = cnt;
      break;
    case 'O': case 'o':
      _ulong = va_arg(argp, int);
      base = 8;
      goto nosign;
    case 'p':
      _ulong = (unsigned long)va_arg(argp, void *);
      base = 16;
      goto nosign;
    case 's':
      if (!(t = va_arg(argp, char *))) t = NULL_REP;
      if (prec >= 0)
      { char *p;
	if ((p = memchr(t, 0, prec)))
	{ size = p - t; if (size > prec) size = prec; }
	else size = prec;
      }
      else size = strlen(t);
      sign = '\0';
      goto pforw;
    case 'U': case 'u':
      _ulong = va_arg(argp, int);
      base = 10;
      goto nosign;
    case 'X': digs = "0123456789ABCDEF";
    case 'x': _ulong = va_arg(argp, int);
      base = 16;
      if (flags & ALT && _ulong != 0) flags |= HEXPREFIX;
    nosign:
      sign = '\0';
    number:
      if ((dprec = prec) >= 0) flags &= ~ZEROPAD;
      t = buf + BUF;
      if (_ulong != 0 || prec != 0)
      {
	register unsigned long _n = (unsigned long)_ulong;
	do { *--t = digs[_n % base]; _n /= base; } while (_n);
        if (flags & ALT && base == 8 && *t != '0') *--t = '0';
      }
      digs = "0123456789abcdef";
      size = buf + BUF - t;
    pforw:
      fieldsz = size + fpprec;
      realsz = dprec > fieldsz ? dprec : fieldsz;
      if (sign) realsz++;
      if (flags & HEXPREFIX) realsz += 2;
      if ((flags & (LADJUST|ZEROPAD)) == 0 && width)
	for (n = realsz; n < width; n++) PUTC(' ');
      if (sign) PUTC(sign);
      if (flags & HEXPREFIX) { PUTC('0'); PUTC((char)*fmt); }
      if ((flags & (LADJUST|ZEROPAD)) == ZEROPAD) for (n = realsz; n < width; n++) PUTC('0');
      for (n = fieldsz; n < dprec; n++) PUTC('0');
      for (n = size; n > 0; n--) PUTC(*t++);
      while (--fpprec >= 0) PUTC('0');
      if (flags & LADJUST) for (n = realsz; n < width; n++) PUTC(' ');
      cnt += width > realsz ? width : realsz;
      break;
    case '\0': return cnt;
    default: PUTC((char)*fmt); cnt++;
    }
  }
}
int fgetc(FILE *f) { return __getc(f); }
char *fgets(char *s, int n, FILE *f)
{
  int c=0; char *cs; cs = s;
  while (--n>0 && (c = __getc(f)) != EOF)
  { *cs++ = c; if (c == '\n') break; }
  if (c == EOF && cs == s) return NULL;
  *cs++ = '\0';
  return s;
}
int ungetc(int c, FILE *f)
{
  if (c == EOF || (f->_flag & (_IOREAD|_IORW)) == 0 || f->_ptr == NULL || f->_base == NULL)
    return EOF;
  if (f->_ptr == f->_base) { if (f->_cnt == 0) f->_ptr++; else return EOF; }
  f->_cnt++; f->_ptr--;
  if(*f->_ptr != c) { f->_flag |= _IOUNGETC; *f->_ptr = c; }
  return c;
}
int sscanf(const char *str, const char *fmt, ...)
{
  int r; va_list a=0; FILE _strbuf;
  va_start(a, fmt);
  _strbuf._flag = _IOREAD|_IOSTRG;
  _strbuf._ptr = _strbuf._base = unconst(str, char *);
  _strbuf._cnt = 0;
  while (*str++) _strbuf._cnt++;
  _strbuf._bufsiz = _strbuf._cnt;
  r = _doscan(&_strbuf, fmt, a);
  va_end(a);
  return r;
}
int printf(const char *fmt, ...)
{
_doprnt(fmt, (&fmt)+1, stdout);
  fflush(stdout);
}
int fprintf(register FILE *iop, const char *fmt, ...)
{
  int len; char localbuf[BUFSIZ];

  if (iop->_flag & _IONBF)
  {
    iop->_flag &= ~_IONBF;
    iop->_ptr = iop->_base = localbuf;
    iop->_bufsiz = BUFSIZ;
    len = _doprnt(fmt, (&fmt)+1, iop);
    fflush(iop);
    iop->_flag |= _IONBF;
    iop->_base = NULL;
    iop->_bufsiz = NULL;
    iop->_cnt = 0;
  }
  else
    len = _doprnt(fmt, (&fmt)+1, iop);
  return ferror(iop) ? EOF : len;
}
int sprintf(char *str, const char *fmt, ...)
{
  FILE _strbuf; int len;
  _strbuf._flag = _IOWRT|_IOSTRG;
  _strbuf._ptr = str;
  _strbuf._cnt = INT_MAX;
  len = _doprnt(fmt, &(fmt)+1, &_strbuf);
  *_strbuf._ptr = 0;
  return len;
}
int vsprintf(char *str, const char *fmt, va_list ap)
{
  FILE f; int len;
  f._flag = _IOWRT|_IOSTRG;
  f._ptr = str;
  f._cnt = INT_MAX;
  len = _doprnt(fmt, ap, &f);
  *f._ptr = 0;
  return len;
}
char *strcat(char *s, const char *append)
{
  char *save = s;
  for (; *s; ++s);
  while ((*s++ = *append++));
  return save;
}
int strcmp(const char *s1, const char *s2)
{
  while (*s1 == *s2)
  {
    if (*s1 == 0) return 0;
    s1++; s2++;
  }
  return *(unsigned const char *)s1 - *(unsigned const char *)(s2);
}
char *strcpy(char *to, const char *from)
{
  char *save = to;
  for (; (*to = *from); ++from, ++to);
  return save;
}
int stricmp(const char *s1, const char *s2)
{
  while (tolower(*s1) == tolower(*s2))
  {
    if (*s1 == 0)
      return 0;
    s1++;
    s2++;
  }
  return (int)tolower(*s1) - (int)tolower(*s2);
}
char *strncat(char *dst, const char *src, size_t n)
{
  if (n != 0)
  {
    char *d = dst;
    const char *s = src;
    while (*d != 0) d++;
    do { if ((*d = *s++) == 0) break; d++; } while (--n != 0);
    *d = 0;
  }
  return dst;
}
int strncmp(const char *s1, const char *s2, size_t n)
{
  if (n == 0) return 0;
  do { if (*s1 != *s2++) return *(unsigned const char *)s1 - *(unsigned const char *)--s2;
  if (*s1++ == 0) break; } while (--n != 0);
  return 0;
}
char *strncpy(char *dst, const char *src, size_t n)
{
  if (n != 0) { char *d = dst; const char *s = src;
    do { if ((*d++ = *s++) == 0) { while (--n != 0) *d++ = 0; break; } } while (--n != 0);
  }
  return dst;
}
int strnicmp(const char *s1, const char *s2, size_t n)
{
  if (n == 0) return 0;
  do { if (tolower(*s1) != tolower(*s2++))
      return (int)tolower(*s1) - (int)tolower(*--s2);
    if (*s1++ == 0) break;
  } while (--n != 0);
  return 0;
}
char *strtok(char *s, const char *delim)
{
  const char *spanp;
  int c, sc; char *tok;
  static char *last;
  if (s == NULL && (s = last) == NULL) return (NULL);
 cont:
  c = *s++;
  for (spanp = delim; (sc = *spanp++) != 0;) {
    if (c == sc)
      goto cont;
  }
  if (c == 0) { last = NULL; return (NULL); }
  tok = s - 1;
  for (;;) { c = *s++; spanp = delim;
    do { if ((sc = *spanp++) == c) { if (c == 0) s = NULL;
	else s[-1] = 0; last = s; return (tok);
      }
    } while (sc != 0);
  }
}
long strtol(const char *nptr, char **endptr, int base)
{
  const char *s = nptr;
  unsigned long acc,cutoff;
  int c, neg = 0, any, cutlim;
  do { c = *s++;
  } while (isspace(c));
  if (c == '-') { neg = 1; c = *s++; }
  else if (c == '+') c = *s++;
  if ((base == 0 || base == 16) && c == '0' && (*s == 'x' || *s == 'X'))
  { c = s[1]; s += 2; base = 16; }
  if (base == 0) base = c == '0' ? 8 : 10;
  cutoff = neg ? -(unsigned long)LONG_MIN : LONG_MAX;
  cutlim = cutoff % (unsigned long)base;
  cutoff /= (unsigned long)base;
  for (acc = 0, any = 0;; c = *s++)
  {
    if (isdigit(c)) c -= '0'; else if (isalpha(c)) c -= isupper(c) ? 'A' - 10 : 'a' - 10;
    else break;
    if (c >= base) break;
    if (any < 0 || acc > cutoff || (acc == cutoff && c > cutlim)) any = -1;
    else { any = 1; acc *= base; acc += c; }
  }
  if (any < 0) acc = neg ? LONG_MIN : LONG_MAX; else if (neg) acc = -acc;
  if (endptr != 0) *endptr = any ? unconst(s, char *) - 1 : unconst(nptr, char *);
  return acc;
}
int atoi(const char *str) { return (int)strtol(str, 0, 10); }
char *strchr(const char *s, int c)
{
  char cc = c;
  while (*s) { if (*s == cc) return unconst(s, char *);s++; }
  if (cc == 0) return unconst(s, char *);
  return 0;
}

unsigned short __djgpp_ds_alias=0;
__Go32_Info_Block _go32_info_block;
unsigned char wrapper_common[] = {
0x06, 0x1e, 0x06, 0x1f, 0x66, 0xb8, 0, 0, 0x8e, 0xd8, 0xff, 0x05, 0, 0, 0, 0, 0x83, 0x3d, 0, 0, 0, 0, 0, 0x75, 0x33,
0xc6, 0x05, 0, 0, 0, 0, 1, 0x8e, 0xc0, 0x8e, 0xe0, 0x8e, 0xe8, 0xbb, 0, 0, 0, 0, 0xfc, 0x89, 0xe1, 0x8c, 0xd2,
0x8e, 0xd0, 0x89, 0xdc, 0x52, 0x51, 0x56, 0x57, 0xe8, 0, 0, 0, 0, 0x5f, 0x5e, 0x58, 0x5b, 0x8e, 0xd3, 0x89,
0xc4, 0xc6, 0x05, 0, 0, 0, 0, 0, 0x1f, 0x07, 0x8b, 0x06, 0x26, 0x89, 0x47, 0x2a,
};
unsigned char wrapper_retf[] = { 0x66, 0x26, 0x83, 0x47, 0x2e, 0x04, 0xcf };
unsigned long _go32_rmcb_stack_size = 32256;

int setup_rmcb(unsigned char *wrapper, _go32_dpmi_seginfo *info,
  __dpmi_regs *regs, unsigned char *stack, unsigned long stack_length)
{
  do { if (!stack_length) {
	stack_length = _go32_rmcb_stack_size;
	stack = (char *)malloc(stack_length);
	if (stack == 0) { free(wrapper); return 0x8015;
	}
	((long *)stack)[0] = 1;
      } else	((long *)stack)[0] = 0;
      ((long *)stack)[1] = 0; ((long *)stack)[2] = 0;
  } while (0);

  *(short *)(wrapper+0x06) = __djgpp_ds_alias;
  *(long  *)(wrapper+0x0c) = (long) stack + 8;
  *(long  *)(wrapper+0x12) = (long) stack + 4;
  *(long  *)(wrapper+0x1b) = (long) stack + 4;
  *(long  *)(wrapper+0x27) = (long) stack + stack_length;
  *(long  *)(wrapper+0x39) = info->pm_offset - ((long)wrapper + 0x3d);
  *(long  *)(wrapper+0x47) = (long) stack + 4;

  info->size = (int)wrapper;

  return __dpmi_allocate_real_mode_callback((void *)wrapper, regs,
                                            (__dpmi_raddr *)&info->rm_offset);
}
int _go32_dpmi_allocate_real_mode_callback_retf_with_stack(
_go32_dpmi_seginfo *info, __dpmi_regs *regs, unsigned char *stack,unsigned long stack_length)
{
  unsigned char *wrapper;
  if ((stack_length && stack_length < 512) || (!stack_length && _go32_rmcb_stack_size < 512))
    return 0x8015;
  wrapper = (unsigned char *)malloc(sizeof(wrapper_common) + sizeof(wrapper_retf));
  if (wrapper == 0) return 0x8015;
  memcpy(wrapper, wrapper_common, sizeof(wrapper_common));
  memcpy(wrapper+sizeof(wrapper_common), wrapper_retf, sizeof(wrapper_retf));
  return setup_rmcb(wrapper, info, regs, stack, stack_length);
}
int _go32_dpmi_allocate_real_mode_callback_retf(_go32_dpmi_seginfo *info,__dpmi_regs *regs)
{
    return _go32_dpmi_allocate_real_mode_callback_retf_with_stack
      (info, regs, (unsigned char *) 0, 0);
}
int _go32_dpmi_free_real_mode_callback(_go32_dpmi_seginfo *info)
{
  unsigned char *stack;
  stack = (char *)(*(long *)((long) info->size+0x12) - 4);
  if (*(long *) stack & 1) free(stack);
  free((char *)info->size);
  return __dpmi_free_real_mode_callback((__dpmi_raddr *)&info->rm_offset);
}
unsigned long _go32_dpmi_remaining_physical_memory(void)
{
  _go32_dpmi_meminfo info;
  _go32_dpmi_get_free_memory_information(&info);
  if (info.available_physical_pages)
    return info.available_physical_pages * 4096;
  return info.available_memory;
}

typedef struct BLOCK { int size; struct BLOCK *next; int bucket; } BLOCK;
#define BEFORE(bp)	((BLOCK *)((char *)bp - *(int *)((char *)bp - 4) - 8))
#define BEFSZ(bp)	(*(int *)((char *)bp - 4))
#define ENDSZ(bp)	(*(int *)((char *)bp + bp->size + 4))
#define AFTER(bp)	((BLOCK *)((char *)bp + bp->size + 8))
#define DATA(bp)	((char *)&(bp->next))
#define ALIGN 8
BLOCK *slop = 0;
BLOCK *freelist[30];
#define MIN_SAVE_EXTRA 64
#define BIG_BLOCK 4096

int size2bucket(unsigned size)
{
  int rv=0;
  size>>=2;
  while (size)
  {
    rv++;
    size>>=1;
  }
  return rv;
}
int b2bucket(BLOCK *b)
{
  if (b->bucket == -1)
    b->bucket = size2bucket(b->size);
  return b->bucket;
}

BLOCK *
split_block(BLOCK *b, int size)
{
  BLOCK *rv = (BLOCK *)((char *)b + size+8);
  rv->size = b->size - size - 8;
  rv->bucket = -1;
  b->size = size;
  ENDSZ(b) = b->size;
  ENDSZ(rv) = rv->size;
  return rv;
}

#define RET(rv) ENDSZ(rv) |= 1; rv->size |= 1; return DATA(rv)

void *malloc(size_t size)
{
  int b, chunk_size;
  BLOCK *rv, **prev;
  static BLOCK *expected_sbrk = 0;
  if (size<ALIGN) size = ALIGN;
  size = (size+(ALIGN-1))&~(ALIGN-1);
  if (slop && slop->size >= size)
  {
    rv = slop;
    if (slop->size >= size+MIN_SAVE_EXTRA) slop = split_block(slop, size);
    else slop = 0;
    RET(rv);
  }
  b = size2bucket(size);
  prev = &(freelist[b]);
  for (rv=freelist[b]; rv; prev=&(rv->next), rv=rv->next)
  {
    if (rv->size >= size && rv->size < size+size/4)
    {
      *prev = rv->next;
      RET(rv);
    }
  }
  while (b < 30)
  {
    prev = &(freelist[b]);
    for (rv=freelist[b]; rv; prev=&(rv->next), rv=rv->next)
      if (rv->size >= size)
      {
	*prev = rv->next;
	if (rv->size >= size+MIN_SAVE_EXTRA)
	{
	  if (slop)
	  {
	    b = b2bucket(slop);
	    slop->next = freelist[b];
	    freelist[b] = slop;
	  }
	  slop = split_block(rv, size);
	}
	RET(rv);
      }
    b++;
  }
  chunk_size = size+16;
  rv = (BLOCK *)__sbrk(chunk_size);
  if (rv == (BLOCK *)(-1))
    return 0;
  if (rv == expected_sbrk)
  {
    expected_sbrk = (BLOCK *)((char *)rv + chunk_size);
    rv = (BLOCK *)((char *)rv - 4);
  }
  else
  {
    expected_sbrk = (BLOCK *)((char *)rv + chunk_size);
    rv->size = 1;
    rv = (BLOCK *)((char *)rv + 4);
    chunk_size -= 8;
  }
  rv->size = chunk_size - 8;
  ENDSZ(rv) = rv->size;
  AFTER(rv)->size = 1;
  RET(rv);
}
BLOCK *
merge(BLOCK *a, BLOCK *b, BLOCK *c)
{
  int bu;
  BLOCK *bp, **bpp;
  if (c == slop) slop = 0;
  bu = b2bucket(c);
  bpp = freelist+bu;
  for (bp=freelist[bu]; bp; bpp=&(bp->next), bp=bp->next)
  {
    if (bp == c)
    {
      *bpp = bp->next;
      break;
    }
  }
  a->size += b->size + 8;
  a->bucket = -1;
  ENDSZ(a) = a->size;
  return a;
}
void free(void *ptr)
{
  int b;
  BLOCK *block;
  if (ptr == 0) return;
  block = (BLOCK *)((char *)ptr-4);
  block->size &= ~1;
  ENDSZ(block) &= ~1;
  block->bucket = -1;
  if (! (BEFSZ(block) & 1))
    block = merge(BEFORE(block), block, BEFORE(block));
  if (! (AFTER(block)->size & 1))
    block = merge(block, AFTER(block), AFTER(block));
  b = b2bucket(block);
  block->next = freelist[b];
  freelist[b] = block;
}
void *realloc(void *ptr, size_t size)
{
  BLOCK *b;
  char *newptr;
  int copysize;
  if (ptr == 0) return malloc(size);
  b = (BLOCK *)((char *)ptr-4);
  copysize = b->size & ~1;
  if (size <= copysize)
  {
      return ptr;
    copysize = size;
  }
  newptr = (char *)malloc(size);
  memcpy(newptr, ptr, copysize);
  free(ptr);
  return newptr;
}
void *calloc(size_t size, size_t nelem)
{
  void *rv = malloc(size*nelem);
  if (rv) memset(rv, 0, size*nelem);
  return rv;
}
void *memchr(const void *s, int c, size_t n)
{
  if (n) { const char *p = s; char cc = c;
  do { if (*p == cc) return unconst(p, void *); p++; } while (--n != 0); 
  } return 0;
}

unsigned int _dos_read(int handle, void *buffer, unsigned int count, unsigned int *result)
{
  __dpmi_regs r;
  unsigned int dos_segment, dos_selector=0, dos_buffer_size, read_size;
  unsigned char *p_buffer;
  dos_buffer_size = (count<0xFFE0)?count:0xFFE0;
  if ((dos_segment=__dpmi_allocate_dos_memory((dos_buffer_size+15)>>4,&dos_selector))==-1) return 8;
  p_buffer = buffer; *result=0;
  while(count) {
    read_size = (count<dos_buffer_size)?count:dos_buffer_size;
    r.h.ah=0x3F; r.x.bx=handle; r.x.cx=read_size;
    r.x.ds=dos_segment; r.x.dx=0; __dpmi_int(0x21, &r);
    if (r.x.flags&1) { __dpmi_free_dos_memory(dos_selector); return r.x.ax; }
    if (r.x.ax) movedata(dos_selector,0,_my_ds(),(unsigned int)p_buffer,r.x.ax);
    count -= read_size; p_buffer += r.x.ax; *result += r.x.ax;
  }
  __dpmi_free_dos_memory(dos_selector);
  return 0;
}
char init_file_handle_modes[20] = { O_TEXT, O_TEXT, O_TEXT, O_BINARY, O_BINARY };
char *__file_handle_modes = init_file_handle_modes;
void __file_handle_set(int fd, int mode)
{ if (fd < 0) return;  __file_handle_modes[fd] = mode; }
long ftell(FILE *f)
{
  long tres;
  int adjust=0;
  if (f->_cnt < 0) f->_cnt = 0;
  if (f->_flag&_IOREAD) adjust = - f->_cnt;
  else if (f->_flag&(_IOWRT|_IORW))
  {
    if (f->_flag&_IOWRT && f->_base && (f->_flag&_IONBF)==0)
      adjust = f->_ptr - f->_base;
  }
  else return -1;
  tres = lseek(fileno(f), 0L, 1);
  if (tres<0) return tres;
  tres += adjust;
  return tres;
}
int _chmod(const char *filename, int func, ...)
{
  __dpmi_regs r;
    r.x.ax = 0x4300 + func;
  _put_path(filename);
  if (func == 1)
    r.x.cx = *(&func + 1);
  r.x.dx = __tb_offset;
  r.x.ds = __tb_segment;
  __dpmi_int(0x21, &r);
  if(r.x.flags & 1) return -1;
  return r.x.cx;
}
int find1(const char *pathname, struct ffblk *ffblk, int attrib)
{
  __dpmi_regs r;
  int pathlen;
  if (pathname == 0 || ffblk == 0) return -1;
  pathlen = strlen(pathname) + 1;
  _put_path(pathname);
    r.x.dx = __tb_offset + pathlen;
    r.x.ds = __tb_segment;
    r.h.ah = 0x1a;
    __dpmi_int(0x21, &r);
    r.h.ah = 0x4e;
    r.x.dx = __tb_offset;
    r.x.ds = __tb_segment;
    r.x.cx = attrib;
    __dpmi_int(0x21, &r);
    if(!(r.x.flags & 1)) { dosmemget(__tb+pathlen,44, ffblk);return 0; }
return 1;
}
int access(const char *fn, int flags)
{
  unsigned attr = _chmod(fn, 0);
  if (attr == -1) { struct ffblk ff;
    if (find1(fn, &ff, FA_RDONLY | FA_ARCH) == 0
	&& (ff.ff_attrib & 0x40) == 0x40 && (flags & (X_OK | D_OK)) == 0)
      return 0;
    return -1;
  }
  if (attr & 0x10) return 0;
  if (flags & D_OK || (flags & W_OK) && (attr & 3)) return -1;
  return 0;
}
int mkdir(const char *mydirname, mode_t mode)
{
  __dpmi_regs r;
  unsigned attr;
  _put_path(mydirname);
    r.h.ah = 0x39;
  r.x.ds = __tb_segment;
  r.x.dx = __tb_offset;
  __dpmi_int(0x21, &r);
  if (r.x.flags & 1) return -1;
  attr = _chmod(mydirname, 0, 0);
  if (_chmod(mydirname, 1, (attr & 0xffe6) | ((mode & S_IWUSR) == 0)) == -1)
    return -1;
  return 0;
}
off_t lseek(int handle, off_t offset, int whence)
{
  __dpmi_regs r;
  r.h.ah = 0x42;
  r.h.al = whence;
  r.x.bx = handle;
  r.x.cx = offset >> 16;
  r.x.dx = offset & 0xffff;
  __dpmi_int(0x21, &r);
  if (r.x.flags & 1) return -1;
  return (r.x.dx << 16) + r.x.ax;
}
long __filelength(int fhandle)
{
  __dpmi_regs    regs;
  unsigned short fpos_high, fpos_low;
  long retval;
  regs.x.ax = 0x4201;
  regs.x.bx = fhandle;
  regs.x.cx = regs.x.dx = 0;
  __dpmi_int(0x21, &regs);
  if (regs.x.flags & 1) return -1L;
  fpos_high = regs.x.dx;
  fpos_low  = regs.x.ax;
  regs.x.cx = regs.x.dx = 0;
  regs.x.ax = 0x4202;
  __dpmi_int(0x21, &regs);
  if (regs.x.flags & 1) return -1L;
  retval = ( (long)regs.x.dx << 16 ) + regs.x.ax;
 regs.x.ax = 0x4200;
 regs.x.cx = fpos_high;
 regs.x.dx = fpos_low;
  __dpmi_int(0x21, &regs);
  if (regs.x.flags & 1) return -1L;
  return retval;
}
int remove(const char *fn)
{
  __dpmi_regs r;
  unsigned attr;
  attr = _chmod(fn, 0);
  if (attr == -1) return(-1);
  r.h.ah = 0x41;
  r.x.dx = __tb_offset;
  r.x.ds = __tb_segment;
  __dpmi_int(0x21, &r);
  if(r.x.flags & 1) { _chmod(fn, 1, attr & 0xffe7); return -1; }
  return 0;
}
FILE __dj_stdout = {0,0,0,0,_IOWRT|_IOFBF,1};
FILE *__alloc_file(void)
{
  FILE *rv;
  rv = (FILE *)malloc(sizeof(FILE));
  if (rv == 0) return 0;
  memset(rv, 0, sizeof(FILE));
  return rv;
}
int close(int handle)
{
  __dpmi_regs r;
  r.h.ah = 0x3e;
  r.x.bx = handle;
  __dpmi_int(0x21, &r);
  if (r.x.flags & 1) return -1;
  return 0;
}
int _creat(const char* filename, int attrib)
{
  __dpmi_regs r;
  if (filename == 0) return -1;
  _put_path(filename);
    r.h.ah = 0x3c;
    r.x.dx = __tb_offset;
  r.x.cx = attrib;
  r.x.ds = __tb_segment;
  __dpmi_int(0x21, &r);
  if(r.x.flags & 1) return -1;
  __file_handle_set(r.x.ax, O_BINARY);
  return r.x.ax;
}
int _open(const char* filename, int oflag)
{
  __dpmi_regs r;
  if (filename == 0) return -1;
  _put_path(filename);
    r.h.ah = 0x3d;
    r.h.al = oflag;
    r.x.dx = __tb_offset;
  r.x.cx = 0;
  r.x.ds = __tb_segment;
  __dpmi_int(0x21, &r);
  if(r.x.flags & 1) return -1;
  __file_handle_set(r.x.ax, O_BINARY);
  return r.x.ax;
}
int read(int handle, void* buffer, size_t count)
{
  size_t j, k; int ngot; unsigned long tbsize;
  __dpmi_regs r;
  tbsize = _go32_info_block.size_of_transfer_buffer;
  ngot = 0;
  do {
    j = (count <= tbsize) ? count : tbsize;
    r.x.ax = 0x3f00;
    r.x.bx = handle;
    r.x.cx = j;
    r.x.dx = __tb & 15;
    r.x.ds = __tb / 16;
    __dpmi_int(0x21, &r);
    if(r.x.flags & 1) return -1;
    count -= j;
    k = r.x.ax;
    ngot += k;
    if (k) dosmemget(__tb, k, buffer);
    buffer = (void *)((int)buffer + k);
  } while(count && j == k);
  return ngot;
}
int _write(int handle, const void* buffer, size_t count)
{
  size_t j, i; int nput; unsigned long tbsize;
  __dpmi_regs r;
  tbsize = _go32_info_block.size_of_transfer_buffer;
  nput = 0;
  do {
    j = (count <= tbsize) ? count : tbsize;
    if (j) dosmemput(buffer, j, __tb);
    r.x.ax = 0x4000;
    r.x.bx = handle;
    r.x.cx = j;
    r.x.dx = __tb & 15;
    r.x.ds = __tb / 16;
    __dpmi_int(0x21, &r);
    if (r.x.flags & 1) return -1;
    i = r.x.ax;
    count -= i;
    buffer = (void *)((int)buffer + i);
    nput += i;
  } while(count && (i == j));
  if (count && nput == 0) return -1;
  return nput;
}
int _fmode = O_TEXT;
FILE *fopen(const char *file, const char *mode)
{
  FILE *f; int fd, rw, oflags = 0;
  char tbchar;
  if (file == 0||mode == 0)
    return 0;
  f = __alloc_file();
  if (f == NULL) return NULL;
  rw = (mode[1] == '+') || (mode[1] && (mode[2] == '+'));
  switch (*mode)
  {
  case 'a':
    oflags = O_CREAT | (rw ? O_RDWR : O_WRONLY);
    break;
  case 'r':
    oflags = rw ? O_RDWR : O_RDONLY;
    break;
  case 'w':
    oflags = O_TRUNC | O_CREAT | (rw ? O_RDWR : O_WRONLY);
    break;
  default:
    return (NULL);
  }
  if (mode[1] == '+') tbchar = mode[2];
  else tbchar = mode[1];
  if (tbchar == 't') oflags |= O_TEXT;
  else if (tbchar == 'b') oflags |= O_BINARY;
  else oflags |= (_fmode & (O_TEXT|O_BINARY));
  fd = open(file, oflags, 0666);
  if (fd < 0) return NULL;
  if (*mode == 'a') lseek(fd, 0, SEEK_END);
  f->_cnt = 0;
  f->_file = fd;
  f->_bufsiz = 0;
  if (rw) f->_flag = _IORW;
  else if (*mode == 'r')
    f->_flag = _IOREAD;
  else f->_flag = _IOWRT;
  f->_base = f->_ptr = NULL;
  return f;
}
size_t fread(void *vptr, size_t size, size_t count, FILE *iop)
{
  char *ptr = (char *)vptr; int s, c;
  while (size*count > iop->_fillsize && iop->_fillsize < iop->_bufsiz)
  {
    if (iop->_fillsize < 512) iop->_fillsize = 512;
    iop->_fillsize *= 2;
  }
  s = size * count;
    while (s > 0) {
      if (iop->_cnt < s) {
	if (iop->_cnt > 0) {
	  memcpy(ptr, iop->_ptr, iop->_cnt);
	  ptr += iop->_cnt;
	  s -= iop->_cnt;
	}
	if ((c = _filbuf(iop)) == EOF)
	  break;
	*ptr++ = c;
	s--;
      }
      if (iop->_cnt >= s) {
	memcpy(ptr, iop->_ptr, s);
	iop->_ptr += s;
	iop->_cnt -= s;
	return count;
      }
    }
  return size != 0 ? count - ((s + size - 1) / size) : 0;
}
int fseek(FILE *f, long offset, int ptrname)
{
  long p = -1;
  f->_fillsize = 512;
  f->_flag &= ~_IOEOF;
  if (f->_flag & _IOREAD)
  {
    if (f->_base && !(f->_flag & _IONBF))
    {
      p = ftell(f);
      if (ptrname == SEEK_CUR) { offset += p; ptrname = SEEK_SET; }
      if (ptrname == SEEK_SET && (f->_flag & (_IOUNGETC|_IORW)) == 0
      && p-offset <= f->_ptr-f->_base && offset-p <= f->_cnt)
      {
        f->_ptr+=offset-p;
        f->_cnt+=p-offset;
        return 0;
      }
    }
    if (f->_flag & _IORW) f->_flag &= ~_IOREAD;
    p = lseek(fileno(f), offset, ptrname);
    f->_cnt = 0;
    f->_ptr = f->_base;
    f->_flag &= ~_IOUNGETC;
  }
  else if (f->_flag & (_IOWRT|_IORW))
  {
    p = fflush(f);
    return lseek(fileno(f), offset, ptrname) == -1 || p == EOF ?
      -1 : 0;
  }
  return p==-1 ? -1 : 0;
}
size_t fwrite(const void *vptr, size_t size, size_t count, FILE *f)
{
  const char *ptr = (const char *)vptr;
  register int s;
  s = size * count;
      while (s > 0) {
      if (f->_cnt < s) {
	if (f->_cnt > 0) {
	  memcpy(f->_ptr, ptr, f->_cnt);
	  ptr += f->_cnt;
	  f->_ptr += f->_cnt;
	  s -= f->_cnt;
	}
	if (_flsbuf(*(const unsigned char *)ptr++, f) == EOF)
	  break;
	s--;
      }
      if (f->_cnt >= s) {
	memcpy(f->_ptr, ptr, s);
	f->_ptr += s;
	f->_cnt -= s;
	return count;
      }
    }
  return size != 0 ? count - ((s + size - 1) / size) : 0;
}
int open(const char* filename, int oflag, ...)
{
  int fd, dmode, bintext;
  int should_create = (oflag & (O_CREAT | O_EXCL)) == (O_CREAT | O_EXCL);
  if (should_create) if (__file_exists(filename)) return -1;
  bintext = oflag & (O_TEXT | O_BINARY);
  if (!bintext) bintext = _fmode & (O_TEXT | O_BINARY);
  if (!bintext) bintext = O_BINARY;
  oflag &= ~(O_TEXT | O_BINARY);
  dmode = (*((&oflag)+1) & S_IWUSR) ? 0 : 1;
    fd = _open(filename, oflag);
    if (fd == -1 && oflag & O_CREAT) fd = _creat(filename, dmode);
  if (fd == -1)  return fd;
  __file_handle_set(fd,__file_handle_modes[fd]&~(O_BINARY|O_TEXT) | (bintext&(O_BINARY|O_TEXT)));
  return fd;
}
int fflush(FILE *f)
{
  char *base;
  int n, rn;
  if (f == NULL) return 0;
  f->_flag &= ~_IOUNGETC;
  if ((f->_flag&(_IONBF|_IOWRT))==_IOWRT
      && (base = f->_base) != NULL
      && (rn = n = f->_ptr - base) > 0)
  {
    f->_ptr = base;
    f->_cnt = (f->_flag&(_IOLBF|_IONBF)) ? 0 : f->_bufsiz;
    do {
      n = _write(fileno(f), base, rn);
      if (n <= 0) {
	f->_flag |= _IOERR;
	return EOF;
      }
      rn -= n;
      base += n;
    } while (rn > 0);
  }
  if (f->_flag & _IORW)
  {
    f->_cnt = 0;
    f->_flag &= ~(_IOWRT|_IOREAD);
    f->_ptr = f->_base;
  }
  return 0;
}
int _filbuf(FILE *f)
{
  int size, fillsize; char c;
  if (f->_flag & _IORW) f->_flag |= _IOREAD;
  if ((f->_flag&_IOREAD) == 0) return EOF;
  if (f->_flag&(_IOSTRG|_IOEOF)) return EOF;
  f->_flag &= ~_IOUNGETC;
  if (f->_base==NULL && (f->_flag&_IONBF)==0) {
    size = _go32_info_block.size_of_transfer_buffer;
    if ((f->_base = malloc(size)) == NULL) { f->_flag |= _IONBF; f->_flag &= ~(_IOFBF|_IOLBF); }
    else { f->_flag |= _IOMYBUF; f->_bufsiz = size; f->_fillsize = 512; }
  }
  if (f->_flag&_IONBF) f->_base = &c;
  if (f->_fillsize > f->_bufsiz) f->_fillsize = f->_bufsiz;
  fillsize = f->_fillsize;
  if (fillsize == 1024 && f->_bufsiz >= 1536) fillsize = 1536;
  f->_cnt = read(fileno(f), f->_base, f->_flag & _IONBF ? 1 : fillsize);
  if (f->_fillsize < f->_bufsiz) f->_fillsize *= 2;
  f->_ptr = f->_base;
  if (f->_flag & _IONBF) f->_base = NULL;
  if (--f->_cnt < 0) {
    if (f->_cnt == -1) { f->_flag |= _IOEOF;
      if (f->_flag & _IORW) f->_flag &= ~_IOREAD;
    } else f->_flag |= _IOERR;
    f->_cnt = 0;
    return EOF;
  }
  return *f->_ptr++ & 0377;
}
int _flsbuf(int c, FILE *f)
{
  char *base,c1; int n, rn, size;
  if (f->_flag & _IORW) { f->_flag |= _IOWRT; f->_flag &= ~(_IOEOF|_IOREAD); }
  if ((f->_flag&_IOWRT)==0) return EOF;
  if ((base = f->_base) == NULL && (f->_flag & _IONBF) == 0)
  {
    size = _go32_info_block.size_of_transfer_buffer;
    if ((f->_base = base = malloc (size)) == NULL) { f->_flag |= _IONBF; f->_flag &= ~(_IOFBF|_IOLBF); }
    else { f->_flag |= _IOMYBUF; f->_cnt = f->_bufsiz = size; f->_ptr = base; rn = 0; }
  }
  if (f->_flag & _IOLBF)
  {
    *f->_ptr++ = c; rn = f->_ptr - base;
    if (c == '\n' || rn >= f->_bufsiz) { f->_ptr = base; f->_cnt = 0; }
    else { f->_cnt = -rn; return c; }
  }
  else if (f->_flag & _IONBF) { c1 = c; rn = 1; base = &c1; f->_cnt = 0; }                 
  else { rn = f->_ptr - base; f->_ptr = base; f->_cnt = f->_bufsiz; }
  while (rn > 0)
  {
    n = _write(fileno(f), base, rn);
    if (n <= 0) { f->_flag |= _IOERR; return EOF; }
    rn -= n; base += n;
  }
  if ((f->_flag&(_IOLBF|_IONBF)) == 0) { f->_cnt--; *f->_ptr++ = c; }
  return c;
}
int fclose(FILE *f)
{
  int r;
  r = EOF;
  if (!f) return r;
  if (f->_flag & (_IOREAD|_IOWRT|_IORW) && !(f->_flag&_IOSTRG))
  {
    r = fflush(f);
    if (close(fileno(f)) < 0) r = EOF;
    if (f->_flag&_IOMYBUF) free(f->_base);
  }
  if (f->_flag & _IORMONCL && f->_name_to_remove)
  {
    remove(f->_name_to_remove);
    free(f->_name_to_remove);
    f->_name_to_remove = 0;
  }
  f->_cnt = 0;  f->_base = 0;
  f->_ptr = 0;  f->_bufsiz = 0;
  f->_flag = 0;  f->_file = -1;
  return r;
}
int __file_exists(const char *fn)
{
  if(_chmod(fn, 0) == -1)
    return 0;
  return 1;
}

int atexit(void (*a)(void))
{
  struct __atexit *ap;
  if (a == 0)  return -1;
  ap = (struct __atexit *)malloc(sizeof(struct __atexit));
  if (!ap) return -1;
  ap->__next = __atexit_ptr;
  ap->__function = a;
  __atexit_ptr = ap;
  return 0;
}
struct __atexit *__atexit_ptr = 0;
void exit(int status)
{
  struct __atexit *a;
  a = __atexit_ptr; __atexit_ptr = 0;
  while (a) { (a->__function)(); a = a->__next; }
  __exit(status);
}
void abort(){ __exit(1); }

#define ds _my_ds()

typedef struct Arg {
  char *arg;
  struct ArgList *arg_file;
  struct Arg *next;
} Arg;
typedef struct ArgList {
  int argc;
  Arg **argv;
} ArgList;

Arg *new_arg(void)
{
  Arg *a = (Arg *)malloc(sizeof(Arg));
  memset(a, 0, sizeof(Arg));
  return a;
}

ArgList *new_arglist(int count)
{
  ArgList *al = (ArgList *)malloc(sizeof(ArgList));
  al->argc = count;
  al->argv = (Arg **)malloc((count+1)*sizeof(Arg *));
  memset(al->argv, 0, (count+1)*sizeof(Arg *));
  return al;
}

char *parse_arg(char *bp, char *last, size_t *len)
{
  char *ep = bp, *epp = bp;
  int quote=0;
  while ((quote || !isspace(*ep)) && ep < last)
  {
    if (quote && *ep == quote) { quote = 0; ep++; }
    else if (!quote && (*ep == '\'' || *ep == '"')) quote = *ep++;
    else if (*ep == '\\' && strchr("'\"", ep[1]) && ep < last-1) ep++;
      *epp++ = *ep++;
  }
  *len = epp - bp;
  return ep;
}

ArgList *parse_bytes(char *bytes, int length)
{
  int largc, i;
  Arg *a, **anext, *afirst;
  ArgList *al;
  char *bp=bytes, *ep, *last=bytes+length;

  anext = &afirst;
  largc = 0;
  while (bp<last)
  {
    size_t arg_len;
    while (isspace(*bp) && bp < last)
      bp++;
    if (bp == last)
      break;
    *anext = a = new_arg();
    ep = parse_arg(bp, last,&arg_len);
    anext = &(a->next);
    largc++;
    a->arg = (char *)malloc(arg_len+1);
    memcpy(a->arg, bp, arg_len);
    a->arg[arg_len] = 0;
    bp = ep+1;
  }
  al = new_arglist(largc);
  for (i=0, a=afirst; i<largc; i++, a=a->next)
    al->argv[i] = a;
  return al;
}

int count_args(ArgList *al)
{
  int i, r=0;
  for (i=0; i<al->argc; i++)
  {
    if (al->argv[i]->arg_file) r += count_args(al->argv[i]->arg_file);
    else r++;
  }
  return r;
}

char **fill_args(char **largv, ArgList *al)
{
  int i;
  for (i=0; i<al->argc; i++)
  {
    if (al->argv[i]->arg_file) largv = fill_args(largv, al->argv[i]->arg_file);
    else { *largv++ = al->argv[i]->arg; al->argv[i]->arg = 0; }
  }
  return largv;
}

int _crt0_startup_flags, __crt0_argc;
char **__crt0_argv, *__dos_argv0;
void __crt0_setup_arguments(void)
{
  ArgList *arglist;
  char *argv0, *ap, *ls, *fc;
  int  i;

    ls = __dos_argv0;
    for (ap=__dos_argv0; *ap; ap++)
      if (*ap == ':' || *ap == '\\' || *ap == '/') ls = ap + 1;
    fc = ls;

    if (_stubinfo->argv0[0]) fc = _stubinfo->argv0;
    argv0 = (char *)calloc(1, ls-__dos_argv0+strlen(fc)+1);
    if (ls == __dos_argv0)
      strncpy(argv0, fc, 16);
    else
    {
      strncpy(argv0, __dos_argv0, ls-__dos_argv0);
      strncat(argv0, fc, 16);
    }
    for (i=0; (fc == _stubinfo->argv0)?(i<ls-__dos_argv0):(argv0[i]); i++)
    {
        if (argv0[i] == '\\') argv0[i] = '/';
        if (isupper(argv0[i])) argv0[i] = tolower(argv0[i]);
    }
  {
    char doscmd[128];
    movedata(_stubinfo->psp_selector, 128, ds, (int)doscmd, 128);
    arglist = parse_bytes(doscmd+1, doscmd[0] & 0x7f);
  }
  __crt0_argc = 1 + count_args(arglist);
  __crt0_argv = (char **)malloc((__crt0_argc+1) * sizeof(char *));
    __crt0_argv[0] = argv0;
  *fill_args(__crt0_argv+1, arglist) = 0;
}

char **environ;
void setup_core_selector(void)
{
  int c = __dpmi_allocate_ldt_descriptors(1);
  if (c == -1) { _dos_ds = 0; return; }
  _dos_ds = c;
  __dpmi_set_segment_limit(_dos_ds, 0x10ffff);
}

void setup_go32_info_block(void)
{
  __dpmi_version_ret ver;
  __dpmi_get_version(&ver);
  _go32_info_block.size_of_this_structure_in_bytes = sizeof(_go32_info_block);
  __tb = _stubinfo->ds_segment * 16;
  _go32_info_block.size_of_transfer_buffer = _stubinfo->minkeep;
  _go32_info_block.pid = _stubinfo->psp_selector;
  _go32_info_block.master_interrupt_controller_base = ver.master_pic;
  _go32_info_block.slave_interrupt_controller_base = ver.slave_pic;
  _go32_info_block.linear_address_of_stub_info_structure = 0xffffffffU;
  __dpmi_get_segment_base_address(_stubinfo->psp_selector,
    &_go32_info_block.linear_address_of_original_psp);
  _go32_info_block.run_mode = _GO32_RUN_MODE_DPMI;
  _go32_info_block.run_mode_info = (ver.major << 8) | (ver.minor);
}

void setup_environment()
{
  char *dos_environ = alloca(_stubinfo->env_size), *cp;
  short env_selector;
  int env_count=0;
  movedata(_stubinfo->psp_selector, 0x2c, ds, (int)&env_selector, 2);
  movedata(env_selector, 0, ds, (int)dos_environ, _stubinfo->env_size);
  cp = dos_environ;
  do {
    env_count++;
    while (*cp) cp++; cp++;
  } while (*cp);
  environ = (char **)malloc((env_count+1) * sizeof(char *));
  if (environ == 0) return;
  cp = dos_environ;
  env_count = 0;
  do {
    environ[env_count] = (char *)malloc(strlen(cp)+1);
    strcpy(environ[env_count], cp);
    env_count++;
    while (*cp) cp++; cp++;
  } while (*cp);
  environ[env_count] = 0;
  __dos_argv0 = (char *)malloc(strlen(cp + 3)+1);
  if (__dos_argv0 == 0) abort();
  strcpy(__dos_argv0, cp+3);
}
char *prog_name;
void setup_pname(void)
{
  char *ap, *fc;
  fc = __dos_argv0;
  for(ap = __dos_argv0; *ap; ap++)
    if(*ap == ':' || *ap == '\\' || *ap == '/')
      fc = ap + 1;
  if(_stubinfo->argv0[0]) fc = _stubinfo->argv0;
  prog_name = (char *)calloc(1, strlen(fc) + 1);
  strcpy(prog_name, fc);
}
extern int  main(int, char **, char **);

void __crt1_startup(void)
{
  __crt0_argv = 0;
  setup_core_selector();
  setup_go32_info_block();
  setup_environment();
  setup_pname();
  free(prog_name);
  __crt0_setup_arguments();
  exit(main(__crt0_argc, __crt0_argv, environ));
}

long long __divdi3 (u, v) long long u, v;
{
  if (u < 0) if (v < 0) return (unsigned long long) -u / (unsigned long long) -v;
    else return - ((unsigned long long) -u / (unsigned long long) v);
  else if (v < 0) return - ((unsigned long long) u / (unsigned long long) -v);
    else return (unsigned long long) u / (unsigned long long) v;
}
typedef	unsigned long ULONG;
void	InsertionSort(ULONG First, ULONG Last);
void	QuickSort (ULONG, ULONG);
extern	void qsort (void *, size_t, size_t,int (*)(const void *, const void *));
void	Swap (char  *, char  *);
int (*Cmpr) (const void *, const void *);

#define ADDR(i) (ULONG)((ULONG)(i)*((ULONG)DataWidth))
#define BASE(i) (MyBase + ADDR((i)-1))
#define DEC(A)	(A -= DataWidth)
#define INC(A)	(A += DataWidth)
#define CMPR(a, b) (*Cmpr)(a, b)
#define SWAP(a, b)   Swap (a, b)

size_t	DataWidth;
char	*MyBase;

void qsort(void *Base, size_t Num, size_t Width,int(*Compare) (const void *, const void *))
{
    Cmpr = Compare;
    DataWidth = Width;
    MyBase = (char *)Base;
    QuickSort((ULONG) 1, (ULONG) Num);
}
void InsertionSort(ULONG First, ULONG Last)
{
    ULONG   NextIdx, StartIdx;
    char   *NextAdr, *PrevAdr, *StartAdr;

    StartAdr = BASE(First + 1);
    for (StartIdx = First + 1; StartIdx <= Last; ++StartIdx)
    {
	PrevAdr = StartAdr;
	INC(StartAdr);
	for (NextIdx = StartIdx; NextIdx > 1; --NextIdx)
	{
	NextAdr = PrevAdr;
	DEC(PrevAdr);
	if (0 >= CMPR(PrevAdr, NextAdr)) break;
	SWAP(PrevAdr, NextAdr);
	}
    }
}

void QuickSort(ULONG First, ULONG Last)
{
    while (First < Last)
    {
    InsertionSort(First, Last);
    break;
    }
}
void Swap(char  * Elem1, char  * Elem2)
{
	char    TempBuf[256];
	size_t  CopySize, XferSize;
	for (XferSize = DataWidth; 0 < XferSize; XferSize -= CopySize)
	{
	CopySize = (XferSize < sizeof(TempBuf)) ? XferSize :
	sizeof(TempBuf);
	memcpy(TempBuf, Elem1, CopySize);
	memcpy(Elem1, Elem2, CopySize);
	memcpy(Elem2, TempBuf, CopySize);
	Elem1 += CopySize, Elem2 += CopySize;
	}
}
unsigned char ScreenAttrib = 0x07;
void ScreenSetCursor(int _row, int _col)
{
  __dpmi_regs r;
  r.h.ah = 2;
  r.h.bh = 0;
  r.h.dh = _row;
  r.h.dl = _col;
  __dpmi_int(0x10, &r);
}
void gotoxy(int col, int row) { ScreenSetCursor(row - 2, col - 2); }
void textattr(int attr) { ScreenAttrib = (unsigned char)attr; }
void clrscr() { int c; __dpmi_regs r; r.x.es = r.x.di = 0; r.x.ax = 3; __dpmi_int(0x10, &r);
for(;c<4000;c++) dosmemput(0,1,(unsigned)(0xb8000+c)); gotoxy(1,1); }
int cputs(const char *s)
{
  int row=0,col=0,c;
  const unsigned char *ss = (const unsigned char *)s;
  short *viaddr;
  short sa = ScreenAttrib << 8;
  viaddr = (short *)(unsigned)(0xb8000);
  while ((c = *ss++))
  {
      short q = c | sa;
      dosmemput(&q, 2, (int)viaddr);
      viaddr++;
      col++;
  }
 ScreenSetCursor(row, col);
}
int cprintf(const char *fmt, ...)
{
  char buf[2048];
  va_list ap;
  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  va_end(ap);  
  cputs(buf);
}
void delay(unsigned msec)
{
  __dpmi_regs r;
  while (msec)
  {
    unsigned usec;
    unsigned msec_this = msec;
    if (msec_this > 4000)
      msec_this = 4000;
    usec = msec_this * 1000;
    r.h.ah = 0x86;
    r.x.cx = usec>>16;
    r.x.dx = usec & 0xffff;
    __dpmi_int(0x15, &r);
    msec -= msec_this;
  }
}
int disable() { asm("cli"); } int enable() { asm("sti"); }
void dosmemget(unsigned long offset, size_t length, void *buffer)
{
  movedata((unsigned)_dos_ds,(unsigned)offset,
 (unsigned)_my_ds(),(unsigned)buffer,length);
}
void dosmemput(const void *buffer, size_t length, unsigned long offset)
{
  movedata((unsigned)_my_ds(),(unsigned)buffer,
 (unsigned)_dos_ds,(unsigned)offset,length);
}

unsigned char __dj_ctype_toupper[] = {
  0x00,
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
  0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
  0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
  0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
  0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
  0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
  0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
  0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
  0x58, 0x59, 0x5a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
  0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
  0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
  0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
  0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
  0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
  0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
  0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
  0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
  0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
  0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};
unsigned char __dj_ctype_tolower[] = {
  0x00,
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
  0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
  0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
  0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
  0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
  0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
  0x78, 0x79, 0x7a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
  0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
  0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
  0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
  0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
  0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
  0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
  0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
  0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
  0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
  0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
  0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
  0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
  0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
  0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};
unsigned short __dj_ctype_flags[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  __dj_ISSPACE,
  __dj_ISSPACE,
  __dj_ISSPACE,
  __dj_ISSPACE,
  __dj_ISSPACE,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  __dj_ISSPACE,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  __dj_ISALNUM | __dj_ISDIGIT,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  __dj_ISALNUM | __dj_ISALPHA | __dj_ISUPPER,
  0,
  0,
  0,
  0,
  0,
  0,
  __dj_ISALNUM | __dj_ISALPHA,	
  __dj_ISALNUM | __dj_ISALPHA,	
  __dj_ISALNUM | __dj_ISALPHA,	
  __dj_ISALNUM | __dj_ISALPHA,	
  __dj_ISALNUM | __dj_ISALPHA,	
  __dj_ISALNUM | __dj_ISALPHA,	
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
  __dj_ISALNUM | __dj_ISALPHA,
};

void _farsetsel(unsigned short selector) {  __asm__ __volatile__ ("movw %w0,%%fs" :: "rm" (selector)); }
void _farnspokeb(unsigned long offset, unsigned char value)
{ __asm__ __volatile__ (".byte 0x64\n" "movb %b0,(%k1)" :: "qi" (value), "r" (offset)); }
unsigned char _farnspeekb(unsigned long offset)
{ unsigned char result; __asm__ __volatile__ (".byte 0x64\n" "movb (%k1),%b0" : "=q" (result) : "r" (offset)); return result; }
void _put_path(const char *path) { _put_path2(path, 0); }
void _put_path2(const char *path, int offset)
{
  int o = __tb+offset;
  int space = _go32_info_block.size_of_transfer_buffer - offset;
  const char *p = path;
  if (path == 0) abort(); _farsetsel(_dos_ds);
  if (p[0] && p[1] == ':') p += 2;
  if (strncmp(p, "/dev/", 5) == 0)
  {
    if (strcmp(p+5, "null") == 0) path = "nul";
    else if (strcmp(p+5, "tty") == 0) path = "con";
    else if ((p[5] >= 'a' && p[5] <= 'z') && (p[6] == '/' || p[6] == '\\' || p[6] == '\0'))
    { _farnspokeb(o++, p[5]); _farnspokeb(o++, ':'); path = p + 6; space -= 2; }
    else if (p[5]) path = p + 5;
  }
  for (; *path; path++)
  {
    if (path[0] != '/' || path[1] != '/')
    { _farnspokeb(o, *path); o++; if (--space < 2) break; }
  }
  if (o-2 >= __tb+offset && _farnspeekb(o-1) == '/' && _farnspeekb(o-2) != ':')
    o--;
  _farnspokeb(o, 0);
}
#undef feof
int feof(FILE *stream)
{
  return stream->_flag & _IOEOF;
}