/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "g_game.h"
#include "r_data.h"
#include "p_inter.h"
#include "m_cheat.h"
#include "sounds.h"
#include "d_englsh.h"
#include "d_deh.h"

#define plyr (players+consoleplayer)

void cheat_mus();
void cheat_choppers();
void cheat_god();
void cheat_fa();
void cheat_kfa();
void cheat_noclip();
void cheat_pw();
void cheat_behold();
void cheat_clev();
void cheat_mypos();
void cheat_massacre();
void cheat_ddt();
void cheat_res();
void cheat_infinite();
void cheat_jet();

struct cheat_s cheat[] = {
  {"idmus", "Change music", always, cheat_mus,-2},
  {"idchoppers", "Chainsaw", not_dm | not_demo, cheat_choppers},
  {"iddqd", "God mode", not_dm | not_demo, cheat_god},
  {"idkfa", "Ammo & Keys", not_dm | not_demo, cheat_kfa},
  {"idfa", "Ammo", not_dm | not_demo, cheat_fa},
  {"idspispopd", "No Clipping 1", not_dm | not_demo, cheat_noclip},
  {"idclip", "No Clipping 2", not_dm | not_demo, cheat_noclip},
  {"idbeholdv","Invincibility",not_dm|not_demo,cheat_pw,pw_invulnerability},
  {"idbeholds","Berserk",not_dm | not_demo,cheat_pw, pw_strength },
  {"idbeholdi", "Invisibility", not_dm | not_demo, cheat_pw,pw_invisibility},
  {"idbeholdr", "Radiation Suit", not_dm | not_demo, cheat_pw,pw_ironfeet},
  {"idbeholda", "Auto-map", not_dm | not_demo, cheat_pw, pw_allmap},
  {"idbeholdl", "Lite-Amp Goggles", not_dm | not_demo, cheat_pw,pw_infrared},
  {"idbehold", "BEHOLD menu", not_dm | not_demo, cheat_behold},
  {"idclev", "Level Warp", not_dm | not_demo, cheat_clev,-2},
  {"idmypos","Player Position",always, cheat_mypos},
  {"kill", NULL, not_demo, cheat_massacre},
  {"iddt", "Map cheat",  not_dm, cheat_ddt},
  {"res", NULL, not_dm | not_demo, cheat_res},
  {"infi", NULL, not_dm | not_demo, cheat_infinite},
  {"jet", NULL, not_dm | not_demo, cheat_jet},
  {NULL}
};

void cheat_mus(buf)
char buf[3];
{
  int musnum;
  
  if (!isdigit(buf[0]) || !isdigit(buf[1]))
    return;

  plyr->message = s_STSTR_MUS;
  
  if (gamemode == commercial)
    {
      musnum = mus_runnin + (buf[0]-'0')*10 + buf[1]-'0' - 1;
          
      if (musnum < mus_runnin ||  ((buf[0]-'0')*10 + buf[1]-'0') > 35)
        plyr->message = s_STSTR_NOMUS;
      else
        {
          S_ChangeMusic(musnum, 1);
          idmusnum = musnum;
        }
    }
  else
    {
      musnum = mus_e1m1 + (buf[0]-'1')*9 + (buf[1]-'1');
          
      if (buf[0] < '1' || buf[1] < '1' || ((buf[0]-'1')*9 + buf[1]-'1') > 31)
        plyr->message = s_STSTR_NOMUS;
      else
        {
          S_ChangeMusic(musnum, 1);
          idmusnum = musnum;
        }
    }
}

void cheat_choppers()
{
  plyr->weaponowned[wp_chainsaw] = true;
  plyr->powers[pw_invulnerability] = true;
  plyr->message = s_STSTR_CHOPPERS;
}

void cheat_god()
{
  plyr->cheats ^= CF_GODMODE;
  if (plyr->cheats & CF_GODMODE)
    {
      if (plyr->mo)
      plyr->mo->health = god_health;
      plyr->health = god_health;
      plyr->message = s_STSTR_DQDON;
    }
  else 
    plyr->message = s_STSTR_DQDOFF;
}

void cheat_fa()
{
  int i;

  if (!plyr->backpack)
    {
      for (i=0 ; i<NUMAMMO ; i++)
        plyr->maxammo[i] *= 2;
      plyr->backpack = true;
    }

  plyr->armorpoints = idfa_armor;
  plyr->armortype = idfa_armor_class;
        
  for (i=0;i<NUMWEAPONS;i++)
      plyr->weaponowned[i] = true;
        
  for (i=0;i<NUMAMMO;i++)
      plyr->ammo[i] = plyr->maxammo[i];

  plyr->message = s_STSTR_FAADDED;
}

void cheat_k()
{
  int i;
  for (i=0;i<NUMCARDS;i++)
        plyr->cards[i] = true;
}

void cheat_kfa()
{
  cheat_k();
  cheat_fa();
  plyr->message = s_STSTR_KFAADDED;
}

void cheat_noclip()
{
  plyr->message = (plyr->cheats ^= CF_NOCLIP) & CF_NOCLIP ? 
    s_STSTR_NCON : s_STSTR_NCOFF;
}

void cheat_pw(pw)
{
  if (plyr->powers[pw])
    plyr->powers[pw] = pw!=pw_strength && pw!=pw_allmap;
  else
    {
      P_GivePower(plyr, pw);
      if (pw != pw_strength && !comp[comp_infcheat])
        plyr->powers[pw] = -1;
    }
  plyr->message = s_STSTR_BEHOLDX;
}

void cheat_behold()
{
  plyr->message = s_STSTR_BEHOLD;
}

void cheat_clev(buf)
char buf[3];
{
  int epsd, map;

  if (gamemode == commercial)
    {
      epsd = 1;
      map = (buf[0] - '0')*10 + buf[1] - '0';
    }
  else
    {
      epsd = buf[0] - '0';
      map = buf[1] - '0';
    }

  if (epsd < 1 || map < 1 ||
      (gamemode == retail     && (epsd > 4 || map > 9  )) ||
      (gamemode == registered && (epsd > 3 || map > 9  )) ||
      (gamemode == shareware  && (epsd > 1 || map > 9  )) ||
      (gamemode == commercial && (epsd > 1 || map > 32 )) )
    return;

  idmusnum = -1;

  G_DeferedInitNew(gameskill, epsd, map);
}

void cheat_mypos()
{
  dprintf("Position (%d,%d,%d)\tAngle %d",
          players[consoleplayer].mo->x >> FRACBITS,
          players[consoleplayer].mo->y >> FRACBITS,
          players[consoleplayer].mo->z >> FRACBITS,
          players[consoleplayer].mo->angle/0xb60000);
}

void cheat_massacre()
{
  int killcount=0;
  thinker_t *currentthinker=&thinkercap;
  extern void A_PainDie(mobj_t *);
  int mask = MF_FRIEND;
  do
    while ((currentthinker=currentthinker->next)!=&thinkercap)
      if (currentthinker->function == P_MobjThinker &&
	  !(((mobj_t *) currentthinker)->flags & mask) &&
	  (((mobj_t *) currentthinker)->flags & MF_COUNTKILL ||
	   ((mobj_t *) currentthinker)->type == MT_SKULL))
	{
	  if (((mobj_t *) currentthinker)->health > 0)
	    {
	      killcount++;
	      P_DamageMobj((mobj_t *) currentthinker, NULL, NULL, 10000);
	    }
	  if (((mobj_t *) currentthinker)->type == MT_PAIN)
	    {
	      A_PainDie((mobj_t *) currentthinker);
	      P_SetMobjState((mobj_t *) currentthinker, S_PAIN_DIE6);
	    }
	}
  while (!killcount && mask ? mask=0, 1 : 0);
  dprintf("%d Monster%s Killed", killcount, killcount==1 ? "" : "s");
}

void cheat_ddt()
{
  extern int ddt_cheating;
  extern boolean automapactive;
  if (automapactive)
    ddt_cheating = (ddt_cheating+1) % 3;
}

#define CHEAT_ARGS_MAX 8

boolean M_FindCheats(int key)
{
  static unsigned long long sr;
  static char argbuf[CHEAT_ARGS_MAX+1], *arg;
  static int init, argsleft, cht;
  int i, ret, matchedbefore;

  if (argsleft)
    {
      *arg++ = key;
      if (!--argsleft)
        cheat[cht].func(argbuf);
      return 1;
    }

  key = key - 'a';
  if (key < 0 || key >= 32)
    {
      sr = 0;
      return 0;
    }

  if (!init)
    {
      init = 1;
      for (i=0;cheat[i].cheat;i++)
        {
          unsigned long long c=0, m=0;
          const unsigned char *p;
          for (p=cheat[i].cheat; *p; p++)
            {
              unsigned key = *p-'a';
              if (key >= 32)
                continue;
              c = (c<<5) + key;
              m = (m<<5) + 31;
            }
          cheat[i].code = c;
          cheat[i].mask = m;
        }
    }

  sr = (sr<<5) + key;

  for (matchedbefore = ret = i = 0; cheat[i].cheat; i++)
    if ((sr & cheat[i].mask) == cheat[i].code &&
        !(cheat[i].when & not_dm   && deathmatch && !demoplayback) &&
        !(cheat[i].when & not_demo && demoplayback))
      if (cheat[i].arg < 0)
        {
          cht = i;
          arg = argbuf;
          argsleft = -cheat[i].arg;
          ret = 1;
        }
      else
        if (!matchedbefore) 
          {
            matchedbefore = ret = 1;
            cheat[i].func(cheat[i].arg);
          }
  return ret;
}

void cheat_res(void)
{ if(plyr->playerstate!=PST_LIVE)
   { plyr->playerstate=PST_LIVE;
     plyr->mo->health=plyr->health=initial_health;
     plyr->mo->height=plyr->mo->info->height;
     S_StartSound(plyr->mo,sfx_slop);
     plyr->mo->flags&=~MF_CORPSE;
     plyr->mo->flags|=MF_SOLID|MF_SHOOTABLE;
     P_BringUpWeapon(plyr); } }

void cheat_infinite(void)
{ plyr->message = (plyr->cheats ^= CF_INFINITE) & CF_INFINITE ?
"Infinite ammo on" : "Infinite ammo off"; }

void cheat_jet(void)
{ plyr->message = (plyr->cheats ^= CF_JET) & CF_JET ?
"Fly mode on" : "Fly mode off"; }