#ifndef __M_MENU__
#define __M_MENU__

#include "d_event.h"

#define S_HILITE     0x1
#define S_SELECT     0x2
#define S_TITLE      0x4
#define S_YESNO      0x8
#define S_CRITEM    0x10
#define S_PREV     0x100
#define S_NEXT     0x200
#define S_KEY      0x400
#define S_NUM     0x1000
#define S_SKIP    0x2000
#define S_KEEP    0x4000
#define S_END     0x8000
#define S_FILE    0x80000
#define S_LEFTJUST 0x100000

#define S_SHOWDESC (S_TITLE|S_YESNO|S_CRITEM|S_PREV|S_NEXT|S_KEY|S_NUM|S_FILE)
#define S_SHOWSET  (S_YESNO|S_CRITEM|S_KEY|S_NUM|S_FILE)
#define S_STRING (S_FILE)
#define S_HASDEFPTR (S_STRING|S_YESNO|S_NUM|S_CRITEM)

typedef struct setup_menu_s
{
  const char  *m_text;
  int         m_flags;
  short       m_x;
  short       m_y;
  union
   {
     void      *var;
     int       *m_key;
     char      *name;
     struct default_s *def;
     struct setup_menu_s *menu;
  } var;
  int         *m_mouse;
  int         *m_joy;
  void (*action)(void);
} setup_menu_t;

#endif