#ifndef __P_MOBJ__
#define __P_MOBJ__

#include "tables.h"
#include "m_fixed.h"
#include "d_think.h"
#include "doomdata.h"
#include "info.h"

typedef enum
{
 MF_SPECIAL = 1,
 MF_SOLID = 2,
 MF_SHOOTABLE = 4,
 MF_NOSECTOR = 8,
 MF_NOBLOCKMAP = 16, 
 MF_AMBUSH = 32,
 MF_JUSTHIT = 64,
 MF_JUSTATTACKED = 128,
 MF_SPAWNCEILING = 256,
 MF_NOGRAVITY = 512,
 MF_DROPOFF = 0x400,
 MF_PICKUP = 0x800,
 MF_NOCLIP = 0x1000,
 MF_SLIDE = 0x2000,
 MF_FLOAT = 0x4000,
 MF_TELEPORT = 0x8000,
 MF_MISSILE = 0x10000, 
 MF_DROPPED = 0x20000,
 MF_SHADOW = 0x40000,
 MF_NOBLOOD = 0x80000,
 MF_CORPSE = 0x100000,
 MF_INFLOAT = 0x200000,
 MF_COUNTKILL = 0x400000,
 MF_COUNTITEM = 0x800000,
 MF_SKULLFLY = 0x1000000,
 MF_NOTDMATCH = 0x2000000,
 MF_TRANSLATION = 0xc000000,
 MF_TRANSSHIFT = 26,
 MF_TOUCHY = 0x10000000,
 MF_BOUNCES = 0x20000000,
 MF_FRIEND = 0x40000000,
 MF_TRANSLUCENT = 0x80000000,
} mobjflag_t;

enum {
 MIF_FALLING = 1,
 MIF_ARMED = 2,
 MIF_LINEDONE = 4,
};

typedef struct mobj_s
{
 thinker_t thinker;
 fixed_t x,y,z;
 struct mobj_s* snext;
 struct mobj_s** sprev;
 angle_t angle;
 spritenum_t sprite;
 int frame;
 struct mobj_s* bnext;
 struct mobj_s** bprev;
 struct subsector_s* subsector;
 fixed_t floorz,ceilingz;
 fixed_t dropoffz;
 fixed_t radius,height; 
 fixed_t momx,momy,momz;
 int validcount;
 mobjtype_t type;
 mobjinfo_t* info;
 int tics;
 state_t* state;
 int flags;
 int intflags;
 int health;
 short movedir,movecount,strafecount;
 struct mobj_s* target;
 short reactiontime; 
 short threshold;
 short pursuecount;
 short gear;
 struct player_s* player;
 short lastlook; 
 mapthing_t spawnpoint; 
 struct mobj_s* tracer; 
 struct mobj_s* lastenemy;
 struct mobj_s* above_thing;
 struct mobj_s* below_thing;
 struct msecnode_s* touching_sectorlist;
} mobj_t;

#define VIEWHEIGHT (41*FRACUNIT)
#define PLAYERRADIUS (16*FRACUNIT)
#define GRAVITY FRACUNIT
#define MAXMOVE (30*FRACUNIT)
#define ONFLOORZ MININT
#define ONCEILINGZ MAXINT
#define ITEMQUESIZE 128
#define FLOATSPEED (FRACUNIT*4)
#define STOPSPEED (FRACUNIT/16)
#define OVERDRIVE 6
#define MAXGEAR (OVERDRIVE+16)
#define sentient(mobj) ((mobj)->health > 0 && (mobj)->info->seestate)

extern mapthing_t itemrespawnque[];
extern int itemrespawntime[],iquehead,iquetail;

mobj_t *P_SpawnMobj(fixed_t x, fixed_t y, fixed_t z, mobjtype_t type);
mobj_t *P_SpawnMissile(mobj_t* source,mobj_t* dest,mobjtype_t type);
void P_MobjThinker(mobj_t* mobj);
#endif