/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "z_zone.h"

#include "doomstat.h"
#include "w_wad.h"
#include "r_main.h"
#include "r_draw.h"
#include "r_plane.h"

#define MAXVISPLANES 128
static visplane_t *visplanes[MAXVISPLANES],*freetail,**freehead=&freetail;
visplane_t *floorplane, *ceilingplane;

#define visplane_hash(picnum,lightlevel,height) \
(((unsigned)(picnum)*3+(unsigned)(lightlevel)+(unsigned)(height)*7)&(MAXVISPLANES-1))
short openings[64000],*lastopening;
short floorclip[320],ceilingclip[320];
static int spanstart[200];
static lighttable_t **planezlight;
static fixed_t planeheight;

static fixed_t basexscale,baseyscale;
static fixed_t cachedheight[200],cacheddistance[200];
static fixed_t cachedxstep[200],cachedystep[200];
static fixed_t xoffs,yoffs;
fixed_t yslope[200],distscale[320];

static void R_MapPlane(int y, int x1, int x2)
{
  angle_t angle;
  fixed_t distance, length;
  unsigned index;

  if (planeheight != cachedheight[y])
    {
      cachedheight[y] = planeheight;
      distance = cacheddistance[y] = FixedMul (planeheight, yslope[y]);
      ds_xstep = cachedxstep[y] = FixedMul (distance,basexscale);
      ds_ystep = cachedystep[y] = FixedMul (distance,baseyscale);
    }
  else
    {
      distance = cacheddistance[y];
      ds_xstep = cachedxstep[y];
      ds_ystep = cachedystep[y];
    }

  length = FixedMul (distance,distscale[x1]);
  angle = (viewangle + xtoviewangle[x1])>>ANGLETOFINESHIFT;

  ds_xfrac =  viewx + FixedMul(finecosine[angle], length) + xoffs;
  ds_yfrac = -viewy - FixedMul(finesine[angle],   length) + yoffs;

  if (!(ds_colormap = fixedcolormap))
    {
      index = distance >> LIGHTZSHIFT;
      if (index >= MAXLIGHTZ )
        index = MAXLIGHTZ-1;
      ds_colormap = planezlight[index];
    }

  ds_y = y;
  ds_x1 = x1;
  ds_x2 = x2;

  R_DrawSpan();
}
int maxf;
void R_ClearPlanes(void)
{
  int i,p;
  angle_t angle;
  for (i=viewwidth;i--;)
  { floorclip[i] = viewheight, ceilingclip[i] = -1;
    for(p=maxf;--p>-1;)
    ffloors[p].c_clip[i]=0,ffloors[p].f_clip[i]=200; }

  for (i=MAXVISPLANES;i--;)
    for (*freehead = visplanes[i], visplanes[i] = NULL; *freehead; )
      freehead = &(*freehead)->next;

  lastopening = openings;
  memset (cachedheight, 0, sizeof(cachedheight));
  angle = (viewangle-ANG90)>>ANGLETOFINESHIFT;
  basexscale = FixedDiv (finecosine[angle],centerxfrac);
  baseyscale = -FixedDiv (finesine[angle],centerxfrac);
}

static visplane_t *new_visplane(unsigned hash)
{
  visplane_t *check = freetail;
  if (!check)
    check = calloc(1, sizeof *check);
  else
    if (!(freetail = freetail->next))
      freehead = &freetail;
  check->next = visplanes[hash];
  visplanes[hash] = check;
  return check;
}
unsigned hash=0;
visplane_t *R_FindPlane(fixed_t height, int picnum, int lightlevel,
                        fixed_t xoffs, fixed_t yoffs, ffloor_t *ffloor)
{
  visplane_t *check;
  if(!ffloor) {
  if (picnum == skyflatnum || picnum & PL_SKYFLAT)
    lightlevel = height = 9000;
  hash = visplane_hash(picnum,lightlevel,height);
  for (check=visplanes[hash]; check&&!check->ffloor; check=check->next)
    if (height==check->height && picnum==check->picnum &&
        lightlevel==check->lightlevel &&
        xoffs==check->xoffs && yoffs==check->yoffs)
      return check;
  }

  check = new_visplane(hash);
  check->height = height;
  check->picnum = picnum;
  check->lightlevel = lightlevel;
  check->minx = viewwidth;
  check->maxx = -1;
  check->xoffs = xoffs;
  check->yoffs = yoffs;
  check->ffloor = ffloor;
  memset (check->top, 0xff, sizeof check->top);

  return check;
}

visplane_t *R_CheckPlane(visplane_t *pl, int start, int stop)
{
  int intrl, intrh, unionl, unionh, x;

  if (start < pl->minx)
    intrl   = pl->minx, unionl = start;
  else
    unionl  = pl->minx,  intrl = start;

  if (stop  > pl->maxx)
    intrh   = pl->maxx, unionh = stop;
  else
    unionh  = pl->maxx, intrh  = stop;

  for (x=intrl ; x <= intrh && pl->top[x] == 0xffff; x++);

  if (x > intrh)
    pl->minx = unionl, pl->maxx = unionh;
  else
    {
      unsigned hash = visplane_hash(pl->picnum, pl->lightlevel, pl->height);
      visplane_t *new_pl = new_visplane(hash);

      new_pl->height = pl->height;
      new_pl->picnum = pl->picnum;
      new_pl->lightlevel = pl->lightlevel;
      new_pl->xoffs = pl->xoffs;
      new_pl->yoffs = pl->yoffs;
      new_pl->ffloor = pl->ffloor;
      pl = new_pl;
      pl->minx = start;
      pl->maxx = stop;
      memset(pl->top, 0xff, sizeof pl->top);
    }

  return pl;
}

void R_MakeSpans(int x, int t1, int b1, int t2, int b2)
{
  for (; t1 < t2 && t1 <= b1; t1++)
    R_MapPlane(t1, spanstart[t1], x-1);
  for (; b1 > b2 && b1 >= t1; b1--)
    R_MapPlane(b1, spanstart[b1] ,x-1);
  while (t2 < t1 && t2 <= b2)
    spanstart[t2++] = x;
  while (b2 > b1 && b2 >= t2)
    spanstart[b2--] = x;
}
int skytexture,pspriteiscale;
void do_draw_plane(visplane_t *pl)
{
  register int x;
  if (pl->minx <= pl->maxx)
    if (pl->picnum == skyflatnum || pl->picnum & PL_SKYFLAT)
      {
	int texture;
	angle_t an, flip;
	an = viewangle;

	if (pl->picnum & PL_SKYFLAT)
	  { 
	    const line_t *l = &lines[pl->picnum & ~PL_SKYFLAT];
	    const side_t *s = *l->sidenum + sides;
	    texture = texturetranslation[s->toptexture];
	    an += s->textureoffset;
	    dc_texturemid = s->rowoffset - 28*FRACUNIT;
	    flip = l->special==272 ? 0u : ~0u;
	  }
        else
	  {
            dc_texturemid = 100*FRACUNIT;
            texture = skytexture;
            flip = 0;
	  }

	if (comp[comp_skymap] || !(dc_colormap = fixedcolormap))
	  dc_colormap = fullcolormap;

        dc_texheight = textureheight[texture]>>FRACBITS;
        dc_iscale = pspriteiscale;

        for (x = pl->minx; (dc_x = x) <= pl->maxx; x++)
          if ((dc_yl = pl->top[x]) <= (dc_yh = pl->bottom[x]))
            {
              dc_source=R_GetColumn(texture,((an+xtoviewangle[x])^flip)>>22);
              colfunc();
            }
      }
    else
      {
        int stop, light;
        
        ds_source = W_CacheLumpNum(firstflat + flattranslation[pl->picnum],
                                   PU_STATIC);

        xoffs = pl->xoffs;
        yoffs = pl->yoffs;
        planeheight = abs(pl->height-viewz);
        light = (pl->lightlevel>>LIGHTSEGSHIFT) + extralight;

        if (light >= LIGHTLEVELS)
          light = LIGHTLEVELS-1;

        if (light < 0)
          light = 0;

        stop = pl->maxx + 1;
        planezlight = zlight[light];
        pl->top[pl->minx-1] = pl->top[stop] = 0xffff;

        for (x = pl->minx ; x <= stop ; x++)
          R_MakeSpans(x,pl->top[x-1],pl->bottom[x-1],pl->top[x],pl->bottom[x]);

        Z_ChangeTag (ds_source, PU_CACHE);
      }
}

void R_DrawPlanes (void)
{
  visplane_t *pl;
  int i;
  for (i=MAXVISPLANES;i--;)
  for (pl=visplanes[i]; pl; pl=pl->next)
     { if(pl->ffloor)continue; 
      do_draw_plane(pl); }
}