/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "w_wad.h"
#include "r_main.h"
#include "r_bsp.h"
#include "r_draw.h"

#define MINZ (FRACUNIT*4)
#define BASEYCENTER 100

typedef struct {
int x1,x2,column,topclip,bottomclip;
} maskdraw_t;

fixed_t pspritescale,pspriteiscale;
lighttable_t **spritelights;
short negonearray[320],screenheightarray[320],*mfloorclip,*mceilingclip;
spritedef_t *sprites;
int numsprites;
spriteframe_t sprtemp[29];
int maxframe;

void R_InstallSpriteLump(int lump, unsigned frame,
                                unsigned rotation, boolean flipped)
{
  if (frame >= 29 || rotation > 8)
    I_Error("R_InstallSpriteLump: mauvais frame letters en lump %i", lump);

  if ((int) frame > maxframe)
    maxframe = frame;

  if (rotation == 0)
    {
      int r;
      for (r=0 ; r<8 ; r++)
        if (sprtemp[frame].lump[r]==-1)
          {
            sprtemp[frame].lump[r] = lump - firstspritelump;
            sprtemp[frame].flip[r] = (byte) flipped;
            sprtemp[frame].rotate = false;
          }
      return;
    }

  if (sprtemp[frame].lump[--rotation] == -1)
    {
      sprtemp[frame].lump[rotation] = lump - firstspritelump;
      sprtemp[frame].flip[rotation] = (byte) flipped;
      sprtemp[frame].rotate = true;
    }
}

#define R_SpriteNameHash(s) ((unsigned)((s)[0]-((s)[1]*3-(s)[3]*2-(s)[2])*2))

void R_InitSpriteDefs(char **namelist)
{
  size_t numentries = lastspritelump-firstspritelump+1;
  struct { int index, next; } *hash;
  int i;

  if (!numentries || !*namelist)
    return;

  for (i=0; namelist[i]; i++);

  numsprites = i;

  sprites = Z_Malloc(numsprites *sizeof(*sprites), PU_STATIC, NULL);

  hash = malloc(sizeof(*hash)*numentries);

  for (i=0; i<numentries; i++)
    hash[i].index = -1;

  for (i=0; i<numentries; i++)
    {
      int j = R_SpriteNameHash(lumpinfo[i+firstspritelump].name) % numentries;
      hash[i].next = hash[j].index;
      hash[j].index = i;
    }

  for (i=0 ; i<numsprites ; i++)
    {
      const char *spritename = namelist[i];
      int j = hash[R_SpriteNameHash(spritename) % numentries].index;

      if (j >= 0)
        {
          memset(sprtemp, -1, sizeof(sprtemp));
          maxframe = -1;
          do
            {
              register lumpinfo_t *lump = lumpinfo + j + firstspritelump;

              if (!((lump->name[0] ^ spritename[0]) |
                    (lump->name[1] ^ spritename[1]) |
                    (lump->name[2] ^ spritename[2]) |
                    (lump->name[3] ^ spritename[3])))
                {
                  R_InstallSpriteLump(j+firstspritelump,
                                      lump->name[4] - 'A',
                                      lump->name[5] - '0',
                                      false);
                  if (lump->name[6])
                    R_InstallSpriteLump(j+firstspritelump,
                                        lump->name[6] - 'A',
                                        lump->name[7] - '0',
                                        true);
                }
            }
          while ((j = hash[j].next) >= 0);

          if ((sprites[i].numframes = ++maxframe))
            {
                sprites[i].spriteframes =
                Z_Malloc (maxframe * sizeof(spriteframe_t), PU_STATIC, NULL);
              memcpy (sprites[i].spriteframes, sprtemp,
                      maxframe*sizeof(spriteframe_t));
            }
        }
    }
  free(hash);
}

vissprite_t *vissprites,**vissprite_ptrs;
size_t num_vissprite, num_vissprite_alloc, num_vissprite_ptrs;

void R_InitSprites(char **namelist)
{
  int i;
  for (i=0; i<320; i++)
    negonearray[i] = -1;
  R_InitSpriteDefs(namelist);
}

void R_ClearSprites (void)
{
  num_vissprite = 0;
}

vissprite_t *R_NewVisSprite(void)
{
  if (num_vissprite >= num_vissprite_alloc)
    {
      num_vissprite_alloc = num_vissprite_alloc ? num_vissprite_alloc*2 : 128;
      vissprites = realloc(vissprites,num_vissprite_alloc*sizeof(*vissprites));
    }
 return vissprites + num_vissprite++;
}

fixed_t spryscale, sprtopscreen;

void R_DrawMaskedColumn(column_t *column)
{
  int topscreen, bottomscreen;
  fixed_t basetexturemid = dc_texturemid;
  
  dc_texheight = 0;

  while (column->topdelta != 0xff)
    {
      topscreen = sprtopscreen + spryscale*column->topdelta;
      bottomscreen = topscreen + spryscale*column->length;
      dc_yl = (topscreen+FRACUNIT-1)>>FRACBITS;
      dc_yh = (bottomscreen-1)>>FRACBITS;

      if (dc_yh >= mfloorclip[dc_x])
        dc_yh = mfloorclip[dc_x]-1;
      if (dc_yl <= mceilingclip[dc_x])
        dc_yl = mceilingclip[dc_x]+1;

      if (dc_yl <= dc_yh && dc_yh < viewheight)
        {
          dc_source = (byte *) column + 3;
          dc_texturemid = basetexturemid - (column->topdelta<<FRACBITS);
          colfunc();
        }
      column = (column_t *)((byte *) column + column->length + 4);
    }
  dc_texturemid = basetexturemid;
}

void R_DrawVisSprite(vissprite_t *vis, int x1, int x2)
{
  column_t *column;
  int      texturecolumn;
  fixed_t  frac;
  patch_t  *patch = W_CacheLumpNum (vis->patch+firstspritelump, PU_CACHE);

  dc_colormap = vis->colormap;

  if (!dc_colormap)
    colfunc = R_DrawFuzzColumn;
  else
    if (vis->mobjflags & MF_TRANSLATION)
      {
        colfunc = R_DrawTranslatedColumn;
        dc_translation = translationtables - 256 +
          ((vis->mobjflags & MF_TRANSLATION) >> (MF_TRANSSHIFT-8) );
      }
    else
      if (vis->mobjflags & MF_TRANSLUCENT && tran_filter_pct<100)
        {
          colfunc = R_DrawTLColumn;
          tranmap = main_tranmap;
        }
      else
        colfunc = R_DrawColumn;

  dc_iscale = abs(vis->xiscale);
  dc_texturemid = vis->texturemid;
  frac = vis->startfrac;
  spryscale = vis->scale;
  sprtopscreen = centeryfrac - FixedMul(dc_texturemid,spryscale);

  for (dc_x=vis->x1 ; dc_x<=vis->x2 ; dc_x++, frac += vis->xiscale)
    {
      texturecolumn = frac>>FRACBITS;

      column = (column_t *)((byte *) patch +
                            LONG(patch->columnofs[texturecolumn]));
      R_DrawMaskedColumn (column);
    }
  colfunc = R_DrawColumn;
}

void R_ProjectSprite (mobj_t* thing,int lightnum)
{
  fixed_t   gzt, tx, xscale;
  int x1, x2;
  spritedef_t   *sprdef;
  spriteframe_t *sprframe;
  int       lump;
  boolean   flip;
  vissprite_t *vis;
  fixed_t   iscale;
  int heightsec;
  fixed_t tr_x = thing->x - viewx;
  fixed_t tr_y = thing->y - viewy;
  fixed_t gxt = FixedMul(tr_x,viewcos);
  fixed_t gyt = -FixedMul(tr_y,viewsin);
  fixed_t tz = gxt-gyt;

  if (tz < MINZ)
    return;

  xscale = FixedDiv(projection, tz);

  gxt = -FixedMul(tr_x,viewsin);
  gyt = FixedMul(tr_y,viewcos);
  tx = -(gyt+gxt);

  if (abs(tx)>(tz<<2))
    return;

  if ((unsigned) thing->sprite >= numsprites)
    I_Error ("R_ProjectSprite: invalide sprite nombre %i", thing->sprite);

  sprdef = &sprites[thing->sprite];

  if ((thing->frame&FF_FRAMEMASK) >= sprdef->numframes)
    I_Error ("R_ProjectSprite: invalide frame %i pour sprite %s",
             thing->frame & FF_FRAMEMASK, sprnames[thing->sprite]);

  sprframe = &sprdef->spriteframes[thing->frame & FF_FRAMEMASK];

  if (sprframe->rotate)
    {
      angle_t ang = R_PointToAngle((long long)thing->x,(long long) thing->y);
      unsigned rot = (ang-thing->angle+(unsigned)(ANG45/2)*9)>>29;
      lump = sprframe->lump[rot];
      flip = (boolean) sprframe->flip[rot];
    }
  else
    {
      lump = sprframe->lump[0];
      flip = (boolean) sprframe->flip[0];
    }

  tx -= spriteoffset[lump];
  x1 = (centerxfrac + FixedMul(tx,xscale)) >>FRACBITS;

  if (x1 > viewwidth)
    return;

  tx +=  spritewidth[lump];
  x2 = ((centerxfrac + FixedMul(tx,xscale)) >> FRACBITS) - 1;

  if (x2 < 0)
    return;

  gzt = thing->z + spritetopoffset[lump];

  if (thing->z > viewz + FixedDiv(centeryfrac, xscale) ||
      gzt      < viewz - FixedDiv(centeryfrac-viewheight, xscale))
    return;

  heightsec = thing->subsector->sector->heightsec;

  if (heightsec != -1)
    {
      int phs = viewplayer->mo->subsector->sector->heightsec;
      if (phs != -1 && viewz < sectors[phs].floorheight ?
          thing->z >= sectors[heightsec].floorheight :
          gzt < sectors[heightsec].floorheight)
        return;
      if (phs != -1 && viewz > sectors[phs].ceilingheight ?
          gzt < sectors[heightsec].ceilingheight &&
          viewz >= sectors[heightsec].ceilingheight :
          thing->z >= sectors[heightsec].ceilingheight)
        return;
    }

  vis = R_NewVisSprite ();

  vis->heightsec = heightsec;
  vis->mobjflags = thing->flags;
  vis->scale = xscale;
  vis->gx = thing->x;
  vis->gy = thing->y;
  vis->gz = thing->z;
  vis->gzt = gzt;
  vis->texturemid = gzt - viewz;
  vis->x1 = x1 < 0 ? 0 : x1;
  vis->x2 = x2 >= viewwidth ? viewwidth-1 : x2;
  iscale = FixedDiv(FRACUNIT, xscale);

  if (flip)
    {
      vis->startfrac = spritewidth[lump]-1;
      vis->xiscale = -iscale;
    }
  else
    {
      vis->startfrac = 0;
      vis->xiscale = iscale;
    }

  if (vis->x1 > x1)
    vis->startfrac += vis->xiscale*(vis->x1-x1);
  vis->patch = lump;

  if (thing->flags & MF_SHADOW)
    vis->colormap = NULL;
  else if (fixedcolormap)
    vis->colormap = fixedcolormap;
  else if (thing->frame & FF_FULLBRIGHT)
    vis->colormap = fullcolormap;
  else
    {
      int index = xscale>>(LIGHTSCALESHIFT);
      if (index >= MAXLIGHTSCALE)
        index = MAXLIGHTSCALE-1;
      if(thing->subsector->sector->ffloors)
      {
       ffloor_t *rover=thing->subsector->sector->ffloors;
       for(;rover;rover=rover->next)
       if(gzt<=*rover->bottomheight)
       {lightnum=*rover->toplightlevel; break;}
      }
    lightnum = (lightnum>>LIGHTSEGSHIFT)+extralight;
    if (lightnum < 0)
      spritelights = scalelight[0];
    else if (lightnum >= LIGHTLEVELS)
      spritelights = scalelight[LIGHTLEVELS-1];
    else
      spritelights = scalelight[lightnum];
      vis->colormap = spritelights[index];
    }
}

void R_AddSprites(subsector_t* ss)
{
  mobj_t *thing;
  if (ss->sector->validcount == validcount) return;
  ss->sector->validcount = validcount;

  for (thing=ss->sector->thinglist;thing;thing=thing->snext)
  if(thing->type!=MT_PUSH&&thing->type!=MT_PULL)
  R_ProjectSprite(thing,ss->sector->lightlevel);
}

void R_DrawPSprite (pspdef_t *psp)
{
  fixed_t       tx;
  int           x1, x2;
  spritedef_t   *sprdef;
  spriteframe_t *sprframe;
  int           lump;
  boolean       flip;
  vissprite_t   *vis;
  vissprite_t   avis;

  sprdef = &sprites[psp->state->sprite];
  sprframe = &sprdef->spriteframes[psp->state->frame & FF_FRAMEMASK];

  lump = sprframe->lump[0];
  flip = (boolean) sprframe->flip[0];

  tx = psp->sx-160*FRACUNIT;

  tx -= spriteoffset[lump];
  x1 = (centerxfrac + FixedMul (tx,pspritescale))>>FRACBITS;

  if (x1 > viewwidth)
    return;

  tx +=  spritewidth[lump];
  x2 = ((centerxfrac + FixedMul (tx, pspritescale) ) >>FRACBITS) - 1;

  if (x2 < 0)
    return;

  vis = &avis;
  vis->mobjflags = 0;

  vis->texturemid = (BASEYCENTER<<FRACBITS) -
                    (psp->sy-spritetopoffset[lump]);

  vis->x1 = x1 < 0 ? 0 : x1;
  vis->x2 = x2 >= viewwidth ? viewwidth-1 : x2;
  vis->scale = pspritescale;

  if (flip)
    {
      vis->xiscale = -pspriteiscale;
      vis->startfrac = spritewidth[lump]-1;
    }
  else
    {
      vis->xiscale = pspriteiscale;
      vis->startfrac = 0;
    }

  if (vis->x1 > x1)
    vis->startfrac += vis->xiscale*(vis->x1-x1);

  vis->patch = lump;

  if (viewplayer->powers[pw_invisibility] > 4*32
      || viewplayer->powers[pw_invisibility] & 8)

    vis->colormap = NULL;
  else if (fixedcolormap)
    vis->colormap = fixedcolormap;
  else if (psp->state->frame & FF_FULLBRIGHT)
    vis->colormap = fullcolormap;
  else
    vis->colormap = spritelights[MAXLIGHTSCALE-1];

  R_DrawVisSprite(vis, vis->x1, vis->x2);
}

void R_DrawPlayerSprites(void)
{
  int i, lightnum;
  pspdef_t *psp;
  sector_t tmpsec;
  int floorlightlevel, ceilinglightlevel;
  if(viewplayer->mo->subsector->sector->ffloors)
  {
   ffloor_t *rover=viewplayer->mo->subsector->sector->ffloors;
   for(;rover;rover=rover->next)
   {
   if(viewplayer->mo->z+viewplayer->mo->height<=*rover->bottomheight)
   {floorlightlevel=ceilinglightlevel=*rover->toplightlevel; break;}
   else if(!rover->next)goto normallight;
   }
  } else
  normallight:
  R_FakeFlat(viewplayer->mo->subsector->sector, &tmpsec,
             &floorlightlevel, &ceilinglightlevel, NULL);
  lightnum = ((floorlightlevel+ceilinglightlevel)>>(LIGHTSEGSHIFT+1))
    + extralight;

  if (lightnum < 0)
    spritelights = scalelight[0];
  else if (lightnum >= LIGHTLEVELS)
    spritelights = scalelight[LIGHTLEVELS-1];
  else
    spritelights = scalelight[lightnum];

  mfloorclip = screenheightarray;
  mceilingclip = negonearray;

  for (i=0, psp=viewplayer->psprites; i<NUMPSPRITES; i++,psp++)
    if (psp->state)
      R_DrawPSprite (psp);
}

int vsort(vissprite_t **a,vissprite_t **b)
{
 return (*b)->scale - (*a)->scale;
}

void R_SortVisSprites (void)
{
  if (num_vissprite)
  {
  int i = num_vissprite;
  if (num_vissprite_ptrs < num_vissprite)
  {
  free(vissprite_ptrs);
  vissprite_ptrs = malloc((num_vissprite_ptrs=num_vissprite_alloc) *
  sizeof(*vissprite_ptrs));
  }
  while (--i>=0)
  vissprite_ptrs[i] = vissprites+i;
  qsort(vissprite_ptrs, num_vissprite, sizeof(*vissprite_ptrs),
  (int (*)(const void *, const void *)) vsort);
  }
}

void R_DrawSprite (vissprite_t* spr)
{
  drawseg_t *ds;
  short   clipbot[320], cliptop[320];
  int     x, r1, r2;
  fixed_t scale, lowscale;

  for (x = spr->x1 ; x<=spr->x2 ; x++)
    clipbot[x] = cliptop[x] = -2;

  for (ds=ds_p ; ds-- > drawsegs ; )
    {
      if (ds->x1 > spr->x2 || ds->x2 < spr->x1 ||
          (!ds->silhouette && !ds->maskedtexturecol))
        continue;

      r1 = ds->x1 < spr->x1 ? spr->x1 : ds->x1;
      r2 = ds->x2 > spr->x2 ? spr->x2 : ds->x2;

      if (ds->scale1 > ds->scale2)
        {
          lowscale = ds->scale2;
          scale = ds->scale1;
        }
      else
        {
          lowscale = ds->scale1;
          scale = ds->scale2;
        }

      if (scale < spr->scale || (lowscale < spr->scale &&
                    !R_PointOnSegSide (spr->gx, spr->gy, ds->curline)))
        {
          if (ds->maskedtexturecol)
          R_RenderMaskedSegRange(ds, r1, r2);
          continue;
        }
      if (ds->silhouette&SIL_BOTTOM && spr->gz < ds->bsilheight)
        for (x=r1 ; x<=r2 ; x++)
          if (clipbot[x] == -2)
            clipbot[x] = ds->sprbottomclip[x];

      if (ds->silhouette&SIL_TOP && spr->gzt > ds->tsilheight)
        for (x=r1 ; x<=r2 ; x++)
          if (cliptop[x] == -2)
            cliptop[x] = ds->sprtopclip[x];
    }
  if (spr->heightsec != -1)
    {
      fixed_t h,mh;
      int phs = viewplayer->mo->subsector->sector->heightsec;
      if ((mh = sectors[spr->heightsec].floorheight) > spr->gz &&
          (h = centeryfrac - FixedMul(mh-=viewz, spr->scale)) >= 0 &&
          (h >>= FRACBITS) < viewheight)
        if (mh <= 0 || (phs != -1 && viewz > sectors[phs].floorheight))
          {
            for (x=spr->x1 ; x<=spr->x2 ; x++)
              if (clipbot[x] == -2 || h < clipbot[x])
                clipbot[x] = h;
          }
        else
          if (phs != -1 && viewz <= sectors[phs].floorheight)
            for (x=spr->x1 ; x<=spr->x2 ; x++)
              if (cliptop[x] == -2 || h > cliptop[x])
                cliptop[x] = h;

      if ((mh = sectors[spr->heightsec].ceilingheight) < spr->gzt &&
          (h = centeryfrac - FixedMul(mh-viewz, spr->scale)) >= 0 &&
          (h >>= FRACBITS) < viewheight)
        if (phs != -1 && viewz >= sectors[phs].ceilingheight)
          {
            for (x=spr->x1 ; x<=spr->x2 ; x++)
              if (clipbot[x] == -2 || h < clipbot[x])
                clipbot[x] = h;
          }
        else
          for (x=spr->x1 ; x<=spr->x2 ; x++)
            if (cliptop[x] == -2 || h > cliptop[x])
              cliptop[x] = h;
    }

  for (x = spr->x1 ; x<=spr->x2 ; x++)
    {
      if (clipbot[x] == -2)
        clipbot[x] = viewheight;

      if (cliptop[x] == -2)
        cliptop[x] = -1;
    }

  mfloorclip = clipbot;
  mceilingclip = cliptop;
  R_DrawVisSprite (spr, spr->x1, spr->x2);
}
int Extrafloors;
void R_DrawMasked()
{
  int i;
  drawseg_t *ds;
  if(!Extrafloors) {
  R_SortVisSprites();
  for (i=num_vissprite;--i>-1;)
  R_DrawSprite(vissprite_ptrs[i]); }

  for (ds=ds_p ; ds-- > drawsegs ; )
    { if (ds->maskedtexturecol)
      R_RenderMaskedSegRange(ds, ds->x1, ds->x2);
      if(Extrafloors) {
      for (i=ds->numthicksides;--i>-1;)
      R_RenderThickSideRange(ds, ds->x1, ds->x2, ds->thicksides[i]);
      for (i=ds->numffloorplanes;--i>-1;)
      do_draw_plane(ds->ffloorplanes[i]);
      if(ds->sub!=(ds-1)->sub) {
      R_AddSprites(ds->sub); R_SortVisSprites();
      for (i=num_vissprite;--i>-1;) R_DrawSprite(vissprite_ptrs[i]);
      num_vissprite = 0; } }
    }
    R_DrawPlayerSprites ();
}