/*
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation. NO WARRANTY.
*/

#include "doomstat.h"
#include "w_wad.h"
#include "r_main.h"
#include "v_video.h"
#include "m_menu.h"

#define SBARHEIGHT 32

byte *viewimage,*ylookup[200];
int viewwidth,scaledviewwidth,scaledviewheight;
int viewheight,viewwindowx,viewwindowy; 
int columnofs[320],linesize=320;
byte translations[3][256],*tranmap,*main_tranmap;
lighttable_t *dc_colormap; 
int dc_x,dc_yl,dc_yh,dc_texheight;
fixed_t dc_iscale,dc_texturemid;
byte *dc_source;
void R_DrawTLColumn (void)                                           
{ 
  int              count; 
  register byte    *dest;
  register fixed_t frac;
  fixed_t          fracstep;
  count = dc_yh - dc_yl + 1; 
  if (count <= 0) return; 
  dest = ylookup[dc_yl] + columnofs[dc_x];  
  fracstep = dc_iscale; 
  frac = dc_texturemid + (dc_yl-centery)*fracstep;
  {
    register const byte *source = dc_source;            
    register const lighttable_t *colormap = dc_colormap; 
    register heightmask = dc_texheight-1;
    if (dc_texheight & heightmask)
      {
        heightmask++;
        heightmask <<= FRACBITS;
        if (frac < 0)
          while ((frac += heightmask) <  0);
        else
          while (frac >= heightmask)
            frac -= heightmask;
        do
          {
            *dest = tranmap[(*dest<<8)+colormap[source[frac>>FRACBITS]]];
            dest += linesize;
            if ((frac += fracstep) >= heightmask)
              frac -= heightmask;
          } 
        while (--count);
      }
    else
      {
        while ((count-=2)>=0)
          {
            *dest = tranmap[(*dest<<8)+colormap[source[(frac>>FRACBITS) & heightmask]]];
            dest += linesize;
            frac += fracstep;
            *dest = tranmap[(*dest<<8)+colormap[source[(frac>>FRACBITS) & heightmask]]];
            dest += linesize;
            frac += fracstep;
          }
        if (count & 1)
          *dest = tranmap[(*dest<<8)+colormap[source[(frac>>FRACBITS) & heightmask]]];
      }
  }
} 

#define FUZZTABLE 50

static const int fuzzoffset[FUZZTABLE] = {
  0,-1,0,-1,0,0,-1,
  0,0,-1,0,0,0,-1,
  0,0,0,-1,-1,-1,-1,
  0,-1,-1,0,0,0,0,-1,
  0,-1,0,0,-1,-1,0,
  0,-1,-1,-1,-1,0,0,
  0,0,-1,0,0,-1,0 
}; 

static int fuzzpos = 0; 

void R_DrawFuzzColumn(void) 
{ 
  int      count; 
  byte     *dest; 
  if (!dc_yl)  dc_yl = 1;
  if (dc_yh == viewheight-1)  dc_yh = viewheight - 2;           
  count = dc_yh - dc_yl; 
  if (count < 0)  return; 
  dest = ylookup[dc_yl] + columnofs[dc_x];
  count++;
  do 
    {
      *dest = fullcolormap[6*256+dest[fuzzoffset[fuzzpos] ^ linesize]]; 
      dest += linesize;
      if (++fuzzpos == FUZZTABLE)
         fuzzpos = 0;
    } 
  while (--count);
}

byte *dc_translation, *translationtables;
void R_DrawTranslatedColumn (void) 
{ 
  int      count; 
  byte     *dest; 
  fixed_t  frac,fracstep;
  count = dc_yh - dc_yl; 
  if (count < 0) return;
  dest = ylookup[dc_yl] + columnofs[dc_x]; 
  fracstep = dc_iscale; 
  frac = dc_texturemid + (dc_yl-centery)*fracstep; 
  count++;
  do 
    {
      *dest = dc_colormap[dc_translation[dc_source[frac>>FRACBITS]]];
      dest += linesize;        
      frac += fracstep; 
    }
  while (--count); 
} 

void R_InitTranslationTables (void)
{
  int i;
  translationtables = Z_Malloc(256*3, PU_STATIC, 0);
  for (i=0; i<256; i++)
    if (i >= 0x70 && i<= 0x7f)
      {
        translationtables[i] = 0x60 + (i&0xf);
        translationtables [i+256] = 0x40 + (i&0xf);
        translationtables [i+512] = 0x20 + (i&0xf);
      }
    else
      translationtables[i]=translationtables[i+256]=translationtables[i+512]=i;
}

int  ds_y,ds_x1,ds_x2;
lighttable_t *ds_colormap; 
fixed_t ds_xfrac,ds_yfrac,ds_xstep,ds_ystep;
byte *ds_source;        

void R_DrawSpan (void)
{ 
  register unsigned position;
  unsigned step;
  byte *source,*colormap,*dest;
  unsigned count,spot,xtemp,ytemp;
  position = ((ds_xfrac<<10)&0xffff0000) | ((ds_yfrac>>6)&0xffff);
  step = ((ds_xstep<<10)&0xffff0000) | ((ds_ystep>>6)&0xffff);       
  source = ds_source;
  colormap = ds_colormap;
  dest = ylookup[ds_y] + columnofs[ds_x1];       
  count = ds_x2 - ds_x1 + 1;
  while (count >= 4)
    { 
      ytemp = position>>4;
      ytemp = ytemp & 4032;
      xtemp = position>>26;
      spot = xtemp | ytemp;
      position += step;
      dest[0] = colormap[source[spot]]; 
      ytemp = position>>4;
      ytemp = ytemp & 4032;
      xtemp = position>>26;
      spot = xtemp | ytemp;
      position += step;
      dest[1] = colormap[source[spot]];
      ytemp = position>>4;
      ytemp = ytemp & 4032;
      xtemp = position>>26;
      spot = xtemp | ytemp;
      position += step;
      dest[2] = colormap[source[spot]];
      ytemp = position>>4;
      ytemp = ytemp & 4032;
      xtemp = position>>26;
      spot = xtemp | ytemp;
      position += step;
      dest[3] = colormap[source[spot]];          
      dest += 4;
      count -= 4;
    }
  while (count)
    { 
      ytemp = position>>4;
      ytemp = ytemp & 4032;
      xtemp = position>>26;
      spot = xtemp | ytemp;
      position += step;
      *dest++ = colormap[source[spot]]; 
      count--;
    } 
} 

void R_InitBuffer(int width, int height)
{ 
  int i; 
  linesize = SCREENWIDTH;
  viewwindowx = (SCREENWIDTH-width) >> 1;
  for (i = width; i--; )
    columnofs[i] = viewwindowx + i;
  viewwindowy = width==SCREENWIDTH ? 0 : (SCREENHEIGHT-SBARHEIGHT-height)>>1; 
  for (i = height; i--; )
    ylookup[i] = screens[0] + (i+viewwindowy)*linesize;
} 

void R_FillBackScreen (void) 
{ 
  int x = viewwindowx, y = viewwindowy; 
  int viewwindowx = x, viewwindowy = y;
  patch_t *patch;
  if (scaledviewwidth == 320) return;
  M_DrawBackground(gamemode==commercial ? "GRNROCK" : "FLOOR7_2", screens[1]); 
  patch = W_CacheLumpName("brdr_t", PU_CACHE);
  for (x=0; x<scaledviewwidth; x+=8)
    V_DrawPatch(viewwindowx+x,viewwindowy-8,1,patch,0);
  patch = W_CacheLumpName("brdr_b",PU_CACHE);
  for (x=0; x<scaledviewwidth; x+=8)
    V_DrawPatch(viewwindowx+x,viewwindowy+scaledviewheight,1,patch,0);
  patch = W_CacheLumpName("brdr_l",PU_CACHE);
  for (y=0; y<scaledviewheight; y+=8)
    V_DrawPatch(viewwindowx-8,viewwindowy+y,1,patch,0);
  patch = W_CacheLumpName("brdr_r",PU_CACHE);
  for (y=0; y<scaledviewheight; y+=8)
    V_DrawPatch(viewwindowx+scaledviewwidth,viewwindowy+y,1,patch,0);
  V_DrawPatch(viewwindowx-8,viewwindowy-8,1,
    W_CacheLumpName("brdr_tl",PU_CACHE),0);
  V_DrawPatch(viewwindowx+scaledviewwidth,viewwindowy-8,1,
    W_CacheLumpName("brdr_tr",PU_CACHE),0);
  V_DrawPatch(viewwindowx-8,viewwindowy+scaledviewheight,1,
    W_CacheLumpName("brdr_bl",PU_CACHE),0);
  V_DrawPatch(viewwindowx+scaledviewwidth,viewwindowy+scaledviewheight,1,
    W_CacheLumpName("brdr_br",PU_CACHE),0);
} 

void R_VideoErase(unsigned ofs, int count)
{ 
  memcpy(screens[0]+ofs, screens[1]+ofs, count);
} 

void R_DrawViewBorder(void) 
{ 
  int side, ofs, i;
  if (scaledviewwidth == SCREENWIDTH)  return;
  for (ofs = 0, i = viewwindowy; i--; ofs += SCREENWIDTH)
    R_VideoErase(ofs, SCREENWIDTH); 
  for (side = viewwindowx, i = scaledviewheight; i--;)
    { 
      R_VideoErase(ofs, side); 
      ofs += SCREENWIDTH;
      R_VideoErase(ofs - side, side); 
    } 
  for (i = viewwindowy; i--; ofs += SCREENWIDTH)
    R_VideoErase(ofs, SCREENWIDTH); 
}