/*
 *	Name:		MUS Playing kernel
 *	Project:	MUS File Player Library
 *	Version:	1.80
 *	Author:		Vladimir Arnost (QA-Software)
 *	Last revision:  Aug-7-2003
 *	Compiler:	Borland C++ 3.1, Watcom C/C++ 10.0, DJGPP 2.03
 *
 */

#include <dos.h>
#include "muslib.h"

char MLcopyright[] = "Copyright (c) 1994-2003 QA-Software";

volatile ulong	MLtime;
volatile uint	playingChannels = 0;

static void playNote(struct musicBlock *mus, uint channel, uchar note, int volume)
{
 if (mus->channelMask & (1 << channel))
	mus->driver->playNote(mus, channel, note, volume);
}

static void releaseNote(struct musicBlock *mus, uint channel, uchar note)
{
 mus->driver->releaseNote(mus, channel, note);
}

static void pitchWheel(struct musicBlock *mus, uint channel, int pitch)
{
 mus->driver->pitchWheel(mus, channel, pitch);
}

static void changeControl(struct musicBlock *mus, uint channel, uchar controller, int value)
{
 mus->driver->changeControl(mus, channel, controller, value);
}

static int playTick(struct musicBlock *mus)
{
 for(;;)
 {
	uint data = MEMgetchar(&mus->score);
	uint command = (data >> 4) & 7;
	uint channel = data & 0x0F;
	uint last = data & 0x80;

	switch (command) {
 case 0:	mus->playingcount--;
	releaseNote(mus, channel, MEMgetchar(&mus->score));
	break;
 case 1: {	uchar note = MEMgetchar(&mus->score);
	mus->playingcount++;
	if (note & 0x80)
 playNote(mus, channel, note & 0x7F, MEMgetchar(&mus->score));
	else
 playNote(mus, channel, note, -1);
	} break;
 case 2:	pitchWheel(mus, channel, MEMgetchar(&mus->score) - 0x80);
	break;
 case 3: 	changeControl(mus, channel, MEMgetchar(&mus->score), 0);
	break;
 case 4: { uchar ctrl = MEMgetchar(&mus->score);
	uchar value = MEMgetchar(&mus->score);
	changeControl(mus, channel, ctrl, value);
	} break;
 case 6:	return -1;
	}
	if (last)
 break;
 }
 return 0;
}

static ulong delayTicks(struct musicBlock *mus)
{
 ulong time = 0;
 uchar data;

 do {
	time <<= 7;
	time += (data = MEMgetchar(&mus->score)) & 0x7F;
 } while (data & 0x80);

 return time;
}

void MLplayerInterrupt(void)
{
 uint i;
 for (i = 0; i < MAXMUSBLOCK; i++)
 {
 register struct musicBlock *mus = MLmusicBlocks[i];
 if (mus && mus->state == ST_PLAYING)
 {
 if (!mus->ticks)
 {
 if (playTick(mus))
 {
 if (mus->loopcount && (mus->loopcount == -1U || --mus->loopcount))
 MEMrewind(&mus->score);
 else
 mus->state = ST_STOPPED;
 continue;
 }
 mus->time += mus->ticks = delayTicks(mus);
 }
 mus->ticks--;
 }
 }
 MLtime++;
}