// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
// $Log:$
//
// DESCRIPTION:
//	System interface for sound.
//
//-----------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <math.h>

#include "../z_zone.h"

#include "../i_system.h"
#include "../i_sound.h"
#include "../m_argv.h"
#include "../m_misc.h"
#include "../w_wad.h"

#include "../doomdef.h"
#include "qmus2mid.h"

//### let's try with Allegro ###
#define  alleg_mouse_unused
#define  alleg_timer_unused
#define  alleg_keyboard_unused
#define  alleg_joystick_unused
#define  alleg_gfx_driver_unused
#define  alleg_palette_unused
#define  alleg_graphics_unused
#define  alleg_vidmem_unused
#define  alleg_flic_unused
//#define  alleg_sound_unused	 we use it
#define  alleg_file_unused
#define  alleg_datafile_unused
#define  alleg_math_unused
#define  alleg_gui_unused
#include <allegro.h>
//### end of Allegro include ###

//allegro has 256 virtual voices
// warning should by a power of 2
#define VIRTUAL_VOICES 256
#define VOICESSHIFT 8

// Needed for calling the actual sound output.
#define SAMPLECOUNT    512

// The actual lengths of all sound effects.
int lengths[NUMSFX];

extern int nosound;
extern int nomusic;
//
// this function converts raw 11khz, 8-bit data to a SAMPLE* that allegro uses
// it is need cuz allegro only loads samples from wavs and vocs
//added:11-01-98: now reads the frequency from the rawdata header.
//   dsdata points a 4 unsigned short header:
//    +0 : value 3 what does it mean?
//    +2 : sample rate, either 11025 or 22050.
//    +4 : number of samples, each sample is a single byte since it's 8bit
//    +6 : value 0
SAMPLE *raw2SAMPLE(unsigned char *dsdata, int len, int priority)
{
    SAMPLE *spl;

    spl=malloc(sizeof(SAMPLE));
    spl->bits = 8;
    spl->freq = *((short *)dsdata+1);	   //mostly 11025, but some at 22050.
    spl->len = len;
    spl->priority = 255; //priority;
    spl->loop_start = 0;
    spl->loop_end = len;
    spl->param = -1;
    spl->data=(void *)(dsdata+8);	//skip the 8bytes header

    return spl;
}

//using Allegro:
//
// This function loads the sound data from the WAD lump,
//  for single sound.
// This now returns a SAMPLE*, not a void*
//
SAMPLE* getsfx ( char*	       sfxname,
		  int*		len,
		  int		priority)
{
    unsigned char*	sfx;
    unsigned char*	paddedsfx;
    int 		i;
    int 		size;
    int 		paddedsize;
    char		name[20];
    int 		sfxlump;


    // Get the sound data from the WAD, allocate lump
    //	in zone memory.
    sprintf(name, "ds%s", sfxname);

    // Now, there is a severe problem with the
    //	sound handling, in it is not (yet/anymore)
    //	gamemode aware. That means, sounds from
    //	DOOM II will be requested even with DOOM
    //	shareware.
    // The sound list is wired into sounds.c,
    //	which sets the external variable.
    // I do not do runtime patches to that
    //	variable. Instead, we will use a
    //	default sound for replacement.
    if ( W_CheckNumForName(name) == -1 )
      sfxlump = W_GetNumForName("dspistol");
    else
      sfxlump = W_GetNumForName(name);

    size = W_LumpLength( sfxlump );

    // Debug.
    // fprintf( stderr, "." );
    //fprintf( stderr, " -loading  %s (lump %d, %d bytes)\n",
    //	     sfxname, sfxlump, size );
    //fflush( stderr );

    sfx = (unsigned char*)W_CacheLumpNum( sfxlump, PU_STATIC );

    // Pads the sound effect out to the mixing buffer size.
    // The original realloc would interfere with zone memory.
    paddedsize = ((size-8 + (SAMPLECOUNT-1)) / SAMPLECOUNT) * SAMPLECOUNT;

    // Allocate from zone memory.
    paddedsfx = (unsigned char*)Z_Malloc( paddedsize+8, PU_STATIC, 0 );
    // ddt: (unsigned char *) realloc(sfx, paddedsize+8);
    // This should interfere with zone memory handling,
    //	which does not kick in in the soundserver.

    // Now copy and pad.
    memcpy(  paddedsfx, sfx, size );
    for (i=size ; i<paddedsize+8 ; i++)
	paddedsfx[i] = 128;

    // Remove the cached lump.
    Z_Free( sfx );

    // Preserve padded length.
    *len = paddedsize;


     //using Allegro:
    // Return allocated padded data.
    //added:11-01-98:now passes paddedsfx instead of paddedsfx+8, so that
    //		     raw2SAMPLE can set the right freq. for the sample.
    return raw2SAMPLE(paddedsfx,*len,priority);
}





//
// This function adds a sound to the
//  list of currently active sounds,
//  which is maintained as a given number
//  (eight, usually) of internal channels.
// Returns a handle.
//
int addsfx ( int	   sfxid,
	     int	   volume,
	     int	   step,
	     int	   seperation )
{
// UNUSED
  return 0;
}


//
// SFX API
// Note: this was called by S_Init.
// However, whatever they did in the
// old DPMS based DOS version, this
// were simply dummies in the Linux
// version.
// See soundserver initdata().
//
void I_SetChannels()
{
  // UNUSED originaly for DMX and LINUX
}


void I_SetSfxVolume(int volume)
{
  if(nosound)
      return;

  // Identical to DOS.
  // Basically, this should propagate
  //  the menu/config file setting
  //  to the state variable used in
  //  the mixing.
  snd_SfxVolume = volume;
  set_volume(snd_SfxVolume*255/31,-1);
}

// MUSIC API - dummy. Some code from DOS version.
void I_SetMusicVolume(int volume)
{
  if(nomusic)
      return;

  // Internal state variable.
  snd_MusicVolume = volume;
  // Now set volume on output device.
  // Whatever( snd_MusciVolume );
  // added 26-1-98
  set_volume(-1,snd_MusicVolume*255/31);
}


//
// Retrieve the raw data lump index
//  for a given SFX name.
//
int I_GetSfxLumpNum(sfxinfo_t* sfx)
{
    char namebuf[9];
    sprintf(namebuf, "ds%s", sfx->name);
    return W_GetNumForName(namebuf);
}

//
// Starting a sound means adding it
//  to the current list of active sounds
//  in the internal channels.
// As the SFX info struct contains
//  e.g. a pointer to the raw data,
//  it is ignored.
// As our sound handling does not handle
//  priority, it is ignored.
// Pitching (that is, increased speed of playback)
//  is set, but currently not used by mixing.
//
int I_StartSound ( int		 id,
		   int		 vol,
		   int		 sep,
		   int		 pitch,
		   int		 priority )
{
  int i,voice;

  if(nosound)
      return 0;

  // UNUSED
  priority = 0;

  pitch=(pitch-128)/2+128;
  voice=play_sample(S_sfx[id].data,vol,sep,(pitch*1000)/128,0);

  // Returns a handle
  return (id<<VOICESSHIFT)+voice;
}

void I_StopSound (int handle)
{
  // You need the handle returned by StartSound.
  // Would be looping all channels,
  //  tracking down the handle,
  //  an setting the channel to zero.
  int voice=handle & (VIRTUAL_VOICES-1);

  if(nosound)
      return;

  if(voice_check(voice)==S_sfx[handle>>VOICESSHIFT].data)
    deallocate_voice(voice);
}

int I_SoundIsPlaying(int handle)
{
  if(nosound)
      return FALSE;

  if(voice_check(handle & (VIRTUAL_VOICES-1))==S_sfx[handle>>VOICESSHIFT].data)
      return TRUE;
  return FALSE;
}


//
// This function loops all active (internal) sound
//  channels, retrieves a given number of samples
//  from the raw sound data, modifies it according
//  to the current (internal) channel parameters,
//  mixes the per channel samples into the global
//  mixbuffer, clamping it to the allowed range,
//  and sets up everything for transferring the
//  contents of the mixbuffer to the (two)
//  hardware channels (left and right, that is).
//
//  allegro does this now
//
void I_UpdateSound( void )
{
}


//
// This would be used to write out the mixbuffer
//  during each game loop update.
// Updates sound buffer and audio device at runtime.
// It is called during Timer interrupt with SNDINTR.
// Mixing now done synchronous, and
//  only output be done asynchronous?
//

void I_SubmitSound( void )
{
  //this should no longer be necessary cuz allegro is doing all the sound mixing now
}

// cut and past from ALLEGRO he don't share it :(
static inline int absolute_freq(int freq, SAMPLE *spl)
{
   if (freq == 1000)
      return spl->freq;
   else
      return (spl->freq * freq) / 1000;
}

void I_UpdateSoundParams( int	handle,
			  int	vol,
			  int	sep,
			  int	pitch)
{
  // I fail too see that this is used.
  // Would be using the handle to identify
  //  on which channel the sound might be active,
  //  and resetting the channel parameters.
  int voice=handle & (VIRTUAL_VOICES-1);
  int numsfx=handle>>VOICESSHIFT;

  if(nosound)
      return;

  if(voice_check(voice)==S_sfx[numsfx].data)
  {
    voice_set_volume(voice, vol);
    voice_set_pan(voice, sep);
    voice_set_frequency(voice, absolute_freq(pitch*1000/128
			     , S_sfx[numsfx].data));
  }
}


void I_ShutdownSound(void)
{
  // Wait till all pending sounds are finished.
  int i;

  //added:03-01-98:
  if( !sound_started )
      return;

  //added:08-01-98: remove_sound() explicitly because we don't use
  //		    Allegro's allegro_exit();
  remove_sound();
  sound_started = false;
}

int DetectMusicCard(void);

void I_StartupSound()
{
  int i,sfxcard,midicard;

  if(nosound)
    sfxcard=DIGI_NONE;
  else
    sfxcard=DIGI_AUTODETECT;

  if(nomusic)
    midicard=MIDI_NONE;
  else
    midicard=DetectMusicCard();

  // Secure and configure sound device first.
  fprintf( stderr, "I_StartupSound: ");
  if (install_sound(sfxcard,midicard,NULL)==-1)
    fprintf(stderr,"ALLEGRO SOUND INIT ERROR!!!!\n");
  else
    fprintf(stderr, " configured audio device\n" );

  if(!nosound)
  {
  // Initialize external data (all sounds) at start, keep static.
  fprintf( stderr, "I_InitSound: ");

  for (i=1 ; i<NUMSFX ; i++)
  {
    // Alias? Example is the chaingun sound linked to pistol.
    if (!S_sfx[i].link)
    {
      // Load data from WAD file.
      //added:11-01-98:note : this routine sets the second parm 'lengths'
      S_sfx[i].data = getsfx( S_sfx[i].name, &lengths[i],S_sfx[i].priority );
    }
    else
    {
      // Previously loaded already?
      S_sfx[i].data = S_sfx[i].link->data;
      lengths[i] = lengths[(S_sfx[i].link - S_sfx)/sizeof(sfxinfo_t)];
    }
  }

  fprintf( stderr, " pre-cached all sound data\n");

  // Finished initialization.
  fprintf(stderr, "I_InitSound: sound module ready\n");
  }

  //added:08-01-98:we use a similar startup/shutdown scheme as Allegro.
  I_AddExitFunc(I_ShutdownSound);
  sound_started = true;
}




//
// MUSIC API.
// Still no music done.
// Remains. Dummies.
//

MIDI* currsong;   //im assuming only 1 song will be played at once
static int	islooping=0;
static int	musicdies=-1;
int		music_started=0;
char*		musicbuffer;


/* load_midi_mem:
 *  Loads a standard MIDI file from memory, returning a pointer to
 *  a MIDI structure, *  or NULL on error.
 *  It is the load_midi from Allegro modified to load it from memory
 */
MIDI *load_midi_mem(char *mempointer,int *e)
{
   int c;
   long data=0;
   char *fp;
   MIDI *midi;
   int num_tracks=0;

   fp = mempointer;
   if (!fp)
      return NULL;

   midi = malloc(sizeof(MIDI)); 	     /* get some memory */
   if (!midi)
      return NULL;

   for (c=0; c<MIDI_TRACKS; c++) {
      midi->track[c].data = NULL;
      midi->track[c].len = 0;
   }

// i know is a midi the test is do before
//
//   pack_fread(buf, 4, fp);		       /* read midi header */
//   if (memcmp(buf, "MThd", 4))
//	goto err;

//   pack_mgetl(fp);			       /* skip header chunk length */

   fp+=4+4;   // header size + 'chunk' size

   swab(fp,&data,2);	 // convert to intel-endian
   fp+=2;				       /* MIDI file type */
   if ((data != 0) && (data != 1)) // only type 0 and 1 are suported
     return NULL;

   swab(fp,&num_tracks,2);		       /* number of tracks */
   fp+=2;
   if ((num_tracks < 1) || (num_tracks > MIDI_TRACKS))
      return NULL;

   swab(fp,&data,2);			      /* beat divisions */
   fp+=2;
   midi->divisions = ABS(data);

   for (c=0; c<num_tracks; c++) {	     /* read each track */
      if (memcmp(fp, "MTrk", 4))
	 return NULL;
      fp+=4;

//	swab(fp,&data,4);	don't work !!!!??
      ((char *)&data)[0]=fp[3];
      ((char *)&data)[1]=fp[2];
      ((char *)&data)[2]=fp[1];
      ((char *)&data)[3]=fp[0];
      fp+=4;

      midi->track[c].len = data;

      midi->track[c].data=fp;
      fp+=data;
   }

   lock_midi(midi);
   return midi;
}


void I_InitMusic(void)
{
  if(nomusic)
    return;

  // initialisation of midicard by I_StartupSound

  musicbuffer=(char *)malloc(65535L);

  I_AddExitFunc(I_ShutdownMusic);
  music_started = true;
}

void I_ShutdownMusic(void)
{
  if( !music_started )
     return;

  I_StopSong(1);
  free(musicbuffer);

  music_started=false;
}

void I_PlaySong(int handle, int looping)
{
  if(nomusic)
      return;

  islooping=looping;
  musicdies = gametic + TICRATE*30;
  play_midi(currsong,looping);
}

void I_PauseSong (int handle)
{
  if(nomusic)
      return;

  midi_pause();
}

void I_ResumeSong (int handle)
{
  if(nomusic)
      return;

  midi_resume();
}

void I_StopSong(int handle)
{
  if(nomusic)
      return;

  islooping = 0;
  musicdies = 0;
  stop_midi();
}

// Is the song playing?
int I_QrySongPlaying(int handle)
{
  if(nomusic)
      return 0;

  //return islooping || musicdies > gametic;
  return (midi_pos==-1);
}

void I_UnRegisterSong(int handle)
{
  if(nomusic)
      return;

  destroy_midi(currsong);
}

int I_RegisterSong(void* data,int len)
{
  FILE* blah;
  int e;
  if(nomusic)
      return 1;

  if(memcmp(data,"MUS",3)==0)
  {
    // convert mus to mid with a wanderfull function
    // thanks to S.Bacquet for the source of qmus2mid
    if((e=qmus2mid((char *)data,musicbuffer,1,89,64,1,len))!=0)
    {
      I_Error("Canot convert mus to mid, converterror :%d\n",e);
    }
    currsong=load_midi_mem(musicbuffer,&e);
  }
  else
  // supprot mid file in WAD !!!
  if(memcmp(data,"MThd",4)==0)
  {
    currsong=load_midi_mem(data,&e);
  }
  else
    I_Error("Music Lump is not MID or MUS lump\n");

  if(currsong==NULL)
    I_Error("Not a valid mid file : %d\n",e);

  return 1;
}

extern int snd_MusicDevice;
int DetectMusicCard(void)
{
  switch (snd_MusicDevice)
    {
    case 0: //nosound
      return MIDI_NONE; break;
    case 2: //adlib
      return MIDI_ADLIB; break;
    case 3: //sound blaster
      return MIDI_OPL3; break;
    case 4: //pro audio spectrum
      return MIDI_NONE; break;
    case 5: //gus
      return MIDI_GUS; break;
    case 6: //wave blaster
      return MIDI_NONE; break;
    case 7: //roland sound canvas
      return MIDI_NONE; break;
    case 8: //general midi
      return MIDI_MPU; break;
    case 9: //awe 32
      return MIDI_AWE32; break;
    }
  return MIDI_AUTODETECT;
}

