//-----------------------------------------------------------------------------
//
// i_system.c :
//
// DESCRIPTION:
//
//     Misc. stuff
//     Startup & Shutdown routines for music,sound,timer,keyboard,...
//     Signal handler to trap errors and exit cleanly.
//
//-----------------------------------------------------------------------------


#include <stdlib.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <io.h>
#include <stdarg.h>
#include <sys/time.h>


#ifdef DJGPP
 #include <dpmi.h>
 #include <go32.h>
 #include <pc.h>
 #include <dos.h>
 #include <crt0.h>
 #include <sys/segments.h>
 #include <sys/nearptr.h>
#endif


#include "../doomdef.h"
#include "../m_misc.h"
#include "../i_video.h"
#include "../i_sound.h"

#include "../d_net.h"
#include "../g_game.h"

#include "../d_main.h"

#include "../m_argv.h"
#include "i_dos.h"

#ifdef __GNUG__
 #pragma implementation "../i_system.h"
 #endif
#include "../i_system.h"


//### let's try with Allegro ###
#define  alleg_mouse_unused
//#define  alleg_timer_unused
#define  alleg_keyboard_unused
#define  alleg_joystick_unused
#define  alleg_gfx_driver_unused
#define  alleg_palette_unused
#define  alleg_graphics_unused
#define  alleg_vidmem_unused
#define  alleg_flic_unused
#define  alleg_sound_unused
#define  alleg_file_unused
#define  alleg_datafile_unused
#define  alleg_math_unused
#define  alleg_gui_unused
#include <allegro.h>
//### end of Allegro include ###



// Do not execute cleanup code more than once. See Shutdown_xxx() routines.
byte graphics_started;
byte keyboard_started;
byte sound_started;
byte timer_started;

/* Keyboard handler stuff */
_go32_dpmi_seginfo oldkeyinfo,newkeyinfo;
volatile char nextkeyextended;
static void I_KeyboardHandler();

/* Mouse stuff */
boolean mouse_detected;


long ticcount;	       //returned by I_GetTime(), updated by timer interrupt


int	mb_used = 10;


void I_Tactile ( int   on,   int   off,   int	total )
{
  // UNUSED.
  on = off = total = 0;
}

ticcmd_t	emptycmd;
ticcmd_t*	I_BaseTiccmd(void)
{
    return &emptycmd;
}


//added:11-02-98: commented out because its not used, got to find why its there
//int  I_GetHeapSize (void)
//{
//    return mb_used*1024*1024;        // what's this for?
//}


//
//  Allocates the base zone memory,
//  this function returns a valid pointer and size,
//  else it should interrupt the program immediately.
//
//added:11-02-98: now checks if mem could be allocated, this is still
//    prehistoric... there's a lot to do here: memory locking, detection
//    of win95 etc...
//
boolean   win95;
boolean   lockmem;

void I_DetectWin95 (void)
{
    __dpmi_regs     r;

    r.x.ax = 0x160a;	    // Get Windows Version
    __dpmi_int(0x2f, &r);

    if(r.x.ax || r.h.bh < 4)	// Not windows or earlier than Win95
    {
	win95 = false;
    }
    else
    {
	printf ("Windows 95 detected\n");
	win95 = true;
    }

    //added:11-02-98: I'm tired of w95 swapping my memory, so I'm testing
    //		      a better way of allocating the mem... still experimental
    //		      that's why it's a switch.
    if ( M_CheckParm ("-lock") )
    {
	lockmem = true;
	printf ("Memory locking requested.\n");
    }
    else
	lockmem = false;
}


byte* I_ZoneBase (int*	size)
{
    void*      pmem;

    // new memory stuff
    _go32_dpmi_meminfo	   info;
    // ---

    // detect the big Bill fake
    I_DetectWin95 ();

    // do it the old way
    if (!lockmem)
    {
	*size = mb_used*1024*1024;

	pmem = malloc (*size);

	if (!pmem)
	{
	    I_Error("Could not allocate %d megabytes.\n"
		    "Please use -mb parameter and specify a lower value.\n", *size);
	}
	return (byte *) pmem;
    }

    // the new way (EXPERIMENTAL)

    _go32_dpmi_get_free_memory_information(&info);
    if (info.available_physical_pages != -1)
    {
	printf("Physical pages available : %ld\n", info.available_physical_pages);
	printf("Available memory	 : %ld\n", info.available_memory);

	printf("Available physical memory: %ld\n", info.available_physical_pages<<12);

    }
    else
	I_Error("Sorry, could not get physical mem info,\n"
		"try without the -lock parameter.\n");

    I_Error ("Beta-testing lock mem. This is not implemented.\n");
    return NULL;
}


/*==========================================================================*/
// I_GetTime ()
/*==========================================================================*/
int  I_GetTime (void)
{
    return ticcount;
}


//
// I_Init
//
void I_Init (void)
{
    I_StartupSound();
}



//
// I_Error
//
extern boolean demorecording;

//added 31-12-97 : display error messy after shutdowngfx
void I_Error (char *error, ...)
{
    va_list	argptr;
    // added 11-2-98 recursive error detecting
    static  int shutdowning=false;
    static  int errorcount=0; // fuck recursive errors

    if(shutdowning)
    {
	if(++errorcount>20)
	  exit(-1);	  // recursive errors detected
    }
    shutdowning=true;

    // Message first.
    // this message can't be seen coz the videomode=graphic
    // but if redirection it will be useful
    va_start (argptr,error);
    fprintf (stderr, "Error: ");
    vfprintf (stderr,error,argptr);
    va_end (argptr);

    // Shutdown. Here might be other errors.
    if (demorecording)
	G_CheckDemoStatus();

    D_QuitNetGame ();

    /* shutdown everything that was started ! */
    I_ShutdownSystem();

    // now display message in textmode
    va_start (argptr,error);
    fprintf (stderr, "Error: ");
    vfprintf (stderr,error,argptr);
    va_end (argptr);
    if(errorcount)
	fprintf(stderr,"\nThere is %d ERRORS before this error",errorcount);
    fprintf (stderr, "\nPress ENTER");


    fflush( stderr );

    getchar();

    exit(-1);
}


//
// I_Quit : shutdown everything cleanly, in reverse order of Startup.
//
void I_Quit (void)
{
  byte* scr;
  byte* dest;

    M_SaveDefaults ();

 #ifdef PC_DOS
    //scr = W_GetName("ENDDOOM");
 #endif

    //added:03-01-98: maybe it needs that the ticcount continues,
    // or something else that will be finished by ShutdownSystem()
    // so I do it before.
    D_QuitNetGame ();

    /* shutdown everything that was started ! */
    I_ShutdownSystem();

 #ifdef PC_DOS
    // Nostalgia...
    // do it BEFORE restoring textmode screen
    //dest = (byte *)(__djgpp_conventional_base+0xb8000);
    //memcpy(dest,scr,4000);
 #endif

    exit(0);
}



void I_WaitVBL(int count)
{
   //added 29-12-97
   while(count-->0);
   {
     while ((inportb(0x3da)&8)!=8);
     while ((inportb(0x3da)&8)==8);
   }

}

void I_BeginRead(void)
{
}

void I_EndRead(void)
{
}

byte*	I_AllocLow(int length)
{
    byte*	mem;

    mem = (byte *)malloc (length);
    memset (mem,0,length);
    return mem;

}



//
//  Initialise the mouse. Doesnt need to be shutdown.
//
void I_StartupMouse()
{
 __dpmi_regs r;

    //detect mouse presence
    r.x.ax=0;
    __dpmi_int(0x33,&r);

    //added:03-01-98:
    if( r.x.ax == 0 )
    {
	mouse_detected=false;
	printf("I_StartupMouse: mouse not present.");
	return;
    }
    else
	mouse_detected=true;

    //hide cursor
    r.x.ax=2;
    __dpmi_int(0x33,&r);

    //reset mickey count
    r.x.ax=0x0b;
    __dpmi_int(0x33,&r);

}


//
//  Timer user routine called at ticrate.
//
void I_TimerISR(void)
{
   //  IO_PlayerInput();      // old doom did that
   ticcount++;

}
END_OF_FUNCTION(I_TimerISR);


//added:08-01-98: we don't use allegro_exit() so we have to do it ourselves.
void I_ShutdownTimer()
{
    if( !timer_started )
	return;
    remove_timer();
}


//
//  Installs the timer interrupt handler with timer speed as TICRATE.
//
void I_StartupTimer(void)
{
   ticcount = 0;

   //lock this from being swapped to disk! BEFORE INSTALLING
   LOCK_VARIABLE(ticcount);
   LOCK_FUNCTION(I_TimerISR);

   if( install_timer() != 0 )
      I_Error("I_StartupTimer: could not install timer.");

   if( install_int_ex( I_TimerISR, BPS_TO_TIMER(TICRATE) ) != 0 )
      //should never happen since we use only one.
      I_Error("I_StartupTimer: no room for callback routine.");

   //added:08-01-98: remove the timer explicitly because we don't use
   //		     Allegro 's allegro_exit() shutdown code.
   I_AddExitFunc(I_ShutdownTimer);
   timer_started = true;
}


//added:07-02-98:
//
//
byte ASCIINames[128] =
{
//  0	    1	    2	    3	    4	    5	    6	    7
//  8	    9	    A	    B	    C	    D	    E	    F
    0  ,    27,     '1',    '2',    '3',    '4',    '5',    '6',
    '7',    '8',    '9',    '0', KEY_MINUS,KEY_EQUALS,KEY_BACKSPACE, KEY_TAB,
    'q',    'w',    'e',    'r',    't',    'y',    'u',    'i',
    'o',    'p',    '[',    ']', KEY_ENTER,KEY_CTRL,'a',    's',
    'd',    'f',    'g',    'h',    'j',    'k',    'l',    ';',
    '\'',   '`', KEY_SHIFT, '\\',   'z',    'x',    'c',    'v',
    'b',    'n',    'm',    ',',    '.',    '/', KEY_SHIFT, '*',
 KEY_ALT,KEY_SPACE,KEY_CAPSLOCK, KEY_F1, KEY_F2, KEY_F3, KEY_F4, KEY_F5,
    KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F10,KEY_NUMLOCK,KEY_SCROLLLOCK,KEY_KEYPAD7,
 KEY_KEYPAD8,KEY_KEYPAD9,KEY_MINUSPAD,KEY_KEYPAD4,KEY_KEYPAD5,KEY_KEYPAD6,KEY_PLUSPAD,KEY_KEYPAD1,
 KEY_KEYPAD2,KEY_KEYPAD3,KEY_KEYPAD0,KEY_KPADDEL,      0,      0,      0,      KEY_F11,
    KEY_F12,0,	    0,	    0,	    0,	    0,	    0,	    0,
    0,	    0,	    0,	    0,	    0,	    0,	    0,	    0,
    0,	    0,	    0,	    0,	    0,	    0,	    0,	    0,
    0,	    0,	    0,	    0,	    0,	    0,	    0,	    0,
    0,	    0,	    0,	    0,	    0,	    0,	    0,	    0
};


static void I_KeyboardHandler()
{
    unsigned char ch;
    event_t	  event;
    static   int  ctrl=0;

    ch=inportb(0x60);

    if(ch==0xE1)
    {
      event.type=ev_keydown;
      event.data1=KEY_PAUSE;
      D_PostEvent(&event);
    }
    else
    if(ch==0xE0)
    {
      nextkeyextended=1;
    }
    else
    {
      if((ch&0x80)==0)
	event.type=ev_keydown;
      else
	event.type=ev_keyup;

      ch&=0x7f;

      if(nextkeyextended)
      {
	nextkeyextended=0;

	// remap lonely keypad slash
	if (ch==53)
	    event.data1 = KEY_KPADSLASH;
	else
	// remap the bill gates keys...
	if (ch>=91 && ch<=93)
	    event.data1 = ch + 0x80;	// leftwin, rightwin, menu
	else
	// remap non-keypad extended keys to a value<128, but
	// make them different than the KEYPAD keys.
	if (ch>=71 && ch<=83)
	    event.data1 = 0x80 + ch + 30;
	else if (ch==28)
	    event.data1 = KEY_ENTER;	// keypad enter -> return key
	else if (ch==29)
	    event.data1 = KEY_CTRL;	// rctrl -> lctrl
	else if (ch==56)
	    event.data1 = KEY_ALT;	// ralt -> lalt
	else
	    ch = 0;
	if (ch)
	    D_PostEvent(&event);
      }
      else
      {
	if(ch==0x1d) //ctrl-key
	{
	  ctrl=(event.type==ev_keydown);
	}

	if (ASCIINames[ch]!=0)
	  event.data1=ASCIINames[ch];
	else
	  event.data1=ch+0x80;
	D_PostEvent(&event);
      }
    }

    if ((ctrl)&&(ch==0x2e)) // crtl-c
    {
	asm ("movb $0x79, %%al
	     call ___djgpp_hw_exception"
	     : : :"%eax","%ebx","%ecx","%edx","%esi","%edi","memory");
    }

    //reset keyoard
//    { char b;
//     b=inportb(0x61);      // ???
//     outportb(0x61,b|80);  // ???   run without it
//     outportb(0x61,b);     // ???
     outportb(0x20,0x20);
//    }
}


//
//  Removes the keyboard handler.
//
void I_ShutdownKeyboard()
{
    if( !keyboard_started )
	return;

    asm("cli");
    _go32_dpmi_set_protected_mode_interrupt_vector(9, &oldkeyinfo);
    _go32_dpmi_free_iret_wrapper(&newkeyinfo);
    asm("sti");
}

//
//  Installs the keyboard handler.
//
void I_StartupKeyboard()
{
    int i;

    nextkeyextended=0;

    asm("cli");
    _go32_dpmi_get_protected_mode_interrupt_vector(9, &oldkeyinfo);
    newkeyinfo.pm_offset=(int)I_KeyboardHandler;
    newkeyinfo.pm_selector=_go32_my_cs();
    _go32_dpmi_allocate_iret_wrapper(&newkeyinfo);
    _go32_dpmi_set_protected_mode_interrupt_vector(9, &newkeyinfo);
    asm("sti");

    //added:08-01-98:register shutdown keyboard code.
    I_AddExitFunc(I_ShutdownKeyboard);
    keyboard_started = true;
}




//added:08-01-98:
//
//  Clean Startup & Shutdown handling, as does Allegro.
//  We need this services for ourselves too, and we don't want to mix
//  with Allegro, because someone might not use Allegro.
//  (all 'exit' was renamed to 'quit')
//
#define MAX_QUIT_FUNCS	   16
typedef void (*quitfuncptr)();
static quitfuncptr quit_funcs[MAX_QUIT_FUNCS] =
	       { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		 NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	       };


//added:08-01-98:
//
//  Adds a function to the list that need to be called by I_SystemShutdown().
//
void I_AddExitFunc(void (*func)())
{
   int c;

   for (c=0; c<MAX_QUIT_FUNCS; c++) {
      if (!quit_funcs[c]) {
	 quit_funcs[c] = func;
	 break;
      }
   }
}


//added:08-01-98:
//
//  Removes a function from the list that need to be called by
//   I_SystemShutdown().
//
void I_RemoveExitFunc(void (*func)())
{
   int c;

   for (c=0; c<MAX_QUIT_FUNCS; c++) {
      if (quit_funcs[c] == func) {
	 while (c<MAX_QUIT_FUNCS-1) {
	    quit_funcs[c] = quit_funcs[c+1];
	    c++;
	 }
	 quit_funcs[MAX_QUIT_FUNCS-1] = NULL;
	 break;
      }
   }
}



 //added:03-01-98:
//
// signal_handler:
//  Used to trap various signals, to make sure things get shut down cleanly.
//
static void signal_handler(int num)
{
static char msg[] = "Oh no! Back to reality!\r\n";

    //D_QuitNetGame ();  //say 'byebye' to other players when your machine
			// crashes?... hmm... do they have to die with you???

    I_ShutdownSystem();

    _write(STDERR_FILENO, msg, sizeof(msg)-1);

    signal(num, SIG_DFL);
    raise(num);
}


//added:08-01-98: now this replaces allegro_init()
//
//  REMEMBER: THIS ROUTINE MUST BE STARTED IN i_main.c BEFORE D_DoomMain()
//
//  This stuff should get rid of the exception and page faults when
//  Doom bugs out with an error. Now it should exit cleanly.
//
int  I_StartupSystem(void)
{

   // some 'more globals than globals' things to initialize here ?
   graphics_started = false;
   keyboard_started = false;
   sound_started = false;
   timer_started = false;


   // check for OS type and version here ?


   signal(SIGABRT, signal_handler);
   signal(SIGFPE,  signal_handler);
   signal(SIGILL,  signal_handler);
   signal(SIGSEGV, signal_handler);
   signal(SIGTERM, signal_handler);
   signal(SIGINT,  signal_handler);
   signal(SIGKILL, signal_handler);
   signal(SIGQUIT, signal_handler);

   i_love_bill = 0;	//doesnt work under w95 as it's supposed to.

   return 0;
}


//added:08-01-98:
//
//  Closes down everything. This includes restoring the initial
//  pallete and video mode, and removing whatever mouse, keyboard, and
//  timer routines have been installed.
//
//  NOTE : Shutdown user funcs. are effectively called in reverse order.
//
void I_ShutdownSystem()
{
   int c;

   for (c=MAX_QUIT_FUNCS-1; c>=0; c--)
      if (quit_funcs[c])
	 (*quit_funcs[c])();

}
