//--------------------------------------------------------------------------//
//
// i_video.c : hardware and software level, screen and video i/o, refresh,
//	       setup ... a big mess. Got to clean that up!
//
//--------------------------------------------------------------------------//

#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
//#include <sys/socket.h>

#include <netinet/in.h>
//#include <errnos.h>
#include <signal.h>


#include <go32.h>
#include <pc.h>
#include <dpmi.h>
#include <dos.h>
#include <sys/nearptr.h>

#include "../doomstat.h"
#include "../i_system.h"
#include "../screen.h"	 //added:26-01-98:
#include "../v_video.h"
#include "../m_argv.h"
#include "../d_main.h"

#include "../doomdef.h"
#include "vid_vesa.h"

//### let's try with Allegro ###
#define  alleg_mouse_unused
#define  alleg_timer_unused
#define  alleg_keyboard_unused
#define  alleg_joystick_unused
#define  alleg_gfx_driver_unused
#define  alleg_palette_unused
#define  alleg_graphics_unused
//#define  alleg_vidmem_unused
#define  alleg_flic_unused
#define  alleg_sound_unused
#define  alleg_file_unused
#define  alleg_datafile_unused
#define  alleg_math_unused
#define  alleg_gui_unused
#include <allegro.h>
//### end of Allegro include ###


#include "../vid_copy.h"    //added:16-01-98:quickie asm linear blit code.


//dosstuff -newly added
unsigned long dascreen;
static int gfx_use_vesa1;
#define SCREENDEPTH   1     // bytes per pixel, do NOT change.


//
// I_StartFrame
//
void I_StartFrame (void)
{
    // er?
}

extern boolean mouse_detected;

void I_GetEvent()
{
    __dpmi_regs r;
    event_t event;
    int xmickeys,ymickeys,buttons;
    int i;
    static int lastbuttons=0;

    if (!mouse_detected)
	return;

    //mouse movement

    r.x.ax=0x0b;	   // ask the mouvement not the position
    __dpmi_int(0x33,&r);
    xmickeys=(signed short)r.x.cx;
    ymickeys=(signed short)r.x.dx;
    r.x.ax=0x03;
    __dpmi_int(0x33,&r);
    buttons=r.x.bx;

    if ((xmickeys!=0)||(ymickeys!=0)||(buttons!=lastbuttons))
    {
      event.type=ev_mouse;
      event.data1=buttons;
      event.data2=xmickeys;
      event.data3=-ymickeys;
      lastbuttons=buttons;

      D_PostEvent(&event);
    }
}


//
// I_StartTic
//
void I_StartTic()
{
  I_GetEvent();
  //i dont think i have to do anything else here
}


//
// I_UpdateNoBlit
//
void I_UpdateNoBlit (void)
{
    // what is this?
}


//profile stuff ---------------------------------------------------------
//added:16-01-98:wanted to profile the VID_BlitLinearScreen() asm code.
//#define TIMING      //uncomment this to enable profiling
#ifdef TIMING
#include "../p5prof.h"
static	 long long mycount;
static	 long long mytotal = 0;
static	 unsigned long	nombre = TICRATE*10;
//static   char runtest[10][80];
#endif
//profile stuff ---------------------------------------------------------


//
// I_FinishUpdate
//
void I_BlitScreenVesa1(void);	//see later
void I_FinishUpdate (void)
{

    static int	lasttic;
    int 	tics;
    int 	i;
    byte *temppointer;
    // UNUSED static unsigned char *bigscreen=0;

    // draws little dots on the bottom of the screen
    if (devparm)
    {
	i = I_GetTime();
	tics = i - lasttic;
	lasttic = i;
	if (tics > 20) tics = 20;

	for (i=0 ; i<tics*2 ; i+=2)
	    screens[0][ (vid.height-1)*vid.width + i] = 0xff;
	for ( ; i<20*2 ; i+=2)
	    screens[0][ (vid.height-1)*vid.width + i] = 0x0;
    }

   //blast it to the screen
   // this code sucks
   //memcpy(dascreen,screens[0],screenwidth*screenheight);

   //added:03-01-98: I tried to I_WaitVBL(1) here, but it slows down
   //  the game when the view becomes complicated, it looses ticks
   //I_WaitVBL(1);


//added:16-01-98:profile screen blit.
#ifdef TIMING
    ProfZeroTimer();
#endif
    //added:08-01-98: support vesa1 bank change, without Allegro's BITMAP screen.
    if( gfx_use_vesa1 )
    {
	I_Error("Banked screen update not finished for dynamic res\n");
	//I_BlitScreenVesa1();	  //blast virtual to physical screen.
    }
    else
    {
	//added:16-01-98:use quickie asm routine, last 2 args are
	//		     src and dest rowbytes
	//		     (memcpy is as fast as this one...)
	PRERR("About to VID_BlitLinearScreen...\n");
	VID_BlitLinearScreen ( vid.buffer, vid.direct,
			       vid.width, vid.height,
			       vid.width, vid.rowbytes );
    }
#ifdef TIMING
    RDMSR(0x10,&mycount);
    mytotal += mycount;   //64bit add

    if(nombre--==0)
       I_Error("ScreenBlit CPU Spy reports: 0x%d %d\n", *((int*)&mytotal+1),
					     (int)mytotal );
#endif

}


//
// I_ReadScreen
//
void I_ReadScreen (byte* scr)
{
    memcpy (scr, screens[0], vid.width*vid.height);
}

void I_SetPalette (byte* palette)
  {
  int c,i;

  outportb(0x3c8,0);
  for (i=0;i<256;i++)
    {
    c=gammatable[usegamma][*palette++];
    outportb(0x3c9,c>>2);
    c=gammatable[usegamma][*palette++];
    outportb(0x3c9,c>>2);
    c=gammatable[usegamma][*palette++];
    outportb(0x3c9,c>>2);
    }
  }


//added 29-12-1997
/*==========================================================================*/
// I_BlastScreen : copy the virtual screen buffer to the physical screen mem
//		   using bank switching if needed.
/*==========================================================================*/
void I_BlitScreenVesa1(void)
{
#define VIDBANKSIZE	(1<<16)
#define VIDBANKSIZEMASK (VIDBANKSIZE-1)   // defines ahoy!

  __dpmi_regs r;
  unsigned char *p_src;
  long	   i;
  long	   virtualsize;

   // virtual screen buffer size
   virtualsize = vid.rowbytes * vid.height * SCREENDEPTH;

   p_src  = screens[0];

   for(i=0; virtualsize > 0; i++ )
   {
      r.x.ax = 0x4f05;
      r.x.bx = 0x0;
      r.x.cx = 0x0;
      r.x.dx = i;
      __dpmi_int(0x10,&r);	//set bank

      memcpy((byte *)dascreen,p_src,(virtualsize < VIDBANKSIZE) ? virtualsize : VIDBANKSIZE );

      p_src += VIDBANKSIZE;
      virtualsize -= VIDBANKSIZE;
   }

}


//added:08-01-98: now we use Allegro's set_gfx_mode, but we want to
//		  restore the exact text mode that was before.
static short  myOldVideoMode;
void I_SaveOldVideoMode(void)
{
  __dpmi_regs r;
    r.x.ax = 0x4f03;		     // Return current video mode
    __dpmi_int(0x10,&r);
    if( r.x.ax != 0x4f )
	I_Error("I_SaveOldVideoMode: could not ask videomode");
    myOldVideoMode = r.x.bx;
}


//
//  Close the screen, restore previous video mode.
//
static void I_ShutdownGraphics(void)
{
    __dpmi_regs r;

    if( !graphics_started )
	return;

    /* Restore old video mode */
    r.x.ax = 0x4f02;		     // Set Super VGA video mode
    r.x.bx = myOldVideoMode;
    __dpmi_int(0x10,&r);

    graphics_started = false;
    if( r.x.ax != 0x4f )
	I_Error("I_RestoreOldVideoMode: could not set mode");
}


//added:08-01-98:
//  Set VESA1 video mode, coz Allegro set_gfx_mode a larger screenwidth...
//
int set_vesa1_mode( int width, int height )
{
    __dpmi_regs r;

    // setup video mode.
    r.x.ax = 0x4f02;
    if( ( width==320 )&&( height==200 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x13; 			    // 320x 200x1 (256 colors)
    else
    if( ( width==320 )&&( height==240 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x154;			    // 320x 240x1 (256 colors)
    else
    if( ( width==320 )&&( height==400 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x155;			    // 320x 400x1 (256 colors)
    else
    if( ( width==640 )&&( height==400 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x100;			    // 640x 400x1 (256 colors)
    else
    if( ( width==640 )&&( height==480 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x101;			    // 640x 480x1 (256 colors)
    else
    if( ( width==800 )&&( height==600 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x103;			    // 800x 600x1 (256 colors)
    else
    if( ( width==1024)&&( height==768 ) && ( SCREENDEPTH==1 ) )
       r.x.bx	= 0x105;			    //1024x 768x1 (256 colors)
    else
       I_Error("I_SetVesa1Mode: video mode not supported.");

    // enter graphics mode.
    __dpmi_int(0x10,&r);

    if( r.x.ax != 0x4f )
       I_Error("I_SetVesa1Mode: init video mode failed !");

    return 0;
}


//added:08-01-98: now uses Allegro to setup Linear Frame Buffer video modes.
//
//  Initialize video mode, setup dynamic screen size variables,
//  and allocate screens.
//
void I_StartupGraphics(void)
{
    //added:26-01-98: VID_Init() must be done only once,
    //		      use VID_SetMode() to change vid mode while in the game.
    if( graphics_started )
	return;

    // remember the exact screen mode we were...
    I_SaveOldVideoMode();

    printf("Vid_Init...");

    VID_Init();

    //gfx_use_vesa1 = false;


    //added:03-01-98: register exit code for graphics
    I_AddExitFunc(I_ShutdownGraphics);
    graphics_started = true;

}
