// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This source is available for distribution and/or modification
// only under the terms of the DOOM Source Code License as
// published by id Software. All rights reserved.
//
// The source is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// FITNESS FOR A PARTICULAR PURPOSE. See the DOOM Source Code License
// for more details.
//
//
// $Log:$
//
// DESCRIPTION:
//	Main loop menu stuff.
//	Default Config File.
//	PCX Screenshots.
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id: m_misc.c,v 1.6 1997/02/03 22:45:10 b1 Exp $";

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#include <ctype.h>


#include "doomdef.h"

#include "z_zone.h"

#include "m_swap.h"
#include "m_argv.h"

#include "w_wad.h"

#include "i_system.h"
#include "i_video.h"
#include "v_video.h"

#include "hu_stuff.h"

// State.
#include "doomstat.h"

// Data.
#include "dstrings.h"

#include "m_misc.h"

#include "g_input.h"

//
// M_DrawText
// Returns the final X coordinate
// HU_Init must have been called to init the font
//
extern patch_t* 	hu_font[HU_FONTSIZE];

int
M_DrawText
( int		x,
  int		y,
  boolean	direct,
  char* 	string )
{
    int 	c;
    int 	w;

    while (*string)
    {
	c = toupper(*string) - HU_FONTSTART;
	string++;
	if (c < 0 || c> HU_FONTSIZE)
	{
	    x += 4;
	    continue;
	}

	w = SHORT (hu_font[c]->width);
	if (x+w > vid.width)
	    break;
	if (direct)
	    V_DrawPatchDirect(x, y, 0, hu_font[c]);
	else
	    V_DrawPatch(x, y, 0, hu_font[c]);
	x+=w;
    }

    return x;
}




//
// M_WriteFile
//
#ifndef O_BINARY
#define O_BINARY 0
#endif

boolean
M_WriteFile
( char const*	name,
  void* 	source,
  int		length )
{
    int 	handle;
    int 	count;

    handle = open ( name, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666);

    if (handle == -1)
	return false;

    count = write (handle, source, length);
    close (handle);

    if (count < length)
	return false;

    return true;
}


//
// M_ReadFile
//
int
M_ReadFile
( char const*	name,
  byte**	buffer )
{
    int handle, count, length;
    struct stat fileinfo;
    byte		*buf;

    handle = open (name, O_RDONLY | O_BINARY, 0666);
    if (handle == -1)
	I_Error ("Couldn't read file %s", name);
    if (fstat (handle,&fileinfo) == -1)
	I_Error ("Couldn't read file %s", name);
    length = fileinfo.st_size;
    buf = Z_Malloc (length, PU_STATIC, NULL);
    count = read (handle, buf, length);
    close (handle);

    if (count < length)
	I_Error ("Couldn't read file %s", name);

    *buffer = buf;
    return length;
}


//
// DEFAULTS
//
int		usemouse;
int		usejoystick;

extern int	key_right;
extern int	key_left;
extern int	key_up;
extern int	key_down;

extern int	key_strafeleft;
extern int	key_straferight;

extern int	key_fire;
extern int	key_use;
extern int	key_strafe;
extern int	key_speed;

//added:10-02-98: these toggles in m_menu.c
extern int	speed_locked;
extern int	mouseaiming_lock;
extern int	invert_mouse;

// Config of console player
extern char*	console_playername;	// sized MAXPLAYERNAME+1
extern int	console_skincolor;
extern int	console_originalweaponswitch;
extern char*	console_favoriteweapon;   // only used if originalweaponswitch==false

extern int	viewwidth;
extern int	viewheight;

extern int	showMessages;

extern int	detailLevel;

extern int	screenblocks;

extern int	showMessages;

// machine-independent sound params
extern	int	numChannels;


// UNIX hack, to be removed.
#ifdef SNDSERV
extern char*	sndserver_filename;
extern int	mb_used;
#endif

#ifdef LINUX
char*		mousetype;
char*		mousedev;
#endif

extern char*	chat_macros[];



typedef struct
{
    char*	name;
    int*	location;
    int 	defaultvalue;
    //added:10-02-98: minimum size for loading string variables,
    //		  0 means allocate the size of the string (like before),
    //		 >0 means the minimum size to allocate for the string buffer
    int 	minstrsize;
} default_t;


//added 01-01-98 : see in default_t.
#ifdef PC_DOS
int snd_MusicDevice;
int snd_SfxDevice;
int comport,snd_sbport,snd_sbirq,snd_sbdma,snd_mport;
#endif

default_t	defaults[] =
{
    {"mouse_sensitivity",&mouseSensitivity, 5},
    {"mlook_sensitivity",&mlookSensitivity, 5}, //added:10-02-98:
    {"sfx_volume",&snd_SfxVolume, 8},
    {"music_volume",&snd_MusicVolume, 8},
    {"show_messages",&showMessages, 1},


#ifdef NORMALUNIX
    {"key_right",&key_right, KEY_RIGHTARROW},
    {"key_left",&key_left, KEY_LEFTARROW},
    {"key_up",&key_up, KEY_UPARROW},
    {"key_down",&key_down, KEY_DOWNARROW},
    {"key_strafeleft",&key_strafeleft, ','},
    {"key_straferight",&key_straferight, '.'},

    {"key_fire",&key_fire, KEY_CTRL},
    {"key_use",&key_use, ' '},
    {"key_strafe",&key_strafe, KEY_ALT},
    {"key_speed",&key_speed, KEY_SHIFT},
    {"run_mode",&speed_locked, 0}, // remember the speed lock value

//added:06-02-98:kik test
    {"mouseaiming_lock", &mouseaiming_lock, false},
    {"invert_mouse", &invert_mouse, true},

// UNIX hack, to be removed.
#ifdef SNDSERV
    {"sndserver", (int *) &sndserver_filename, (int) "sndserver",0},
    {"mb_used", &mb_used, 2},
#endif

#endif

#ifdef LINUX
    {"mousedev", (int*)&mousedev, (int)"/dev/ttyS0",0},
    {"mousetype", (int*)&mousetype, (int)"microsoft",0},
#endif

    {"use_mouse",&usemouse, 1},
    {"mouseb_fire",&mousebfire,0},
    {"mouseb_strafe",&mousebstrafe,1},
    {"mouseb_forward",&mousebforward,2},

    {"use_joystick",&usejoystick, 0},
    {"joyb_fire",&joybfire,0},
    {"joyb_strafe",&joybstrafe,1},
    {"joyb_use",&joybuse,3},
    {"joyb_speed",&joybspeed,2},

    //added:08-02-98: BIG TEMPORARY HACK : should create our own config file
    // but for now, people still use SETUP to choose their soundcard,
    // se we keep using the default.cfg until we do our own setup...
    // new customize controls menu saves keys here
    {"gc_forward",    NULL, gc_forward},
    {"gc_backward",   NULL, gc_backward},
    {"gc_strafe",     NULL, gc_strafe},
    {"gc_straferight",NULL, gc_straferight},
    {"gc_strafeleft", NULL, gc_strafeleft},
    {"gc_speed",      NULL, gc_speed},
    {"gc_turnleft",   NULL, gc_turnleft},
    {"gc_turnright",  NULL, gc_turnright},
    {"gc_fire",       NULL, gc_fire},
    {"gc_use",	      NULL, gc_use},
    {"gc_lookup",     NULL, gc_lookup},
    {"gc_lookdown",   NULL, gc_lookdown},
    {"gc_centerview", NULL, gc_centerview},
    {"gc_mouseaiming",NULL, gc_mouseaiming},
    {"gc_weapon1",    NULL, gc_weapon1},
    {"gc_weapon2",    NULL, gc_weapon2},
    {"gc_weapon3",    NULL, gc_weapon3},
    {"gc_weapon4",    NULL, gc_weapon4},
    {"gc_weapon5",    NULL, gc_weapon5},
    {"gc_weapon6",    NULL, gc_weapon6},
    {"gc_weapon7",    NULL, gc_weapon7},
    {"gc_weapon8",    NULL, gc_weapon8},

    {"screenblocks",&screenblocks, 9},
    {"detaillevel",&detailLevel, 0},

    {"snd_channels",&numChannels, 3},

  //added 01-01-98
 // these values are not used now, but we want to keep these into the
// default.cfg. They have to be stored so that they can be written back.
#ifdef PC_DOS
    {"comport",&comport,1},
    {"snd_musicdevice",&snd_MusicDevice,0},	 // defined in s_sound.c
    {"snd_sfxdevice",&snd_SfxDevice,0}, 	// defined in s_sound.c
    {"snd_sbport",&snd_sbport,0},
    {"snd_sbirq",&snd_sbirq,0},
    {"snd_sbdma",&snd_sbdma,0},
    {"snd_mport",&snd_mport,0},
#endif

    {"console_skincolor",     &console_skincolor,0},
    {"console_name",(int *)   &console_playername,(int) "GI Joe",MAXPLAYERNAME+1},
    {"original_weaponswitch", &console_originalweaponswitch,false},
    {"favorite_weapon",(int *)&console_favoriteweapon,(int) "014576328",NUMWEAPONS+1},
							   //fpscrpbcs
							   //iihholfhu

    //added:27-01-98: quick hack for dynamic screen resize,
    //		      now we really should make our own config in addition
    //		      to the standard doom one...
    {"scr_width", &scr_width, BASEVIDWIDTH},
    {"scr_height",&scr_height,BASEVIDHEIGHT},

    {"usegamma",&usegamma, 0},

    {"chatmacro0", (int *) &chat_macros[0], (int) HUSTR_CHATMACRO0,0 },
    {"chatmacro1", (int *) &chat_macros[1], (int) HUSTR_CHATMACRO1,0 },
    {"chatmacro2", (int *) &chat_macros[2], (int) HUSTR_CHATMACRO2,0 },
    {"chatmacro3", (int *) &chat_macros[3], (int) HUSTR_CHATMACRO3,0 },
    {"chatmacro4", (int *) &chat_macros[4], (int) HUSTR_CHATMACRO4,0 },
    {"chatmacro5", (int *) &chat_macros[5], (int) HUSTR_CHATMACRO5,0 },
    {"chatmacro6", (int *) &chat_macros[6], (int) HUSTR_CHATMACRO6,0 },
    {"chatmacro7", (int *) &chat_macros[7], (int) HUSTR_CHATMACRO7,0 },
    {"chatmacro8", (int *) &chat_macros[8], (int) HUSTR_CHATMACRO8,0 },
    {"chatmacro9", (int *) &chat_macros[9], (int) HUSTR_CHATMACRO9,0 }

};

int	numdefaults;
char*	defaultfile;


#ifdef PC_DOS
//added 28-12-1997 quick fix for M_SaveDefaults() & M_LoadDefaults()
extern byte	ASCIINames[128];	//was scantokey[]
#endif

//
// M_SaveDefaults
//

void M_SaveDefaults (void)
{
    int 	i,j;
    int 	v;
    FILE*	f;

    f = fopen (defaultfile, "w");
    if (!f)
	return; // can't write the file, but don't complain

    for (i=0 ; i<numdefaults ; i++)
    {
	//added:08-02-98:
	// hack to save the new double-keycodes for each control
	// THIS IS TEMPORARY, note that normal key_xxxx are read
	// and written back unchanged, we don't want to clear
	// Doom2's settings (the least)
	if (!strncmp(defaults[i].name,"gc_",3))
	{
	    v = G_TwokeysForControl(defaults[i].defaultvalue);
	    fprintf (f,"%s\t\t%i\n",defaults[i].name,v);
	}
	else//end of hack
	if (defaults[i].defaultvalue > -0xfff
	    && defaults[i].defaultvalue < 0xfff)
	{
	    v = *defaults[i].location;
#ifdef PC_DOS
	    //added 28-12-1997
	    // save key scancodes like commercial doom
	    if( !strncmp(defaults[i].name,"key_",4) )
		if( v >= 0x80 )
		    v -= 0x80;	//restore scancode
		else
		// convert ASCII back to scancode
		{
		    for(j=0;j<128;j++)
			if( ASCIINames[j]==v )
			{
			    v=j;   //scancode was the index into ASCIINames[]
			    break;
			}
		}
#endif
	    fprintf (f,"%s\t\t%i\n",defaults[i].name,v);
	}
	else
	{
	    fprintf (f,"%s\t\t\"%s\"\n",defaults[i].name,
		     * (char **) (defaults[i].location));
	}
    }

    fclose (f);
}


//
// M_LoadDefaults
//

void M_LoadDefaults (void)
{
    int 	i;
    int 	len;
    FILE*	f;
    char	def[80];
    char	strparm[100];
    char*	newstring = NULL;	//shut up compiler!
    int 	parm;
    boolean	isstring;
    //check if gc_xxx defaults are found BIG TEMPORARY HACK
    boolean	gcfound = false;

    //added:08-02-98:welcome to dirty land... BIG TEMP HACK
    memset(controlmap,gc_null,sizeof(controlmap));     //eof big hack

    // set everything to base values
    numdefaults = sizeof(defaults)/sizeof(defaults[0]);
    for (i=0 ; i<numdefaults ; i++)
	//added:08-02-98:added condition because hack for gc_xxxx defaults
	// note THIS IS TEMPORARY
	if (defaults[i].location!=NULL) //end of hack
	    *defaults[i].location = defaults[i].defaultvalue;

    // check for a custom default file
    i = M_CheckParm ("-config");
    if (i && i<myargc-1)
    {
	defaultfile = myargv[i+1];
	printf ("	default file: %s\n",defaultfile);
    }
    else
	defaultfile = basedefault;

    // read the file in, overriding any set defaults
    f = fopen (defaultfile, "r");
    if (f)
    {
	while (!feof(f))
	{
	    isstring = false;
	    if (fscanf (f, "%79s %[^\n]\n", def, strparm) == 2)
	    {
		// get a string default
		if (strparm[0] == '"')
		    isstring = true;
		// hexadecimal value
		else if (strparm[0] == '0' && strparm[1] == 'x')
		    sscanf(strparm+2, "%x", &parm);
		// decimal value
		else
		    sscanf(strparm, "%i", &parm);

		// search the default
		for (i=0 ; i<numdefaults ; i++)
		    if (!strcmp(def, defaults[i].name))
		    {
			if (!isstring)
			{
#ifdef PC_DOS
			    //added 28-12-1997
			    // if it's a key default, convert the scancode
			    if( !strncmp(def,"key_",4) )
				if( parm<128 && ASCIINames[parm]!=0 )
				    parm = ASCIINames[parm];
				else
				    parm += 0x80;	//extended key
#endif
			    //added:08-02-98: big dirty hack to read the twokeys
			    //	 per control for the new customize controls menu
			    // THIS IS TEMPORARY!! OKAY? I KNOW THIS STINKS...
			    // anyway: the keys are two 9bits values
			    if (!strncmp(def,"gc_",3))
			    {
				gcfound = true;
				controlmap[parm&511] = defaults[i].defaultvalue;
				parm>>=9;
				if (parm>0)
				    controlmap[parm&511] = defaults[i].defaultvalue;
			    }
			    else //end of big dirty hack, NOTE the else

			     *defaults[i].location = parm;
			}
			else
			{
			    len = strlen(strparm);
			    strparm[len-1] = 0;

			    //added:10-02-98: some defaults need a minimum buffer
			    //		      size like the playernames that can
			    //		      be edited
			    if (defaults[i].minstrsize)
			    {
				if (len < defaults[i].minstrsize)
				    len = defaults[i].minstrsize;
			    }

			    newstring = (char *) malloc(len);
			    strcpy(newstring, strparm+1);

			    *defaults[i].location = (int) newstring;

			}
			break;
		    }
	    }
	}

	fclose (f);
    }

    //added:08-02-98: BIG TEMPORARY HACK : setup the game controls of the
    //	    customize controls menu, convert old key_xxxx if necessary
    G_SetupDefaultGameControls (gcfound);
}


//
// SCREEN SHOTS
//


typedef struct
{
    char		manufacturer;
    char		version;
    char		encoding;
    char		bits_per_pixel;

    unsigned short	xmin;
    unsigned short	ymin;
    unsigned short	xmax;
    unsigned short	ymax;

    unsigned short	hres;
    unsigned short	vres;

    unsigned char	palette[48];

    char		reserved;
    char		color_planes;
    unsigned short	bytes_per_line;
    unsigned short	palette_type;

    char		filler[58];
    unsigned char	data;		// unbounded
} pcx_t;


//
// WritePCXfile
//
void
WritePCXfile
( char* 	filename,
  byte* 	data,
  int		width,
  int		height,
  byte* 	palette )
{
    int 	i;
    int 	length;
    pcx_t*	pcx;
    byte*	pack;

    pcx = Z_Malloc (width*height*2+1000, PU_STATIC, NULL);

    pcx->manufacturer = 0x0a;		// PCX id
    pcx->version = 5;			// 256 color
    pcx->encoding = 1;			// uncompressed
    pcx->bits_per_pixel = 8;		// 256 color
    pcx->xmin = 0;
    pcx->ymin = 0;
    pcx->xmax = SHORT(width-1);
    pcx->ymax = SHORT(height-1);
    pcx->hres = SHORT(width);
    pcx->vres = SHORT(height);
    memset (pcx->palette,0,sizeof(pcx->palette));
    pcx->color_planes = 1;		// chunky image
    pcx->bytes_per_line = SHORT(width);
    pcx->palette_type = SHORT(2);	// not a grey scale
    memset (pcx->filler,0,sizeof(pcx->filler));


    // pack the image
    pack = &pcx->data;

    for (i=0 ; i<width*height ; i++)
    {
	if ( (*data & 0xc0) != 0xc0)
	    *pack++ = *data++;
	else
	{
	    *pack++ = 0xc1;
	    *pack++ = *data++;
	}
    }

    // write the palette
    *pack++ = 0x0c;	// palette ID byte
    for (i=0 ; i<768 ; i++)
	*pack++ = *palette++;

    // write output file
    length = pack - (byte *)pcx;
    M_WriteFile (filename, pcx, length);

    Z_Free (pcx);
}


//
// M_ScreenShot
//
void M_ScreenShot (void)
{
    int 	i;
    byte*	linear;
    char	lbmname[12];

    // munge planar buffer to linear
    linear = screens[2];
    I_ReadScreen (linear);

    // find a file name to save it to
    strcpy(lbmname,"DOOM00.pcx");

    for (i=0 ; i<=99 ; i++)
    {
	lbmname[4] = i/10 + '0';
	lbmname[5] = i%10 + '0';
	if (access(lbmname,0) == -1)
	    break;	// file doesn't exist
    }
    if (i==100)
	I_Error ("M_ScreenShot: Couldn't create a PCX");

    // save the pcx file
    WritePCXfile (lbmname, linear,
		  vid.width, vid.height,
		  W_CacheLumpName ("PLAYPAL",PU_CACHE));

    players[consoleplayer].message = "screen shot";
}


