
// p_fab.c : some new action routines, separated from the original doom
//	     sources, so that you can include it or remove it easy.
//
//  by Fab.

#include <stdlib.h>

#include "m_random.h"
#include "i_system.h"

#include "doomdef.h"
#include "p_local.h"

#include "s_sound.h"

#include "g_game.h"

// State.
#include "doomstat.h"
#include "r_state.h"

// Data.
#include "sounds.h"



//
// Action routine, for the ROCKET thing.
// This one adds trails of smoke to the rocket.
// The action pointer of the S_ROCKET state must point here to take effect.
// This routine is based on the Revenant Fireball Tracer code A_Tracer()
//
void A_SmokeTrailer (mobj_t* actor)
{
    angle_t	exact;
    fixed_t	dist;
    fixed_t	slope;
    mobj_t*	dest;
    mobj_t*	th;

    if (gametic & 3)
	return;

    // spawn a puff of smoke behind the rocket
    P_SpawnPuff (actor->x, actor->y, actor->z);

    // add the smoke behind the rocket
    th = P_SpawnMobj (actor->x-actor->momx,
		      actor->y-actor->momy,
		      actor->z, MT_SMOKE);

    th->momz = FRACUNIT;
    th->tics -= P_Random()&3;
    if (th->tics < 1)
	th->tics = 1;
}


//
// Activate or not the rocket trails, this should be toggle-able in the
// main menu.
//
void P_SetupRocketTrails( boolean enable )
{

    if( enable )
	// hack the info.c table !
	states[S_ROCKET].action.acv = A_SmokeTrailer;
    else
	// this was NULL in Doom2 v1.9
	states[S_ROCKET].action.acv = NULL;
}
