////////////////////////////////////////////////////////////////////////////
//
// CMAPTOOL		By J. Flynn 5/23/98
//
// Creates a colormap lump from an input BMP file edited from one containing 
// all colors of the DOOM palette. Can also generate the BMP file for the
// standard DOOM palette, or a custom palette/colormap used in a wad.
//
////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>

// use unwrapped free directly

#define xlibfree(a) free(a)

// defines for .BMP files

#define BI_RGB      0L
#define BI_RLE8     1L
#define BI_RLE4     2L

typedef unsigned short UINT;
typedef unsigned short WORD;
typedef unsigned short UWORD;
typedef unsigned short SWORD;
typedef unsigned long DWORD;
typedef long LONG;
typedef unsigned long ULONG;
typedef long SLONG;
typedef unsigned char BYTE;
typedef signed char SBYTE;
typedef unsigned char UBYTE;

typedef struct tagBITMAPFILEHEADER
{
    UINT    bfType;				   //	2
    DWORD   bfSize;				   //	4
    UINT    bfReserved1;		   //	2
    UINT    bfReserved2;		   //	2
    DWORD   bfOffBits;			   //	4
} __attribute__ ((packed)) BITMAPFILEHEADER;				   //	14

typedef struct tagBITMAPINFOHEADER
{
    DWORD   biSize;				   //	4
    LONG    biWidth;			   //	4
    LONG    biHeight;			   //	4
    WORD    biPlanes;			   //	2
    WORD    biBitCount;			   //	2
    DWORD   biCompression;		   //	4
    DWORD   biSizeImage;		   //	4
    LONG    biXPelsPerMeter;	   //	4
    LONG    biYPelsPerMeter;	   //	4
	  DWORD   biClrUsed;			   //	4
    DWORD   biClrImportant;		   //	4
} __attribute__ ((packed)) BITMAPINFOHEADER;				   //	40

typedef struct tagRGBQUAD
{
    UBYTE    rgbBlue;
    UBYTE    rgbGreen;
    UBYTE    rgbRed;
    UBYTE    rgbReserved;
} __attribute__ ((packed)) RGBQUAD;

// wad structure type definitions

typedef struct stWadFileHeader
{
	char wadtag[4];					/* wad identification tag */
	unsigned long waddirlen;		/* number of entries in directory*/
	unsigned long waddiraddr;		/* byte file offset of directory*/
} WadHeader;

/* wad directory entry structure*/

typedef struct stWadDirEntry
{
	unsigned long resptr;			/* byte file offset of resource*/
	unsigned long reslen;			/* byte length of resource*/
	char resname[8];				/* name of resource nul termed if < 8 char*/
} WadDirEntry;

/* Directory locations for start/end tags */

/* wad directory structure*/

typedef struct stWadDir
{
	WadDirEntry *dirp;				/* dynamic array of directory entries*/
	int nentries;					/* number of entries used */
	int allentries;					/* number of entries allocated */
} WadDir;

// variable to hold palette for BMP

RGBQUAD InPal[256];

// standard DOOM palette

RGBQUAD DoomPalette[]=
{
	{  0,  0,  0,  0},{ 11, 23, 31,  0},{  7, 15, 23,  0},{ 75, 75, 75,  0},
	{255,255,255,  0},{ 27, 27, 27,  0},{ 19, 19, 19,  0},{ 11, 11, 11,  0},
	{  7,  7,  7,  0},{ 31, 55, 47,  0},{ 15, 43, 35,  0},{  7, 31, 23,  0},
	{  0, 23, 15,  0},{ 43, 59, 79,  0},{ 35, 51, 71,  0},{ 27, 43, 63,  0},
	{183,183,255,  0},{171,171,247,  0},{163,163,243,  0},{151,151,235,  0},
	{143,143,231,  0},{135,135,223,  0},{123,123,219,  0},{115,115,211,  0},
	{107,107,203,  0},{ 99, 99,199,  0},{ 91, 91,191,  0},{ 87, 87,187,  0},
	{ 79, 79,179,  0},{ 71, 71,175,  0},{ 63, 63,167,  0},{ 59, 59,163,  0},
	{ 51, 51,155,  0},{ 47, 47,151,  0},{ 43, 43,143,  0},{ 35, 35,139,  0},
	{ 31, 31,131,  0},{ 27, 27,127,  0},{ 23, 23,119,  0},{ 19, 19,115,  0},
	{ 15, 15,107,  0},{ 11, 11,103,  0},{  7,  7, 95,  0},{  7,  7, 91,  0},
	{  7,  7, 83,  0},{  0,  0, 79,  0},{  0,  0, 71,  0},{  0,  0, 67,  0},
	{223,235,255,  0},{211,227,255,  0},{199,219,255,  0},{187,211,255,  0},
	{179,207,255,  0},{167,199,255,  0},{155,191,255,  0},{147,187,255,  0},
	{131,179,255,  0},{123,171,247,  0},{115,163,239,  0},{107,155,231,  0},
	{ 99,147,223,  0},{ 91,139,215,  0},{ 83,131,207,  0},{ 79,127,203,  0},
	{ 75,123,191,  0},{ 71,115,179,  0},{ 67,111,171,  0},{ 63,107,163,  0},
	{ 59, 99,155,  0},{ 55, 95,143,  0},{ 51, 87,135,  0},{ 47, 83,127,  0},
	{ 43, 79,119,  0},{ 39, 71,107,  0},{ 35, 67, 95,  0},{ 31, 63, 83,  0},
	{ 27, 55, 75,  0},{ 23, 47, 63,  0},{ 19, 43, 51,  0},{ 15, 35, 43,  0},
	{239,239,239,  0},{231,231,231,  0},{223,223,223,  0},{219,219,219,  0},
	{211,211,211,  0},{203,203,203,  0},{199,199,199,  0},{191,191,191,  0},
	{183,183,183,  0},{179,179,179,  0},{171,171,171,  0},{167,167,167,  0},
	{159,159,159,  0},{151,151,151,  0},{147,147,147,  0},{139,139,139,  0},
	{131,131,131,  0},{127,127,127,  0},{119,119,119,  0},{111,111,111,  0},
	{107,107,107,  0},{ 99, 99, 99,  0},{ 91, 91, 91,  0},{ 87, 87, 87,  0},
	{ 79, 79, 79,  0},{ 71, 71, 71,  0},{ 67, 67, 67,  0},{ 59, 59, 59,  0},
	{ 55, 55, 55,  0},{ 47, 47, 47,  0},{ 39, 39, 39,  0},{ 35, 35, 35,  0},
	{111,255,119,  0},{103,239,111,  0},{ 95,223,103,  0},{ 87,207, 95,  0},
	{ 79,191, 91,  0},{ 71,175, 83,  0},{ 63,159, 75,  0},{ 55,147, 67,  0},
	{ 47,131, 63,  0},{ 43,115, 55,  0},{ 35, 99, 47,  0},{ 27, 83, 39,  0},
	{ 23, 67, 31,  0},{ 15, 51, 23,  0},{ 11, 35, 19,  0},{  7, 23, 11,  0},
	{143,167,191,  0},{135,159,183,  0},{127,151,175,  0},{119,143,167,  0},
	{111,135,159,  0},{107,127,155,  0},{ 99,123,147,  0},{ 91,115,139,  0},
	{ 87,107,131,  0},{ 79, 99,123,  0},{ 75, 95,119,  0},{ 67, 87,111,  0},
	{ 63, 83,103,  0},{ 55, 75, 95,  0},{ 51, 67, 87,  0},{ 47, 63, 83,  0},
	{ 99,131,159,  0},{ 83,119,143,  0},{ 75,107,131,  0},{ 63, 95,119,  0},
	{ 51, 83,103,  0},{ 43, 71, 91,  0},{ 35, 59, 79,  0},{ 27, 51, 67,  0},
	{ 99,127,123,  0},{ 87,115,111,  0},{ 79,107,103,  0},{ 71, 99, 91,  0},
	{ 59, 87, 83,  0},{ 51, 79, 71,  0},{ 43, 71, 63,  0},{ 39, 63, 55,  0},
	{115,255,255,  0},{ 87,219,235,  0},{ 67,187,215,  0},{ 47,155,195,  0},
	{ 31,123,175,  0},{ 19, 91,155,  0},{  7, 67,135,  0},{  0, 43,115,  0},
	{255,255,255,  0},{219,219,255,  0},{187,187,255,  0},{155,155,255,  0},
	{123,123,255,  0},{ 95, 95,255,  0},{ 63, 63,255,  0},{ 31, 31,255,  0},
	{  0,  0,255,  0},{  0,  0,239,  0},{  0,  0,227,  0},{  0,  0,215,  0},
	{  0,  0,203,  0},{  0,  0,191,  0},{  0,  0,179,  0},{  0,  0,167,  0},
	{  0,  0,155,  0},{  0,  0,139,  0},{  0,  0,127,  0},{  0,  0,115,  0},
	{  0,  0,103,  0},{  0,  0, 91,  0},{  0,  0, 79,  0},{  0,  0, 67,  0},
	{255,231,231,  0},{255,199,199,  0},{255,171,171,  0},{255,143,143,  0},
	{255,115,115,  0},{255, 83, 83,  0},{255, 55, 55,  0},{255, 27, 27,  0},
	{255,  0,  0,  0},{227,  0,  0,  0},{203,  0,  0,  0},{179,  0,  0,  0},
	{155,  0,  0,  0},{131,  0,  0,  0},{107,  0,  0,  0},{ 83,  0,  0,  0},
	{255,255,255,  0},{219,235,255,  0},{187,215,255,  0},{155,199,255,  0},
	{123,179,255,  0},{ 91,163,255,  0},{ 59,143,255,  0},{ 27,127,255,  0},
	{ 23,115,243,  0},{ 15,111,235,  0},{ 15,103,223,  0},{ 11, 95,215,  0},
	{  7, 87,203,  0},{  0, 79,195,  0},{  0, 71,183,  0},{  0, 67,175,  0},
	{255,255,255,  0},{215,255,255,  0},{179,255,255,  0},{143,255,255,  0},
	{107,255,255,  0},{ 71,255,255,  0},{ 35,255,255,  0},{  0,255,255,  0},
	{  0, 63,167,  0},{  0, 55,159,  0},{  0, 47,147,  0},{  0, 35,135,  0},
	{ 39, 59, 79,  0},{ 27, 47, 67,  0},{ 19, 35, 55,  0},{ 11, 27, 47,  0},
	{ 83,  0,  0,  0},{ 71,  0,  0,  0},{ 59,  0,  0,  0},{ 47,  0,  0,  0},
	{ 35,  0,  0,  0},{ 23,  0,  0,  0},{ 11,  0,  0,  0},{255,255,  0,  0},
	{ 67,159,255,  0},{ 75,231,255,  0},{255,123,255,  0},{255,  0,255,  0},
	{207,  0,207,  0},{155,  0,159,  0},{107,  0,111,  0},{107,107,167,  0},
};

// standard DOOM colormap

unsigned char ColorMap[][256]=
{
    {//0
      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
     32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
     48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
     64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
     96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
    128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,  4,169,170,171,172,173,174,175,
    176,177,178,179,180,181,182,183,184,185,186,187,188,189, 45, 47,
    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
      4,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
      4,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
    207,241,242,243,244,245,246,  0,248,249,250,251,252,253,254,255
    },
    {//1
      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     17, 18, 19, 20, 21, 21, 23, 24, 24, 25, 27, 27, 28, 29, 31, 31,
     33, 33, 34, 35, 36, 37, 38, 39, 40, 41, 43, 43, 44, 45, 46, 47,
     49, 50, 51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 64,
     64, 66, 67, 67, 68, 69, 71, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 95,
     97, 97, 98,100,100,101,103,103,  3,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
    129,130,131,132,133,134,134,136,136,138,138,139,140,141,143, 13,
    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,  4,169, 16,171,172,173,174,175,
    176,178,179,180,180,181,182,183,184,185,186,187,188,189, 45, 47,
    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
      4, 49, 52, 54, 57,213,214,215,217,218,219,219,220,221,223,232,
      4,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
    207,241,242,243,244,245,246,  0,248,249,250,251,252,253,254,255
    },
    {//2
      0,  1,  2,105, 80,  5,  6,  7,  8,  9, 10, 11, 12,236, 14, 15,
     17, 18, 19, 21, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
     33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 44, 46, 47, 47,
     49, 50, 51, 53, 53, 54, 55, 57, 57, 58, 59, 60, 61, 62, 64, 64,
     65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,151, 77, 78, 79,
     82, 83, 84, 85, 86, 87, 87, 89, 90, 91, 92, 92, 93, 95, 95, 96,
     97, 98, 99,100,101,102,103,104,  3,106,106,108,108,109,110,111,
    113,114,115,116,117,118,119,120,121,121,122,123,124,125,126,127,
    129,130,131,132,133,134,135,136,137,138,139,140,141,142,143, 13,
    134,146,138,139,141,149, 14, 77,153,154,155,155,156,157,159,159,
    228,161,162,163,164,165,166,167, 80, 50, 17, 20,172,173,174,175,
    177,178,179,180,181,182,183,184,185,186,187,188,188, 45, 46, 47,
     82,193,194,195,196,197,198,199,201,202,203,203,204,205,206,207,
     80, 50, 52, 55, 58,213,214,216,218,218,219,220,221,222,223,232,
     80, 49,226,227,228,249,230,231,233,234,234,235, 14, 15,238,239,
    207,241,242,243,244,245,246,  0,214,161,250,251,252,253,254,255
    },
    {//3
      0,  1,  2,106, 81,  5,  6,  7,  8,  9, 10, 11, 12, 14, 15,238,
     18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 28, 29, 30, 32, 32,
     34, 34, 35, 36, 38, 38, 39, 40, 41, 42, 44, 44, 44, 46, 47, 47,
     83, 51, 52, 53, 17, 18, 57, 57, 58, 59, 60, 61, 62, 63, 64, 65,
     66, 67, 68, 69, 69, 70, 72, 72, 73, 74, 75, 76,151, 78, 79, 79,
     83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 92, 93, 94, 95, 96, 97,
     98, 98,100,101,101,102,104,104,105,106,107,108,109,109,111,111,
    113,114,115,116,117,118,119,120,121,122,123,124,124,125,126,127,
    130,131,132,133,134,135,136,137,137,139,139,140,141,142, 13, 13,
    135,146,147,140,149,236, 14, 77,153,154,155,156,157,158,159,  9,
    161,162,163,164,164,165,166,167, 81, 84, 18, 20, 22,173,174,175,
    178,179,180,181,182,182,183,184,185,186,187,188,189, 45, 46, 47,
     83,194,195,195,196,197,198,199,201,202,203,204,205,205,206,241,
     81, 84, 53, 57, 59, 60,214,217,218,219,220,220,222,223,232,233,
     81, 50, 52,227,161,161,230,231,233,234,235,167, 14, 15,238,239,
    241,242,242,243,244,245,246,  0,214,161,250,251,252,253,254,255
    },
    {//4
      0,  1,  2,106, 82,  5,  6,  7,  8,  9, 10, 11, 12, 14, 15,238,
     19, 20, 21, 21, 23, 23, 24, 25, 27, 28, 28, 29, 30, 31, 32, 33,
     34, 35, 36, 37, 38, 38, 40, 40, 42, 43, 44, 44, 46, 46, 47, 47,
     84, 85, 17, 17, 18, 19, 19, 58, 59, 60, 61, 62, 63, 64, 65, 65,
     66, 68, 68, 69, 70, 71, 72, 73, 73, 74, 75, 76, 77, 78, 79, 79,
     84, 85, 86, 87, 88, 89, 90, 91, 92, 92, 93, 94, 95, 96, 96, 98,
     98, 99,100,101,102,103,104,  3,105,107,107,108,109,110,111,  5,
    114,115,116,117,117,118,119,120,121,122,123,124,124,125,126,127,
    131,131,132,134,135,135,136,137,138,139,140,141,141,143, 13, 13,
    135,146,147,148,149,236, 14, 77,153,155,155,156,157,158,159,  9,
    161,162,163,164,165,166,167,167, 82, 85, 18, 21, 23, 25,174,175,
    178,179,180,181,182,183,184,185,185,186,187,188,189, 45, 46, 47,
     84,194,195,196,196,197,198,199,201,202,203,204,205,206,207,241,
     82, 84, 17, 57, 59, 61, 63,218,219,219,220,221,222,223,232,233,
     82, 84,211,161,161,161,230,231,234,234,235,167, 14, 15, 79,239,
    241,242,243,243,244,245,246,  0, 62,162,250,252,253,253,254,136
    },
    {//5
      0,  2,  2,106, 83,  5,  6,  7,  8,  9, 10, 11, 12, 14, 15,238,
     19, 21, 21, 23, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
     34, 36, 36, 38, 38, 39, 40, 41, 43, 43, 44, 44, 46, 47, 47, 47,
     86, 86, 87,128,128,128, 20, 59, 60, 61, 61, 62, 64, 65, 66, 66,
     67, 68, 69, 70, 70, 72, 72, 73, 74, 75,150,151, 77, 78, 79,  1,
     85, 86, 87, 88, 89, 90, 91, 92, 93, 93, 94, 95, 96, 97, 97, 98,
     99,100,101,102,102,103,  3,  3,106,107,107,109,109,110,111,  5,
    114,115,116,117,118,119,120,120,121,122,123,124,125,126,126,127,
    131,132,133,134,135,136,137,138,139,140,140,141,142,143, 13, 14,
    136,138,139,148,149,150,151, 15,154,155,156,156,157,158,159,  9,
    161,162,163,164,165,166,167,167, 83, 86, 19, 21, 24, 26,174,179,
    179,180,181,182,183,183,184,185,186,187,188,188,189, 45, 47, 47,
     85, 88,195,196,197,197,198,201,201,202,203,204,205,206,207,241,
     83, 86,128,128, 60, 62, 63,218,219,220,220,222,223,232,233,234,
     83, 85,211,161,161,162,162,231,234,235,167,167, 14,238, 79,239,
    241,242,243,244,244,245,246,  0, 63,162,250,252,253,254,254,136
    },
    {//6
      0,  2,  2,107, 84,  6,  6,  7,  8, 10, 11, 11, 12, 14, 15,238,
    128, 21, 22, 23, 24,255,255, 27, 28, 28, 30, 30, 31, 32, 34, 34,
     36, 36, 37, 38, 39, 40, 40, 41, 43, 44, 44, 46, 47, 47, 47, 47,
     87, 87,128,128,128,128,129, 60, 60, 61, 62, 64, 65, 65, 66, 67,
     68, 69, 70, 70, 71, 72, 73, 73, 74, 75, 76,151, 77, 78, 79,  1,
     87, 87, 88, 89, 90, 91, 92, 92, 93, 94, 95, 95, 96, 97, 98, 99,
    100,100,101,102,103,104,  3,105,106,107,108,109,109,110,111,  5,
    115,116,117,117,118,119,120,121,122,122,123,124,125,126,127,127,
    132,133,134,135,136,136,137,138,139,140,141,142,142, 13, 14, 14,
    146,147,140,141,143,150,237, 78,154,155,156,157,158,159,  9,  9,
    161,162,163,164,165,166,167,167, 84, 87,128, 22, 25, 27, 29,180,
    180,181,182,182,183,184,185,185,186,187,188,189, 45, 46, 47, 47,
     87, 89,195,196,197,198,198,202,202,203,204,204,205,206,207,241,
     84, 87,128,128, 61, 63, 64,219,220,220,222,222,232,232,233,234,
     84, 86,128,161,162,162,162,231,234,235,167,167,237,238,239,  1,
    241,242,243,244,245,245,246,  0, 63,162,250,252,253,254,254,137
    },
    {//7
      0,  2,  2,107, 86,  6,  6,  7,  8, 10, 11, 12, 12, 15, 15,238,
    129,130, 23,255,255,255,255, 28, 28, 29, 30, 31, 32, 33, 34, 34,
     36, 36, 38, 38, 40, 40, 41, 43, 44, 44, 46, 46, 47, 47, 47, 47,
     88, 89,128,128,128,129,129,130, 61, 62, 64, 64, 65, 66, 67, 68,
     68, 69, 70, 71, 72, 73, 73, 74, 74, 75, 76, 77, 77, 78, 79,  1,
     87, 89, 90, 90, 91, 92, 92, 93, 94, 95, 96, 96, 97, 98, 98, 99,
    101,101,102,103,103,  3,105,106,107,108,108,109,109,110,  5,  5,
    115,116,117,118,119,119,120,121,122,122,123,124,125,126,127,127,
    133,134,135,136,136,137,138,139,140,141,141,142,143, 13, 14, 14,
    137,139,140,141,236, 14, 15, 78,155,155,156,157,158,159,  9,  9,
    162,163,163,164,165,166,167,167, 86, 89,128, 23, 25, 28, 30,180,
    180,181,182,183,184,184,185,186,186,187,188,189, 45, 46, 47, 47,
     88, 90, 92,196,197,198,198,202,202,203,204,205,205,206,207,241,
     86, 88,128,129, 61, 63,164,220,220,221,222,223,232,233,234,234,
     86, 87,128,128,162,162,162,163,235,167,167,167, 15,238,239,  1,
    241,242,243,244,245,245,246,  0, 64,162, 21,252,253,254,254,137
    },
    {//8
      0,  2,  2,108, 87,  6,  7,  8,  8, 10, 11, 12, 12, 15,238, 79,
    129,130,131,255,255,255,255, 28, 29, 30, 31, 31, 32, 34, 34, 36,
     36, 37, 38, 39, 40, 40, 43, 44, 44, 44, 46, 47, 47, 47, 47, 47,
     89,128,128,128,129,129,130,130, 62, 64, 64, 65, 66, 67, 68, 68,
     69, 70, 71, 72, 72, 73, 74, 74, 75, 76,151, 77, 78, 79, 79,  1,
     89, 90, 91, 91, 92, 93, 93, 94, 95, 96, 97, 97, 98, 99, 99,100,
    101,101,102,103,104,  3,106,106,107,108,109,109,110,111,  5,  5,
    116,117,117,118,119,120,121,121,122,123,124,124,125,126,127,127,
    134,134,135,136,137,138,139,140,140,141,142,143, 13, 14, 14, 15,
    138,139,141,149,236, 14, 15, 78,155,156,156,157,158,159,  9,  9,
    162,163,164, 69,165,166,167, 44, 87,128,129, 24, 26, 29, 31,181,
    181,182,183,183,184,185,185,186,187,188,189,189, 45, 47, 47, 47,
     89, 91, 93,196,197,198,202,202,202,203,204,205,206,206,207,242,
     87, 89,128,130, 62, 64,164,220,221,222,223,232,233,234,234,235,
     87, 88,128,128,162,162,163,163,167,167,167, 41, 15,238,239,  1,
    242,242,243,244,245,245,246,  0, 65,163, 21,252,253,254,254,138
    },
    {//9
      0,  2,  2,108, 88,  6,  7,  8,  8, 10, 11, 12, 12, 15,238, 79,
    130,131,255,255,255,255, 28, 28, 69, 31, 70, 71, 34, 34, 36, 36,
     37, 38, 38, 40, 40, 41, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47,
     90,128,129,129,130,130,131,131, 64, 64, 65, 66, 67, 68, 68, 69,
     70, 71, 71, 72, 73, 73, 74, 74, 75, 76,237, 77, 78, 79, 79,  1,
     90, 91, 92, 92, 93, 94, 94, 95, 96, 96, 97, 98, 99, 99,100,101,
    102,102,103,104,  3,105,106,106,107,108,109,110,110,111,  5,  5,
    116,117,118,119,119,120,121,122,122,123,124,124,125,126,127,127,
    134,135,136,137,138,138,139,140,141,142,142,143, 13, 14, 14, 15,
    138,140,141,142,150,151, 15, 78,155,156,157,158,159,  9,  9,  9,
    162,163,164, 69, 72,166,167, 44, 88,128,130,255, 27, 29, 31,182,
    182,183,183,184,185,185,186,187,187,188,189, 45, 46, 47, 47, 47,
     90, 92, 94, 96,197,198,203,203,203,204,204,205,206,207,207,242,
     88,128,129,131, 64, 65,164,220,165,223,232,232,166,234,234,167,
     88,128,128,129,162,163,163,163,167,167,167, 41, 15, 79,239,  1,
    242,243,243,244,245,245,246,  0,164,163, 93,252,253,254,254,139
    },
    {//10
      0,  2,  7,108, 89,  6,  7,  8,  8, 10, 11, 12, 12, 15,238, 79,
    131,255,255,255,255,255, 28, 69, 70, 70, 71, 71, 34, 34, 36, 36,
     38, 38, 39, 40, 40, 43, 44, 44, 44, 46, 47, 47, 47, 47, 47, 47,
     91,129,130,130,131,131,132,144,144, 65, 66, 67, 68, 68, 69, 70,
     70, 71, 72, 73, 73, 74, 74, 75, 76, 76, 77, 78,238, 79,  1,  1,
     91, 92, 93, 93, 94, 95, 95, 96, 97, 97, 98, 98, 99,100,101,101,
    102,103,104,  3,  3,106,106,107,108,109,109,110,110,111,  5,  5,
    117,118,118,119,120,121,121,122,123,123,124,125,125,126,127,127,
    135,136,137,137,138,139,140,140,141,142,142, 13, 13, 14, 15, 15,
    139,140,141,143, 14,151, 78, 79,156,157,157,158,159,  9,  9,111,
    163,163,164, 69, 72,167,167, 44, 89, 92,131,255, 28, 29, 32,182,
    182,183,184,184,185,186,186,187,188,189,189, 45, 46, 47, 47, 47,
     91, 93, 95, 97, 99,198,203,203,203,204,205,205,206,207,241,242,
     89, 92,130,131, 65, 66, 67,165,165,232,166,166,166,234,167,167,
     89,128,129,130,163,163,163,163,167,167,167, 42, 78, 79,  1,  1,
    242,243,243,244,245,246,246,  0,164,163,255,253,253,254,254,139
    },
    {//11
      0,  2,  7,109, 91,  6,  7,  8,  8, 10, 11,127, 12, 78, 79, 79,
    255,255,255,255,255,136,137, 70, 70, 71, 72, 72, 73, 73, 36, 38,
     38, 38, 40, 40, 44, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47,
     92,130,130,131,131,132,144,144, 65, 66, 67, 68, 69, 69, 70, 70,
     71, 72, 73, 73, 73, 74, 75,150, 76,237, 77, 78,238, 79,  1,  1,
     92, 93, 94, 94, 95, 96, 96, 97, 98, 98, 99, 99,100,101,101,102,
    103,103,104,  3,105,106,107,107,108,109,109,110,111,  5,  5,  5,
    117,118,119,120,120,121,122,122,123,123,124,125,125,126,127,  7,
    136,136,137,138,139,140,140,141,142,143,143, 13, 14, 14, 15, 15,
    140,141,142, 13, 14, 15, 78, 79,156,157,157,158,159,  9,  9,111,
    163,145, 69, 71, 73,167,167, 44, 91, 93,132,255, 28, 30, 33,183,
    183,184,184,185,185,186,187,187,188,189, 45, 45, 47, 47, 47, 47,
     92, 94, 96, 98,100,203,203,203,203,204,205,206,206,207,241,242,
     91, 92,131,144, 65, 67,165,165,165,232,166,166,166,167,167,167,
     91,129,130,131,163,163,163,164,167,167,167, 43, 78, 79,  1,  1,
    242,243,244,244,245,246,246,  0, 67,163,255,253,253,254,254,140
    },
    {//12
      0,  2,  7,109, 92,  6,  7,  8,  8,  5, 11, 12,  8, 78, 79, 79,
    255,255,255,136,136,137,138, 70, 71, 71, 73, 73, 73, 73, 38, 38,
     38, 40, 40, 43, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47,
     94,131,131,132,132,133,144,134,145, 67, 68, 69, 69, 70, 71, 71,
     72, 73, 73, 73, 74, 75,150, 76, 76,237, 15, 78, 79, 79,  1,  1,
     93, 94, 95, 95, 96, 97, 97, 98, 99, 99,100,100,101,102,102,103,
    104,104,  3,105,106,107,107,108,109,109,110,110,111,  5,  5,  6,
    118,119,119,120,121,121,122,122,123,124,124,125,126,126,127,  8,
    137,137,138,139,140,140,141,142,142,143, 13, 14, 14, 15, 15, 78,
    140,141,143,236,151, 15, 78, 79,156,157,158,159,  9,  9, 10, 10,
    144,145, 69, 72, 73, 75, 76, 44, 92, 94,133,255, 29, 31, 33,184,
    184,184,185,185,186,187,187,188,188,189, 45, 46, 47, 47, 47, 47,
     93, 95, 97, 99,101,204,204,204,204,205,205,206,206,207,241,243,
     92, 94,132,144, 67, 68,165,165,166,166,166,166,166,167,167,167,
     92,130,131,144,163,163,164,164,167,167, 43, 44, 78, 79,  1,  2,
    243,243,244,244,245,246,246,  0, 68,164,255,253,254,254,109,140
    },
    {//13
      0,  2,  7,109, 93,  6,  7,  8,  8,  5, 11, 12,  8,238, 79,  1,
    255,135,136,136,137,138,139,139,139, 72, 73, 73, 73, 74, 38, 38,
     40, 40, 40, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47,  2,
     95,132,132,133,133,134,135,145,145, 68, 69, 69, 70, 71, 71, 72,
     72, 73, 73, 74, 74,150, 76, 76,237, 15,238, 78, 79,  1,  1,  1,
     95, 95, 96, 96, 97, 98, 98, 99, 99,100,101,101,102,102,103,103,
    104,  3,105,106,106,107,108,108,109,110,110,111,111,  5,  5,  6,
    118,119,120,120,121,122,122,123,123,124,124,125,126,126,127,  8,
    137,138,139,140,140,141,141,142,143, 13, 13, 14, 14, 15, 78, 78,
    141,142, 13, 14, 15, 78, 79, 79,157,158,158,159,  9,  9, 10, 10,
    145,145, 69, 72, 74, 76, 77,239, 93, 95,133,136, 30, 32, 34,184,
    184,185,185,186,186,187,188,188,189, 45, 45, 47, 47, 47, 47,  2,
     95, 96, 98,100,101,204,204,204,204,205,205,206,207,207,242,243,
     93, 95,133,134, 67, 68,165,165,166,166,166,166,167,167,167,167,
     93, 94,132,144,145,164,164,164,167,167, 43, 44, 79, 79,  1,  2,
    243,243,244,245,245,246,246,  0, 69,164,255,253,254,254,109,141
    },
    {//14
      0,  2,  8,110, 94,  6,  7,  8,  8,126, 11,127,  8, 79, 79,  1,
    135,136,136,137,138,138,139,139, 73, 73, 73, 73, 74,236, 14, 14,
    237, 40, 44, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47,  2,  2,
     96,133,133,134,134,135,135,136,146, 69, 69, 70, 71, 72, 72, 73,
     73, 74, 74, 74, 75, 76, 76,237,237, 15,238, 79, 79,  1,  1,  2,
     96, 96, 97, 97, 98, 99, 99,100,100,101,101,102,102,103,103,104,
      3,105,106,107,107,108,108,109,109,110,110,111,  5,  5,  6,  6,
    119,120,120,121,121,122,123,123,124,124,125,125,126,127,127,  8,
    138,139,140,140,141,142,142,143, 13, 13, 14, 14, 15, 15, 78,238,
    141,143, 13, 14, 15, 78, 79, 79,157,158,159,159,  9,110, 10,  5,
    145,146, 71, 72, 74, 76, 77,239, 94, 96,135,136, 31, 33, 35, 37,
    185,185,186,186,187,188,188,189,189, 45, 46, 47, 47, 47, 47,  2,
     96, 98, 99,101,102,204,204,204,204,205,206,206,207,241,242,243,
     94, 96,134,135,146, 69, 70,166,166,166,166,167,167,167,167,167,
     94, 95,144,145,145,164,164,164,167, 43, 44, 44, 79,  1,  1,  2,
    243,244,244,245,245,246,246,  0, 70,164,255,253,254,254,110,142
    },
    {//15
      0,  7,  8,110, 95,  7,  7,  8,  8, 11,127,127,  8, 79, 79,  1,
    136,136,137,138,139,139,140,141,141, 73,143,143, 13,236, 14, 14,
     15, 15, 44, 44, 44, 44, 47, 47, 47, 47, 47, 47, 47, 47,  2,  2,
     97, 98,134,135,135,136,136,146,146,147,147, 71, 72, 72, 73, 73,
     74, 74, 74, 75,150, 76,237,237, 15,238,238, 79, 79,  1,  1,  2,
     97, 97, 98, 98, 99,100,100,101,101,101,102,102,103,104,104,  3,
    105,106,106,107,107,108,109,109,110,110,111,  5,  5,  5,  6,  6,
    120,120,121,121,122,122,123,123,124,124,125,125,126,127,127,  8,
    139,140,140,141,142,142,143, 13, 13, 14, 14, 15, 15, 78, 78, 79,
    142, 13, 14,151, 15, 78, 79,  1,158,159,159,  9,  9,111, 10,  5,
    145,147, 72, 73, 75, 76,238,239, 95, 98,136,137, 70, 34, 35, 37,
    185,186,186,187,188,188,189,189, 45, 46, 47, 47, 47, 47, 47,  2,
     97, 98,100,101,103,205,205,205,205,205,206,206,207,241,242,243,
     95, 97,135,136, 69, 70, 71,166,166,166,167,167,167,167,167,167,
     95, 97,152,145,145,164,164,165, 43, 44, 44, 44, 79,  1,  1,  2,
    243,244,244,245,245,246,246,  0, 71, 69, 99,253,254,254,110,142
    },
    {//16
      0,  7,  8,110, 97,  7,  7,  8,  8, 11,127,127,  8, 79,  1,  1,
    137,137,138,139,139,140,141,141,142,142,143, 13,236, 14, 14,237,
     15, 15,238, 44, 44, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,
     98,152,136,136,136,137,137,137,147,147, 71, 72, 72, 73, 73, 73,
     74, 75,150,150, 76,237,237, 15, 15,238, 79, 79, 79,  1,  1,  2,
     98, 98, 99, 99,100,101,101,101,102,102,103,103,104,  3,  3,105,
    106,106,107,108,108,109,109,109,110,111,111,  5,  5,  5,  6,  6,
    120,121,121,122,122,123,123,124,124,124,125,126,126,127,127,  8,
    140,140,141,142,142,143, 13, 13, 14, 14, 14, 15, 15, 78, 79, 79,
    143, 13, 14, 15, 78, 79, 79,  1,158,159,159,  9,110,111, 10,  5,
    146,147, 72, 74, 75, 76,238,239, 97, 98,136,138, 71, 34, 36, 38,
    186,187,187,188,188,189,189, 45, 45, 46, 47, 47, 47, 47,  2,  2,
     98, 99,101,102,104,205,205,205,205,206,206,207,207,241,242,243,
     97, 98,136,137,147, 71, 72,166,166,167,167,167,167,167,167, 43,
     97,152,152,145,146, 69,165,165, 44, 44, 44, 47, 79,  1,  1,  2,
    243,244,244,245,245,246,246,  0, 72, 69,100,254,254,254,111,143
    },
    {//17
      0,  7,  8,111, 98,  7,  7,  8,  0,  6,127,  7,  8, 79,  1,  1,
    138,139,139,140,140,141,141,142,143, 13, 13, 13, 14, 14, 15, 15,
     15,238,238,238,239,239,239, 47, 47, 47, 47,  2,  2,  2,  2,  2,
     99,100,136,137,137,138,138,138,139,139,148, 73, 73, 73, 74, 74,
     75,150, 76, 76,237,237, 15, 15,238,238, 79, 79,  1,  1,  2,  2,
     99,100,100,100,101,101,102,102,103,103,104,104,  3,105,105,106,
    107,107,108,108,109,109,109,110,110,111,  5,  5,  5,  6,  6,  6,
    121,121,122,122,122,123,123,124,124,125,125,126,126,127,127,  8,
    141,141,142,142,143, 13, 13, 14, 14, 15, 15, 15, 78, 79, 79, 79,
     13, 14, 14, 15, 78, 79,  1,  1,159,159,  9,  9,111, 10,  5,  5,
    147,148, 73, 74, 76, 77,238,239, 98,100,137,139, 72, 36, 37, 39,
    187,187,188,188,189,189, 45, 45, 46, 47, 47, 47, 47, 47,  2,  2,
     99,101,102,103,  3,205,205,205,205,206,206,207,241,242,243,244,
     98, 99,137,138,147, 72, 73,166,167,167,167,167,167,167, 44, 44,
     98,152,153,146,147,147,165,165, 44, 44, 44, 47, 79,  1,  2,  2,
    244,244,245,245,246,246,  0,  0, 72, 71,101,254,254,254,111, 13
    },
    {//18
      0,  7,  8,111, 99,  7,  8,  8,  0,  6,127,  7,  8,  1,  1,  1,
    139,139,140,141,141,142,142,143, 13, 13, 14, 14, 14, 15, 15, 15,
    238,238,238,239,239,239,239,239,239,239,  2,  2,  2,  2,  2,  2,
    100,101,137,138,138,139,139,139,140,148, 73, 73, 74, 74, 74, 75,
    150, 76, 76,237,237, 15,238,238,238, 79, 79,  1,  1,  1,  2,  2,
    100,101,101,101,102,102,103,103,104,104,  3,  3,105,106,106,107,
    107,108,108,109,109,109,110,110,111,  5,  5,  5,  5,  6,  6,  6,
    121,121,122,122,123,123,124,124,125,125,125,126,127,127,  7,  8,
    141,142,142,143, 13, 13, 14, 14, 15, 15, 15, 78,111, 79, 79,  5,
     13, 14, 15, 78, 79, 79,  1,  1,159,  9,  9,110,111,  5,  5,  1,
    147,148, 74, 75, 76, 77,239,239, 99,101,139,140, 73, 36, 38, 40,
    187,188,188,189,189, 45, 45, 46, 47, 47, 47, 47, 47,  2,  2,  2,
    100,101,103,104,105,206,206,206,206,206,207,207,241,242,243,244,
     99,100,138,139,148, 73, 73,167,167,167,167,167,167, 44, 44, 44,
     99,153,153,147,147, 72, 72,166, 44, 44,239, 47,  1,  1,  2,  2,
    244,244,245,245,246,246,  0,  0, 73, 72,102,254,254,109,111, 14
    },
    {//19
      0,  8,  8,  5,100,  7,  8,  8,  0,  6,127,  8,  8,  1,  1,  2,
    140,140,141,142,142,142,143, 13, 14, 14, 14, 14, 15, 15,238,238,
    238,238,239,239,239,239,239,239,  1,  2,  2,  2,  2,  2,  2,  2,
    101,102,139,139,139,140,140,140,141,141,149,149, 74,150,150,150,
     76,237,237, 15, 15,238,238,238, 79, 79,239,  1,  1,  2,  2,  2,
    101,102,102,102,103,104,104,104,  3,  3,105,106,106,107,107,108,
    108,108,109,109,109,110,110,111,111,  5,  5,  5,  6,  6,  6,  7,
    122,122,122,123,123,124,124,124,125,125,126,126,127,127,  8,  8,
    142,143, 13, 13, 14, 14, 14, 15, 15,110, 78, 79, 79, 79,  5,  1,
     14, 15, 15, 78, 79, 79,  1,  1,109,  9,110,111,  5,  5,  1,  6,
    148,148, 75, 76, 77,238,239,239,100,102,140,141, 73, 38, 39, 41,
    188,188,189,189, 45, 45, 46, 47, 47, 47, 47, 47, 47,  2,  2,  2,
    101,103,104,  3,106,206,206,206,206,207,207,241,242,242,243,244,
    100,101,139,140,148, 73, 74,167,167,167,167,167, 44, 44, 44, 44,
    100,154,154,147,148,148, 72,166,239,239,239, 47,  1,  1,  2,  2,
    244,244,245,245,246,246,  0,  0, 74,148,103,254,254,110,  5, 14
    },
    {//20
      0,  8,  8,  5,101,  7,  8,  8,  0,  6,  7,  8,  8,  1,  1,  2,
    141,141,142,142,143, 13, 13, 14, 14, 14, 15, 15, 15,238,238,238,
    239,239,239,239,239,239,239,  1,  2,  2,  2,  2,  2,  2,  2,  2,
    102,103,140,140,140,141,141,141,149,149,143,236,150,150, 76, 14,
    237, 15, 15, 15,238,238,238, 79, 79,239,  1,  1,  1,  2,  2,  2,
    102,103,103,104,104,  3,  3,105,105,106,106,106,107,107,108,108,
    109,109,109,110,110,110,111,111,  5,  5,  5,  6,  6,  6,  6,  7,
    122,122,123,123,124,124,124,125,125,125,126,126,127,127,  8,  8,
    143, 13,107,108, 14,109,109, 15,110,110,111, 79, 79,  5,  1,  1,
     14, 15, 78, 79, 79,  1,  1,  2,  9,110,111,111,  5,  5,  1,  6,
    148,149, 75, 76, 77,238,239,239,101,103,141,142,143,150, 40, 41,
    189,189, 45, 45, 45, 46, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,
    102,104,  3,106,107,206,206,206,206,207,241,241,242,243,244,244,
    101,103,140,141,149, 74, 75,167,167,167, 76, 77,238, 44,239,239,
    101,155,155,148,148,148, 74, 74,239,239,239,239,  1,  2,  2,  2,
    244,245,245,245,246,246,  0,  0, 74, 74,104,254,254,110,  5, 15
    },
    {//21
      0,  8,  8,  5,103,  7,  8,  8,  0,127,  7,  8,  8,  1,  2,  2,
    142,142,143, 13, 13, 13, 14, 14, 15, 15, 15, 15,238,238,238,239,
    239,239,239,239,239,239,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,
    104,104,  3,141,141,142,142,142,143, 13,236,150, 14, 14,237,237,
     15, 15,238,238,238,238, 79, 79,239,  1,  1,  1,  2,  2,  2,  7,
    104,104,  3,  3,  3,105,106,106,106,107,107,107,108,108,108,109,
    109,109,110,110,110,111,  5,  5,  5,  5,  5,  6,  6,  6,  7,  7,
    123,123,123,124,124,124,125,125,125,126,126,127,127,127,  8,  8,
    107,108,108,109,109,109,110,110,110,111,111, 79,  5,  1,  1,  1,
     15, 78, 78, 79,  1,  1,  1,  2,110,111,111,  5,  5,  5,  6,  6,
    149, 75, 76, 77,238,239,239,  1,103,104,142,143, 13, 14, 40, 43,
    189, 45, 45, 46, 46, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,
    104,  3,106,107,108,207,207,207,207,207,241,242,242,243,244,244,
    103,104,141,142,143, 75, 76, 76, 76, 77, 77,238,238,239,239,239,
    103,155,156,156,149, 74, 75, 75,239,239,239,239,  1,  2,  2,  7,
    244,245,245,246,246,246,  0,  0, 75, 74,105,254,254,111,  5, 15
    },
    {//22
      0,  8,  8,  5,104,  8,  8,  0,  0,  7,  7,  8,  8,  2,  2,  2,
    143, 13, 13, 14, 14, 14, 15, 15, 15, 15,238,238,238,238,239,239,
    239,239,239,239,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
      3,105,105,142,142,143,143, 13, 13,236, 14, 14,237, 15, 15, 15,
     15,238,238,238, 79, 79,239,239,  1,  1,  1,  1,  2,  2,  2,  7,
      3,105,105,106,106,106,107,107,107,108,108,108,109,109,109,109,
    110,110,110,111,111,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,
    123,123,124,124,124,125,125,125,126,126,126,127,127,127,  8,  8,
    108,109,109,109,110,110,110,111,111,111,  5,  5,  5,  1,  1,  1,
     78, 78, 79, 79,  1,  1,  2,  2,111,111,  5,  5,  5,  6,  6,  6,
    149, 75,151, 77,238,239,239,  2,104,105,143, 13, 14, 15, 44, 44,
     45, 45, 46, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,
      3,106,107,108,109,207,207,207,207,241,242,242,243,243,244,245,
    104,  3,142,143,236, 76, 76, 77, 77,238,238,238,239,239,239,239,
    104,  3,156,157, 75, 75, 75, 75,239,239,239,  1,  2,  2,  2,  8,
    245,245,245,246,246,246,  0,  0, 76, 75,106,254,109,111,  6,238
    },
    {//23
      0,  8,  8,  6,105,  8,  8,  0,  0,  7,  8,  8,  0,  2,  2,  2,
     13, 14, 14, 14, 14, 15, 15, 15,238,238,238,238,239,239,239,239,
    239,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,
    106,106,106, 13, 13, 13, 13, 14, 14, 14,237, 15, 15, 15,238,238,
    238,238, 79, 79,239,239,  1,  1,  1,  1,  1,  2,  2,  2,  7,  8,
    106,106,106,107,107,107,108,108,108,109,109,109,109,110,110,110,
    110,111,111,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,
    124,124,124,124,125,125,125,126,126,126,127,127,127,  8,  8,  8,
    109,109,110,110,110,111,111,111,  5,  5,  5,  1,  1,  1,  6,  2,
     78, 79, 79,  1,  1,  1,  2,  2,111,  5,  5,  5,  6,  6,  6,127,
     75,151, 77, 78, 79,239,  1,  2,105,106, 13, 14, 15, 15, 44, 44,
     46, 47, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,  8,
    106,107,108,109,109,241,241,241,241,242,242,243,243,244,244,245,
    105,106, 13, 13, 14,237, 77,238,238,238,239,239,239,239,239,239,
    105,106,157,158, 75, 75, 76, 76,239,239,  1,  2,  2,  2,  7,  8,
    245,245,245,246,246,246,  0,  0,237, 76,107,254,110,  5,  6,111
    },
    {//24
      0,  8,  8,  6,106,  8,  8,  0,  0,  7,  8,  8,  0,  2,  2,  7,
     14, 14, 15, 15, 15, 15,238,238,238,238,239,239,239,239,239,  1,
      1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,
    107,107,108,108, 14, 14, 14, 14, 15, 15, 15, 15,238,238,238,238,
     79, 79, 79,239,  1,  1,  1,  1,  1,  2,  2,  2,  2,  7,  7,  8,
    107,107,108,108,108,108,109,109,109,109,109,110,110,110,110,111,
    111,111,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,  7,
    124,124,125,125,125,125,126,126,126,126,127,127,127,  8,  8,  8,
    110,110,110,111,111,111,  5,  5,  5,  5,  1,  1,  1,  6,  2,  2,
     79, 79,  1,  1,  1,  2,  2,  2,  5,  5,  5,  6,  6,  6,127,  7,
    151, 77, 78, 79,239,  1,  1,  2,106,107, 14, 15, 15,238,239, 47,
     47, 47, 47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,  8,  8,
    107,108,109,109,110,242,242,242,242,242,243,243,244,244,245,245,
    106,107,108, 14, 15, 15,238,238,239,239,239,239,239,239,239,239,
    106,107,158,159,151,151, 77, 77,239,  1,  2,  2,  2,  2,  7,  8,
    245,245,246,246,246,246,  0,  0, 77,151,108,110,111,  5,  6,111
    },
    {//25
      0,  8,  0,  6,108,  8,  8,  0,  0,  7,  8,  8,  0,  2,  7,  7,
    109, 15,110,110,238,238,238,239,239,239,239,239,  1,  1,  1,  1,
      1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,
    108,109,109,109,109, 15, 15, 15, 15,238,238,238,238, 79, 79,239,
    239,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  7,  7,  8,  8,
    108,108,109,109,109,109,109,110,110,110,110,110,111,111,111,  5,
      5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  8,
    125,125,125,125,126,126,126,126,127,127,127,127,  7,  8,  8,  0,
    111,111,111,111,  5,  5,  5,  5,  1,  1,  1,  6,  6,  2,  2,  2,
      5,  1,  1,  1,  2,  2,  2,  7,  5,  6,  6,  6,  6,  7,  7,  7,
      9, 78, 78, 79,  1,  1,  2,  2,108,109,109, 15,238,238,239, 47,
     47, 47, 47, 47, 47, 47,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,
    108,109,109,110,111,242,242,242,242,243,243,244,244,244,245,245,
    108,108,109, 15, 15,238,238,239,239,239,239,239,239,239,  1,  1,
    108,108,159,  9, 77, 77, 78, 78,  1,  2,  2,  2,  2,  7,  8,  8,
    245,246,246,246,246,  0,  0,  0,238, 78,109,110,  5,  5,  6,  5
    },
    {//26
      0,  8,  0,  7,109,  8,  8,  0,  0,  8,  8,  8,  0,  7,  7,  8,
    110,111,111,111,111, 79,239,239,  1,  1,  1,  1,  1,  1,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  8,  8,
    109,109,110,110,110,110,238,238,238, 79, 79, 79, 79,239,  1,  1,
      1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  7,  7,  8,  8,  8,
    109,109,110,110,110,110,110,111,111,111,111,  5,  5,  5,  5,  5,
      5,  5,  6,  6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,  8,  8,
    125,125,126,126,126,126,126,127,127,127,127,127,  8,  8,  8,  0,
    111,  5,  5,  5,  5,  5,  1,  1,  6,  6,  6,  2,  2,  2,  7,  7,
      1,  1,  1,  2,  2,  2,  7,  7,  6,  6,  6,  6,  7,  7,  7,  7,
     78, 79, 79,  1,  1,  2,  2,  2,109,109,110,238,239,239,239, 47,
     47, 47, 47,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,
    109,110,110,111,  5,243,243,243,243,243,244,244,244,245,245,246,
    109,109,110, 78,238, 79,239,239,239,239,239,  1,  1,  1,  2,  2,
    109,109,  9,  9, 78, 78, 78, 78,  2,  2,  2,  2,  7,  7,  8,  8,
    246,246,246,246,246,  0,  0,  0,239, 78,110,111,  5,  6,  7,  1
    },
    {//27
      0,  8,  0,  7,110,  8,  0,  0,  0,  8,  8,  0,  0,  7,  8,  8,
    111,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  8,  8,  8,  0,
    110,111,111,111,111,111, 79, 79, 79, 79,  1,  1,  1,  1,  1,  1,
      1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  7,  7,  8,  8,  8,  8,
    110,111,111,111,111,111,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,
      6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,
    126,126,126,126,126,127,127,127,127,127,  7,  8,  8,  8,  0,  0,
      5,  5,  5,  6,  6,  6,  6,  6,  6,  2,  2,  2,  7,  7,  7,  7,
      6,  6,  2,  2,  7,  7,  8,  8,  6,  6,  6,  7,  7,  7,  7,  8,
     10, 79,  1,  1,  2,  2,  2,  2,110,111,111,  5,  1,  1,  1,  2,
      2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  0,
    110,111,111,  5,  5,244,244,244,244,244,244,245,245,245,245,246,
    110,110,111, 79, 79,239,239,  1,  1,  1,  1,  2,  2,  2,  2,  2,
    110,110,111, 10, 10, 10, 10, 10,  2,  2,  2,  2,  7,  8,  8,  8,
    246,246,246,246,  0,  0,  0,  0,239, 79,111,  5,  6,  6,  7,  6
    },
    {//28
      0,  0,  0,  7,111,  0,  0,  0,  0,  8,  8,  0,  0,  8,  8,  8,
      5,  5,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,
      5,  5,  5,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  7,  7,  7,  8,  8,  8,  8,  8,  8,
      5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  6,
      6,  6,  6,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,
    126,126,127,127,127,127,127,127,  7,  8,  8,  8,  8,  8,  0,  0,
      6,  6,  6,  6,  6,  6,  2,  7,  7,  7,  7,  7,  7,  7,  8,  8,
      2,  2,  7,  7,  7,  8,  8,  8,  7,  7,  7,  7,  7,  8,  8,  8,
      1,  1,  1,  2,  2,  2,  2,  8,111,  5,  5,  1,  1,  2,  2,  2,
      2,  2,  2,  2,  2,  2,  2,  2,  8,  8,  8,  8,  8,  8,  0,  0,
      5,  5,  5,  6,  6,244,244,244,244,245,245,245,245,246,246,246,
    111,  5,  5,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    111,  5,  5,  1,  1,  1, 11, 11,  2,  2,  2,  8,  8,  8,  8,  0,
    246,246,246,246,  0,  0,  0,  0,  1,  1,  5,  6,  6,  7,  7,  2
    },
    {//29
      0,  0,  0,  8,  5,  0,  0,  0,  0,  8,  0,  0,  0,  8,  8,  8,
      6,  6,  6,  2,  2,  2,  2,  2,  2,  2,  7,  7,  7,  7,  7,  7,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      6,  6,  6,  6,  6,  6,  6,  6,  2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,
      6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  7,  7,  7,
      7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  0,
    127,127,127,127,127,  7,  7,  8,  8,  8,  8,  8,  8,  0,  0,  0,
      6,  6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,
      7,  7,  7,  8,  8,  8,  8,  8,  7,  7,  7,  8,  8,  8,  8,  8,
      1,  2,  2,  2,  2,  8,  8,  8,  5,  6,  6,  6,  2,  2,  2,  2,
      2,  2,  2,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      6,  6,  6,  6,  6,245,245,245,245,245,245,245,246,246,246,246,
      5,  6,  6,  6,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  8,
      5,  6,  6,  1,  1, 11, 11, 12,  8,  8,  8,  8,  8,  8,  0,  0,
    246,246,246,  0,  0,  0,  0,  0,  2,  2,  6,  6,  7,  7,  8,  7
    },
    {//30
      0,  0,  0,  8,  6,  0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,
      7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      6,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,
      7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  0,  8,  8,  8,  8,  8,  8,  8,  0,
      2,  7,  7,  8,  8,  8,  8,  0,  6,  7,  7,  7,  7,  7,  8,  8,
      8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      7,  7,  7,  7,  7,246,246,246,246,246,246,246,246,246,246,  0,
      6,  6,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      6,  6,  7,  2,  2,  2, 12, 12,  8,  8,  8,  0,  8,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  7,  2,  7,  7,  8,  8,  8,  8
    },
    {//31
      0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  0,  0,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,246,246,246,246,246,246,246,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,
      8,  8,  8,  8,  8,  8,  8,  8,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  8,  8,  8,  8,  8,  0,  0,  8
    },
    {//32 invulnerability colormap
      4, 81, 80, 89,  0, 81, 80, 80,  4, 85, 83, 81, 80, 87, 86, 84,
    109,108,106,  3,104,102,101,100, 98, 97, 96, 95, 94, 93, 92, 91,
     90, 89, 88, 87, 87, 86, 85, 85, 84, 83, 82, 82, 82, 81, 81, 80,
      7,  6,  6,  5,111,110,109,109,108,106,105,104,103,101,100,100,
     98, 97, 96, 96, 95, 94, 92, 92, 91, 89, 88, 87, 86, 85, 84, 83,
      7,  6,  5,  5,110,109,109,107,106,105,104,103,102,101,100, 99,
     98, 97, 96, 95, 94, 93, 92, 91, 90, 88, 88, 87, 86, 85, 84, 83,
    108,106,104,102,100, 98, 96, 95, 93, 91, 89, 87, 85, 83, 81, 80,
    104,103,101,100, 99, 98, 97, 96, 95, 93, 93, 92, 91, 90, 88, 88,
     98, 96, 95, 93, 91, 89, 87, 85, 96, 95, 93, 92, 90, 89, 87, 86,
      7,109,105,101, 97, 93, 90, 86,  0,  6,110,106,102, 99, 96, 92,
     89, 88, 87, 87, 87, 86, 85, 85, 84, 84, 83, 83, 82, 81, 81, 80,
      7,110,106,102, 98, 94, 90, 87, 83, 82, 82, 81, 81, 80, 80, 80,
      0,  7,  5,110,108,105,103,101, 99, 98, 97, 96, 95, 93, 92, 91,
      0,  0,  8,  7,  7,  6,  5,  5, 91, 89, 88, 87, 87, 85, 83, 82,
     80, 80, 80,  4,  4,  4,  4,  4,  3,111,105, 95, 91, 88, 85, 97
    },
    {//33
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
    }
};

// dynamic command line parsing variables

char **clfiles;			// dynamic array of dynamic parameter strings
int nclfiles;			// number of strings in array
char **cloptions;		// dynamic array of dynamic option strings
int *cloptsense;		// polarity of option - vs. / or +
int nclopts;			// number of strings in array
char **clstrs;			// dynamic array of dynamic argument strings
int nclstrs;			// number of strings in array
char cmdline[256];

// Routines for maintaining a dynamic list of dynamic strings or integers

// Add a string at the end of a dynamic array of dynamic strings

void AddDynStr(char ***dynstrp,int *ndynstr,char *str)
{
	// add one more dynamic string pointer to array

	*dynstrp = (char **) realloc(*dynstrp, (*ndynstr+1)*sizeof(char *));

	// allocate the bytes for new string on new pointer

	(*dynstrp)[*ndynstr] = (char *) malloc(1+strlen(str));
	strcpy((*dynstrp)[*ndynstr],str);	// copy string bytes and terminator

	(*ndynstr)++;						// note one more dynamic string
}

// deallocate a dynamic array of dynamic strings

void FreeDynStr(char ***dynstrp,int *ndynstr)
{
	int i;

	for (i=0;i<*ndynstr;i++)			// free the strings
		free((*dynstrp)[i]);
	free(*dynstrp);						// free array of string pointers
	*ndynstr = 0;
	*dynstrp = NULL;					// ready for next use
}

// Add an integer to a dynamic array of them

void AddDynInt(int **dynintp,int *n,int val)
{
	// add one more integer

	*dynintp = (int *) realloc(*dynintp, ((*n)+1)*sizeof(int));
	(*dynintp)[*n] = val;

	(*n)++;
}

// deallocate a dynamic array of integers

void FreeDynInt(int **dynintp,int *n)
{
	free(*dynintp);
	*n = 0;
	*dynintp = NULL;
}

void DelDynInt(int **dynintp,int *n,int idx)
{
	// delete the idx-th integer

	if (*dynintp==NULL || n==0 || idx<0)
		return;

	if (idx<*n-1)
		memmove((*dynintp)+idx,(*dynintp)+idx+1,*n-1-idx);
	(*n)--;
	if (*n>0)
	{
		*dynintp = (int *) realloc(*dynintp, (*n)*sizeof(int));
	}
	else FreeDynInt(dynintp,n);
}

// Routines to support command line parsing

void InitCLStrs()
{
	clstrs=NULL;
	nclstrs=0;
	nclopts=nclfiles=0;
	cloptions=clfiles=NULL;
	cloptsense=NULL;
}

void FreeCLStrs()
{
	int zero=nclopts;

	FreeDynStr(&clstrs,&nclstrs);
	FreeDynStr(&clfiles,&nclfiles);
	FreeDynStr(&cloptions,&nclopts);
	FreeDynInt(&cloptsense,&zero);
}

// Add the tokens in str delimited by chars in dlm to the dynamic
// array of dynamic strings *dynstrp of length *ndynstr

int Tokenize (char *str,char *dlm,char ***dynstrp,int *ndynstr)
{
	char *t,*s;

	s = strdup(str);
	t = strtok(s,dlm);
	while (t!=NULL)
	{
		AddDynStr(dynstrp,ndynstr,t);
		t = strtok(NULL,dlm);
	}
	xlibfree(s);
	return *ndynstr;
}

// Add the next n-1 tokens in str delimited by chars in dlm to the dynamic
// array of dynamic strings *dynstrp of length *ndynstr. Then if str not
// exhausted add the remainder of str (minus initial delimiters) as
// one more string.

int TokenizeN (char *str,char *dlm,char ***dynstrp,int *ndynstr, int n)
{
	char *t,*s;
	int cnt=0,p;

	s = strdup(str);
	t = strtok(s,dlm);			 				        // 0-th string
	while (t!=NULL && ++cnt<n)
	{
		AddDynStr(dynstrp,ndynstr,t); 			  // add cnt-1 th string
		t = strtok(NULL,cnt==n-1? "" : dlm);	// on last call get rest
	}
	p = strspn(t,dlm);			 				        // skip delims before last
	AddDynStr(dynstrp,ndynstr,t+p);				  // add rest as n-1th string

	xlibfree(s);
	return *ndynstr;
}

// Read the specified environment variable and use it as default command
// line if present. Add the command line arguments at the end.

void CopyEnvironmentCLArgs(char *envar,int arc,char **arv)
{
	char *p,*q;
	int i;

	if ((p = getenv(envar))!=NULL)
	{
		strcpy(cmdline,p);
		q=strdup(p);
		Tokenize(q," \t",&clstrs,&nclstrs);
		xlibfree(q);
	}
	for (i=1;i<arc;i++)
	{
		AddDynStr(&clstrs,&nclstrs,arv[i]);
		strcat(cmdline," ");
		strcat(cmdline,arv[i]);
	}
}

// Read the command line arguments and separate options and parameters

int ParseCommandLine(int maxopts,int maxfiles)
{
	int i,j,k,m,n;
	char temp[128];
	
	nclfiles=nclopts=0;
	for (i=0;i<nclstrs;i++)
	{
		if (clstrs[i][0]=='-' || clstrs[i][0]=='/' || clstrs[i][0]=='+')
		{
			if (maxopts>=0 && nclopts==maxopts)
			{
				printf("Only %d options allowed on command line\n",maxopts);
				return(1);
			}
			k = n = nclopts;
			strcpy(temp,clstrs[i]+1);
			Tokenize(temp,"-/+",&cloptions,&n);
			for (j=0,m=0;j<n-k;j++)
			{
				AddDynInt(&cloptsense,&nclopts,clstrs[i][m]=='-'? 0 : 1);
				m += 1+strlen(cloptions[k+j]);
			}					  
		}
		else
		{
			if (maxfiles>=0 && nclfiles==maxfiles)
			{
				printf("Only %d parameters allowed on command line\n",maxfiles);
				return(1);
			}
			AddDynStr(&clfiles,&nclfiles,clstrs[i]);
		}
	}
	return 0;
}

// safe fwrite that stops on write error

void SafeWrite(const void *buffer, int siz, int n, FILE *st)
{
	clearerr(st);
	if (fwrite(buffer,siz,n,st)<n)
	{
		if (ferror(st))
		{
			perror("I/O error during file write, out of space?");
			exit(2);
		}
	}
}

// Write a byte array to .BMP file

void WriteBMP(BYTE *out,int logw,int logh,char *rbmpname,RGBQUAD *pal)
{
	int i,wid;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	int fhsiz,ihsiz;
	FILE *st;
	char bmpname[256],tbmpname[256];
	char *p=NULL;

	strcpy(bmpname,rbmpname);

	fhsiz = sizeof(BITMAPFILEHEADER);
	ihsiz = sizeof(BITMAPINFOHEADER);
	wid = 4*((logw+3)/4);
	bmfh.bfType = 19778;
	bmfh.bfSize = fhsiz+ihsiz+256L*sizeof(RGBQUAD)+wid*logh;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = fhsiz+ihsiz+256L*sizeof(RGBQUAD);

	bmih.biSize = ihsiz;
	bmih.biWidth = logw;
	bmih.biHeight = logh;
	bmih.biPlanes = 1;
	bmih.biBitCount = 8;
	bmih.biCompression = BI_RGB;
	bmih.biSizeImage = wid*logh;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	bmih.biClrUsed = 256;
	bmih.biClrImportant = 256;

 	st = fopen(bmpname,"wb");
	if (st!=NULL)
	{
		SafeWrite(&bmfh.bfType,sizeof(bmfh.bfType),1,st);
		SafeWrite(&bmfh.bfSize,sizeof(bmfh.bfSize),1,st);
		SafeWrite(&bmfh.bfReserved1,sizeof(bmfh.bfReserved1),1,st);
		SafeWrite(&bmfh.bfReserved2,sizeof(bmfh.bfReserved2),1,st);
		SafeWrite(&bmfh.bfOffBits,sizeof(bmfh.bfOffBits),1,st);

		SafeWrite(&bmih.biSize,sizeof(bmih.biSize),1,st);
		SafeWrite(&bmih.biWidth,sizeof(bmih.biWidth),1,st);
		SafeWrite(&bmih.biHeight,sizeof(bmih.biHeight),1,st);
		SafeWrite(&bmih.biPlanes,sizeof(bmih.biPlanes),1,st);
		SafeWrite(&bmih.biBitCount,sizeof(bmih.biBitCount),1,st);
		SafeWrite(&bmih.biCompression,sizeof(bmih.biCompression),1,st);
		SafeWrite(&bmih.biSizeImage,sizeof(bmih.biSizeImage),1,st);
		SafeWrite(&bmih.biXPelsPerMeter,sizeof(bmih.biXPelsPerMeter),1,st);
		SafeWrite(&bmih.biYPelsPerMeter,sizeof(bmih.biYPelsPerMeter),1,st);
		SafeWrite(&bmih.biClrUsed,sizeof(bmih.biClrUsed),1,st);
		SafeWrite(&bmih.biClrImportant,sizeof(bmih.biClrImportant),1,st);
		SafeWrite(pal,sizeof(RGBQUAD),256,st);

		for (i=0;i<logh;i++)
			SafeWrite(out+(logh-1-i)*logw,sizeof(BYTE),wid,st);

		fclose(st);
	}
	else printf("Cannot open bitmap %s for write\n",bmpname);
}

// Reads BMP file
// Header is read for real width, and logical height
// Logical width is next multiple of 4 greater than or equal to real width
// Bitmap is written to byte array *out, allocated to fit
// *out is allocated and read as logical width by logical height
//
// memory is allocated on *out
//
void ReadBMP(BYTE **out,int *logw,int *realw,int *logh,char *rbmpname,RGBQUAD *pal)
{
	int i,n;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	FILE *st;
	char *buffer=NULL;
	char bmpname[256],tbmpname[256];
	char *p=NULL;

	strcpy(bmpname,rbmpname);

	*logw = *logh = *realw = 0;
   	st = fopen(bmpname,"rb");
	if (st!=NULL)
	{
		fread(&bmfh.bfType,sizeof(bmfh.bfType),1,st);
		fread(&bmfh.bfSize,sizeof(bmfh.bfSize),1,st);
		fread(&bmfh.bfReserved1,sizeof(bmfh.bfReserved1),1,st);
		fread(&bmfh.bfReserved2,sizeof(bmfh.bfReserved2),1,st);
		fread(&bmfh.bfOffBits,sizeof(bmfh.bfOffBits),1,st);
		fread(&bmih.biSize,sizeof(bmih.biSize),1,st);
		fread(&bmih.biWidth,sizeof(bmih.biWidth),1,st);
		fread(&bmih.biHeight,sizeof(bmih.biHeight),1,st);
		fread(&bmih.biPlanes,sizeof(bmih.biPlanes),1,st);
		fread(&bmih.biBitCount,sizeof(bmih.biBitCount),1,st);
		fread(&bmih.biCompression,sizeof(bmih.biCompression),1,st);
		fread(&bmih.biSizeImage,sizeof(bmih.biSizeImage),1,st);
		fread(&bmih.biXPelsPerMeter,sizeof(bmih.biXPelsPerMeter),1,st);
		fread(&bmih.biYPelsPerMeter,sizeof(bmih.biYPelsPerMeter),1,st);
		fread(&bmih.biClrUsed,sizeof(bmih.biClrUsed),1,st);
		fread(&bmih.biClrImportant,sizeof(bmih.biClrImportant),1,st);
		fread(pal,sizeof(RGBQUAD),256,st);

		*realw = bmih.biWidth;
		*logw = 4*((bmih.biWidth+3)/4);
		*logh = bmih.biHeight;

		n = (*logw)*(*logh);

		buffer = malloc(n);
		fseek(st,bmfh.bfOffBits,SEEK_SET);
		fread(buffer,n,1,st);

		*out = (BYTE *)malloc(n);

		for (i=(*logh)-1;i>=0;i--)
			memmove((*out)+((*logh)-1-i)*(*logw),buffer+(*logw)*i,*logw);
		fclose(st);
		free(buffer);
	}
	else printf("WARNING: bitmap for %s not supplied\n",bmpname);
}

void AddExt(char *str,char *ext)
{
	char *p,*q;

	if (!str || !*str)
		return;

	p = strrchr(str,'\\');		// last backslash
	q = strrchr(str,'.');		// last period
	if (p && q && q<p)			// if is a backslash, and the . is before it
		strcat(str,ext);		// add an extension, since there is none
	else if (q)					// else if is a period, replace the extension
	{							
		*q='\0';
		strcat(str,ext);
	}
	else if (!q)				// else if no period, default the extension
		strcat(str,ext);
}

// convert an 8 character buffer to a static 9 character string

char *Str8(char *buff)
{
	static char bf[9];

	strncpy(bf,buff,8);
	bf[8]='\0';
	return bf;
}

// directory processing routines

/* Initialize a new directory */

void InitDir(WadDir *d)
{
	d->allentries=0;
	d->nentries=0;
	d->dirp = NULL;
}

/* Free a directory */

void FreeDir(WadDir *d)
{
	d->allentries=0;
	d->nentries=0;
	free(d->dirp);
	d->dirp = NULL;
}

/* set a wad directory entry to values passed in */

void SetDirEntry(WadDirEntry *wde,unsigned long iresptr, unsigned long ireslen, char *iresname)
{
	wde->resptr = iresptr;
	wde->reslen = ireslen;
	strncpy(wde->resname,iresname,8);
}

/* Add a directory entry to the wad, allocate more memory if necessary
   and initialize the new directory entry */

int AddDirEntry(WadDir *wdd,unsigned long iresptr, unsigned long ireslen, char *iresname)
{
	char resn[16];

	if (wdd->nentries>=wdd->allentries)
	{
		wdd->allentries += 256;
		wdd->dirp = realloc(wdd->dirp,wdd->allentries*sizeof(WadDirEntry));
	}

	strcpy(resn,Str8(iresname));
	strupr(resn);
		
	SetDirEntry(&wdd->dirp[wdd->nentries++],iresptr,ireslen,resn);
	return 0;
}

/* Read the directory from a wad file with header hdr to the specified
   dir structure */

int ReadDir(WadHeader *hdr,WadDir *dir,FILE *st)
{
	WadDirEntry wde;
	int entry;

	fseek(st,hdr->waddiraddr,SEEK_SET);
	for (entry=0;entry<hdr->waddirlen;entry++)
	{
		fread(&wde,sizeof(WadDirEntry),1,st);
		AddDirEntry(dir,wde.resptr,wde.reslen,Str8(wde.resname));
	}
	return 0;
}

/* Get location of resource in directory or return -1 */

int IsIn(char *res,WadDir *d)
{
	int i;

	for (i=0;i<d->nentries;i++)
		if (strnicmp(res,d->dirp[i].resname,8)==0) return i;

	return -1;
}

// Main colormap creation routine

int main(int argc,char **argv)
{
	char filename[256];
	FILE *st;
	int logw,logh,realw;

	InitCLStrs();
	CopyEnvironmentCLArgs("CMAPTOOL",argc,argv);
	if (ParseCommandLine(-1,-1))
	{
		FreeCLStrs();
		return 3;
	}

  if (!nclopts && !nclfiles)
  {
      printf("\nCMAPTOOL.EXE 1.01b by Jim Flynn, Copyright 1998 -- Freeware --\n");
      printf("\nCreate a COLORMAP lump from an edited BMP, or generate the source BMP\n");
      printf("\nUsage 1: CMAPTOOL /G\n");
			printf("  generates DOOMCOLR.BMP from DOOM's palette\n");
      printf("\nUsage 2: CMAPTOOL colormap[.LMP] [edited[.BMP]]\n");
			printf("  creates colormap lump specified from edited DOOMCOLR.BMP\n");
      printf("\nUsage 3: CMAPTOOL /W:MYWAD[.WAD] /G\n");
			printf("  generates DOOMCOLR.BMP using palette in MYWAD.WAD\n");
      printf("\nUsage 4: CMAPTOOL /W:MYWAD[.WAD] colormap[.LMP] [edited[.BMP]]\n");
			printf("  creates colormap lump specified from edited DOOMCOLR.BMP\n");
			printf("  using the PLAYPAL and COLORMAP from MYWAD.WAD\n");

			FreeCLStrs();
      return 1;
  }

	if (nclopts)
	{
		int i;

		for (i=0;i<nclopts;i++)
		{
			if (tolower(cloptions[i][0])=='g')
			{
		   	char *out;
			 	int i,j;

			 	out = malloc(128*256);
			 	for (i=127;i>=0;i--)
				 	for (j=0;j<256;j++)
					  	out[256*i+j] = j;

			 	printf("Writing DOOMCOLR.BMP\n");
			 	WriteBMP(out,256,128,"DOOMCOLR.BMP",DoomPalette);
			 	free(out);
		   	FreeCLStrs();
			 	return 0;
			}
			else if (tolower(cloptions[i][0])=='w' && cloptions[i][1]==':')
			{
				int p,q,j;
				unsigned char *ppal,*pptr;
				char wadname[256];
				WadHeader whdr;
				WadDir wdir;

				strcpy(wadname,cloptions[i]+2);
				AddExt(wadname,".WAD");
				printf("Reading PLAYPAL and COLORMAP from %s\n",wadname);
				st = fopen(wadname,"rb");
				if (st)
				{
					InitDir(&wdir);
					fread(&whdr,sizeof(WadHeader),1,st);
					ReadDir(&whdr,&wdir,st);
					p = IsIn("PLAYPAL",&wdir);
					q = IsIn("COLORMAP",&wdir);
					if (p<0 || q<0)
					{
						printf("Wad %s does not contain a PLAYPAL\n",wadname);
						FreeDir(&wdir);
						FreeCLStrs();
						return 1;
					}

					// read the PLAYPAL into DoomPalette
					ppal = malloc(768);
					fseek(st,wdir.dirp[p].resptr,SEEK_SET);
					fread(ppal,768,1,st);
					for (j=0,pptr=ppal;j<256;j++)
					{
						DoomPalette[j].rgbBlue = *pptr++;
						DoomPalette[j].rgbGreen = *pptr++;
						DoomPalette[j].rgbRed = *pptr++;
						DoomPalette[j].rgbReserved = 0;
					}
					free(ppal);

					// read the COLORMAP into ColorMap
					fseek(st,wdir.dirp[q].resptr,SEEK_SET);
					fread(&ColorMap[0][0],256,34,st);

					fclose(st);
					FreeDir(&wdir);
				}
				else
				{
					printf("Can't open %s\n",wadname);
					FreeDir(&wdir);
					FreeCLStrs();
					return 1;
				}
			}
		}
	}

	if (nclfiles<3)
	{
		int i,j;
		char buffer[256];
		char infile[256];
    BYTE *out;

		if (nclfiles>1)
			strcpy(infile,clfiles[1]);
		else
			strcpy(infile,"DOOMCOLR");
		AddExt(infile,".BMP");

		ReadBMP(&out,&logw,&realw,&logh,infile,InPal);

		strcpy(filename,clfiles[0]);
		AddExt(filename,".LMP");

		st = fopen(filename,"wb");
		if (st)
	  {
			for (i=0;i<34;i++)
			{
				for (j=0;j<256;j++)
					 buffer[j] = out[ColorMap[i][j]];
  			SafeWrite(buffer,256,1,st);
			}
			fclose(st);
			free(out);
			FreeCLStrs();
			printf("COLORMAP %s created\n",filename);
			return 0;
	  }
		else
		{
			printf("Cannot open %s for output\n",filename);
			free(out);
			FreeCLStrs();
			return 1;
		}
	}
	FreeCLStrs();
	printf("Too many parameters specified\n");
  exit(1);
}
