@echo OFF
echo. Welcome to Army of Darkness DOOM!
echo. This installation routine will only work with Ultimate DOOM ver. 1.9
echo. Hit CTRL-C NOW if this is incorrect.
echo.
pause

rem
rem Check the DOOM 1 files
rem
echo. DOOM.EXE and DOOM.WAD must be in the current directory
if not exist DOOM.EXE goto fail1
if not exist DOOM.WAD goto fail1
goto checkfiles

:fail1
echo. DOOM.EXE or DOOM.WAD not found! Installation aborted.
pause
exit

rem
rem Check if all needed files are in the current directory
rem 

:checkfiles
if not exist AODTCSPR.WAD goto fail2
if not exist AODTCMS1.WAD goto fail3
if not exist AODTCTX1.WAD goto fail4
if not exist AODTCLV1.WAD goto fail5
if not exist AODTCSND.WAD goto fail6
if not exist AODTCUDM.DEH goto fail7
if not exist DEHACKED.EXE goto fail8
if not exist DEUSF.EXE goto fail9
goto startinstall

:fail2
echo. Sprites not found! (AODTCSPR.WAD) Install aborted.
exit

:fail3
echo. Music not found! (AODTCMS1.WAD) Install aborted.
exit

:fail4
echo. Textures & Flats not found! (AODTCTX1.WAD) Install aborted.
exit

:fail5
echo. Level & GFX not found! (AODTCLV1.WAD) Install aborted.
exit

:fail6
echo. Sound WAD not found! (AODTCSND.WAD) Install aborted.
exit

:fail7
echo. DeHackEd Patch not found! (AODTCUDM.DEH) Install aborted.
exit

:fail8
echo. DeHackEd not found! (DEHACKED.EXE) Install aborted.
exit

:fail9
echo. DeuSF not found! (DEUSF.EXE) Install aborted.
exit

:startinstall
echo. Alright! You got all needed files.
echo. Patching EXE
copy doom.exe doomhack.exe
dehacked -load aodtcudm.deh
ren doomhack.exe aod.exe

echo. Preparing WAD.
deusf -merge aodtcspr.wad
deusf -merge aodtctx1.wad
echo. Ready!
echo.
echo. Preparing to play Army of Darkness Doom...
pause
echo.|aod -file aodtclv1.wad aodtcsnd.wad aodtcms1.wad
