echo OFF
echo.      ************************
echo.      *    Starwars DOOM     *
echo.      ************************
echo.
echo.
echo.   This file is for DOOM I  1.9, 1.7, 1.7a and 1.666
echo.
echo. If you don't have one of these version, you'd better hit CTRL-C
echo.
pause
rem
rem Check the DOOM files
rem
if not exist DOOM.EXE goto fail
if not exist DOOM.WAD goto fail
goto checkthem
rem
:fail
echo.   ERROR:
echo.   Can't Find DOOM I files DOOM.WAD or DOOM.EXE
echo.   please move Starwars to the doom directory.
pause
goto end
rem
rem Check the archive contents
rem
:checkthem
echo Checking STARWARS.WAD
if not exist STARWARS.WAD goto missfile
echo Checking starwars.deh
if not exist starwars.deh goto missfile
echo Checking DEUSF.EXE
if not exist DEUSF.EXE goto missfile
echo Checking DEHACKED.EXE
if not exist DEHACKED.EXE goto missfile
goto checkok
rem
rem
:missfile
echo.
echo. ERROR:
echo.   The above file is Missing from the archives
echo.   You can't play Starwars without it.
pause
goto end
rem
rem Check if dehacked.ini exists, and complain
rem
:checkok
echo. Copying DOOM.EXE in DOOMHACK.EXE
If exist DOOMHACK.EXE goto rundhe
copy DOOM.EXE DOOMHACK.EXE
rem
rem APPLY DEHACKED
rem
:rundhe
echo Applying Dehacked patch for DOOM I
Dehacked -reload -load STARWARS.DEH
if ERRORLEVEL 0             goto rundeusf
echo.
echo. ERROR:
echo. The DOOM executable could not be modified.
echo.
pause
goto end

:rundeusf
REN DOOM.EXE STARWARS.EXE
REN DOOMHACK.EXE DOOM.EXE
rem
echo.
echo. Merging STARWARS.WAD into the main WAD
echo. This may take a while on some computers.
if exist starwars.log goto restore
DeuSF -doom . -join doom.wad starwars.wad > starwars.log
if ERRORLEVEL 0             goto restore
echo. Error:
echo. An error occured while completing sprite and flat merge.
echo. Did you have enough disk space? 
pause
goto end
:restore
rem
rem Restoration
rem
echo echo off > RESTORE.BAT
echo deusf -doom . -res >> RESTORE.BAT
echo del starwars.log >> RESTORE.BAT
echo if exist STARWARS.EXE  del STARWARS.EXE >> RESTORE.BAT
echo.
echo. ************ INSTALL IS COMPLETE ***************
echo. To play                   type:   STARWARS
echo.
echo. To restore the files      type:   RESTORE
echo. (This saves some disk space, and is necessary
echo.  before you distribute the Starwars files again)
echo.
:end
