echo OFF
echo. --------Wolfenstein Sprites and Sounds Conversion--------
echo.
echo.   By R.Hutchison
echo.
echo.   This batch is for DOOM II  1.9
echo.
echo. May possibly work with other versions. 
echo. If you wish to abort press CTRL-C
echo.
pause

rem
rem Check the DOOM files
rem
if not exist DOOM2.EXE goto fail
if not exist DOOM2.WAD goto fail
goto checkthem

rem
:fail
echo.   ERROR:
echo.   Can't Find DOOM II files DOOM2.WAD or DOOM2.EXE
echo.   please move Wolfenstein files to the doom2 directory.
pause
goto end
rem
rem Check the archive contents
rem
:checkthem
echo Checking WOLFSPT.WAD
if not exist WOLFSPT.WAD goto missfile
echo Checking WOLFSND.WAD
if not exist WOLFSND.WAD goto missfile
echo Checking WOLF.DEH
if not exist WOLF.DEH goto missfile
echo Checking DEUSF.EXE
if not exist DEUSF.EXE goto missfile
echo Checking DEHACKED.EXE
if not exist DEHACKED.EXE goto missfile
goto checkok
rem
rem
:missfile
echo.
echo. ERROR:
echo.   The above file is Missing from the archives
echo.   You can't properly install Wolfenstein sprites without it.
pause
goto end
rem
rem Check if dehacked.ini exists, and complain
rem
:checkok
if not exist DEHACKED.INI goto saveexe
echo.
echo. WARNING:
echo. A dehacked.ini file exists here. That could compromise this
echo. installation if you have DOOM II version 1.666.
echo. Please hit CTRL-C and delete or rename that file if you're not
echo. sure you really need it.
echo.
pause
goto saveexe
rem
rem
rem
:saveexe
echo. Copying DOOM2.EXE in DOOMHACK.EXE
If exist DOOMHACK.EXE goto rundhe
copy DOOM2.EXE DOOMHACK.EXE
rem
rem APPLY DEHACKED
rem
:rundhe
echo Applying Dehacked patch for DOOM II
Dehacked -reload -load WOLF.DEH
if ERRORLEVEL 0             goto rundeusf
echo.
echo. ERROR:
echo. The DOOM executable could not be modified.
echo.
pause
goto end

:rundeusf
rem
rem  APPLY DEUSF
echo.
echo. Creating new sprite PWAD with DeuSF
echo. This uses about 3 more meg of disk space and takes some time
echo.
if exist WOLF.log goto restore
DeuSF -doom . -sprites -app wolfspt.wad > wolfspt.log
if ERRORLEVEL 0             goto restore
echo. Error:
echo. An error occured while completing sprite wad.
echo. Did you have enough disk space?
pause
goto end

:restore
rem
rem Restoration
rem
echo echo off > RESTORE.BAT
echo deusf -doom . -res wolfspt.WAD >> RESTORE.BAT
echo del wolfspt.log >> RESTORE.BAT
echo if exist DOOMHACK.EXE  del DOOMHACK.EXE >> RESTORE.BAT

echo echo off > WOLF.BAT
echo echo. WOLFENSTEIN CHARACTER, by Robert Hutchison >> WOLF.BAT
echo echo. Type RESTORE to restore the WOLFENSTEIN files >> WOLF.BAT
echo doomhack -file wolfspt.wad wolfsnd.wad >> WOLF.BAT

echo. ************ INSTALL IS COMPLETE ***************
echo.
echo. We hope you will enjoy WOLFENSTEIN for DOOM2!
echo.
echo. To play                   type:   WOLF

echo.
echo. To restore the files      type:   RESTORE
echo. (This saves some disk space, and is necessary
echo.  before you distribute the Wolfenstein files again)
echo.
echo. To play network games you will have to type NETWORK
echo. To restore everything after a network game type RESTORE
echo.
:end
