' DEHACK - Doom Exe HACK
' by Matt Fell (matt.burnett@acebbs.com)
' written 3/5/94, last revised 6/13/94
'
' DEHACK 3 - The FRAME TABLE
'
' These crude programs extract information from the DOOM.EXE or DOOM.WAD
' files and store it into a TXT file, suitable for perusing or printing.
' If you want to print the results, you might have to reformat it. Please
' don't waste reams of paper. Thanks.
' All of these only work on the 1.2 registered doom.exe, because I use
' simple byte offset numbers, not search strings.
'
' IMPORTANT: If you don't like typing pathnames, modify the next section,
' un-comment it, and remove or comment-out the input section.

' infile$ = "c:\doom\doom.exe"
' outfile$ = "c:\-\doom\12\dehack3.txt"

CLS
PRINT "Enter the full pathname to your DOOM.EXE file, then the full pathname"
PRINT "to where you want the textfile to be (in an already existing directory)"
PRINT "e.g. 'c:\doom\doom.exe' and 'c:\doom\txt\dehack3.txt'"
PRINT "Note: modify the program with built-in pathnames, and skip this!"
PRINT
INPUT infile$
INPUT outfile$

OPEN infile$ FOR BINARY AS 1
OPEN outfile$ FOR OUTPUT AS 2

PRINT #2, "The 'Frame Table' contained in DOOM.EXE version 1.2 2-17-94"
PRINT #2, "List-making program was written by Matt Fell (matt.burnett@acebbs.com)"
PRINT #2, "=========================================================================="
PRINT #2, "Note that the first column/index # is not actually in the table, all the"
PRINT #2, "records have a constant length (28 bytes), so they are found by a"
PRINT #2, "calculation, not a bunch of pointers."
PRINT #2, "The columns are: (4 and 5 are 2-byte integers, the others are 4-byte)"
PRINT #2, "  0. Frame number (used in THING TABLE)"
PRINT #2, "  1. Sprite number. 0 is TROO (imp), ..., 104 is SMRT (small red torch)"
PRINT #2, "  2. Sprite sub-type number. An example sequence is SMRT, it goes from"
PRINT #2, "     frame 508, which is '104:0', to frame 511, which is '104:3'. 0"
PRINT #2, "     corresponds to 'A' in the fifth spot in a sprite's entryname in"  
PRINT #2, "     DOOM.WAD, likewise 1 is B, 2 is C, etc. So 104:3 is 'SMRTD0'"  
PRINT #2, "     Also, if bit 15 is set (I indicate this with a * symbol), then it"
PRINT #2, "     means the frame is drawn using colormap 0, i.e. it ignores the"
PRINT #2, "     light levels, for that glow-in-the-dark effect"
PRINT #2, "  3. Duration, how long this frame stays until displaying the next one."
PRINT #2, "     -1 means forever."
PRINT #2, "  4. ?"
PRINT #2, "  5. ?"
PRINT #2, "  6. Next frame # for continuing animation sequences. Note that many"
PRINT #2, "     return to their first frame, creating endless loops. I think that"
PRINT #2, "     a next frame of 0 means 'no next frame', not frame # 0."
PRINT #2, "  7. always 0"
PRINT #2, "  8. always 0"
PRINT #2, ""
PRINT #2, "Yes, the terminology is sloppy. Too many possible meanings for 'frame'."
PRINT #2, "I welcome any suggestions for improvement."
PRINT #2, "=========================================================================="

pointer& = 555945               ' this is for 1.2 doom

FOR i& = 0 TO 511
PRINT #2, USING "####"; i&;
PRINT #2, " ";
FOR j% = 0 TO 24 STEP 4
        GET #1, pointer& + i& * 28 + j%, num&
               
        SELECT CASE j%
        CASE 4
                IF (num& > 32767) AND (num& < 65536) THEN
                        num& = (num& - 32768)
                        sep$ = "*"
                ELSE
                        sep$ = " "
                END IF
                PRINT #2, USING "####"; num&;
                PRINT #2, sep$;
        CASE 12
                PRINT #2, USING "####"; (num& AND 255);
                PRINT #2, " ";
                PRINT #2, USING "####"; INT(num& / 256);
                PRINT #2, " ";
        CASE ELSE
                PRINT #2, USING "####"; num&;
                PRINT #2, " ";
        END SELECT
               
NEXT j%
PRINT #2, " "
NEXT i&

END

