// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Function prototypes for input.cpp
EBool ConfirmQuit(void);
int   Getinput(int promptlen, char *string, int maxlen, int type, int x1, char firstchar = 0);
int   GetThingWindow(int curfield);
void  GoPageDown(void);
void  GoPageUp(void);
int   Inputtext(EBool showonly);
int   Printgowindow(void);
int   Printinputwindow(char *buffer, char *prompt, EInptype type, int length, char firstchar = 0);
EBool ProcessKeypress(void);
EBool ProcessMouse(void);
int   Sortfunction(const void *a, const void *b);
EBool Waitforevent(EBool eatevent);

// Which fields belong to which thing windows...
char fieldinfo[5][2] = { 1, 10,	// Misc
								11, 15,	// Sound
								16, 23,	// Frame
								24, 39,	// bit1
								40, 55}; // bit2

// Field info for the rest of the modes
char fieldinfo2[NUMSCREENS] = {0, 6, 0, 3, 1, 1, 4};

// Page-up/page-down arrow locations
int arrows[NUMSCREENS][4] = {77,  5, 77, 23,
									  76,  8, 76, 42,
									  60, 20, 60, 30,
									  64,  8, 64, 42,
									  54,  8, 54, 42,
									  77,  8, 77, 42,
									  76,  8, 76, 42};

// Variables from dehacked.cpp
extern ERedraw redraw;					// Current redraw state
extern EModes  mode;						//	The mode we start in
extern FILE *doomexefp;					// File pointer to doom.exe
extern FILE *doomwadfp; 		      // File pointer to doom.wad
extern FILE *doombakfp;					// File pointer to doom backup exe
extern EVersions version;           // The Doom version we're using
extern char curdir[MAXPATHLEN+1];			// Directory at start of program
extern EBool changes;					// If changes have been made or not

extern char doompath[80];				// Directory to run doom from
extern char doomexe[80];				// Doom.exe file name
extern char doomargs[80];				// Arguments when Doom is run

extern unsigned long (*thingdata )[THING_FIELDS];
extern unsigned long (*framedata )[FRAME_FIELDS];
extern unsigned long (*sounddata )[SOUND_FIELDS];
extern unsigned long (*weapondata)[WEAPON_FIELDS];
extern unsigned long *spritedata;
extern unsigned long *maxammodata;
extern unsigned long *perammodata;
extern char *textdatap;

extern int numobj[NUMDATA][NUMVERS];
extern int global[NUMSCREENS][5];
extern char thingorder[THING_FIELDS];

// Functions from dehacked.cpp
extern void AbortProg(char *func);
extern void Changemode(EModes newmode);
extern int  Getcopyinfo(void);
extern int  GotoObject(int firstdigit);
extern void Highlight(unsigned char attribute);
extern int  RunExe(void);

// Functions from print.cpp
extern int   Gettextnum(int offset);
extern void  Printhelp(void);
extern void  Printintro(void);
extern EBool Printwindow(char *message, int type);

// Variables from print.cpp
extern char *namelist[138];

// Functions from screen.cpp
extern void CPrintfXY(int x, int y, char *string, ...);
extern void CPutsXY(int x, int y, char *string);
extern void Drawframe(int type, unsigned char attr, int left, int top,
							 int right, int bot);

// Functions from files.cpp
extern int  GetDoomFiles(char *arg1);
extern void Loaddoom(FILE *exefp);
extern int  Loadpatch(char *filename);
extern int  OldSave(char *filename, EBool Overwrite);
extern int  Savepatch(char *filename, EBool Overwrite);
extern void Writedoom(void);
extern void Dumpdata(void);

// From playview.cpp
extern void Playsound(long soundnum);
extern int  Showframe(long framenum);

// Variables from files.cpp
extern unsigned char thingconvar[104];			// Thing # conversion array

#ifdef HAVE_MOUSE
// Functions from mouse.cpp
extern void  CloseMouse(void);
extern void  hideMouseCursor(void);
extern void  InitMouse(void);
extern void  showMouseCursor(void);
extern EBool getLastEvent(unsigned *x, unsigned *y, EButton *left_button,
								  EButton *right_button);

// Variables from mouse.h
extern unsigned eventButtons;
extern unsigned LastEventButtons;
extern EBool eventHappened;        // these vars to use getLastEvent
extern long lclicktime;
#endif /* HAVE_MOUSE */

// Array of pointers to update functions
typedef int (*funcptr)();
extern funcptr Updatefunc[NUMSCREENS];

// Referenced for the posdata array
// Row of first data | num rows of data | type of mode (1 = columns)

char posinfo[NUMSCREENS][3] = { 0, 55, 0,
										 55,  6, 1,
										 61,  8, 0,
										 69,  3, 1,
										 72,  1, 1,
										 73,  1, 1,
										 74,  4, 1};

// y coord, x start, x end, hilite start, hilite end
char Fielddata[][5] = {13,  5, 30, 21, 31,
							  14,  5, 30, 21, 31,
							  15,  5, 30, 21, 31,
							  16,  5, 30, 21, 31,
							  17,  5, 30, 21, 31,
							  18,  5, 30, 21, 31,
							  19,  5, 30, 21, 31,
							  20,  5, 30, 21, 31,
							  21,  5, 30, 21, 31,
							  22,  5, 30, 21, 31,
								4, 40, 65, 55, 66,
								5, 40, 65, 55, 66,
								6, 40, 65, 55, 66,
								7, 40, 65, 55, 66,
								8, 40, 65, 55, 66,
							  15, 37, 66, 57, 67,
							  16, 37, 66, 57, 67,
							  17, 37, 66, 57, 67,
							  18, 37, 66, 57, 67,
							  19, 37, 66, 57, 67,
							  20, 37, 66, 57, 67,
							  21, 37, 66, 57, 67,
							  22, 37, 66, 57, 67,
							  29, 11, 37, 15, 17,
							  30, 11, 37, 15, 17,
							  31, 11, 37, 15, 17,
							  32, 11, 37, 15, 17,
							  33, 11, 37, 15, 17,
							  34, 11, 37, 15, 17,
							  35, 11, 37, 15, 17,
							  36, 11, 37, 15, 17,
							  37, 11, 37, 15, 17,
							  38, 11, 37, 15, 17,
							  39, 11, 37, 15, 17,
							  40, 11, 37, 15, 17,
							  41, 11, 37, 15, 17,
							  42, 11, 37, 15, 17,
							  43, 11, 37, 15, 17,
							  44, 11, 37, 15, 17,
							  29, 41, 67, 45, 47,
							  30, 41, 67, 45, 47,
							  31, 41, 67, 45, 47,
							  32, 41, 67, 45, 47,
							  33, 41, 67, 45, 47,
							  34, 41, 67, 45, 47,
							  35, 41, 67, 45, 47,
							  36, 41, 67, 45, 47,
							  37, 41, 67, 45, 47,
							  38, 41, 67, 45, 47,
							  39, 41, 67, 45, 47,
							  40, 41, 67, 45, 47,
							  41, 41, 67, 45, 47,
							  42, 41, 67, 45, 47,
							  43, 41, 67, 45, 47,
							  44, 41, 67, 45, 47,

								0, 21, 26, 22, 26,
								0, 27, 29, 28, 30,
								0, 34, 36, 35, 37,
								0, 41, 50, 42, 51,
								0, 51, 59, 52, 60,
								0, 60, 69, 61, 70,

							  22, 21, 50, 38, 50,
							  23, 21, 50, 38, 50,
							  24, 21, 50, 38, 50,
							  25, 21, 50, 38, 50,
							  26, 21, 50, 38, 50,
							  27, 21, 50, 38, 50,
							  28, 21, 50, 38, 50,
							  29, 21, 50, 38, 50,

								0, 34, 41, 35, 42,
								0, 43, 49, 44, 50,
								0, 52, 61, 53, 62,

								0, 36, 42, 36, 44,

								0, 13, 74, 13, 75,

								0, 32, 38, 32, 39,
								0, 40, 47, 40, 48,
								0, 51, 55, 51, 56,
								0, 59, 65, 59, 66};
