
#include <sys/time.h>
#include <stdlib.h>
#include <stdio.h>
#include "keyboard.h"

// Define C functions that are used here...
extern "C" {
	extern void bzero(void *data, int len);
	extern int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
};

TTY_Keyboard:: TTY_Keyboard(void)
{
	keyboard_state = COOKED;
	do_refresh = 0;
	App_Refresh = NULL;
}

TTY_Keyboard:: ~TTY_Keyboard()
{
	if ( keyboard_state != COOKED )
		raw(COOKED);
}
const int &
TTY_Keyboard::getstate(void)
{
	return(keyboard_state);
}
int
TTY_Keyboard:: raw(int newstate)
{
	if ( newstate == RAW )
		system("stty -echo raw");
	else
		system("stty -raw echo");
	keyboard_state = newstate;
	return(0);
}

#ifdef linux
#define STDIO_PEEK(stream)	(stream->_IO_read_ptr < stream->_IO_read_end)
#else
#ifdef _SGI_SOURCE
#define STDIO_PEEK(stream)	(stream->_cnt)
#else
#error What machine are we compiling for?
#endif /* _SGI_SOURCE */
#endif /* linux */

int
TTY_Keyboard:: pending_input(float do_wait)
{
	fd_set fdset;
	struct timeval tv;
	
	/* Does the stdio buffer have anything in it? */
	if ( STDIO_PEEK(stdin) )
		return(1);

	/* Check the pending input */
	FD_ZERO(&fdset);
	FD_SET(0, &fdset);
	tv.tv_sec = ((int)do_wait);
	tv.tv_usec = (int)((do_wait-((int)do_wait))*1000);

	return(select(64, &fdset, NULL, NULL, &tv));
}

int
TTY_Keyboard:: getch(void)
{
static struct { int fcode; char *fstring; int valid; } func_keys[] = {
/* Console Keymap */
	{ F1,	"[[A", 1 },
	{ F2,	"[[B", 1 },
	{ F3,	"[[C", 1 },
	{ F4,	"[[D", 1 },
	{ F5,	"[[E", 1 },
	{ F6,	"[17~", 1 },
	{ F7,	"[18~", 1 },
	{ F8,	"[19~", 1 },
	{ HOME,	"[1~", 1 },
	{ UP,	"[A", 1 },
	{ PGUP,	"[5~", 1 },
	{ LEFT,	"[D", 1 },
	{ RIGHT,"[C", 1 },
	{ END,	"[4~", 1 },
	{ DOWN,	"[B", 1 },
	{ PGDN,	"[6~", 1 },
/* Xterm Keymap */
	{ F1,	"[11~", 1 },
	{ F2,	"[12~", 1 },
	{ F3,	"[13~", 1 },
	{ F4,	"[14~", 1 },
	{ F5,	"[15~", 1 },
	{ F6,	"[17~", 1 },
	{ F7,	"[18~", 1 },
	{ F8,	"[19~", 1 },
	{ HOME,	"[H",	 1 },
	{ END,	"Ow", 1 },
/* SGI xwsh keymap (incomplete) */
	{ F1, "^[[001q", 1 },
	{ F2, "^[[002q", 1 },
	{ F3, "^[[003q", 1 },
	{ F5, "^[[005q", 1 },
	{ F6, "^[[006q", 1 },
	{ F7, "^[[007q", 1 },
	{ F8, "^[[008q", 1 },
/* Terminate the list */
	{ 0, NULL } };

	static int extended=0;
	int c, ret, i, valid;

	if ( (c=getchar()) == EOF )
		return(-1);

	if ( ! extended ) {
		if ( c == '\033' ) {
			if ( (ret=pending_input(1)) == 0 )
				return('\033');
			else if ( ret < 0 )
				return(256);
			extended=1;
			return(0);
		} else if ( c == ('H'-'@') ) {
			return(BKSP);
		} else if ( c == 127 ) {
			return(BKSP);
		} else
			return(c);
	}

	/* Otherwise, return the extended character code... */
	for ( i=0; func_keys[i].fstring; ++i )
		func_keys[i].valid=1;
	valid=1;

	while ( valid ) {
		for ( i=0, valid=0; func_keys[i].fstring; ++i ) {
			if ( func_keys[i].valid ) {
				++valid;
				if ( func_keys[i].fstring[extended] == c ) {
					if ( func_keys[i].fstring[extended+1] == '\0' ) {
						extended=0;
						return(func_keys[i].fcode);
					}
				} else
					func_keys[i].valid=0;
			}
		}
		++extended;
		c=getchar();
	}
	extended=0;

	// What function key??
	return(256);
}

void
TTY_Keyboard:: set_refresh_f(void (*func)())
{
	App_Refresh=func;
}

void
TTY_Keyboard:: toggle_refresh(int flag)
{
	do_refresh=flag;
}
