/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
		
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/



#include "deutex.h"
#include "tools.h"
#include "mkwad.h"
#include "sound.h"
#include "text.h"

/*compile only for DeuTex*/
#if defined DeuTex


/*********************** WAVE *********************/

static struct RIFFHEAD
{ char  riff[4];
  Int32 length;
  char 	wave[4];
} headr;
static struct CHUNK
{ char name[4];
  Int32 size;
} headc;
static struct WAVEFMT/*format*/
{ char            fmt[4];
  Int32 fmtsize;    /*0x10*/
  Int16 tag;        /*format tag. 1=PCM*/
  Int16 channel;    /*1*/
  Int32 smplrate;
  Int32 bytescnd;   /*average bytes per second*/
  Int16 align;      /*block alignment, in bytes*/
  Int16 nbits;      /*specific to PCM format*/
}headf;
static struct WAVEDATA /*data*/
{  char data[4];
   Int32 datasize;
}headw;

static void SNDsaveWave(char *file,char huge *buffer,Int32 size,Int32 speed)
{
  FILE *fp;
  Int32 wsize,sz=0;
  fp=fopen(file,FOPEN_WB);
  if(fp==NULL)
  { ProgError("WAV: can't write %s",file);
  }
  /*header*/
  strncpy(headr.riff,"RIFF",4);
  headr.length=BE_Int32(4+sizeof(struct WAVEFMT)+sizeof(struct WAVEDATA)+size);
  strncpy(headr.wave,"WAVE",4);
  fwrite(&headr,sizeof(struct RIFFHEAD),1,fp);
  strncpy(headf.fmt, "fmt ",4);
  headf.fmtsize=BE_Int32(sizeof(struct WAVEFMT)-8);
  headf.tag=BE_Int16(1);
  headf.channel=BE_Int16(1);
  headf.smplrate=BE_Int32(speed);
  headf.bytescnd=BE_Int32(speed);
  headf.align=BE_Int16(1);
  headf.nbits=BE_Int16(8);
  fwrite(&headf,sizeof(struct WAVEFMT),1,fp);
  strncpy(headw.data,"data",4);
  headw.datasize=BE_Int32(size);
  fwrite(&headw,sizeof(struct WAVEDATA),1,fp);
  for(wsize=0;wsize<size;wsize+=sz)
  { sz= (size-wsize>MEMORYCACHE)? MEMORYCACHE:(size-wsize);
    if(fwrite((buffer+(wsize)),(size_t)sz,1,fp)!=1)ProgError("WAV: write error");
  }
  fclose(fp);
}

char huge *SNDloadWaveFile(char *file, Int32 *psize, Int32 *pspeed)
{ FILE *fp;
  Int32 wsize,sz=0,smplrate,datasize;
  Int32 chunk;
  char huge *data;
  fp=fopen(file,FOPEN_RB);
  if(fp==NULL)				ProgError("WAV: can't read file %s",file);
  /*read RIFF HEADER*/
  if(fread(&headr,sizeof(struct RIFFHEAD),1,fp)!=1)
					ProgError("WAV: can't read header");
  /*check RIFF header*/
  if(strncmp(headr.riff,"RIFF",4)!=0)	ProgError("WAV: wrong header");
  if(strncmp(headr.wave,"WAVE",4)!=0)	ProgError("WAV: wrong header");
  chunk=sizeof(struct RIFFHEAD);
  for(sz=0;;sz++)
  { if(sz>256)  ProgError("WAV: no fmt");
    fseek(fp,chunk,SEEK_SET);
    if(fread(&headc,sizeof(struct CHUNK),1,fp)!=1)ProgError("WAV: no fmt");
    if(strncmp(headc.name,"fmt ",4)==0)break;
    chunk+=BE_Int32(sizeof(struct CHUNK)+headc.size);
  }
  fseek(fp,chunk,SEEK_SET);
  fread(&headf,sizeof(struct WAVEFMT),1,fp);
  if(BE_Int16(headf.tag)!=1) ProgError("WAV: not raw data");
  if(BE_Int16(headf.channel)!=1) ProgError("WAV: not one channel");
  smplrate=BE_Int32(headf.smplrate);
  
  for(sz=0;;sz++)
  { if(sz>256)  ProgError("WAV: no data");
    fseek(fp,chunk,SEEK_SET);
    if(fread(&headc,sizeof(struct CHUNK),1,fp)!=1) ProgError("WAV: no data");
    if(strncmp(headc.name,"data",4)==0)break;
    chunk+=BE_Int32(sizeof(struct CHUNK)+headc.size);
  }
  fseek(fp,chunk,SEEK_SET);
  if(fread(&headw,sizeof(struct WAVEDATA),1,fp)!=1) ProgError("WAV: no data");
  datasize=BE_Int32(headw.datasize);
  /*check WAVE header*/
  if(datasize>0x100000L)           	ProgError("WAV: sample too long!");
  /*read data*/
  data=(char huge *)Malloc(datasize);
  for(wsize=0;wsize<datasize;wsize+=sz)
  { sz = (datasize-wsize>MEMORYCACHE)? MEMORYCACHE:(datasize-wsize);
    if(fread((data+(wsize)),(size_t)sz,1,fp)!=1)    	ProgError("WAV: can't read data of%s",file);
  }
  fclose(fp);
  *psize=datasize;
  *pspeed=smplrate&0xFFFFL;
  return data;
}


/***************** AU **********************/
struct AUHEAD
{ char snd[4];	/*.snd*/
  Int32 dataloc;  /*LITTLE ENDIAN*/
  Int32 datasize; /*LITTLE ENDIAN*/
  Int32 format;	  /*LITTLE ENDIAN*/
  Int32 smplrate; /*LITTLE ENDIAN*/
  Int32 channel;  /*LITTLE ENDIAN*/
  char  info[4];
};
static struct AUHEAD heada;
/*char data[datasize] as signed char*/

static void SNDsaveAu(char *file,char huge *buffer,Int32 size,Int32 speed)
{ FILE *fp;
  Int32 i,wsize,sz=0;
  fp=fopen(file,FOPEN_WB);
  if(fp==NULL)ProgError("WAV: can't write %s",file);
  /*header*/
  strncpy(heada.snd,".snd",4);
  heada.dataloc=LE_Int32(sizeof(struct AUHEAD));
  heada.datasize=LE_Int32(size);
  heada.format=LE_Int32(2L); /*8 bit linear*/
  heada.smplrate=LE_Int32(speed);
  heada.channel=LE_Int32(1L);
  heada.info[0]='\0';
  if(fwrite(&heada,sizeof(struct AUHEAD),1,fp)!=1)ProgError("AU: write error");
  for(i=0;i<size;i++)
  { buffer[i]-=0x80;
  }
  for(wsize=0;wsize<size;wsize+=sz)
  { sz= (size-wsize>MEMORYCACHE)? MEMORYCACHE:(size-wsize);
    if(fwrite((buffer+(wsize)),(size_t)sz,1,fp)!=1)ProgError("AU: write error");
  }
    fclose(fp);
}
char huge *SNDloadAuFile(char *file, Int32 *psize, Int32 *pspeed)
{ FILE *fp;
  Int32 wsize,sz=0,i,smplrate,datasize;
  char huge *data;
  fp=fopen(file,FOPEN_RB);
  if(fp==NULL)				ProgError("AU: can't read file %s",file);
  /*read AU HEADER*/
  if(fread(&heada,sizeof(struct AUHEAD),1,fp)!=1)

  /*check AU header*/
  if(strncmp(heada.snd,".snd",4)!=0)	ProgError("AU: not an audio file.");
  /*read RIFF HEADER*/
  if(heada.format!=LE_Int32(2L))		ProgError("AU: not linear 8 bit.");
  if(heada.channel!=LE_Int32(1L))	ProgError("AU: not one channel.");

  if(fseek(fp,heada.dataloc,SEEK_SET))  ProgError("AU: bad header");
  smplrate=LE_Int32(heada.smplrate);
  datasize=LE_Int32(heada.datasize);
  /*check WAVE header*/
  if(smplrate!=11025)
	Warning("sample rate of %s is %u instead of 11025",file,smplrate);
  if(datasize>0x100000L)
	ProgError("AU: sample too long!");
  /*read data*/
  data=(char huge *)Malloc(datasize);
  for(wsize=0;wsize<datasize;wsize+=sz)
  { sz = (datasize-wsize>MEMORYCACHE)? MEMORYCACHE:(datasize-wsize);
    if(fread((data+(wsize)),(size_t)sz,1,fp)!=1) ProgError("WAV: can't read data of%s",file);
  }
  fclose(fp);
  /*convert from signed to unsigned char*/
  for(i=0;i<datasize;i++) data[i]+=0x80;
  /*return*/
  *psize=datasize;
  *pspeed=smplrate&0xFFFFL;
  return data;
}


/*********************** VOC *********************/
#define VOCIDLEN (0x013)
static char VocId[]="Creative Voice File";
static struct VOCHEAD
{ char ident[VOCIDLEN];  /*0x13*/
  char eof;       /*0x1A*/
  short block1;   /*offset to block1=0x1A*/
  short version;  /*0x010A*/
  short version2; /*0x2229*/
}headv;
static struct VOCBLOCK1
{ char  type;   /*1=sound data.0=end block*/
  char  sizeL;  /*2+length of data*/
  char  sizeM;
  char  sizeU;
  char  rate;   /*rate = 256-(1000000/sample_rate)*/
  char  cmprs;  /*0=no compression*/
}blockv;

static void SNDsaveVoc(char *file,char huge *buffer,Int32 size,Int32 speed)
{ FILE *fp;
  Int32 wsize,sz=0;
  fp=fopen(file,FOPEN_WB);
  if(fp==NULL)ProgError("VOC: can't write %s",file);
  /*VOC header*/
  strncpy(headv.ident,VocId,VOCIDLEN);
  headv.eof=0x1A;
  headv.block1=0x1A;
  headv.version=0x10A;
  headv.version2=0x2229;
  fwrite(&headv,sizeof(struct VOCHEAD),1,fp);
  blockv.type=0x1;
  sz=(size+2)&0xFFFFFFL; /*char rate, char 0, then char[size]*/
  blockv.sizeL= (char)(sz&0xFFL);
  blockv.sizeM= (char)((sz>>8)&0xFFL);
  blockv.sizeU= (char)((sz>>16)&0xFFL);
  if(speed<=4000)speed=4000;
  blockv.rate=(char)(256-(1000000L/((long)speed)));
  blockv.cmprs=0;
  fwrite(&blockv,sizeof(struct VOCBLOCK1),1,fp);
  /*VOC data*/
  for(wsize=0;wsize<size;wsize+=sz)
  { sz= (size-wsize>MEMORYCACHE)? MEMORYCACHE:(size-wsize);
    if(fwrite((buffer+(wsize)),(size_t)sz,1,fp)!=1)ProgError("VOC: write error");
  }
  blockv.type=0;/*last block*/
  fwrite(&blockv,1,1,fp);
  fclose(fp);
}

char huge *SNDloadVocFile(char *file, Int32 *psize, Int32 *pspeed)
{ FILE *fp;
  Int32 wsize,sz=0,smplrate,datasize;
  char huge *data;
  fp=fopen(file,FOPEN_RB);
  if(fp==NULL)				ProgError("VOC: can't read file %s",file);
  /*read VOC HEADER*/
  if(fread(&headv,sizeof(struct VOCHEAD),1,fp)!=1) ProgError("VOC: can't read header");
  if(strncmp(VocId,headv.ident,VOCIDLEN)!=0) ProgError("VOC: bad header");
  if(fseek(fp,headv.block1,SEEK_SET)) ProgError("VOC: bad header");
  if(fread(&blockv,sizeof(struct VOCHEAD),1,fp)!=1) ProgError("VOC: can't read block");
  if(blockv.type!=1) ProgError("VOC: first block is not sound");
  datasize= ((blockv.sizeU)<<16)&0xFF0000L;
  datasize+=((blockv.sizeM)<<8)&0xFF00L;
  datasize+= (blockv.sizeL)&0xFFL;
  datasize -=2;
  /*check VOC header*/
  if(datasize>0x10000L) ProgError("VOC: sample too long!");
  if(blockv.cmprs!=0) ProgError("VOC: compression not supported.");
  smplrate= (1000000L)/(256-(((int)blockv.rate)&0xFF));
  /*read data*/
  data=(char huge *)Malloc(datasize);
  for(wsize=0;wsize<datasize;wsize+=sz)
  { sz = (datasize-wsize>MEMORYCACHE)? MEMORYCACHE:(datasize-wsize);
    if(fread((data+(wsize)),(size_t)sz,1,fp)!=1)    	ProgError("VOC: can't read sound");
  }
  fclose(fp);
  /*should check for more blocks*/
  *psize=datasize;
  *pspeed=smplrate&0xFFFFL;
  return data;
}




/**************** generic sound *******************/
void SNDsaveSound(char *file,char huge *buffer,Int32 size,SNDTYPE Sound,Bool fullSND)
{ char huge *data;
  Int32 datasize;
  Int16 type,speed,headsize;
  headsize = sizeof(Int16)+sizeof(Int16)+sizeof(Int32);
  if(size<headsize)	ProgError("Sound size too small");
  type     = (Int16)BE_Int16(CharToInt16(&buffer[0]));
  speed    = (Int16)BE_Int16(CharToInt16(&buffer[2]));
  datasize = BE_Int32(CharToInt32(&buffer[4]));
  data	   = buffer+(headsize);
  if(type!=3)		Bug("not a WAVE");
  if(size<datasize+headsize)ProgError("Sound size too small");
  /* Sometime the size of sound entry is greater than the
  ** declared sound size.
  */
  if(fullSND==TRUE)       /*use full sound entry*/
    datasize=size-2-2-4;
  else if(datasize!=size-2-2-4)
    Warning("Sound entry is bigger than declared sound size");
  switch(Sound)
  { case SNDWAV: SNDsaveWave(file,data,datasize,speed);break;
    case SNDAU:  SNDsaveAu(file,data,datasize,speed);break;
    case SNDVOC: SNDsaveVoc(file,data,datasize,speed);break;
    default:  Bug("sndsv");
  }
}


Int32 SNDcopyInWAD(struct WADINFO *info,char *file,SNDTYPE Sound)
{ Int32 size=0,d,s,soundsize,datasize,speed;
  char huge *data=NULL;
  long rate;
  switch(Sound)
  { case SNDWAV: data=SNDloadWaveFile(file,&datasize,&speed);break;
    case SNDAU:  data=SNDloadAuFile(file,&datasize,&speed);break;
    case SNDVOC: data=SNDloadVocFile(file,&datasize,&speed);break;
    default:  Bug("sndcw");
  }
  rate = (11025L<<8)/((Int32)speed);
  soundsize= (datasize*rate)>>8;
  rate = ((Int32)speed<<8)/11025L;
  if(speed>11025)
  { Warning("shrinking %ld to 11025 sample/s",speed);
    for(s=0;s<soundsize;s++)
    { d= (s*rate)>>8;  /* (s*((Int32)speed))/11025;*/
      data[s]= data[d];
    }
    data=(char huge *)Realloc(data,soundsize);
  }
  else if(speed < 11025)
  { Warning("expanding %ld to 11025 sample/s",speed);
    data=(char huge *)Realloc(data,soundsize);
    for(s=soundsize-1;s>=0;s--)
    { d= (s*rate)>>8;
      data[s]= data[d];
    }
  }
  else  /*11025*/
  { soundsize=datasize;
  }
  if(soundsize>0)
  { size= WADRwriteShort(info,3);
    size+=WADRwriteShort(info,11025);
    size+=WADRwriteLong(info,soundsize);
    size+=WADRwriteBytes(info,data,soundsize);
  }
  Free(data);
  return size;
}
/*********** end soundcard sound effects  WAVE ***********/




/*********** PC speaker sound effect ***********/


void SNDsavePCSound(char *file,char huge *buffer,Int32 size)
{ FILE *fp;
  char huge *data;
  Int16 datasize,type,headsize;
  Int16 i;
  headsize = sizeof(Int16)+sizeof(Int16);
  if(size<headsize)	ProgError("WAV: wrong size");
  type     = (Int16)BE_Int16(CharToInt16(buffer+(0)));
  datasize = (Int16)BE_Int16(CharToInt16(buffer+(2)));
  data= buffer+(sizeof(Int16)+sizeof(Int16));
  if(type!=0)		Bug("SNDsavePCcound: not a PC sound");
  if(size<datasize+headsize)ProgError("WAV: wrong size");
  fp=fopen(file,FOPEN_WT); /*text file*/
  if(fp==NULL)ProgError("Can't create %s",file);
  for(i=0;i<datasize;i++)
  { fprintf(fp,"%d\n",((int)data[i])&0xFF);
#ifdef WinDeuTex
    windoze();   /*Actually Process Windows Messages*/
#endif
  }
  fclose(fp);
}

Int32 SNDcopyPCSoundInWAD(struct WADINFO *info,char *file)
{ struct TXTFILE *Txt;
  Int32 size,datasizepos;
  Int16 datasize,s;
  char c;
  Txt=TXTopenR(file);
  size=WADRwriteShort(info,0);
  datasizepos=WADRposition(info);
  size+=WADRwriteShort(info,-1);
  datasize=0;
  while(TXTskipComment(Txt)!=FALSE)
  { s=TXTreadShort(Txt);
    if((s<0)||(s>255))ProgError("SND: number out of bounds [0-255]");
    datasize+=sizeof(char);
    c=(char)(s&0xFF);
    size+=WADRwriteBytes(info,&c,sizeof(c));
  }
  WADRsetShort(info,datasizepos,datasize);
  TXTcloseR(Txt);
  return size;
}

#endif /*DeuTex*/

