/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
		
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/
/*
** simplified TEXT parsing
*/
struct TXTFILE
{ FILE *fp;
  Int16 Lines;
  Int16 LastChar;
  Int16 SectionStart;
  Int16 SectionEnd;
  char Section[8];
};
/*
** For any Reading of TEXT files
*/
void   TXTinit(void);
struct TXTFILE *TXTopenR(char *file); /*open, and init if needed*/
void   TXTcloseR(struct TXTFILE *TXT);
/*
** To read entries
*/
Bool   TXTskipComment(struct TXTFILE *TXT);
Bool   TXTseekSection(struct TXTFILE *TXT,char *def);
Bool   TXTentryParse(char *name,char *filenam,Int16 *x,Int16 *y,Bool *repeat, struct TXTFILE *TXT, Bool XY);
/*
** To read textures
*/
Bool   TXTreadTexDef(struct TXTFILE *TXT,char name[8],Int16 *szx,Int16 *szy);
Bool   TXTreadPatchDef(struct TXTFILE *TXT,char name[8],Int16 *ofsx,Int16 *ofsy);
/*
** To read PC sounds
*/
Int16  TXTreadShort(struct TXTFILE *TXT);


/*
** For any Writing of text files
*/
struct TXTFILE *TXTopenW(char *file); /*open, and init if needed*/
void   TXTcloseW(struct TXTFILE *TXT);
/*
** To write entries
*/
void TXTaddSection(struct TXTFILE *TXT,char *def);
void TXTaddEntry(struct TXTFILE *TXT,char *name,char *filenam,Int16 x,Int16 y,Bool repeat, Bool XY);
void TXTaddComment(struct TXTFILE *TXT,char *text);

