/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
                
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/

/*
** This code should contain all the tricky O/S related
** functions. If you're porting DeuTex/DeuSF, look here!
*/

#include "deutex.h"
#include "tools.h"

/*MSDOS*/
#if defined (__MSDOS__)
#if defined (__GNUC__) /*DJGPP dor DOS*/
#include <malloc.h>
#include <dos.h>
#else
#include <alloc.h>
#endif /*__GNUC__*/
#include <dir.h>
#include <io.h>
#define SEPARATOR "\\"
/*OS/2*/
#elif defined (__OS2__)
#include <malloc.h>
#include <direct.h>
#include <io.h>
#define SEPARATOR "\\"
/*UNIX*/
#else
#include <unistd.h>
#include <malloc.h>
#include <memory.h>
#define SEPARATOR "/"
#endif

#if defined (__OS2__) && !defined (__BORLANDC__)
#include <sys\utime.h>
#else
#include <utime.h>
#endif

#include <time.h>

/*argument lists ... */
#include <stdarg.h>
/*isascii,isprint,...*/
#include <ctype.h>
#include <sys/stat.h>

/*
** Resize a file
** returns   0 if okay    -1 if failed.
*/
Int16 Chsize(int handle,Int32 newsize)
{
#if defined (__MSDOS__)
#if defined (__GNUC__)
  return (Int16)ftruncate(handle, newsize);
#else
  return (Int16)chsize(handle,newsize);
#endif
#elif defined (__OS2__)
#if defined (__BORLANDC__)
   return (Int16)chsize(handle,newsize);
#else
   return (Int16)_chsize(handle,newsize);
#endif
#else
  return (Int16)ftruncate(handle, newsize);
#endif
}

/*
** Delete a file
*/
void Unlink(char *file)
{  unlink(file);
}

/*
** Get a file time stamp. (date of last modification)
*/
Int32 GetFileTime(char *path)
{ Int32 time;
  struct stat statbuf;
  stat(path,&statbuf);
  time =statbuf.st_ctime;
  return time;
}
/*
** Set a file time stamp.
*/
void SetFileTime(char *path, Int32 time)
{
  struct utimbuf stime;
  stime.modtime=stime.actime=time;
#if defined (__OS2__) && !defined (__BORLANDC__)
  _utime(path, &stime);
#else
  utime(path, &stime);
#endif
}
/*
** Copy memory
*/
void Memcpy(void huge *dest,const void huge *src, Int32 n)
{  if(n<0) Bug("MovInf"); /*move inf to zero*/
   if(n==0)return;
#if defined (__MSDOS__)
#if defined (__GNUC__)
   memcpy((char huge *)dest,(char huge *)src,(size_t)n);
#else
   if(n>0x10000L) Bug("MovSup"); /*DOS limit: not more than 0x10000*/
  _fmemcpy(dest,src,(size_t)n);
#endif
#elif defined (__OS2__)
  memcpy((char huge *)dest,(char huge *)src,(size_t)n);
#else
  memcpy((char huge *)dest,(char huge *)src,(size_t)n);
#endif
}
/*
** Set memory
*/
void Memset(void huge *dest,char car, Int32 n)
{  if(n<0) Bug("MStInf"); /*set inf to zero*/
   if(n==0)return;
#if defined (__MSDOS__)
#if defined (__GNUC__)
   memset(dest,car,(size_t)n);
#else
   if(n>0x10000L) Bug("MStSup"); /*DOS limit: not more than 0x10000*/
  _fmemset(dest,car,(size_t)n);
#endif
#elif defined (__OS2__)
  memset(dest,car,(size_t)n);
#else
  memset(dest,car,(size_t)n);
#endif
}
/*
** Allocate memory
*/
/*code derived from DEU*/
#define SIZE_THRESHOLD        0x400L
#define SIZE_OF_BLOCK        0xFFFL
/* actually, this is (size - 1) */
void huge *Malloc( Int32 size)
{
   void huge *ret;
   if(size<1)
   {  Warning("Attempt to allocate %ld bytes",size);
      size=1;
   }
#if defined (__MSDOS__)
#if defined (__GNUC__)
   ret = malloc((size_t) size);
#else
   ret = farmalloc( size);
#endif
#elif defined (__OS2__)
   ret = malloc((size_t) size);
#else
   ret = malloc((size_t) size);
#endif
   if (ret==NULL)
      ProgError("Out of memory (Needed %ld bytes)", size);
   return ret;
}
/*
** Reallocate memory
*/
void huge *Realloc( void huge *old, Int32 size)
{  void huge *ret;

   if(size<1)
   {  Warning("Attempt to allocate %ld bytes",size);
      size=1;
   }
#if defined (__MSDOS__)
#if defined (__GNUC__)
   ret = realloc( old, (size_t)size);
#else
   /*more than 64K is allowed*/
   /*if(size>0x10000L)Bug("MemDos");*/
   ret = farrealloc( old, size);
#endif
#elif defined (__OS2__)
   ret = realloc( old, (size_t)size);
#else
   ret = realloc( old, (size_t)size);
#endif
   if (ret==NULL)
      ProgError( "Out of memory (Needed %ld bytes)", size);
   return ret;
}
/*
** Free
*/
void Free( void huge *ptr)
{
#if defined (__MSDOS__)
#if defined (__GNUC__)
   free( ptr );
#else
   farfree( ptr);
#endif
#elif defined (__OS2__)
   free( ptr );
#else
   free( ptr );
#endif
}
/*****************************************************/
/*
** Convert from LITTLE ENDIAN to BIG ENDIAN
** these functions are needed because integers are
** not stored the same way in the Intels and
** in the real processors (MC68k, SPARC,...)
** Don't use them directly. Use the macro.
*/
Int32  SwapInt32(Int32 l)
{ return  (((l<<24)&0xFF000000L)|((l<<8)&0xFF0000L)|((l>>8)&0xFF00L)|((l>>24)&0xFFL));
}
Int16 SwapInt16(Int16 s)
{ return (((s<<8)&0xFF00)|((s>>8)&0xFF));
}
Int32 CharToInt32(char huge *org)
{ Int32 l; Int16 i;
  char huge *c;
  c=(char huge *)&l;
  for(i=0;i<sizeof(Int32);i++) c[i]=org[i];
  return l;
}
Int32 CharToInt16(char huge *org)
{ Int16 s; Int16 i;
  char huge *c;
  c=(char huge *)&s;
  for(i=0;i<sizeof(Int16);i++)c[i]=org[i];
  return s;
}
/*****************************************************/
/*
** Use only lower case file names
*/
void ToLowerCase(char *file)
{ Int16 i;
  for(i=0;(i<128)&&(file[i]!='\0');i++)
         file[i]=tolower((((Int16)file[i])&0xFF));
}
static void NameDir(char file[128], char *path,char *dir,char *sdir)
{
   file[0]='.';
   file[1]='\0';
   if(path!=NULL) if(strlen(path)>0){ strncpy(file,path,80);}
   if(dir!=NULL)  if(strlen(dir)>0)
   { strcat(file,SEPARATOR);strncat(file,dir,12);}
   if(sdir!=NULL) if(strlen(sdir)>0)
   { strcat(file,SEPARATOR);strncat(file,sdir,12);}
   ToLowerCase(file);
}
/*
** Create directory if it does not exists
*/
void MakeDir(char file[128], char *path,char *dir,char *sdir)
{  NameDir(file,path,dir,sdir);
#if defined (__MSDOS__)
#if defined (__GNUC__)
   mkdir(file,0); /*2nd arguement not used in DOS*/
#else
   mkdir(file);
#endif /*__GNUC__*/
#elif defined (__OS2__)
#if defined (__BORLANDC__)
   mkdir(file);
#else
   _mkdir(file);
#endif
#else
   mkdir(file,(mode_t)S_IRWXU); /*read write exec owner*/
#endif
}
/*
** Create a file name, by concatenation
** returns TRUE if file exists FALSE otherwise
*/
Bool MakeFileName(char file[128], char *path,char *dir,char *sdir,char *name,char *extens)
{  FILE *fp;
   char name2[8];
   /* deal with VILE strange name
   ** replace the VILE[ VILE\ VILE]
   ** by          VIL@A VIL@B VIL@C
   */
   Normalise(name2,name);
   switch(name2[4])
   { case '[':  name2[4]='$';break;
     case '\\': name2[4]='@';break;
     case ']':  name2[4]='#';break;
   }
   switch(name2[6])
   { case '[':  name2[6]='$';break;
     case '\\': name2[6]='@';break;
     case ']':  name2[6]='#';break;
   }
   NameDir(file,path,dir,sdir);
   /*
   ** file name
   */
   strcat(file,SEPARATOR);
   strncat(file,name2,8);
   strcat(file,".");
   strncat(file,extens,4);
   ToLowerCase(file);
   /*
   ** check if file exists
   */
   fp=fopen(file,FOPEN_RB);
   fclose(fp);
   if(fp!=NULL) return TRUE;
   return FALSE;
}
/*
** Get the root name of a WAD file
*/
void GetNameOfWAD(char name[8],char *path)
{ Int16 n, nam,len;
  len=(Int16)strlen(path);
  /*find end of DOS or Unix path*/
  for(nam=n=0;n<len;n++)
    switch(path[n])
    { case '\\': case '/': case '$':  nam=n+1;
    }
  /*find root name*/
  for(n=0;n<8;n++)
    switch(path[nam+n])
    { case '.': case '\0': case '\n':
      name[n]='\0'; return;
      default:   name[n]=toupper(path[nam+n]); break;
    }
    return;
}

/*****************************************************/



void NoCommandGiven(void)
{  Info("Suggestion: use WinTex 4.x as a WAD editor.\n");
	return;
}

/*** JackL, 6-Mar-1996
#if sizeof(Int8)!=1
#error Int8 should be a 8 bit integer
#endif
#if sizeof(Int16)!=2
#error Int16 should be a 16 bit integer
#endif
#if sizeof(Int32)!=4
#error Int32 should be a 32 bit integer
#endif
***/

void PrintCopyright(void)
{  
	Int32 l,ll;
	static char c[]={0x68,0x19,0x06,0x24};
	Legal("\n%s V%d.%d Copyright (c)1994,95 O.Montanuy\n",DEUTEXNAME,DEUTEXMAJOR,DEUTEXMINOR);
	Legal("  Ported to DOS, Unix, OS/2, Linux, SGiX, DEC Alpha.\n");
	Legal("  Thanx to M.Mathews, P.Allansson, C.Rossi, J.Bonfield.\n");
	Legal("  This program is freeware.\n");
	Legal("Type: %s -help  to get the list of commands.\n",DEUTEXNAME);
	ll=CharToInt32(c);
	l=BE_Int32(ll);
	if(l==0x24061968L)
	{ return;
	}
	Info("Wrong processor architecture!\n");
	if(ll==0x24061968L)
	  ProgError("Recompile %s for BIG_ENDIAN (i486 or Alpha)",DEUTEXNAME);
	else if(ll==0x68190624L)
	  ProgError("Recompile %s for LITTLE_ENDIAN (68040 or SPARC or R6000)",DEUTEXNAME);
	else
	  ProgError("Your processor was designed by Bill Gates.");
	return;
}


/*****************************************************/

/* convert 8 byte string to upper case, 0 padded*/
void Normalise(char dest[8], char *src)  /*strupr*/
{ Int16 n;Bool pad=FALSE; char c='A';
  for(n=0;n<8;n++)
  { c= (pad==TRUE)? '\0': src[n];
	 if(c=='\0')   pad=TRUE;
	 else c=(isprint(c))? toupper(c) : '*';
	 dest[n] = c;}
}







/*
** Output and Error handling
*/
static Bool asFile=FALSE;
static Int16 Verbosity=2;
static FILE *Stdout;  /*command output*/
static FILE *Stderr;  /*errors*/
static FILE *Stdwarn;  /*warningss*/
static FILE *Stdinfo; /*infos*/
void PrintInit(Bool asfile)
{
#if defined __OS2__
   setbuf(stdout,(char *)NULL);
#endif
  /*clear a previous call*/
  PrintExit();
  /* choose */
  if(asfile==TRUE)
  { if((Stdout=fopen("output.txt",FOPEN_WT))==NULL)
        ProgError("Can't open output.txt");
    if((Stderr=fopen("error.txt",FOPEN_WT))==NULL)
    {   Stderr=stderr;
        ProgError("Can't open error.txt");
    }
    Stdinfo=stdout;
    Stdwarn=Stderr;
  }
  else
  { Stdout=stdout;
    Stderr=stderr;
    Stdwarn=stderr;
    Stdinfo=stdout;
  }
  asFile=asfile;
}
void PrintVerbosity(Int16 level)
{ Verbosity=(level<0)? 0: (level>4)? 4:level;
}
void PrintExit(void)
{ if(asFile==TRUE)
  { fclose(Stdout);
    fclose(Stderr);
    /*fclose(Stdinfo);*/
  }
}


void ActionDummy(void)
{ return; }
static void (*Action)(void)=ActionDummy;
void ProgErrorCancel(void)
{ Action = ActionDummy;
}
void ProgErrorAction(void (*action)(void))
{ Action = action;
}
void ProgError( char *errstr, ...)
{
   va_list args;va_start( args, errstr);
   fprintf(Stderr, "\nError: *** ");
   vfprintf(Stderr, errstr, args);
   fprintf(Stderr, " ***\n");
   va_end( args);
   (*Action)();  /* execute error handler*/
   PrintExit();
   exit( -5);
}
void Bug( char *errstr, ...)
{  va_list args;va_start( args, errstr);
   fprintf(Stderr, "\nBug: *** ");
   vfprintf(Stderr, errstr, args);
   fprintf(Stderr, " ***\n");
   fprintf(Stderr, "Please report that bug.\n");
   va_end( args);  /* CloseWadFiles();*/
   PrintExit();
   exit( -10);
}
void Warning( char *str, ...)
{  va_list args;va_start( args, str);
   fprintf(Stdwarn, "Warning: ** ");
   vfprintf(Stdwarn, str, args);
   fprintf(Stdwarn, " **\n");
   va_end( args);
}
void Legal(char *str, ...)
{  va_list args;va_start( args, str);
   vfprintf(stdout, str, args);
   va_end( args);
}
void Output(char *str, ...)
{  va_list args;va_start( args, str);
   vfprintf(Stdout, str, args);
   va_end( args);
}
void Info(char *str, ...)
{  va_list args;va_start( args, str);
   if(Verbosity>=1)
     vfprintf(Stdinfo, str, args);
   va_end( args);
}
void Phase(char *str, ...)
{  va_list args;va_start( args, str);
   if(Verbosity>=2)
     vfprintf(Stdinfo, str, args);
   va_end( args);
}
void Detail(char *str, ...)
{  va_list args;va_start( args, str);
   if(Verbosity>=3)
     vfprintf(Stdinfo, str, args);
   va_end( args);
}
#if 0
Int16 NbP=0;
void Progress(void)
{ NbP++;
  if(NbP&0xF==0) fprintf(Stdinfo,".");
  if(NbP>0x400)
  { NbP=0;
    fprintf(Stdinfo,"\n");
  }
}
void ProgressEnds(void)
{ fprintf(Stdinfo,"\n");
}
#endif







