// behavior.c
// (c) Luc Cluitmans 1995

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wadentry.h"
#include "goutput.h"
#include "instruct.h"
#include "statment.h"
#include "script.h"

// -----------------------------------------------------

#pragma argsused
BhvInfo *_LoadBehavior(char *pRaw, WORD wSize)
    // Returns NULL on failure.
    // Do not free pRaw until after calling
    // UnloadBehavior!
{
    BhvInfo *bhv;
    BhvHeader *bhh = (BhvHeader*)pRaw;
    WORD w;
    DWORD dwScriptEnd;
    
    if(bhh->dwSig != SIG_ACS)
    {
        FinishLine();
        AccumulateString("Signature error\n");
        return(NULL);
    }
    bhv = calloc(sizeof(BhvInfo), 1);
    if(!bhv)
    {
        FinishLine();
        AccumulateString("Out of memory\n");
        return(NULL);
    }
    
    bhv->pRaw = pRaw;
    bhv->pscd = (ScriptDir *)(pRaw + bhh->dwOff);
    bhv->nScripts = (WORD)(bhv->pscd->dwCnt);
    bhv->pstd = (StringDir *)(
                  ((char *)(bhv->pscd)) + 4
                           + bhv->nScripts*sizeof(ScriptPtr));

    bhv->psc = calloc(sizeof(Script), (size_t)(bhv->pscd->dwCnt));
    if(!bhv->psc)
    {
        FinishLine();
        AccumulateString("Out of memory\n");
        return(NULL);
    }

    // Calculate end-of-script position
    dwScriptEnd = (bhv->pstd->dwCnt==0)
                 ? bhh->dwOff
                 : bhv->pstd->dwOff[0];
    
    for(w=0; w<bhv->nScripts; w++)
    {
        bhv->psc[w].dwByteOff = bhv->pscd->sp[w].dwOff;
        bhv->psc[w].data = (DWORD*)(pRaw + bhv->pscd->sp[w].dwOff);
        bhv->psc[w].wSize = (WORD)((w+1<bhv->nScripts)
                             ? bhv->pscd->sp[w+1].dwOff - bhv->pscd->sp[w].dwOff
                             : dwScriptEnd - bhv->pscd->sp[w].dwOff)/4;
    }

    return(bhv);
}

void _UnloadBehavior(BhvInfo *bhv)
    // Frees memory.
{
    if(bhv)
    {
        if(bhv->psc)
        {
            free(bhv->psc);
        }
        free(bhv);
    }
}

// -----------------------------------------------------
