// goutput.c
// (c) Luc Cluitmans 1995
// This version of the Goutput routines print to stdout

#include <stdio.h>
    // for vsprintf definition and more
    
#include <string.h>
#include <stdarg.h>

#include "goutput.h"

static char szAcc[1024]; // stores accumulated strings
static int iAccPtr=0; // index of next character in szAcc


// --------------------------------------------

#if 0
static FILE *fout=NULL;

void SetOutputFile(FILE *f)
	 // passing NULL sets stdout
{
	 fout = f;
}

void DoOutput(char *lpsz)
	 // The actual printing routine.
	 // Change this to print in another way.
	 // This version prints to stdout.
{
	 fputs(lpsz, (fout)?fout:stdout);
	 fputs("\n", (fout)?fout:stdout);
}
#endif

// --------------------------------------------

void AccumulateString(char *lpszFormat, ...)
	 // accumulates string data to be printed later
	 // (large memory model assumed)
{
    static va_list marker;

    va_start(marker, lpszFormat);
    vsprintf(szAcc+iAccPtr, lpszFormat, marker); // use wvsprintf in windows
    va_end(marker);
    iAccPtr = strlen(szAcc);
}

void FinishLine(void)
    // Call this to print the accumulated line
{
    DoOutput(szAcc);
    ClearStringBuffer();
}

void ClearStringBuffer(void)
{
    iAccPtr = 0;
    szAcc[0] = '\0';
}

char *GetStringBuffer(void)
    // Returns string buffer
    // (used in error handling)
{
    return(szAcc);
}

// EOF
