// instruct.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "wadentry.h"
#include "opcode.h"
#include "instruct.h"
#include "statment.h"
#include "specials.h"
#include "goutput.h"
#include "script.h"

// -------------------------------------------------------

static WORD InstructionCount(Script *ps);
    // Returns number of instructions in the script.
    // Returns 0xFFFF on error (Use GetStringBuffer to retrieve
    // error string).
    // This function performs some sanity checks.

// -------------------------------------------------------

BOOL GetInstructions(ScriptInfo *psi, int iIdx)
    // Sets current script and loads instructions for it.
    // (changes load state to LS_INSTRUCTIONS)
    // Unloads existing script if necessary.
    // Returns FALSE if ok or TRUE if error. In case of
    // error, retrieve the error message with
    // GetStringBuffer();
{
    WORD w, v, wIc, wJustJumped;
    WORD wLevel, wAdr, wArgCnt;
    int i, iptr;
    Opcode *popc, *popc2;
    Instruction *lpis=NULL;
    
    if(psi->iLoadLevel >= LS_INSTRUCTIONS)
    {
        UnloadInstructions(psi);
    }
    if(iIdx<0 || iIdx>(int)psi->bhv->nScripts)
    {
        AccumulateString("Invalid script index %d\n", iIdx);
        return(TRUE);
    }
    psi->iScript = iIdx;
    psi->iArgCount = (int)psi->bhv->pscd->sp[iIdx].dwXxx;
    psi->lpps = psi->bhv->psc+iIdx;
    psi->wCntInst = InstructionCount(psi->lpps);
    if(psi->wCntInst == 0xFFFF) return(TRUE);
    psi->lpis = calloc(psi->wCntInst, sizeof(Instruction));
    if(!(psi->lpis))
    {
        AccumulateString("FATAL: out of memory\n");
        return(TRUE);
    }
    lpis = psi->lpis;
    
    for(w=0, wLevel=0, wIc=0, wJustJumped=0; w<psi->lpps->wSize; wIc++)
    {
        lpis[wIc].lpdw = psi->lpps->data + w;
        lpis[wIc].wIdx = w;
        lpis[wIc].iFirstInst = wIc;
        popc = opcodes + lpis[wIc].lpdw[0];
        if(wJustJumped && popc->wInterpretation == WINT_CASE)
        {
            wLevel = 1;
        }
        if(wLevel<popc->wArgCnt)
        {
            ClearStringBuffer();
            AccumulateString("FATAL: Stack underflow on '%s' (%d<%d)",
                    popc->szName, wLevel, popc->wArgCnt);
            free(psi->lpis);
            psi->lpis = NULL;
            return(TRUE);
        }
        wLevel += popc->wPushCnt - popc->wArgCnt;
        if(wLevel!=0 && popc->wPushCnt==0 &&
           popc->wInterpretation!=WINT_JUMP &&
           (popc->wInterpretation<WINT_MODIFYLOCAL ||
            popc->wInterpretation>WINT_MODIFYWORLD))
        {
            // print warning
            ClearStringBuffer();
            AccumulateString("WARNING: %5ld : %s toplevel command not at top level",
                 psi->lpps->dwByteOff+4*w, popc->szName);
            FinishLine();
        }
        lpis[wIc].iLevel = wLevel;
        
        lpis[wIc].wJump = 0xFFFF; // do not update jumps yet
        lpis[wIc].wInterpretation = popc->wInterpretation;
        if(popc->wInterpretation == WINT_JUMP)
        {
            if(wLevel!=0)
            {
                lpis[wIc].wInterpretation = WINT_SWITCH;
                lpis[wIc].iLevel = 0; // change interpretation of jump...
            }
            wLevel = 0; // assume that at the adress after a plain jump
                        // all arguments are popped.
                        // This is not true when jumped to case-jumps!
            wJustJumped = 1; // set flag
        }
        else
        {
            wJustJumped = 0;
        }

        // update wXLevel
        lpis[wIc].wXLevel = 0;
        if(popc->wInterpretation != WINT_CASE) // 'case_jump' is a special case
        {
            if(wIc>0 && lpis[wIc-1].wInterpretation == WINT_CASE) // terminate case sequence
            {
                // nothing
            }
            else
            {
                // increase the XLevel of the arguments to this function
                wArgCnt = popc->wArgCnt;
                if(lpis[wIc].wInterpretation == WINT_SWITCH) wArgCnt = 1;
                for(v=0, iptr=wIc-1; v<wArgCnt && iptr!=-1; /*v++*/)
                {
                    // iptr now points to the tail of an argument!
                    // or it points to a increment/decrement instruction...
                    // Move it and all *its* arguments up in the hierarchy.
                    
                    // Skip instructions that do not change the stack in the
                    // argument counting!
                    // Add number of arguments produced by instruction 'iptr':
                    popc2 = opcodes + lpis[iptr].lpdw[0];
                    v += popc2->wPushCnt;
                    
                    for(i=iptr; i>=lpis[iptr].iFirstInst; i--)
                    {
                        lpis[i].wXLevel++;
                    }
                    iptr = i;
                }
                if(v!=wArgCnt)
                {
                    ClearStringBuffer();
                    AccumulateString("FATAL: Secondary stack underflow on '%s'",
                            popc->szName);
                    free(psi->lpis);
                    psi->lpis = NULL;
                    return(TRUE);
                }
                lpis[wIc].iFirstInst = iptr+1;
            }
        }
        
        w += 1+popc->wCnt;
    }
    
    // update jumps
    for(w=0; w<wIc; w++)
    {
        switch(lpis[w].wInterpretation)
        {
            case WINT_SWITCH:
            case WINT_JUMP:
            case WINT_CASE:
            case WINT_CONDJUMPTRUE:
            case WINT_CONDJUMPFALSE:
                // get jump adress (convert to dword index)
                popc = opcodes + lpis[w].lpdw[0];
                wAdr = (WORD)((lpis[w].lpdw[popc->wCnt] - psi->lpps->dwByteOff)/4);
                        // last dword
                // find matching instruction
                for(v=0; v<wIc && (lpis[v].wIdx!=wAdr); v++);
                if(v>=wIc)
                {
                    ClearStringBuffer();
                    AccumulateString(
                         "WARNING: %d : %5ld : Jump label %5ld (%d, %s %d) not found",
                         w, psi->lpps->dwByteOff+4*(lpis[w].wIdx),
                         lpis[w].lpdw[popc->wCnt],
                         wAdr, popc->szName, popc->wArgCnt);
                    FinishLine();
                }
                else
                {
                    lpis[w].wJump = v;
                    if(lpis[v].iLabel==0) lpis[v].iLabel = 1;
                }
                break;
        }
    }
    
    // Name labels
    for(w=0, v=1; w<wIc; w++)
    {
        if(lpis[w].iLabel != 0)
        {
            lpis[w].iLabel = v++;
        }
    }
    
    // a bit of tweaking: modify prefix ++/-- entries
    for(w=0; w<wIc-1; w++)
    {
        if(lpis[w].wInterpretation>=WINT_MODIFYLOCAL &&
           lpis[w].wInterpretation<=WINT_MODIFYWORLD)
        {
            // it is a ++ or --
            
            if(lpis[w+1].wInterpretation - WINT_LOCALVAR ==
                 lpis[w].wInterpretation - WINT_MODIFYLOCAL &&
               lpis[w+1].lpdw[1] == lpis[w].lpdw[1])
            {
                // next instruction is a push of the same variable
                
                if(lpis[w+1].iLabel == 0)
                {
                    // that next instruction is not a jump target
                    
                    if(lpis[w].wXLevel < lpis[w+1].wXLevel)
                    {
                        // the instructions are on a different expression level
                        
                        // Now change the expression level of lpis[w] and
                        // update any changes this may have...
                        lpis[w].wXLevel = lpis[w+1].wXLevel;
                        for(v=w+1;
                            v<wIc &&
                               !((WORD)lpis[v].iFirstInst>w+1 && lpis[v].wXLevel==0);
                            v++)
                        {
                            if(((WORD)lpis[v].iFirstInst) == w+1)
                            {
                                lpis[v].iFirstInst = (int)w;
                            }
                        }
                    }
                }
            }
        }
    }
    
    psi->iLoadLevel = LS_INSTRUCTIONS;
    return(FALSE);
}

// ------------------------------------------------------------------

static WORD InstructionCount(Script *ps)
    // Returns number of instructions in the script.
    // Returns 0xFFFF on error (Use GetStringBuffer to retrieve
    // error string).
    // This function performs some sanity checks.
{
    WORD w, wIc;
    DWORD dw;
    
    for(w=0, wIc=0; w<ps->wSize; wIc++)
    {
        dw = ps->data[w++];
        if(dw>(DWORD)OpcodeCount())
        {
            ClearStringBuffer();
            AccumulateString("FATAL: got invalid opcode %04lX\n", dw);
            return(0xFFFF);
        }
        if(w+opcodes[dw].wCnt > ps->wSize)
        {
            ClearStringBuffer();
            AccumulateString(
               "FATAL: sync lost (need %d more dwords, %d available)\n",
               opcodes[(WORD)dw].wCnt, ps->wSize-w);
            return(0xFFFF);
        }
        // check sanity of specials
        if(opcodes[dw].wInterpretation == WINT_SPECIAL)
        {
            if(!SpecialName((WORD)(ps->data[w])))
            {
                return(0xFFFF);
            }
        }
        w += opcodes[dw].wCnt;
    }
    return(wIc);
}


void ArgumentArray(ScriptInfo *psi, WORD wInst, WORD wArgs[7])
    // retrieves array of subexpression leaders
{
    WORD wI, wCnt;
    Opcode *popc;
    
    for(wCnt=0; wCnt<7; wCnt++)
    {
        wArgs[wCnt] = 0xFFFF;
    }
    for(wI=(WORD)psi->lpis[wInst].iFirstInst, wCnt=0;
        wI<wInst && wCnt<7;
        wI++)
    {
        if(psi->lpis[wI].wXLevel>psi->lpis[wInst].wXLevel+1) continue;
        popc = opcodes+psi->lpis[wI].lpdw[0];
        if(popc->wArgCnt<popc->wPushCnt) // skip inter-instructions
        {
            wArgs[wCnt++] = wI;
        }
    }
    if(wCnt != opcodes[psi->lpis[wInst].lpdw[0]].wArgCnt)
    {
        //  error?
    }
}


// EOF

