// instruct.h -- definition of 'Instruction'

#ifndef _instruct_h_
#define _instruct_h_

typedef struct tagScriptInfo ScriptInfo;
#include "opcode.h" // just in case it wasn't included already...

typedef struct tagInstruction
{
    DWORD   *lpdw; // Points to the first dword of the instruction
                   // This also determines the number of words
    WORD    wIdx;  // Index of first dword of the instruction
    int     iLevel; // stack level: the number of arguments on
                    // the stack after executing this instruction.
    WORD    wXLevel; // expression level
    int     iFirstInst; // first instruction for this expression
    int     iLabel; // jump target. 0 means: not a jump target
    WORD    wJump;  // instruction that is jumped to. (0xFFFF = none)
    WORD    wInterpretation;
                    // copy of instruction interpretation
                    // or WINT_SWITCH
    char    cType;  // 'print as' override (used for constants)
} Instruction; // used to grab together all dwords of an instruction

BOOL GetInstructions(ScriptInfo *psi, int iIdx);
    // Sets current script and loads instructions for it.
    // (changes load state to LS_INSTRUCTIONS)
    // Unloads existing script if necessary.
    // Returns FALSE if ok or TRUE if error. In case of
    // error, retrieve the error message with
    // GetStringBuffer();

void ArgumentArray(ScriptInfo *psi, WORD wInst, WORD wArgs[7]);
    // retrieves array of subexpression leaders
    // Note: add-on expressions (pre/post inc/dec) are skipped!
    // Unused entries are set to 0xFFFF

#endif
