// script.h -- script handling structure and operations

#ifndef _script_h_
#define _script_h_

// sub-includes
//#include "wadentry.h"
//#include "instruct.h"
//#include "statment.h"

typedef struct tagScriptInfo
{
    BhvInfo     *bhv; // currently loaded behavior
    int         iScript; // index of current script
    int         iArgCount; // number of args of current script
    int         iLoadLevel; // script loading state
                            // (LS_xxx constant)
    Script      *lpps; // pointer to current script

    WORD        wCntInst; // instruction count
    Instruction *lpis; // current instruction array
    
    WORD        wCntStat; // statement count
    Statement   *lpstat; // current statement array

    WORD        wMVarCnt; // number of map variables
    WORD        wLVarCnt; // number of local variables

    WORD        *pwMVarType; // VAR_USEDASxxx combination    
    WORD        *pwLVarType; // VAR_USEDASxxx combination    
} ScriptInfo;

enum
{
    LS_UNLOADED,
    LS_BEHAVIOR,
    LS_INSTRUCTIONS,
    LS_STATEMENTS
}; // loading state constants

    // variable usage constants
#define VAR_USEDASINT 1
#define VAR_USEDASSTRING 2

ScriptInfo *LoadBehavior(char *pRaw, WORD wSize);
    // Returns NULL on failure.
    // On error You should retriev the error string
    // with the GOutput function GetStringBuffer
    // Do not free pRaw until after calling
    // UnloadBehavior!
    // You have to set 'gScr' to the result of this
    // function for most functions to work correctly.

void UnloadBehavior(ScriptInfo *lpScr);
    // Frees memory for behavior (not for scriptinfo).

void UnloadStatements(ScriptInfo *lpScr);
void UnloadInstructions(ScriptInfo *lpScr);

extern ScriptInfo *gScr; // global variable pointing to current script

void SetgScr(ScriptInfo *scr);
ScriptInfo *GetgScr(void);
#endif

