// wadentry.h - structures found in wad entries
// (c) Luc Cluitmans 1995

#ifndef _wadentry_h_
#define _wadentry_h_

#include "bastypes.h"

typedef struct tagHxLine
{
    WORD    wVtx[2]; // start and end vertices
    WORD    wFlags;  // LFLG_* combination
    unsigned char special[6];
    WORD    wSide[2]; // right and left sidedef
} HxLine;

#define LFLG_BLOCK          0x0001
#define LFLG_MONSTERBLOCK   0x0002
#define LFLG_TWOSIDED       0x0004
#define LFLG_UNPEGUP        0x0008
#define LFLG_UNPEGLO        0x0010
#define LFLG_SECRET         0x0020
#define LFLG_SNDBLOCK       0x0040
#define LFLG_INVIS          0x0080
#define LFLG_ALWAYS         0x0100
#define LFLG_REPEAT         0x0200
#define LFLG_ACTMASK        0x1C00
#define LFLG_ACT_CROSS      0x0000
#define LFLG_ACT_USE        0x0400
#define LFLG_ACT_MCROSS     0x0800
#define LFLG_ACT_IMPACT     0x0C00
#define LFLG_ACT_PUSH       0x1000
#define LFLG_ACT_PCROSS     0x1400

typedef struct tagHxThing
{
    WORD    wTid;
    int     iPos[2];
    WORD    wAltitude;
    WORD    wAngle;
    WORD    wType;
    WORD    wFlags; // TFLG_*
    unsigned char special[6];
} HxThing;

#define TFLG_EASY           0x0001
#define TFLG_NORMAL         0x0002
#define TFLG_HARD           0x0004
#define TFLG_DEAF           0x0008
#define TFLG_DORMANT        0x0010
#define TFLG_FIGHTER        0x0020
#define TFLG_CLERIC         0x0040
#define TFLG_MAGE           0x0080
#define TFLG_SINGLE         0x0100
#define TFLG_COOP           0x0200
#define TFLG_DEATH          0x0400


// entries occurring physically in a behavior resource
typedef struct tagBhvHeader
{
    DWORD   dwSig; // should be SIG_ACS
    DWORD   dwOff; // offset of script dir
} BhvHeader;

#define SIG_ACS 0x00534341L

typedef struct tagScriptPtr
{
    DWORD   dwId;   // Script Id
    DWORD   dwOff;  // byte Offset
    DWORD   dwXxx;  // number of args
} ScriptPtr;

typedef struct tagScriptDir
{
    DWORD   dwCnt; // number of scripts
    ScriptPtr sp[]; // array of ScriptPtrs
} ScriptDir;

typedef struct tagStringDir
{
    DWORD   dwCnt;
    DWORD   dwOff[]; // array of offsets
} StringDir;

// my types to access script info:
typedef struct tagScript
{
    DWORD   *data;
    DWORD   dwByteOff; // byte offset of start
                       // (for adress calculations)
    WORD    wSize; // number of DWORDs in script
} Script;

typedef struct tagBhvInfo
    // Info on a behavior entry
    // Use LoadBehavior() to create
{
    char        *pRaw; // Raw data.
    ScriptDir   *pscd;
    StringDir   *pstd;
    WORD        nScripts;
    Script      *psc; // first interpretation layer
} BhvInfo;

BhvInfo *_LoadBehavior(char *pRaw, WORD wSize);
    // Returns NULL on failure.
    // On error You should retriev the error string
    // with the GOutput function GetStringBuffer
    // Do not free pRaw until after calling
    // UnloadBehavior!
void _UnloadBehavior(BhvInfo *bhv);
    // Frees memory.


#endif

