/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'B'

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwadir.h"
#include "lbbehav.h"

#if (DLLFORDOOM)
/****************************************************\
*
*
*  Show Behaviour
*
*
\****************************************************/
Int16 WADBlistDir(pWADDEF This, Int16 Entry, pTXTOBJ Txt);

struct BHEAD{ Int32 Acs; Int32 DirPos;};
typedef struct BHEAD PTR *pBHEAD;

/*
** Check Behavior
*/
Int16 WADBcheckBehav(pInt8 Lmp, Int32 LmpSz)
{ if((Lmp==NULL)||(LmpSz<=0))
  { return BAD_ENTRY;}
  if(Strncmp(Lmp,"ACS\0",4)>0) return 1;
  return ERRfaultWad(ERR_BADBEH);
}
/*
** Show Behavior
*/
Int16 WADBshowBehav(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{
  TXTOBJ Txt;
  if(TXTinitWnd(&Txt,0,Wnd)<0)
  { return BAD_PARM;}
  WADBlistDir(This, Entry, &Txt);
  TXTfree(&Txt);
  return 1;
}
/*
** Save Behavior
*/
Int16 WADBsaveBehav(pWADDEF This, Int16 Entry, pInt8 File)
{
  TXTOBJ Txt;
  pInt8 Lmp;
  Int32 LmpSz;
  if(TXTinit(&Txt,0)<0)
  { return BAD_PARM;}
  WADBlistDir(This, Entry, &Txt);
  Lmp= TXTget(&Txt,&LmpSz);
  TXTfree(&Txt);
  if((Lmp==NULL)||(LmpSz<=0))
  { return BAD_ENTRY;}
  FILEwriteText(Lmp,0,LmpSz,File);
  Free(Lmp);
  return 1;
}



/*
**
** DEACC HEADER
**
*/
void *LoadBehavior(void *pRaw, unsigned int wSize);
	 // Returns NULL on failure.
	 // On error You should retriev the error string
	 // with the GOutput function GetStringBuffer
	 // Do not free pRaw until after calling
	 // UnloadBehavior!
	 // You have to set 'gScr' to the result of this
	 // function for most functions to work correctly.
int PrintBehavior(void *scr);
	 // returns TRUE on failure, FALSE on success
void UnloadBehavior(void *lpScr);
	 // Frees memory for behavior (not for scriptinfo).
//void SetgScr(void *scr);
//void *GetgScr(void);
extern void *gScr;
	// hack

/*
** Output function, to link to DEACC
*/
static pTXTOBJ WADBtxt = NULL;
void DoOutput(char *lpsz)
{
  if((lpsz==NULL)||(WADBtxt==NULL)) return;
  TXTprintName(WADBtxt,-1,lpsz, Strlen(lpsz,2048));
}
/*
** List directory
*/
Int16 WADBlistDir(pWADDEF This, Int16 Entry, pTXTOBJ Txt)
{
  pInt8 Lmp;
  Int32 LmpSz;
  void *scr;
  /**/
  if(This==NULL){return BAD_PARM;}
  /*find pnames*/
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if((WADBcheckBehav(Lmp,LmpSz)<0)||(LmpSz>65000L))
  { return BAD_ENTRY;}
  /*prepare for output*/
  WADBtxt=Txt;
  /*output*/
#if 1
  scr = LoadBehavior(Lmp, (unsigned int)LmpSz);
  if(scr==NULL)
  { return BAD_ENTRY;}
  //SetgScr(scr);
  gScr=scr;
  if(PrintBehavior(scr))
  { return BAD_ENTRY;}
  //scr =GetgScr();
  //SetgScr(NULL);
  scr=gScr;
  gScr=NULL;
  UnloadBehavior(scr);
  free(scr);
#endif
  /*end of output*/
  WADBtxt=NULL;
  /**/
  Free(Lmp);
  return 1;
}



 #endif /*DLLFORDOOM*/
