/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'V'




#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>
#include "lbwad.h"
#include "lbdispl.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"

/****************************************************\
*
*
* Entry clipboard
*
*
\****************************************************/

/*
** copy paste structure
*/
typedef struct CLIPB PTR *pCLIPB;
struct CLIPB
{
  Int16 Check;       /*check: 666*/
  IDENT Id;          /*Identity of entry*/
  pCLIPB Next;       /*next*/
  pInt8 Lmp;         /*data of entry*/
  Int32  LmpSz;       /*Size of entry*/
  Int8  Name[NORMALISELEN];/*Name of entry*/
};

static pCLIPB WADclipb=NULL;

/*
** Unlink one clipB
*/
static Int16 WADclipbRemove(void)
{
  pCLIPB clipb;
  clipb = WADclipb;
  if(clipb==NULL) return 0;
  if(clipb->Check!=666) return 0;
  WADclipb = clipb->Next;
  /* Free data */
  if(clipb->Lmp!=NULL) Free(clipb->Lmp);
  /* Free clib structure*/
  Free(clipb);
  return 1;
}
/*
** Add new entry in front of the clipboard linked list
*/
static Int16 WADclipbAdd(pInt8 Lmp, Int32 LmpSz, pInt8 Name,Int16 Id)
{ pCLIPB clipb;
  clipb = Malloc(sizeof(struct CLIPB));
  if(clipb==NULL) return 0;
  /*link with next*/
  clipb->Next=WADclipb;
  clipb->Check=666;
  /*copy data*/
  clipb->Lmp=Lmp;
  clipb->LmpSz=LmpSz;
  Normalise(clipb->Name,Name);
  clipb->Id=Id;
  /*put in front of list*/
  WADclipb=clipb;
  return 1;
}
/*
** clear the clipboard
*/
Int16 EXPORT WADclipbClear(void)
{
  Int16 n;
  for(n=0;n<256;n++)
  {
	 if(WADclipbRemove() <= 0) break;
  }
  WADclipb=NULL;
  return 1;
}
/*
** Copy one entry in the front of clipboard
**  entry = reference of entry
*/
Int16 EXPORT WADclipbCopy(Int16 Self, Int16 Entry)
{
  pInt8 Lmp;
  Int32 LmpSz;
  Int8 Name[NORMALISELEN+2];
  pWADDEF This=WADgetThis(Self);
  IDENT Id;
  /**/
  if(This==NULL) return ERR_BUG;
  /*
  ** read original name and original identifier
  */
  Id=WADDgetEntryI(This,NULL,&LmpSz,Entry);
  if(Id<0) return BAD_ENTRY;
  Normalise(Name,WADDgetNameEntryI(This,Entry));
  Name[NORMALISELEN]='\0';
  if(LmpSz<=0)
  { /*void entry*/
	 Lmp=NULL;
	 LmpSz=0;
  }
  else
  { /**/
	 Lmp=WADreadEntryI(This,&LmpSz,Entry);
	 if((Lmp==NULL)||(LmpSz<=0)) return BAD_PARM;
  }
  /*
  ** Add in clipboard
  */
  return WADclipbAdd(Lmp, LmpSz,Name,Id);
}
/*
** Paste all entries into WAD
**  Entry = suggested position
** The clipboard is not cleared down after this operation
*/
Int16 EXPORT WADclipbPaste(Int16 Self, Int16 Entry)
{
  Int8 Name[NORMALISELEN+2];
  pCLIPB clipb;
  pWADDEF This=WADgetThis(Self);
  Int16 n,res;
  /**/
  if(This==NULL) return ERR_BUG;
  /**/
  for(clipb= WADclipb,n=0; n<0x400; n++, clipb = clipb->Next)
  {
	 if(clipb==NULL) break;
	 /*
	 ** Insert entries in new wad, at position entry
	 ** this assumes the entries were copied from last to first
	 ** and so are made available in clipboard from first to last
	 */
	 if(clipb->Check==666)
	 {
		Normalise(Name,clipb->Name);

		res=WADmodifyEntryI(This,Entry,clipb->Id,Name,clipb->Lmp,clipb->LmpSz);
		/* Do not free the clipb->Lmp*/
		if(res<0) break;
      if(clipb->Id == ELVLHDR)
      { /* If level header, take it as new base entry */
        Entry=res;
      }
      else switch(clipb->Id&EMASK)
      { case ELEVEL: /* level data: do not move entry */
          break;
        default:     /* if not a level data, move entry to the next */
          Entry=res+1;
          break;
      }

	 }
  }
  return n;
}










