/*
** DOOM, HERETIC AND QUAKE SPECIAL STRUCTURES
*/
#if (DLLFORQUAK)
/*
** QUAKE picture header
*/
struct QKPICHEAD /*like DOOM, but row-oriented*/
{ Int32 SzX;
  Int32 SzY;
  Int32 Row[1];
};
typedef struct QKPICHEAD PTR *pQKPICHEAD;
struct QKPICSET
{ Int16 OfsX;     /*X Offset, or 0xFFFF for end*/
  Int16 NbPix;    /*number of pixels*/
  Int8 Pix[1];  /*Pix[(NbPix+1)&(~1)]*/
};
typedef struct QKPICSET PTR *pQKPICSET;
/*
** Quake texture header
*/
struct QKTEXHEAD
{ Int8  Name[16];   /*unknown*/
  Int32 SzX;       /*width*/
  Int32 SzY;       /*height*/
  Int32 Scal1Ofs;  /*pointer to Int8 [SzX   * SzY]*/
  Int32 Scal2Ofs;  /*pointer to Int8 [SzX/2 * SzY/2]*/
  Int32 Scal4Ofs;  /*pointer to Int8 [SzX/4 * SzY/4]*/
  Int32 Scal8Ofs;  /*pointer to Int8 [SzX/8 * SzY/8]*/
};
typedef struct QKTEXHEAD PTR *pQKTEXHEAD;

#endif /*DLLFORQUAK*/




#if (DLLFORDOOM)
/*
** Picture Header
*/
struct DMPICINFO
{ Int16 SzX;
  Int16 SzY;
  Int16 OfsX;
  Int16 OfsY;
};
/*
** Complete picture Header
*/
struct DMPICHEAD
{ Int16 SzX;       /*width*/
  Int16 SzY;       /*height*/
  Int16 OfsX;
  Int16 OfsY;
  Int32 Column[1];  /*pointers to columns*/
};
typedef struct DMPICHEAD PTR *pDMPICHEAD;
/*
** Sound Header
*/
struct DMSNDHEAD /*DOOM sound header*/
{ Int16 Ident;
  Int16 Rate;
  Int32  Size;
};
typedef struct DMSNDHEAD PTR *pDMSNDHEAD;
/*
** Music Header
*/
struct DMMUSINFO
{  Int32	 Ident;         /* identifier "MUS" 0x1A  */
   Int16 ScoreLen;      /* score length           */
   Int16 ScoreStart;    /* score start            */
};
/*
** PNAMES
*/
typedef Int8 PATNAME[8];
struct DMPATLST  /*PNAMES lump*/
{ Int32 NbPatch;
  PATNAME Name[1];
};
typedef struct DMPATLST PTR *pDMPATLST;
/*
** Patches in TEXTURE1
*/
struct DMPATCH    /*size=2+2+2+4 = 10*/
{ Int16 OfsX;     /*offset X*/
  Int16 OfsY;     /*offset Y*/
  Int16 Pidx;     /*patch index*/
  Int32 dummy1;    /*always 1*/
};
typedef struct DMPATCH PTR *pDMPATCH;
/*
** TEXTURE1 HEADER
*/
struct DMTEXULMP       /*Texture lump*/
{ Int32 NbTexu;
  Int32 Texu[1];        /*Texu[TexuSz]*/
};
/*
** TEXTURE1 TEXTURES DEFINITIONS
*/
typedef struct DMTEXULMP PTR *pDMTEXULMP;
struct DMTEXU          /*one texture*/
{ Int8 Name[NORMALISELEN];
  Int32 dummy0;
  Int16 SzX;
  Int16 SzY;
  Int32 dummy00;
  Int16 NbPat;
  struct DMPATCH Pat[1]; /*Pat[PatSz]*/
  /*Valid only as Borland code*/
  /*struct DMPATCH Pat[];*/
};
typedef struct DMTEXU PTR *pDMTEXU;
/*
** Level Vertex
*/
struct DMVERTEX
{ Int16 X;
  Int16 Y;
};
typedef struct DMVERTEX PTR *pDMVERTEX;
/*
** Level Line Definitions
*/
#define FLAG_2S	(0x04)  /*two sided*/
#define FLAG_WAL (0x01)  /*impassible*/
struct DMLINEDEF
{  Int16 VtxS; /* index of vertex start  */
   Int16 VtxE; /* index of vertex end */
	Int16 Flag;/* flags 1=impassible 2=block 4=2sided  32=secret  128=not on map*/
   Int16 Type;/* special type*/
   Int16 Tag; /* sector tag  */
   Int16 SideR;/* Index of Right SideDef (-1=null) */
   Int16 SideL;/* Index of Left SideDef (-1=null)  */
};
typedef struct DMLINEDEF PTR *pDMLINEDEF;
/*
** Level Line Definition of HERETIC2
*/
struct H2LINEDEF
{  Int16 VtxS; /* index of vertex start  */
   Int16 VtxE; /* index of vertex end */
   Int16 Flag; /* flags 1=impassible 2=block 4=2sided  32=secret  128=not on map*/
	Int8  Type;   /*type*/
	Int8  args[5];/*arguments*/
   Int16 SideR;/* Index of Right SideDef (-1=null) */
   Int16 SideL;/* Index of Left SideDef (-1=null)  */
};
typedef struct H2LINEDEF PTR *pH2LINEDEF;
/*
** Level Reject data
*/
/* DMREJECT = REJECT =Int8 */
/*
** Nodes
*/
/*
** Level sectors
*/
struct DMSECTOR
{  Int16 FloorZ;        /*height of floor*/
   Int16 CeilZ;         /*ceiling of floor*/
	Int8  Floor[8];      /*name of flat*/
   Int8  Ceil[8];       /*name of flat*/
   Int16 Light;         /*light level*/
   Int16 Type;          /*type*/
   Int16 Tag;   	/*line teg*/
};
typedef struct DMSECTOR PTR *pDMSECTOR;
/*
** Sidedef
*/
struct DMSIDEDEF
{  Int16 OfsX;          /*X offset of texture*/
   Int16 OfsY;          /*Y offset of texture*/
	Int8  Upper[8];      /*name of upper texture or -*/
	Int8  Lower[8];      /*name of lower texture or -*/
	Int8  Middle[8];     /*name of top texture or -*/
	Int16 Sector;        /*sector reference*/
};
typedef struct DMSIDEDEF PTR *pDMSIDEDEF;
/*
** segment
*/
struct DMSEGS
{ Int16 VtxS;           /*start vertex*/
  Int16 VtxE;           /*end vertex*/
  Int16 Angle;          /*direction angle*/
  Int16 Line;           /*line the SEG is part of*/
  Int16 Side;           /*-1 if left, 0 if right*/
  Int16 OfsX;           /*texture X offset*/
};
typedef struct DMSEGS PTR *pDMSEGS;
/*
** Sub Sector
*/
struct DMSSECTOR
{ Int16 Nb;                /*nb of SEGS*/
  Int16 First;             /*index of first SEG*/
};
typedef struct DMSSECTOR PTR *pDMSSECTOR;

/*
** Node
*/
struct DMNODE
{ Int16 X;        /*start of line*/
  Int16 Y;
  Int16 dX;       /*line vector*/
  Int16 dY;
  Int16 RYmax;    /*right bounding*/
  Int16 RYmin;
  Int16 RXmin;
  Int16 RXmax;
  Int16 LYmax;    /*left bounding*/
  Int16 LYmin;
  Int16 LXmin;
  Int16 LXmax;
  Int16 Right;   /*Right node, or SSector if & 0x8000*/
  Int16 Left;    /*Left  node, or SSector if & 0x8000*/
};
typedef struct DMNODE PTR *pDMNODE;
/*
** Thing
*/
struct DMTHING
{	Int16 X;          /*position*/
	Int16 Y;
	Int16 Facing;     /*direction*/
	Int16 Id;         /*type of thing*/
	Int16 Flag;
};
typedef struct DMTHING PTR *pDMTHING;
#endif












