/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'r'

#include "lbwintex.h"
/*include windows.h after lbwintex.h*/
#include "lbcommon.h"
#include "lbdraw.h"

/*
** Draw a line that is inside the screen
*/
#define DRWdebug (0)
/*BUG: there are still some bugs in Y*/

#define DRWabs(a) (((a)<0)? -(a):(a))
Int16 DRWline0(pInt8 Pic, Int32 LineSz, Int32 A, Int32 B, Int32 C,Int16 SzX, Int16 SzY, Int16 sX,Int16 sY,Int16 eX,Int16 eY,Int8 Color)
{
  Int32 x,y;
  Int32 MaxP,P,dPu,dPv,L,dLu,dLv;
  Int16 n,nb;
#if DRWdebug
/**/Int32 dxu,dyu,dxv, dyv;
#endif
  MaxP=LineSz*((Int32)SzY);

  if(DRWabs(B)>=DRWabs(A))
  { /* u=x  v=y*/
    if(B<0)
    { x=eX; y=eY; nb=sX-eX; A= -A; B= -B; C= -C; }
    else
    { x=sX; y=sY; nb=eX-sX; }
    L   = (A*x + B*y -C)<<1;
    dLu = (A)<<1;  dLv = (B)<<1;
    dPu = 1;       dPv = +LineSz;
#if DRWdebug
/**/dxu = 1;       dxv = 0;
/**/dyu = 0;       dyv = 1;
#endif
  }
  else
  { /* u=y  v=-x*/
    if(A>0) /* eY<sY*/
    { x=eX; y=eY; nb=sY-eY; A= -A; B= -B; C= -C; }
    else    /* sY<eY*/
    { x=sX; y=sY; nb=eY-sY; }
    L   = (A*x + B*y -C)<<1;
    dLu = (B)<<1;  dLv = (-A)<<1;
    dPu = +LineSz; dPv = -1;
#if DRWdebug
/**/dxu = 0;       dxv = -1;
/**/dyu = 1;       dyv = 0;
#endif
  }
  P  = x + (LineSz)*(y);
  if(dLu>0)
  { L= -L;     /*A=-A, B=-B, C=-C*/
    dLu= -dLu; /*A=-A  u= u*/
    dLv= +dLv; /*B=-B, v= -v*/
    dPv= -dPv;
#if DRWdebug
/**/dxv = -dxv;/*v= -v*/
/**/dyv = -dyv;/*v= -v*/
#endif
  }
  /*half step toward v (or -v): middle point*/
  L+= (dLv)>>1;
  /**/
  for(n=0; ; n++)
  { /*plot*/
#if DRWdebug
    if(x<0)
    { return ERRfault(ERR_BUG);}
    if(x>=SzX)
    { return ERRfault(ERR_BUG);}
    if(y<0)
    { return ERRfault(ERR_BUG);} /*happens*/
    if(y>=SzY)
	 { return ERRfault(ERR_BUG);} /*happens*/
	 if(P<0)
	 { ERRfault(ERR_BUG); }
	 else if(P>= MaxP)
	 { ERRfault(ERR_BUG);}
	 else
#else
	 if((P>=0)&&(P<MaxP))
#endif
	 { Pic[P] = Color; }
	 /*last?*/
	 if(n>=nb) { break;}
	 /*step toward u*/
	 L+= dLu;   P+= dPu;
#if DRWdebug
/**/x+= dxu;
/**/y+= dyu;
#endif
    /*test if middle point is "below" line*/
    if(L<0)
    { L+= dLv; P+= dPv;
#if DRWdebug
/**/x+= dxv;
/**/y+= dyv;
#endif
    }
  }
  return 1;
}

#if 0
/*
** Naive method to draw lines. Doesn't work very well: +/-1 pixel off target
*/
#define PREC     (14)          /*minimum 14, for 1024x768*/
#define UNITY    (1<<PREC)     /* 1   */
#define UHALF    (1<<(PREC-1)) /* 1/2 */
Int16 DRWline0(pInt8 Pic, Int32 LineSz, Int16 SzX, Int16 SzY,Int16 sX,Int16 sY,Int16 eX,Int16 eY,Int16 Color)
{
  Int16 x,y,dum,stepX,stepY;
  Int32 t,dx,dy,inc,val,pos,dposX,dposY;
#if 0
  if(Pic==NULL)
  { return ERRfault(ERR_BUG;}
#endif
  /*set origin at the lower left corner*/
  sY=(SzY-1)-sY;
  eY=(SzY-1)-eY;
  /* simplified rejection test. see if out of both bands
  ** no clipping
  */
#if 0
  if((sX<0)&&(eX<0))       return 0;
  if((sX>=SzX)&&(eX>=SzX)) return 0;
  if((sY<0)&&(eY<0))       return 0;
  if((sY>=SzY)&&(eY>=SzY)) return 0;
#endif
  /*
  ** calculate dx, dy (absolute)
  */
  dx=((Int32)eX)-((Int32)sX);
  dy=((Int32)eY)-((Int32)sY);
  if(dx<0) {dx=-dx;}
  if(dy<0) {dy=-dy;}
  /*
  ** Steps
  */
  stepX=1; dposX=1;
  stepY=1; dposY=-LineSz;
  /*
  ** dx>=dy
  */
  if((dx==0)&&(dy==0))
  {
	 return 0;
  }
  if(dx>=dy)
  {
	 if(eX<sX)
	 { dum=eX;eX=sX;sX=dum;
		dum=eY;eY=sY;sY=dum;
	 }
	 if(eY<sY)
	 { stepY=-stepY;dposY=-dposY;
	 }
	 /*start position*/
	 x=sX;
	 y=sY;
	 pos = ((Int32)x)+(LineSz)*((Int32)(SzY-1)-(Int32)y);
	 if(dy==0)
	 {
		if((y>=0)&&(y<SzY))
		{ /*loop, from 0 to dt=dx included (two extremities included)*/
		  for(t=0; t<=dx; t++)
		  { if((x>=0)&&(x<SzX))
			 { /*pos= ((Int32)x + (LnSz)*(Int32)(SzY-1-y));*/
				if(pos>=0)Pic[pos]=Color;
			 }
			 x+=stepX; pos +=dposX;
		  }
		}
	 }
	 else
	 { /*increments. a mere hack.*/
		inc=(((dy+ ((dy>=(dx>>1))?1L:0L) )<<PREC)+(dx>>1))/dx;
		/*loop, from 0 to dt=dx included (two extremities included)*/
		for(val=UHALF,t=0; t<=dx; t++,val+=inc)
		{ if((x>=0)&&(x<SzX)&&(y>=0)&&(y<SzY))
		  { /*pos= ((Int32)x + (LnSz)*(Int32)(SzY-1-y));*/
			 if(pos>=0)Pic[pos]=Color;
		  }
		  x+=stepX; pos +=dposX;
		  if(val>= UNITY)
		  { val-=UNITY;
			 y+=stepY; pos +=dposY;
		  }
		}
	 }
	 return (Int16)dx;
  }
  else /*(dx<dy)*/
  {
	 if(eY<sY)
	 { dum=eY;eY=sY;sY=dum;
		dum=eX;eX=sX;sX=dum;
	 }
	 if(eX<sX)
	 { stepX=-stepX;dposX=-dposX;
	 }
	 /*start position*/
	 x=sX;
	 y=sY;
	 pos = ((Int32)x)+(LineSz)*((Int32)(SzY-1)-(Int32)y);
	 if(dx==0)
	 {
		if((x>=0)&&(x<SzX))
		{ /*loop, from 0 to dt=dx included (two extremities included)*/
		  for(t=0; t<=dy; t++)
		  { if((y>=0)&&(y<SzY))
			 { /*pos= ((Int32)x + (LnSz)*(Int32)(SzY-1-y));*/
				if(pos>=0)Pic[pos]=Color;
			 }
			 y+=stepY; pos +=dposY;
		  }
		}
	 }
	 else
	 { /*increments. a mere hack*/
		inc=(((dx+ ((dx>=(dy>>1))?1L:0L) )<<PREC)+(dy>>1))/dy;
		/*loop, from 0 to dt=dx included (two extremities included)*/
		for(val=UHALF,t=0; t<=dy; t++,val+=inc)
		{ if((x>=0)&&(x<SzX)&&(y>=0)&&(y<SzY))
		  { /*pos= ((Int32)x + (LnSz)*(Int32)(SzY-1-y));*/
			 if(pos>=0)Pic[pos]=Color;
		  }
		  y+=stepY; pos +=dposY;
		  if(val>= UNITY)
		  { val-=UNITY;
			 x+=stepX; pos +=dposX;
		  }
		}
	 }
	 return (Int16)dy;
  }
}
#endif





/*
**
** return -1 if out,
**         0 if no cut
**         1 if cut sT and 0
**         2 if cut sT and Tmax
**         4 if cut eT and 0
**         8 if cut eT and Tmax

*/
Int16 DRWelimBand(Int16 Tmax, Int16 sT, Int16 eT)
{ Int16 res;
  res = (sT<0)? 1 : ((sT>=Tmax)? 2: 0);
  res|= (eT<0)? 4 : ((eT>=Tmax)? 8: 0);
  /*
  ** Eliminate if both sT and eT out of bounds
  */
  if((res&(1+4)) == (1+4)) return -1;
  if((res&(2+8)) == (2+8)) return -1;
  return res;
}



/*
** Intersection of lines X=Val and A.X+B.Y=C
*/
void DRWcutX(pInt16 pX, pInt16 pY, Int32 A, Int32 B, Int32 C, Int16 Val, Int16 MaxY)
{
  Int32 CAV,BYM,BYm,BT;
  Int16 YM,Ym,T;
  /**/
  if(B<0)  /*normalise*/
  { B=-B; A=-A; C=-C; }
  Ym=0;
  BYm=0;
  YM=MaxY;
  CAV= C-A*((Int32)Val);
  BYM=  B*((Int32)YM);
  /**/
  while(1)
  { T  = YM+Ym; /*middle, with roundup error*/
    BT = ((BYM+BYm)>>1) - ((T&1)? (B>>1):0);
    T  = T>>1;
#if 0
    if(BT==CAV)      /* found the point*/
    { break;}
#endif
    if(T==Ym)        /* end of search*/
    { BT = (BYM+BYm)>>1; /*middle*/
      T= (BT>CAV)? Ym: YM; /*closest*/
      break;
    }
    if(BT>CAV) /*Y too big*/
    { YM=T; BYM=BT;}
    else       /*Y too small*/
    { Ym=T; BYm=BT;}
  }
  *pX = Val;
  *pY = T;
}
/*
** Intersection of lines Y=Val and A.X+B.Y=C
*/
void DRWcutY(pInt16 pX, pInt16 pY, Int32 A, Int32 B, Int32 C, Int16 Val, Int16 MaxX)
{
  Int32 CBV,AXM,AXm,AT;
  Int16 XM,Xm,T;
  /**/
  if(A<0)  /*normalise*/
  {  A=-A; B=-B; C=-C; }
  Xm=0;
  AXm=0;
  XM=MaxX;
  CBV= C-B*((Int32)Val);
  AXM=  A*((Int32)XM);
  /**/
  while(1)
  { T  = XM+Xm; /*middle, with roundup error*/
    AT = ((AXM+AXm)>>1) - ((T&1)? (A>>1):0);
    T  = T>>1;
#if 0
    if(AT==CBV)      /* found the point*/
    { break;}
#endif
    if(T==Xm)        /* end of search*/
    { AT = (AXM+AXm)>>1; /*middle*/
      T= (AT>CBV)? Xm: XM; /*closest*/
      break;
    }
    if(AT>CBV) /*X too big*/
    { XM=T; AXM=AT;}
    else       /*X too small*/
    { Xm=T; AXm=AT;}
  }
  *pX = T;
  *pY = Val;
}
/*
** Sign
*/
#define DRWsign2(A,C) ((A==C)? 0:((A>C)?1:-1))
Int16 DRWline(pInt8 Pic, Int32 LineSz, Int16 SzX, Int16 SzY,Int16 sX,Int16 sY,Int16 eX,Int16 eY,Int16 Color)
{
  Int32 A,B,C,dumX,dumY;
  Int16 sgX,sgY;
  Int16 sgC00,sgCX0,sgC0Y,sgCXY;
  /*
  ** eliminate the segments trivially out of screen
  */
  sgX=DRWelimBand(SzX, sX, eX);
  if(sgX<0){ return 0;}
  sgY=DRWelimBand(SzY, sY, eY);
  if(sgY<0){ return 0;}
  /**/
  /*
  ** Calculate line coefficients
  ** f(X,Y):  A.X + B.Y = C
  */
  A = ((Int32)sY)-((Int32)eY);
  B = ((Int32)eX)-((Int32)sX);
  C = A*((Int32)sX) + B*((Int32)sY);
  /*
  ** Calculate screen extremities (C0-C3)
  */
  dumX=A*((Int32)SzX);
  dumY=B*((Int32)SzY);
  sgC00=DRWsign2(0,C);			/*sign(A*0  +B*0  -C);*/
  sgCX0=DRWsign2(dumX,C);		/*sign(A*SzX+B*0  -C);*/
  sgC0Y=DRWsign2(dumY,C);		/*sign(A*0  +B*SzY-C);*/
  sgCXY=DRWsign2(dumX+dumY,C);/*sign(A*SzX+B*SzY-C);*/
  /*
  ** Check if line is out of screen
  ** (this test also eliminates lines of size 0)
  */
  if((sgC00==sgCXY)&&(sgCX0==sgC0Y))
  { return 0;}
  /*
  ** Cut line by band X=0,X=SzX
  */
  if(B!=0)
  {
	 if(sgC00!=sgC0Y) /*X=0 cut may  be necessary*/
	 {
		if(sgX&1)
		{ DRWcutX(&sX,&sY,A,B,C,0,SzY-1);}
		if(sgX&4)
		{ DRWcutX(&eX,&eY,A,B,C,0,SzY-1);}
	 }
	 if(sgCX0!=sgCXY) /*X=SzX cut may  be necessary*/
	 {
		if(sgX&2)
		{ DRWcutX(&sX,&sY,A,B,C,SzX-1,SzY-1);}
		if(sgX&8)
		{ DRWcutX(&eX,&eY,A,B,C,SzX-1,SzY-1);}
	 }
  }
  /*
  ** Cut line by band Y=0,Y=SzY
  */
  if(A!=0)
  {
	 if(sgC00!=sgCX0) /*Y=0 cut may  be necessary*/
	 { if(sgY&1)
		{ DRWcutY(&sX,&sY,A,B,C,0,SzX-1); }
		if(sgY&4)
		{ DRWcutY(&eX,&eY,A,B,C,0,SzX-1); }
	 }
	 if(sgC0Y!=sgCXY) /*Y=SzY cut may  be necessary*/
	 { if(sgY&2)
		{ DRWcutY(&sX,&sY,A,B,C,SzY-1,SzX-1); }
		if(sgY&8)
		{ DRWcutY(&eX,&eY,A,B,C,SzY-1,SzX-1); }
	 }
  }
#if 1
  if((sX<0)||(sY<0)||(sX>=SzX)||(sY>=SzY))
  { return 0;}
#else
  if((sX<0)||(sY<0))
  { return ERRfault(ERR_BUG);}  /*can happen*/
  if((sX>=SzX)||(sY>=SzY))
  { return ERRfault(ERR_BUG);}  /*can happen*/
#endif
#if 1
  return DRWline0(Pic,LineSz,A,B,C,SzX,SzY,sX,sY,eX,eY,Color);
#else
  return DRWline0(Pic,LineSz,SzX,SzY,sX,sY,eX,eY,Color);
#endif
}

