/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'L'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lblevprt.h"
#include "lblevel.h"


#if (DLLFORDOOM)

/****************************************************\
*
*
*  Internal level display API
*
*
\****************************************************/
	/*
	** read a level
	*/
static Int16 WADLreadLevel(pLVLOBJ Dml, pWADDEF Wad,Int16 Entry, Int16 Which);
	/*
	** show sector
	*/
static Int16 WADLshowLevelI(pLVLOBJ Dml, pBMPOBJ Bmp, Int16 Sec, pBOUND Bound, pWINDOZE PicB);
	/*
	** show a given sidedef
	*/
static Int16 WADLshowSidedefI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Sid, pBOUND Bound, pWINDOZE PicB);
	/*
	** show sector, and reject data
	*/
static Int16 WADLshowRejectI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Sector,pBOUND Bound, pWINDOZE PicB);
	/*
	** show BSP node
	*/
static Int16 WADLshowNodeI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Node, pBOUND Bound, pWINDOZE PicB);

/****************************************************\
*
*
*  Init and Read level object
*
*
\****************************************************/
/*
** Init Level object
*/
Int16 WADLinitI(pLVLOBJ Dml)
{ if(Dml==NULL)
  { return ERRfault(ERR_BUG);}
  Dml->Level=-1;
  /*vertex*/
  Dml->Vtx=NULL;Dml->VtxNb=0;
  /*linedef*/
  Dml->Lnd=NULL;Dml->LndNb=0;
  /*sidedef*/
  Dml->Sid=NULL;Dml->SidNb=0;
  /*sector*/
  Dml->Sec=NULL;Dml->SecNb=0;
  /*reject*/
  Dml->Rej=NULL;Dml->RejNb=0;
  /*segs*/
  Dml->Seg=NULL;Dml->SegNb=0;
  /*sub sectors*/
  Dml->Ssc=NULL;Dml->SscNb=0;
  /*nodes*/
  Dml->Nod=NULL;Dml->NodNb=0;
  return 1;
}
/*
** free level object
*/
Int16 WADLfreeI(pLVLOBJ Dml)
{ if(Dml==NULL)
  { return ERRfault(ERR_BUG);}
  Dml->Level=-1;
  /*vertex list*/
  if(Dml->Vtx !=NULL) Free(Dml->Vtx);
  Dml->Vtx=NULL;Dml->VtxNb=0;
  /*linedef list*/
  if(Dml->Lnd !=NULL) Free(Dml->Lnd);
  Dml->Lnd=NULL;Dml->LndNb=0;
  /*sidedef list*/
  if(Dml->Sid !=NULL) Free(Dml->Sid);
  Dml->Sid=NULL;Dml->SidNb=0;
  /*sector list*/
  if(Dml->Sec !=NULL) Free(Dml->Sec);
  Dml->Sec=NULL;Dml->SecNb=0;
  /*segments list*/
  if(Dml->Seg !=NULL) Free(Dml->Seg);
  Dml->Seg=NULL;Dml->SegNb=0;
  /*sub sector list*/
  if(Dml->Ssc !=NULL) Free(Dml->Ssc);
  Dml->Ssc=NULL;Dml->SscNb=0;
  /*nodes list*/
  if(Dml->Nod !=NULL) Free(Dml->Nod);
  Dml->Nod=NULL;Dml->NodNb=0;
  /*reject list*/
  if(Dml->Rej !=NULL) Free(Dml->Rej);
  Dml->Rej=NULL;Dml->RejNb=0;
  return 1;
}
/*
** read level data
*/
#define LVL_BASE   (0x01)
#define LVL_SECT   (0x02)
#define LVL_SIDE   (0x04)
#define LVL_REJ    (0x08)
#define LVL_NODE   (0x10)
#define LVL_BLOCK  (0x20)
#define LVL_THING  (0x20)


static pInt8 WADLobtainEntryI(pWADDEF Wad, pInt32 pLmpSz, Int16 Here, pInt8 Name, IDENT Type)
{ Int16 Entry;
  pInt8 Lmp;
  Entry=WADDfindEntryI(Wad,Here,Name,Type);
  if(Entry<0)
  { ERRfaultWad(ERR_BADLEVEL); return NULL;}
  /*read lump, convert to vertex list*/
  Lmp=(pInt8)WADreadEntryI(Wad,pLmpSz,Entry);
  if(Lmp==NULL)
  { ERRfault(BAD_ENTRY); return NULL;}
  return Lmp;
}
static Int16 WADLreadLevel(pLVLOBJ Dml, pWADDEF Wad,Int16 Entry, Int16 Which)
{ pInt8 Lmp;
  Int16 res,Old; /*old or new format for linedefs?*/
  Int32 LmpSz;
  if(Dml==NULL)
  { return ERRfault(ERR_BUG);}
  if(Entry<0)
  { return ERR_BUG;} /*no such level*/
  /*
  ** If it's not the right level, free all
  */
  if(Dml->Level!=Entry)
  {
	 WADLfreeI(&(Wad->Dml));
  }
  Dml->Level=-1;
  /*
  ** Selection
  */
  /*
  ** Read entries
  */
  if(Which&LVL_BASE)
  { if(Dml->Vtx==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "VERTEXES",EVERTEX);
		res= WADLvrtxReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
	 if(Dml->Lnd==NULL)
	 {
		Old= (Wad->Game & GAM_HEXN)? 0: 1;
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "LINEDEFS",ELINEDEF);
		res= WADLreadLinedefI(Dml,Lmp,LmpSz,Old);
		if(res<0) return res;
	 }
  }
  if(Which&LVL_SIDE)
  {
	 if(Dml->Sid==NULL)
	 {	Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "SIDEDEFS",ESIDEDEF);
		res=WADLsideReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
  }
  if(Which&LVL_SECT)
  {
	 if(Dml->Sec==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "SECTORS",ESECTOR);
		res=WADLsectReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
  }
  if(Which&LVL_REJ)
  {
	 if(Dml->Rej==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "REJECT",EREJECT);
		res=WADLrejReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
  }
  if(Which&LVL_NODE)
  {
	 if(Dml->Seg==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "SEGS",ESEGS);
		res=WADLssegReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
	 if(Dml->Ssc==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "SSECTORS",ESSECTOR);
		res=WADLssecReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
	 if(Dml->Nod==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "NODES",ENODE);
		res=WADLnodeReadI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
  }
  if(Which&LVL_BLOCK)
  {
#if 0
	 if(Dml->Blo==NULL)
	 {
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "BLOCKMAP",EBLOCKMP);
		res= WADLreadBlockmapI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
#endif
  }
  if(Which&LVL_THING)
  {
#if 0
	 if(Dml->Thg==NULL)
	 {
		Old = (Wad->Game & GAM_HEXN)? 0: 1;
		Lmp= WADLobtainEntryI(Wad, &LmpSz, Entry, "THINGS",ETHING);
		res= WADLreadThingI(Dml,Lmp,LmpSz);
		if(res<0) return res;
	 }
#endif
  }
  Dml->Level=Entry;
  return 1;
}







/****************************************************\
*
*
*  Show a level, as a set of linedefs,
*   and indicate 2S, tagged and normal linedefs
*   show sector too
\****************************************************/


static Int16 WADLshowLevelI(pLVLOBJ Dml, pBMPOBJ Bmp, Int16 Sec, pBOUND Bound, pWINDOZE PicB)
{ /*show*/
  Int16 res,l;
  pLINEDEF TLnd;
  pSIDEDEF TSid;
  Int8 Color,Lin2s,LinBl,LinUk,LinSp,SecSel,SecSel2;
  if((Dml==NULL)||(Dml->Vtx==NULL)||(Dml->Lnd==NULL))
  { return ERRfault(ERR_BUG);}
  /*
  ** Set colors
  */
  LinSp  =BMP_COL_PURPLE;    /*special*/
  Lin2s  =BMP_COL_DARKBLUE;  /*2 sided*/
  LinBl  =BMP_COL_BLUE;      /*wall*/
  LinUk  =BMP_COL_GREY;      /*unknown*/
  SecSel =BMP_COL_YELLOW;    /*selected*/
  SecSel2=BMP_COL_DARKYELLOW;/*selected, 2sided*/
  /*
  ** Allocate a BMP, use system colors
  */
  BMPinit(Bmp,Bound->SzX,Bound->SzY,8,NULL,-1);
  /*
  ** clear background in black, load default palette
  */
  BMPclear(Bmp,BMP_COL_BLACK);
  /*
  ** start cacheing vertexes. security check
  */
  res=WADLvrtxCacheI(Dml);
  if(res<0){ return res;}
  /*
  ** write linedefs
  */
  for(l=0,TLnd= Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
  { /*TLnd=&(This->Dml.Lnd[l]);*/
	 if(TLnd->Type!=0)      /*special*/
	 { Color=LinSp;}
	 else if(TLnd->Flag&FLAG_WAL)/*impassible*/
	 { Color=LinBl;}
	 else if(TLnd->Flag&FLAG_2S)/*two sided*/
	 { Color=Lin2s;}
	 else  /*strange*/
	 { Color=LinUk;}
	 WADLdrawLineI(Dml, Bmp,TLnd,Bound,Color);
  }

  /*
  ** Draw Sector Seen
  */
  if((Sec>=0)&&(Sec<Dml->SecNb))
  {
	 if(Dml->Sid==NULL)
	 { return ERRfault(ERR_BUG);}
	 for(l=0,TLnd= Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
	 { /*TLnd=&(This->Dml.Lnd[l]);*/
		Color=(TLnd->Flag&FLAG_2S)? SecSel2:SecSel;
		/*right side*/
		if((TLnd->SideR>=0)&&(TLnd->SideR< Dml->SidNb))
		{ TSid=&(Dml->Sid[TLnd->SideR]);
		  if(TSid->Sector==Sec)
		  { WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);}
		}
		/*left side*/
		if((TLnd->SideL>=0)&&(TLnd->SideL< Dml->SidNb))
		{ TSid=&(Dml->Sid[TLnd->SideL]);
		  if(TSid->Sector==Sec)
		  { WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);}
		}
	 }
  }
  /*
  ** Display level
  */
  BMPassignToWindoze(Bmp,PicB);
  BMPfree(Bmp);
  return 1;
}






/****************************************************\
*
*
*  Show a level, as a set of linedefs,
*    and highlight the selected SIDEDEF
*
\****************************************************/

static Int16 WADLshowSidedefI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Sid, pBOUND Bound, pWINDOZE PicB)
{ /*show*/
  Int16 res,l;
  pLINEDEF TLnd;
  Int8 Color,Lin2s,LinBl,LinUk,LinSp,SidRSel,SidLSel;
  if((Dml==NULL)||(Dml->Vtx==NULL)||(Dml->Lnd==NULL))
  {return ERRfault(ERR_BUG);}
  /*
  ** Set colors
  */
  LinSp  =BMP_COL_PURPLE;   /*special*/
  Lin2s  =BMP_COL_DARKBLUE; /*2 sided*/
  LinBl  =BMP_COL_BLUE;     /*wall*/
  LinUk  =BMP_COL_GREY;     /*unknown*/
  SidRSel=BMP_COL_GREEN;    /*selected SidR*/
  SidLSel=BMP_COL_RED;      /*selected SidL*/
  /*
  ** Allocate a BMP, use system colors
  */
  BMPinit(Bmp,Bound->SzX,Bound->SzY,8,NULL,-1);
  /*
  ** clear background in black, load default palette
  */
  BMPclear(Bmp,BMP_COL_BLACK);
  /*
  ** start cacheing vertexes. security check
  */
  res=WADLvrtxCacheI(Dml);
  if(res<0){ return res;}
  /*
  ** write linedefs
  */
  for(l=0,TLnd= Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
  { /*TLnd=&(This->Dml.Lnd[l]);*/
	 if((TLnd->SideR==Sid)&&(Sid>=0))         /*selected right side*/
	 { Color=SidRSel;}
	 else if ((TLnd->SideL==Sid)&&(Sid>=0))   /*selected left side*/
	 { Color=SidLSel;}
	 else if(TLnd->Type!=0)      /*special*/
	 { Color=LinSp;}
	 else if(TLnd->Flag&FLAG_WAL)/*impassible*/
	 { Color=LinBl;}
	 else if(TLnd->Flag&FLAG_2S)/*two sided*/
	 { Color=Lin2s;}
	 else  /*strange*/
	 { Color=LinUk;}
	 WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);
  }
  /*
  ** Display level
  */
  BMPassignToWindoze(Bmp,PicB);
  BMPfree(Bmp);
  return 1;
}


/****************************************************\
*
*
*  Show a level, as a set of linedefs,
*   according to REJECT data
*
\****************************************************/


static Int16 WADLshowRejectI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Sector,pBOUND Bound, pWINDOZE PicB)
{ Int16 res,l;
  pLINEDEF TLnd;
  pSIDEDEF TSid;
  Int8 Color, Lorg,Lseen,Lhidn,Lorg2,Lseen2,Lhidn2;
  if((Dml==NULL)||(Dml->Vtx==NULL)||(Dml->Lnd==NULL)||(Dml->Sid==NULL))
  {return ERRfault(ERR_BUG);}
  /*
  ** colors
  */
  if(WADLrejGetI(Dml, Sector, Sector)<=0)
  { /*sector is safe*/
	 Lorg =BMP_COL_GREEN;       /*origin safe*/
	 Lorg2=BMP_COL_DARKGREEN;  /*origin safe*/
  }
  else
  { /*sector is dangerous*/
	 Lorg =BMP_COL_YELLOW;      /*origin*/
	 Lorg2=BMP_COL_DARKYELLOW;  /*origin*/
  }
  Lhidn =BMP_COL_GREY;       /*hidden*/
  Lhidn2=BMP_COL_DARKGREY;   /*hidden 2sided*/
  Lseen =BMP_COL_PURPLE;     /*seen*/
  Lseen2=BMP_COL_DARKPURPLE; /*seen 2sided*/
  /*
  ** Allocate a BMP, use system colors
  */
  BMPinit(Bmp,Bound->SzX,Bound->SzY,8,NULL,-1);
  /*
  ** clear background, load default palette
  */
  BMPclear(Bmp,BMP_COL_BLACK);
  /*
  ** start cacheing. security check
  */
  res=WADLvrtxCacheI(Dml);
  if(res<0){ return res;}
  /*
  ** Draw hidden sector
  */
  for(l=0,TLnd=Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
  { /*Lnd=&(This->Dml.Lnd[l]);*/
	 if((TLnd->SideR<0)||(TLnd->SideR>= Dml->SidNb))continue;
	 TSid=&(Dml->Sid[TLnd->SideR]);
	 if(TSid->Sector==Sector) continue;
	 if(WADLrejGetI(Dml, TSid->Sector, Sector)>0) continue;
	 Color=(TLnd->Flag&FLAG_2S)? Lhidn2:Lhidn;
	 WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);
  }
  /*
  ** Draw Seen sectors
  */
  for(l=0,TLnd= Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
  { /*TLnd=&(This->Dml.Lnd[l]);*/
	 if((TLnd->SideR<0)||(TLnd->SideR>= Dml->SidNb))continue;
	 TSid=&(Dml->Sid[TLnd->SideR]);
	 if(TSid->Sector==Sector) continue;
	 if(WADLrejGetI(Dml, TSid->Sector, Sector)<=0) continue;
	 Color=(TLnd->Flag&FLAG_2S)? Lseen2:Lseen;
	 WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);
  }
  /*
  ** draw player sector
  */
  for(l=0,TLnd= Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
  { /*TLnd=&(This->Dml.Lnd[l]);*/
	 /*right side*/
	 if((TLnd->SideR>=0)&&(TLnd->SideR< Dml->SidNb))
	 {
		TSid=&( Dml->Sid[TLnd->SideR]);
		if(TSid->Sector==Sector)
		{ Color=(TLnd->Flag&FLAG_2S)? Lorg2:Lorg;
		  WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);
		}
	 }
	 /*left side*/
	 if((TLnd->SideL>=0)&&(TLnd->SideL< Dml->SidNb))
	 { TSid=&(Dml->Sid[TLnd->SideL]);
		if(TSid->Sector==Sector)
		{ Color=(TLnd->Flag&FLAG_2S)? Lorg2:Lorg;
		  WADLdrawLineI(Dml,Bmp,TLnd,Bound,Color);
		}
	 }
  }
  /*
  ** display sector
  */
  BMPassignToWindoze(Bmp, PicB);
  BMPfree(Bmp);
  return 1;
}


/****************************************************\
*
*
*  Show a Binary Space Partition Tree in 2D
*
*
\****************************************************/

/*
** Those are static variables to avoid sucking stack
** when recursing.
*/
static pBOUND   NODbound;/*Bound*/
static pLVLOBJ   NODdml; /*Dml, pointer to level*/
static pBMPOBJ  NODbmp; /*&This->Bmp*/
static pWINDOZE NODpicB; /*PicB*/
static Int16    NODcol0; /*color*/
static Int16    NODcol1; /*color*/
/*
** Recursive functions
*/
  /*show sub sectors*/
static void NODshowSsct(Int16 Node, Int16 Credit);
  /*show split*/
static void NODshowSplit(Int16 Node, Int16 Credit);
/*
**
**  Show a level, as a node
**  set start node=top, if node<0
*/
static Int16 WADLshowNodeI(pLVLOBJ Dml,pBMPOBJ Bmp, Int16 Node, pBOUND Bound, pWINDOZE PicB)
{ /*show*/
  Int16 res,l;
  pLINEDEF TLnd;
  Int16 LinGr,LinRs,LinLs,LinSplt,LinSp2;
  if((Dml==NULL)||(Dml->Vtx==NULL)||(Dml->Lnd==NULL)||(Dml->Nod==NULL))
  { return ERRfault(ERR_BUG);}
  /*
  ** set start node=top, if no node
  */
  if(Node<0) Node=WADLnodeGetTop(Dml);
  /*
  ** Set colors
  */
  LinGr=  BMP_COL_DARKGREY;   /*grey lines*/
  LinRs=  BMP_COL_RED;        /*left seg*/
  LinLs=  BMP_COL_GREEN;      /*right seg*/
  LinSplt=BMP_COL_YELLOW;     /*split main*/
  LinSp2= BMP_COL_DARKYELLOW; /*split 2*/
  /*
  ** Allocate a BMP
  */
  BMPinit(Bmp,Bound->SzX,Bound->SzY,8,NULL,-1);
  /*
  ** clear background in black, load default palette
  */
  BMPclear(Bmp,BMP_COL_BLACK);
  /*
  ** start cacheing vertexes. security check
  */
  res=WADLvrtxCacheI(Dml);
  if(res<0){ return res;}
  /*
  ** write linedefs in grey
  */
  for(l=0,TLnd=Dml->Lnd; l< Dml->LndNb; l++,TLnd+=1)
  { /*TLnd=&(This->Lnd[l]);*/
	 WADLdrawLineI(Dml,Bmp,TLnd,Bound,LinGr);
  }
  /*
  ** store static variables, for recursive functions.
  ** (else they would suck some stack, for no reason)
  */
  NODdml=Dml;
  NODbmp=Bmp;
  NODbound=Bound;
  NODpicB=PicB;
  /*
  ** write level below Nod
  */
  NODcol0= LinRs;
  NODcol1= LinLs;
  NODshowSsct(Node,256);
  /*
  ** write split line
  */
  NODcol0= LinSplt;
  NODcol1= LinSp2;
  NODshowSplit(Node,256);
  /*
  ** Display level
  */
  BMPassignToWindoze(Bmp,PicB);
  BMPfree(Bmp);
  return 1;
}

static void NODshowSplit(Int16 Node, Int16 Credit)
{ static pNODE TNod;
  static Int16 X,Y,dX,dY;
  /*no more credits*/
  if(Credit<0) return;
  /*avoid invalid nodes*/
  if((Node<0)||(Node>=NODdml->NodNb)) return;
  /* show main split line */
  TNod=&(NODdml->Nod[Node]); /*static!*/
  X=TNod->X;
  Y=TNod->Y;
  dX=TNod->dX;
  dY=TNod->dY;
  X-= dX<<2;Y-= dY<<2;
  dX+= dX<<3;dY+= dY<<3;
  WADLdrawScaledLine(NODbmp,X,Y,dX,dY,NODbound,NODcol0);
}

static void NODshowSsct2(Int16 Node, Int16 Credit)
{ static pNODE TNod;
  if(Credit<0) return;
  if(Node& NOTNODE)
  { WADLssecDrawI(NODdml,NODbmp, (Node)&(~NOTNODE),NODbound, NODcol0);
  }
  else
  { if((Node<0)||(Node>=NODdml->NodNb)) return;
	 /*show right child*/
	 TNod=&(NODdml->Nod[Node]); /*static!*/
	 NODshowSsct2(TNod->Right, Credit-1);
	 /*show left child*/
	 TNod=&(NODdml->Nod[Node]); /*static!*/
	 NODshowSsct2(TNod->Left, Credit-1);
  }
}
static void NODshowSsct(Int16 Node, Int16 Credit)
{ static pNODE TNod;
  if(Credit<0) return;
  if((Node<0)||(Node>=NODdml->NodNb)) return;
  /*show right child*/
  TNod=&(NODdml->Nod[Node]); /*static!*/
  NODshowSsct2(TNod->Right, Credit-1);
  /*change color*/
  NODcol0=NODcol1;
  /*show left child*/
  TNod=&(NODdml->Nod[Node]); /*static!*/
  NODshowSsct2(TNod->Left, Credit-1);
}








/****************************************************\
*
*
*  External Level API
*
*
\****************************************************/
/*
** Show level entirely
*/
Int16 WADLshowLevelAll(pLVLOBJ Dml,pWADDEF Wad, pBMPOBJ Bmp, Int16 Entry, pWINDOZE PicB)
{ BOUND Bound;
  Int16 res;
  /*read vertex linedefs*/
  res=WADLreadLevel(Dml,Wad,Entry,LVL_BASE);
  if(res<0) {WADLfreeI(Dml); return res;}
  /*bound level*/
  WADLvrtxBoundI(Dml,&Bound);
  /*scale level*/
  Bound.SzX=LEVELMAXX;
  Bound.SzY=LEVELMAXY;
  res=WADLscale(&Bound,1);
  if(res<0) return res;           /*no line selected*/
  return WADLshowLevelI(Dml,Bmp, -1,&Bound, PicB);
}
/*
** Get Xmax,Xmin, Ymax, Ymin for a level
*/
Int16 EXPORT WADLboundLevel(Int16 Self, Int16 Entry, pBOUND BoundEx)
{ /*bound*/
  BOUND Bound; /* Xmin,Xmax,szX,Ymin,Ymax,SzY*/
  Int16 res;
  /*display*/
  pWADDEF This;
  This=WADgetThis(Self); if(This==NULL) return BAD_PARM;
  if(BoundEx==NULL) return ERRfault(ERR_BUG);
  /*read vertex linedefs*/
  res=WADLreadLevel(&(This->Dml),This,Entry,LVL_BASE);
  if(res<0) {WADLfreeI(&(This->Dml)); return res;}
  /*bound level*/
  WADLvrtxBoundI(&(This->Dml),&Bound);
  Memcpy(BoundEx,&Bound,sizeof(BOUND));
  return 1;
}
/*
** Show level
**
** The caller MUST set Bound Xmin,Xmax,Ymin,Ymax,SzX,SzY
** Returns ScaleX,ScaleY, OfsX,OfsY and SzX,SzY updated
**
** Show the level lines
** Depending on Id, show highlight Object
*/
Int16 EXPORT WADLshowLevel(Int16 Self, Int16 Entry, Int16 Obj, IDENT Id, pBOUND BoundEx, pWINDOZE PicB)
{ BOUND Bound;
  pWADDEF This;
  Int16 Ref,res;
  This=WADgetThis(Self);
  /*security check*/
  if(BoundEx==NULL) return ERRfault(ERR_BUG);
  /*security on level*/
  if(Entry<0) return ERR_BUG;

  Memcpy(&Bound,BoundEx,sizeof(BOUND));
  /*scale level*/
  res=WADLscale(&Bound,0);
  if(res<0) return res;
  Memcpy(BoundEx,&Bound,sizeof(BOUND));
  switch(Id)
  {
	 case EREJECT:
		Ref=(LVL_BASE|LVL_SIDE|LVL_REJ);break;
	 case ESECTOR:  /*doesn't need LVL_SECT*/
	 case ELINEDEF:
		Ref=(LVL_BASE|LVL_SIDE);break;
	 case EVERTEX:
	 case ESIDEDEF: /*doesn't need LVL_SIDE*/
		Ref=LVL_BASE;break;
	 case ENODE:
		Ref=(LVL_BASE|LVL_NODE);break;
	 default: return ERRfault(BAD_PARM);
  }
  res=WADLreadLevel(&(This->Dml),This,Entry,Ref);
  if(res<0) { return res; }
  switch(Id)
  { case EVERTEX:
		break;
	 case ELINEDEF:/*Obj=linedef*/
		Obj=-1;
	 case ESECTOR: /*Obj=Sector*/
		return WADLshowLevelI(&(This->Dml),&(This->Bmp), Obj, &Bound, PicB);
	 case ESIDEDEF: /*Obj=sidedef*/
		return WADLshowSidedefI(&(This->Dml),&(This->Bmp), Obj, &Bound, PicB);
	 case EREJECT: /*Obj=Sector*/
		return WADLshowRejectI(&(This->Dml),&(This->Bmp), Obj, &Bound, PicB);
	 case ENODE:  /*Obj=Node*/
		return WADLshowNodeI(&(This->Dml),&(This->Bmp), Obj, &Bound, PicB);
  }
  return -1;
}

/*
**   Point to an object of a given type
**   returns the identifier of that object, or -1
**
**   Also used to descend NODES and get REJECT status
*/
Int32 EXPORT WADLpointObject(Int16 Self, Int16 Entry, IDENT Id, Int16 Object, Int16 X, Int16 Y, Int16 OX, Int16 OY)
{ Int16 res,Ref,depth,node,child;
	pWADDEF This;
  This=WADgetThis(Self);
  /*security check*/
  if(This==NULL) return ERRfault(ERR_BUG);
  /*
  ** Read levels
  */
  switch(Id)
  { case ELINEDEF: Ref=LVL_BASE;break;
	 case EREJECT:  Ref=(LVL_BASE|LVL_REJ|LVL_SIDE);break;
	 case ESECTOR:  Ref=(LVL_BASE|LVL_SIDE);break;
	 case EVERTEX:  Ref=LVL_BASE;break;
	 case ESIDEDEF: Ref=(LVL_BASE|LVL_SIDE);break;
	 case ENODE:    Ref=LVL_NODE;break;
	 default: return ERRfault(BAD_PARM);
  }
  res=WADLreadLevel(&(This->Dml),This,Entry,Ref);
  if(res<0) {WADLfreeI(&(This->Dml)); return res;}
  switch(Id)
  { /*
	 ** Vertex
	 */
	 case EVERTEX:
		return WADLvrtxFindI(&(This->Dml),X,Y);
	 /*
	 ** Point to Line
	 */
	 case ELINEDEF:
		return WADLpointLineI(&(This->Dml), X, Y);
	 /*
	 ** Point to closest Side, taking orientation into account
	 */
	 case ESIDEDEF:
		return WADLsidePointI(&(This->Dml), X, Y);
	 /*
	 ** Point to a sector
	 */
	 case ESECTOR:
		Ref=WADLsidePointI(&(This->Dml), X, Y);
		if((Ref<0)||(Ref>=This->Dml.SidNb)) return Ref;
		return This->Dml.Sid[Ref].Sector;
	 /*
	 ** Get Reject status of a sector toward another sector
	 ** Object=Last Sector selected
	 */
	 case EREJECT:
		Ref=WADLsidePointI(&(This->Dml), X, Y);
		if((Ref<0)||(Ref>=This->Dml.SidNb)) return Ref;
		Ref=This->Dml.Sid[Ref].Sector;
		return WADLrejGetI(&(This->Dml), Ref, Object);
	 /*
	 ** Point to a node
	 ** Object =Last node selected
	 ** (OX,OY)=Last coordinated selected (to get to Node)
	 */
	 case ENODE:
		/*
		** start for top of node tree
		*/
		node=WADLnodeGetTop(&(This->Dml));depth=0;
		if((Object<0)||(Object>=This->Dml.NodNb)) Object=node;
		/*
		** seek node, possibly child of previous node
		*/
		while(depth<256)
		{
		  child=WADLnodeGetChild(&(This->Dml),node, X, Y);
		  /*
		  ** not a node. Return error.
		  */
		  if(child<0) break;
		  /*
		  ** if previous node, Return the relevant child.
		  */
		  if(node==Object)
		  { node=child; depth++; break;}
		  /*
		  ** not the same branch as before. Stop there.
		  */
		  if(child!=WADLnodeGetChild(&(This->Dml),node, OX, OY)) break;
		  /*
		  ** same branch, keep going...
		  */
		  node=child; depth++;
		}
		/*
		** return node and depth (as higher bytes)
		*/
		return (node)|((((Int32)depth)&0xFF)<<16);
  }
  return -1;
}
/*
**  modify reject data
**
*/
Int16 EXPORT WADLmodifyReject(Int16 Self, Int16 Entry, Int16 Target, Int16 Sector, Int16 Ops)
{ Int16 res;
  pWADDEF This;
  This=WADgetThis(Self);
  /*security check*/
  if(This==NULL) { return ERR_BUG;}
  /*
  ** Read levels
  */
  res=WADLreadLevel(&(This->Dml),This,Entry,(LVL_BASE|LVL_REJ));
  if(res<0) {WADLfreeI(&(This->Dml)); return res;}
  switch(Ops)
  { case 1:
     res= WADL_REJ_SAFE;
     break;
    case 2:
     res= WADL_REJ_UNSAFE;
	  break;
    case 0:
	 default:
      res=WADL_REJ_TOGGLE;
	  break;
  }
  return WADLrejSetI(&(This->Dml), Sector, Target, res);
}


/*
**
** Assist level scaling up/down, with a secure function.
**  Modif= 0,1= left/right 2,3=up/down 0x10=zoom out 0x11=zoom in
*/
Int16 EXPORT WADLboundScale(pBOUND BoundEx, Int16 X, Int16 Y, Int16 Modif)
{  Int32 StepX,StepY,Xmin,Xmax,Ymin,Ymax;

  if(BoundEx==NULL) return ERRfault(ERR_BUG);
  Xmin= (Int32)BoundEx->Xmin;
  Xmax= (Int32)BoundEx->Xmax;
  Ymin= (Int32)BoundEx->Ymin;
  Ymax= (Int32)BoundEx->Ymax;
  StepX=(Xmax-Xmin)>>4;
  StepY=(Ymax-Ymin)>>4;
  switch(Modif)
  { case 0:       /*right*/
      StepX=-StepX;
    case 1:       /*left*/
      Xmin=Xmin+StepX;
      Xmax=Xmax+StepX;
		break;
	 case 2:       /*down*/
      StepY=-StepY;
	 case 3:       /*up*/
      Ymin=Ymin+StepY;
      Ymax=Ymax+StepY;
      break;
	 case 0x10:  /*scale up*/
      Xmin= (Xmin<<1) - ((Int32)X);
		Xmax= (Xmax<<1) - ((Int32)X);
      Ymin= (Ymin<<1) - ((Int32)Y);
		Ymax= (Ymax<<1) - ((Int32)Y);
		break;
    default:
    case 0x11:  /*scale down*/
      Xmin= (Xmin + ((Int32)X)) >>1;
      Xmax= (Xmax + ((Int32)X)) >>1;
		Ymin= (Ymin + ((Int32)Y)) >>1;
      Ymax= (Ymax + ((Int32)Y)) >>1;
		break;
  }
  if(((Xmax-Xmin)<64)||((Xmax-Xmin)>0x7FFF)) return 0;
  if((Xmin<-0x7FFFL)||(Xmax>0x7FFFL)) return 0;
  if(((Ymax-Ymin)<64)||((Ymax-Ymin)>0x7FFF)) return 0;
  if((Ymin<-0x7FFFL)||(Ymax>0x7FFFL)) return 0;
  BoundEx->Xmin=(Int16)Xmin;
  BoundEx->Xmax=(Int16)Xmax;
  BoundEx->Ymin=(Int16)Ymin;
  BoundEx->Ymax=(Int16)Ymax;
  return 1;
}
/*
** Save a level part, from Level object to WAD file
*/
Int16 EXPORT WADLsaveLevel(Int16 Self, Int16 Entry, IDENT Id)
{ pWADDEF This;
  pInt8 Lmp;
  Int32 LmpSz;
  Int16 res;
  pInt8 Name;
  This=WADgetThis(Self);
  if(This==NULL) {return ERR_BUG;}
  /*
  ** Entry must be the currently edited level
  ** otherwise the entries may not be for the
  ** right level.
  */
  if((Entry<0)||(Entry!=This->Dml.Level))
  { return ERRfault(ERR_BUG);}
  switch(Id)
  { case EREJECT:
		Name="REJECT";
		Lmp=WADLrejGetLmpI(&(This->Dml),&LmpSz);
		break;
	 case ESIDEDEF:
		Name="SIDEDEFS";
		Lmp=WADLsideGetLmpI(&(This->Dml),&LmpSz);
		break;
	 case ESECTOR:
		Name="SECTORS";
		Lmp=WADLsectGetLmpI(&(This->Dml),&LmpSz);
		break;
	 default:
		return ERRfault(ERR_BUG);
  }
  if(Lmp==NULL) { return ERR_BUG;}
  res=WADmodifyEntryI(This, Entry, Id, Name, Lmp, LmpSz);
  Free(Lmp);
  return res;
}
/*
** Show list of flats/textures
*/
Int16 WADLshowList(pLVLOBJ Dml, pWADDEF Wad, Int16 Entry, IDENT Type, pWINDOZE Wnd)
{
  Int16 res;
  TXTOBJ Txt;
  TXTinitWnd(&Txt,0,Wnd);
  switch(Type)
  { case ESECTOR:
		res=WADLreadLevel(Dml,Wad,Entry,LVL_SECT);
		if(res<0) {WADLfreeI(Dml); return res;}
		res= WADLsectListTexu(Dml,&Txt);
		break;
	 case ESIDEDEF:
		res=WADLreadLevel(Dml,Wad,Entry,LVL_SIDE);
		if(res<0) {WADLfreeI(Dml); return res;}
		res= WADLsideListTexu(Dml,&Txt);
		break;
	 case EBEHAVE:
		ERRfault(BAD_PARM);/*not allowed*/
		break;
  }
  TXTfree(&Txt);
  return res;
}
/*
** Get/Set texture names
**
*/
Int16 EXPORT WADLmodifTexu(Int16 Self, Int16 Entry, Int16 Obj, Int16 Ops, pInt8 Texu)
{
  Int16 res=-1;
  pWADDEF This;
  Int8 Texu2[3*NORMALISELEN+2];  /*safeguard*/
  /**/
  This=WADgetThis(Self);
  if(This==NULL) { return ERR_BUG;}
  /**/
  switch(Ops)
  { case WADL_SIDE_SET:
	 case WADL_SIDE_GET:
	   res= LVL_SIDE; break;
	 case WADL_SECT_SET:
	 case WADL_SECT_GET:
		res= LVL_SECT; break;
  }
  res=WADLreadLevel(&(This->Dml),This,Entry,res);
  if(res<0) {WADLfreeI(&(This->Dml)); return res;}
  switch(Ops)
  { case WADL_SIDE_SET:
		Strncpy(Texu2,Texu,3*NORMALISELEN);
		res= WADLsideSetTexu(&(This->Dml),Obj,Texu2);
		break;
	 case WADL_SIDE_GET:
		res= WADLsideGetTexu(&(This->Dml),Obj,Texu2);
		Strncpy(Texu,Texu2,3*NORMALISELEN);
		break;
	 case WADL_SECT_SET:
		Strncpy(Texu2,Texu,2*NORMALISELEN);
		res= WADLsectSetTexu(&(This->Dml),Obj,Texu2);
		break;
	 case WADL_SECT_GET:
		res= WADLsectGetTexu(&(This->Dml),Obj,Texu2);
		Strncpy(Texu,Texu2,2*NORMALISELEN);
		break;
  }
  return res;
}
#endif /*DLLFORDOOM*/
